/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.DefaultClass;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.interfaces.compiler.IClass;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class MyClass
implements IClass {
    static final Map<String, String> autoboxingClassNames = new HashMap<String, String>();
    static final Hashtable<Object, MyClass> myclassCache;

    public static MyClass getInstance(Pcc pcc, int n2) {
        return new DefaultClass(pcc, n2);
    }

    public static MyClass getInstance(String string) throws ClassNotFoundException {
        return MyClass.getInstance(string, null, 0);
    }

    public static MyClass getInstance(Class clazz) {
        MyClass myClass = myclassCache.get(clazz);
        if (myClass == null) {
            myClass = new DefaultClass(clazz);
            myclassCache.put(clazz, myClass);
        }
        return myClass;
    }

    public static MyClass getInstance(String string, Pcc pcc) throws ClassNotFoundException {
        return MyClass.getInstance(string, pcc, 0);
    }

    public static MyClass getInstance(String string, Pcc pcc, int n2) throws ClassNotFoundException {
        MyClass myClass = myclassCache.get(string);
        if (myClass == null) {
            if (pcc != null) {
                return new DefaultClass(string, pcc, n2);
            }
            myClass = new DefaultClass(string, null, 0);
            myclassCache.put(string, myClass);
        }
        return myClass;
    }

    public static MyClass getInstance(MyMethod myMethod) {
        String string = LambdaExpression.getName(myMethod);
        MyClass myClass = myclassCache.get(string);
        if (myClass == null) {
            myClass = new LambdaExpression(myMethod);
            myclassCache.put(string, myClass);
        }
        return myClass;
    }

    public abstract String getName(boolean var1);

    public static String getAutoboxingName(String string) {
        String string2 = autoboxingClassNames.get(string);
        return string2 != null ? string2 : string;
    }

    public abstract MyMethod[] getConstructors();

    public abstract MyMethod[] retrieveConstructors();

    public abstract MyClass[] getInterfaces();

    @Override
    public abstract MyClass getSuperclass();

    public abstract MyMethod[] getMethods(boolean var1);

    public abstract MyField[] getFields(boolean var1);

    public abstract MyField getField(String var1, boolean var2) throws NoSuchFieldException;

    @Override
    public final boolean isString(Class clazz) {
        return clazz.equals(String.class);
    }

    @Override
    public final boolean isBoolean(Class clazz) {
        return clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    @Override
    public final boolean isPrimitiveOrString(Class clazz) {
        return clazz.equals(String.class) || MyClass.isPrimitive(clazz);
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || MyClass.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return MyClass.isPrimitiveNumericWrapper(clazz) || clazz == Boolean.class || clazz == Character.class;
    }

    public static boolean isPrimitiveNumericWrapper(Class clazz) {
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    public static boolean isPrimitiveInteger(Class clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class;
    }

    public static boolean isPrimitive(String string) {
        return "boolean".equals(string) || "byte".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string) || "char".equals(string) || "java.lang.Boolean".equals(string) || "java.lang.Byte".equals(string) || "java.lang.Short".equals(string) || "java.lang.Integer".equals(string) || "java.lang.Long".equals(string) || "java.lang.Float".equals(string) || "java.lang.Double".equals(string) || "java.lang.Character".equals(string);
    }

    public abstract boolean isStrictPrimitive();

    public abstract boolean isPrimitiveWrapper();

    public abstract boolean isPrimitiveNumericWrapper();

    public abstract boolean isPrimitiveInteger();

    public static boolean isPrimitiveAssignableFrom(Class clazz, Class clazz2) {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return clazz2 == Boolean.TYPE || clazz2 == Boolean.class;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return clazz2 == Byte.TYPE || clazz2 == Byte.class;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Short.TYPE) {
            return clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Byte.TYPE || clazz2 == Byte.class || clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Short.class) {
            return clazz2 == Short.TYPE || clazz2 == Short.class;
        }
        if (clazz == Integer.TYPE) {
            return clazz2 == Integer.TYPE || clazz2 == Integer.class || clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Byte.TYPE || clazz2 == Byte.class || clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Integer.class) {
            return clazz2 == Integer.TYPE || clazz2 == Integer.class;
        }
        if (clazz == Long.TYPE) {
            return clazz2 == Long.TYPE || clazz2 == Long.class || clazz2 == Integer.TYPE || clazz2 == Integer.class || clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Byte.TYPE || clazz2 == Byte.class || clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Long.class) {
            return clazz2 == Long.TYPE || clazz2 == Long.class;
        }
        if (clazz == Float.TYPE) {
            return clazz2 == Float.TYPE || clazz2 == Float.class || clazz2 == Long.TYPE || clazz2 == Long.class || clazz2 == Integer.TYPE || clazz2 == Integer.class || clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Byte.TYPE || clazz2 == Byte.class || clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Float.class) {
            return clazz2 == Float.TYPE || clazz2 == Float.class;
        }
        if (clazz == Double.TYPE) {
            return clazz2 == Double.TYPE || clazz2 == Double.class || clazz2 == Float.TYPE || clazz2 == Float.class || clazz2 == Long.TYPE || clazz2 == Long.class || clazz2 == Integer.TYPE || clazz2 == Integer.class || clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Byte.TYPE || clazz2 == Byte.class || clazz2 == Character.TYPE || clazz2 == Character.class;
        }
        if (clazz == Double.class) {
            return clazz2 == Double.TYPE || clazz2 == Double.class;
        }
        return false;
    }

    public abstract MyClass getWrappedType();

    public abstract boolean isAssignableFrom(MyClass var1);

    public abstract boolean isAssignableFrom(MyClass var1, boolean var2);

    public static boolean isNumericVar(String string) {
        try {
            return MyClass.isNumericVar(MyClass.forName(string));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isNumericVar(Class clazz) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".NumericVar").isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("" + classNotFoundException);
        }
    }

    public static boolean isCobolVar(String string) {
        try {
            return MyClass.isCobolVar(MyClass.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isCobolVar(Class clazz) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".CobolVar").isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("" + classNotFoundException);
        }
    }

    public static boolean isNumericEditedVar(Class clazz) {
        try {
            return MyClass.forName(Pcc.TYPES_PACKAGE + ".PicNumEdit").isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("" + classNotFoundException);
        }
    }

    public abstract boolean isNumericEditedVar();

    public abstract boolean isAssignableTo(MyClass var1, boolean var2);

    public abstract boolean isAssignableTo(MyClass var1);

    public final boolean isAssignableTo(String string) {
        try {
            Class clazz = MyClass.forName(string);
            return this.isAssignableTo(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalErrorException("" + classNotFoundException);
        }
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (MyClass.isPrimitive(clazz) && MyClass.isPrimitive(clazz2)) {
            return MyClass.isPrimitiveAssignableFrom(clazz, clazz2);
        }
        return false;
    }

    public abstract boolean isAbstract();

    @Override
    public abstract MyClass getComponentType();

    /*
     * Loose catch block
     */
    static Class forName(String string) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        while (true) {
            try {
                return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                int n2;
                if (classNotFoundException == null) {
                    classNotFoundException = classNotFoundException2;
                }
                if ((n2 = string.lastIndexOf(46)) >= 0) {
                    string = string.substring(0, n2) + '$' + string.substring(n2 + 1);
                    continue;
                }
                throw classNotFoundException;
            }
            break;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(noClassDefFoundError.getMessage());
        }
    }

    public static boolean isClassAccessible(Pcc pcc, MyClass myClass) {
        if (pcc.getPackageName().equals(myClass.getPackageName())) {
            return true;
        }
        return myClass.isPublic();
    }

    public abstract boolean isClassAccessible(MyClass var1);

    public abstract boolean isInterface();

    public static MyClass removeDimension(MyClass myClass, int n2) {
        if (!(myClass instanceof DefaultClass)) {
            return MyClass.getInstance(WrongDimension.class);
        }
        DefaultClass defaultClass = (DefaultClass)myClass;
        if (defaultClass.extClass != null) {
            return MyClass.getInstance(MyClass.removeDimension(defaultClass.extClass, n2));
        }
        if (n2 <= defaultClass.dimensions) {
            return MyClass.getInstance(defaultClass.intClass, defaultClass.dimensions - n2);
        }
        return MyClass.getInstance(WrongDimension.class);
    }

    private static Class removeDimension(Class clazz, int n2) {
        String string;
        int n3;
        String string2 = clazz.getName();
        for (n3 = 0; n3 < string2.length() && string2.charAt(n3) == '['; ++n3) {
            --n2;
        }
        if (n2 < 0) {
            return WrongDimension.class;
        }
        String string3 = "";
        String string4 = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string4 = string4 + "[]";
            string3 = string3 + "[";
        }
        if (n3 < string2.length() && string2.charAt(n3) == 'L') {
            string = MyClass.getClassNameCode(string2.substring(n3 + 1, string2.length() - 1)) + string4;
        } else {
            if (string3.equals("")) {
                switch (string2.charAt(n3)) {
                    case 'B': {
                        return Byte.TYPE;
                    }
                    case 'C': {
                        return Character.TYPE;
                    }
                    case 'S': {
                        return Short.TYPE;
                    }
                    case 'I': {
                        return Integer.TYPE;
                    }
                    case 'J': {
                        return Long.TYPE;
                    }
                    case 'F': {
                        return Float.TYPE;
                    }
                    case 'D': {
                        return Double.TYPE;
                    }
                    case 'Z': {
                        return Boolean.TYPE;
                    }
                }
            }
            string = string3 + string2.charAt(n3);
        }
        try {
            return MyClass.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return clazz;
        }
    }

    public abstract boolean isFunctionalInterface();

    public abstract boolean isEnclosedClass();

    public abstract MyMethod getFunctionalMethod();

    static String getClassNameCode(String string) {
        try {
            MyClass myClass = MyClass.getInstance(string);
            if (myClass.isEnclosedClass()) {
                return string.replace('$', '.');
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return string;
    }

    static {
        autoboxingClassNames.put("java.lang.Boolean", "boolean");
        autoboxingClassNames.put("java.lang.Byte", "byte");
        autoboxingClassNames.put("java.lang.Short", "short");
        autoboxingClassNames.put("java.lang.Integer", "int");
        autoboxingClassNames.put("java.lang.Long", "long");
        autoboxingClassNames.put("java.lang.Float", "float");
        autoboxingClassNames.put("java.lang.Double", "double");
        autoboxingClassNames.put("java.lang.Character", "char");
        myclassCache = new Hashtable();
    }

    private static class WrongDimension {
        private WrongDimension() {
        }
    }
}

