/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class NextSentence
extends Verb
implements CobolToken,
ErrorsNumbers {
    private NextSentenceBlock nsb;
    private String deferredMethodName;
    private boolean exitFromDeferredMethod;

    public NextSentence(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) {
        super(token, block, pcc, tokenManager, errors);
        this.nsb = block.getNextSentenceBlock(token);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("   ");
        stringBuffer.append("if (true) ");
        String string = this.getDeferredMethodName();
        if (string != null) {
            stringBuffer.append("return " + string + "(true)");
        } else if (this.exitFromDeferredMethod) {
            stringBuffer.append("return -3");
        } else {
            stringBuffer.append("break ");
            stringBuffer.append(this.nsb.getName());
        }
        stringBuffer.append(";");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public NextSentenceBlock getNextSentenceBlock() {
        return this.nsb;
    }

    public String getDeferredMethodName() {
        return this.deferredMethodName;
    }

    public void setDeferredMethodName(String string) {
        this.deferredMethodName = string;
    }

    public boolean isExitFromDeferredMethod() {
        return this.exitFromDeferredMethod;
    }

    public void setExitFromDeferredMethod(boolean bl) {
        this.exitFromDeferredMethod = bl;
    }
}

