/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class NextSentenceBlock
extends Verb
implements CobolToken {
    private final String NAME_PREFIX = "$NextSentence$";
    private String name = "$NextSentence$" + prog++;
    private End end;
    private static int prog;
    private boolean alreadyPrinted;

    public NextSentenceBlock(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) {
        super(token, block, pcc, tokenManager, errors);
        this.end = new End(this.name, token, block, pcc, tokenManager, errors);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    public End getEnd() {
        return this.end;
    }

    public static void resetCounters() {
        prog = 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        if (this.alreadyPrinted) {
            return "/* next sentence " + this.name + " */" + eol;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getEnd().getDeferredMethodId() == this.getDeferredMethodId()) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.name);
            stringBuffer.append(": {");
            stringBuffer.append(eol);
        } else {
            stringBuffer.append("/* next sentence {start} " + this.name + " */" + eol);
        }
        this.getParent().getParent().setActNextSentence(this);
        this.alreadyPrinted = true;
        return stringBuffer.toString();
    }

    public static class End
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        private String name;

        public End(String string, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) {
            super(token, block, pcc, tokenManager, errors);
            this.name = string;
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        @Override
        public String getCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} // ");
            stringBuffer.append(this.name);
            stringBuffer.append(" {end}");
            stringBuffer.append(eol);
            this.getParent().getParent().setActNextSentence(null);
            return stringBuffer.toString();
        }
    }
}

