/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import java.util.Enumeration;
import java.util.Vector;

public class OffsetHelper {
    private final VariableDeclaration target;
    private final Vector[] dimensions;
    private final Vector finalFormula = new Vector();

    private static VariableDeclaration getRealTarget(VariableDeclaration variableDeclaration) {
        if (variableDeclaration.getRename() != null) {
            variableDeclaration = variableDeclaration.getRename();
        }
        while (variableDeclaration.isRedefines()) {
            if (variableDeclaration.getRedefinesVar() != null) {
                variableDeclaration = variableDeclaration.getRedefinesVar();
                continue;
            }
            variableDeclaration = variableDeclaration.parent;
        }
        return variableDeclaration;
    }

    public OffsetHelper(VariableDeclaration variableDeclaration, Object[] objectArray) {
        int n2;
        this.target = OffsetHelper.getRealTarget(variableDeclaration);
        VariableDeclaration variableDeclaration2 = this.target.getGrandPa();
        if (objectArray != null && (n2 = objectArray.length) > 0) {
            this.dimensions = new Vector[n2];
            VariableDeclaration variableDeclaration3 = this.target;
            int n3 = n2 - 1;
            while (n3 >= 0 && variableDeclaration3 != null) {
                if (variableDeclaration3.getOccurs() > 0) {
                    this.dimensions[n3] = new Vector();
                    this.dimensions[n3].addElement(variableDeclaration3.getPhisicLen());
                    --n3;
                }
                variableDeclaration3 = variableDeclaration3.parent;
            }
        } else {
            this.dimensions = null;
        }
        this.findOffset0(variableDeclaration2, this.finalFormula, new boolean[]{false});
        if (this.dimensions != null) {
            for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
                if (this.dimensions[i2] == null) continue;
                Object object = objectArray[i2];
                if (object instanceof Subscript) {
                    Subscript subscript = (Subscript)object;
                    Expression expression = subscript.getExpression();
                    if (subscript.isLiteral()) {
                        Object object2;
                        int n4 = 0;
                        if (expression != null) {
                            object2 = expression.getAsToken();
                            n4 = "1".equals(((Token)object2).getWord()) ? 1 : ((Token)object2).longValue();
                        } else {
                            object2 = subscript.getIndex();
                            try {
                                n4 = Integer.parseInt((String)object2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (n4 == 1) continue;
                        OffsetHelper.multiply(this.dimensions[i2], n4 - 1);
                        this.finalFormula.addElement("+");
                        this.finalFormula.addElement(this.toString(this.dimensions[i2]));
                        continue;
                    }
                    OffsetHelper.multiply(this.dimensions[i2], "(" + expression.getCode() + ".intValue()-1)");
                    this.finalFormula.addElement("+");
                    this.finalFormula.addElement(this.toString(this.dimensions[i2]));
                    continue;
                }
                OffsetHelper.multiply(this.dimensions[i2], object);
                this.finalFormula.addElement("+");
                this.finalFormula.addElement(this.toString(this.dimensions[i2]));
            }
        }
    }

    public OffsetHelper(VariableDeclaration variableDeclaration, SubscriptList subscriptList) {
        int n2;
        CobolToken cobolToken;
        int n3;
        this.target = OffsetHelper.getRealTarget(variableDeclaration);
        if (this.target != variableDeclaration) {
            int n4 = variableDeclaration.getOffset();
            if (this.target.hasVariableOffset()) {
                n4 -= this.target.getOffset();
            }
            if (n4 > 0) {
                OffsetHelper.add(this.finalFormula, n4);
            }
        }
        VariableDeclaration variableDeclaration2 = this.target.getGrandPa();
        if (subscriptList != null && (n3 = subscriptList.getItemNum()) > 0) {
            this.dimensions = new Vector[n3];
            cobolToken = variableDeclaration;
            n2 = n3 - 1;
            while (n2 >= 0 && cobolToken != null) {
                if (((VariableDeclaration)cobolToken).getOccurs() > 0) {
                    this.dimensions[n2] = new Vector();
                    this.calcDimension((VariableDeclaration)cobolToken, this.dimensions[n2]);
                    --n2;
                }
                cobolToken = ((VariableDeclaration)cobolToken).parent;
            }
        } else {
            this.dimensions = null;
        }
        this.findOffset0(variableDeclaration2, this.finalFormula, new boolean[]{false});
        if (this.dimensions != null) {
            cobolToken = subscriptList.getFirst();
            for (n2 = 0; n2 < this.dimensions.length; ++n2) {
                Expression expression = ((Subscript)cobolToken).getExpression();
                if (((Subscript)cobolToken).isLiteral()) {
                    Object object;
                    int n5 = 0;
                    if (expression != null) {
                        object = expression.getAsToken();
                        n5 = "1".equals(((Token)object).getWord()) ? 1 : ((Token)object).longValue();
                    } else {
                        object = ((Subscript)cobolToken).getIndex();
                        try {
                            n5 = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n5 != 1) {
                        OffsetHelper.multiply(this.dimensions[n2], n5 - 1);
                        this.finalFormula.addElement("+");
                        this.finalFormula.addElement(this.toString(this.dimensions[n2]));
                    }
                } else {
                    OffsetHelper.multiply(this.dimensions[n2], "(" + expression.getCode() + ".intValue()-1)");
                    this.finalFormula.addElement("+");
                    this.finalFormula.addElement(this.toString(this.dimensions[n2]));
                }
                cobolToken = subscriptList.getNext();
            }
        }
    }

    private static void multiply(Vector vector, Object object) {
        int n2 = vector.size();
        Object e2 = vector.elementAt(0);
        if (object instanceof Integer && n2 == 1 && e2 instanceof Integer) {
            int n3 = (Integer)object;
            vector.setElementAt(n3 *= ((Integer)vector.elementAt(0)).intValue(), 0);
        } else if (n2 == 1 && e2 instanceof Integer && (Integer)e2 == 1) {
            vector.setElementAt(object, 0);
        } else {
            if (vector.size() > 1) {
                vector.insertElementAt("(", 0);
                vector.addElement(")");
            }
            vector.addElement("*");
            vector.addElement(object.toString());
        }
    }

    private static void add(Vector vector, Object object) {
        int n2 = vector.size() - 1;
        if (n2 >= 0) {
            Object e2 = vector.elementAt(n2);
            if (object instanceof Integer && e2 instanceof Integer) {
                vector.setElementAt((Integer)object + (Integer)e2, n2);
            } else {
                if (!e2.equals("(")) {
                    vector.addElement("+");
                }
                vector.addElement(object);
            }
        } else {
            vector.addElement(object);
        }
    }

    private void calcDimensionChildren(VariableDeclarationList variableDeclarationList, Vector vector) {
        Enumeration enumeration = variableDeclarationList.elements();
        while (enumeration.hasMoreElements()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)enumeration.nextElement();
            if (variableDeclaration.getRedefines() != null) continue;
            if (variableDeclaration.getOccurs() > 0) {
                Vector<String> vector2 = new Vector<String>();
                this.calcDimension(variableDeclaration, vector2);
                if (vector2.size() > 1) {
                    vector2.insertElementAt("(", 0);
                    vector2.addElement(")");
                }
                OffsetHelper.add(vector, this.toString(vector2));
                vector.addElement("*");
                VariableName variableName = variableDeclaration.getDepending();
                if (variableName != null) {
                    vector.addElement(variableName.getCode() + ".toint()");
                    continue;
                }
                vector.addElement("" + variableDeclaration.getOccurs());
                continue;
            }
            this.calcDimension(variableDeclaration, vector);
        }
    }

    private void calcDimension(VariableDeclaration variableDeclaration, Vector vector) {
        if (variableDeclaration.children == null || variableDeclaration.children.getItemNum() == 0) {
            OffsetHelper.add(vector, variableDeclaration.getPhisicLen());
        } else {
            this.calcDimensionChildren(variableDeclaration.children, vector);
        }
    }

    public String toString() {
        return this.toString(this.finalFormula);
    }

    private String toString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            stringBuffer.append(vector.elementAt(i2));
        }
        return stringBuffer.toString();
    }

    private boolean findOffset0(VariableDeclaration variableDeclaration, Vector vector, boolean[] blArray) {
        boolean bl;
        if (!blArray[0] && variableDeclaration.hasVariableOffset()) {
            OffsetHelper.add(this.finalFormula, variableDeclaration.getOffset());
            blArray[0] = true;
        }
        if (variableDeclaration == this.target) {
            if (!blArray[0]) {
                OffsetHelper.add(this.finalFormula, 0);
            }
            bl = false;
        } else {
            bl = true;
            if (blArray[0]) {
                int n2;
                VariableName variableName = variableDeclaration.getDepending();
                Object object = variableDeclaration.getOccurs() > 0 ? (variableName != null ? variableName.getCode() + ".toint()" : Integer.valueOf(variableDeclaration.getOccurs())) : null;
                Vector vector2 = new Vector();
                if (variableDeclaration.children == null || variableDeclaration.children.getItemNum() == 0) {
                    if (!variableDeclaration.isRedefines()) {
                        OffsetHelper.add(vector2, variableDeclaration.getPhisicLen());
                    }
                } else {
                    Enumeration enumeration = variableDeclaration.children.elements();
                    while (enumeration.hasMoreElements() && bl) {
                        VariableDeclaration variableDeclaration2 = (VariableDeclaration)enumeration.nextElement();
                        bl = this.findOffset0(variableDeclaration2, vector2, blArray);
                    }
                }
                if ((n2 = vector2.size()) > 0) {
                    if (bl && object != null) {
                        OffsetHelper.multiply(vector2, object);
                    }
                    if (vector2.size() == 1 && vector2.elementAt(0) instanceof Integer) {
                        OffsetHelper.add(vector, vector2.elementAt(0));
                    } else {
                        OffsetHelper.add(vector, this.toString(vector2));
                    }
                }
            } else if (variableDeclaration.children != null) {
                Enumeration enumeration = variableDeclaration.children.elements();
                while (enumeration.hasMoreElements() && bl) {
                    VariableDeclaration variableDeclaration3 = (VariableDeclaration)enumeration.nextElement();
                    bl = this.findOffset0(variableDeclaration3, vector, blArray);
                }
            }
        }
        return bl;
    }
}

