/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class On
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token onTk;
    private VariableName onVn;
    private Token everyTk;
    private VariableName everyVn;
    private Token untilTk;
    private VariableName untilVn;
    private Block onBlock;
    private Block elseBlock;
    private boolean hasElse;
    private NextSentence ns;
    private final String onCounter;

    public On(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(19, 4, token, token.getWord(), this.error);
        }
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10002) {
            this.onTk = token2;
        } else if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.onVn = VariableName.get(this.tm, this.error, this.pc);
            if (!this.onVn.isInteger()) {
                throw new GeneralErrorException(46, 4, this.onVn.getNameToken(), this.onVn.getName(), this.error);
            }
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 274) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 469) {
                throw new ExpectedFoundException(token2, this.error, "'EVERY'");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10002) {
                this.everyTk = token2;
            } else if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.everyVn = VariableName.get(this.tm, this.error, this.pc);
                if (!this.everyVn.isInteger()) {
                    throw new GeneralErrorException(46, 4, this.everyVn.getNameToken(), this.everyVn.getName(), this.error);
                }
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 791) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10002) {
                this.untilTk = token2;
            } else if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.untilVn = VariableName.get(this.tm, this.error, this.pc);
                if (!this.untilVn.isInteger()) {
                    throw new GeneralErrorException(46, 4, this.untilVn.getNameToken(), this.untilVn.getName(), this.error);
                }
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = this.tm.getToken();
        }
        boolean bl = this.pc.getOption("-cm") != null || this.pc.getOption("-cr") != null || this.pc.getOption("-ca") != null;
        Token token3 = null;
        if (bl || token2.getToknum() != 595) {
            this.tm.ungetToken();
            this.onBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        } else {
            token3 = token2;
            token2 = this.tm.getToken();
            if (token2.getToknum() != 714) {
                throw new ExpectedFoundException(token2, this.error, "SENTENCE");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10006 && token2.getToknum() != 417 && token2.getToknum() != 622) {
                throw new ExpectedFoundException(token2, this.error, "ELSE|.");
            }
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 417 || token2.getToknum() == 622) {
            this.hasElse = true;
            token2 = this.tm.getToken();
            if (bl || token2.getToknum() != 595) {
                this.tm.ungetToken();
                this.elseBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            } else {
                token3 = token2;
                token2 = this.tm.getToken();
                if (token2.getToknum() != 714) {
                    throw new ExpectedFoundException(token2, this.error, "SENTENCE");
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10006) {
                    throw new ExpectedFoundException(token2, this.error, ".");
                }
            }
        } else {
            this.tm.ungetToken();
        }
        if (token3 != null) {
            this.ns = new NextSentence(token3, block, this.pc, this.tm, this.error);
        }
        this.onCounter = "$onCounters$[" + (((CobolProgram)this.pc).addOnStatement() - 1) + "]";
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(this.onCounter + "++;" + eol);
        stringBuffer.append(this.parent.getIndent());
        String string = "onEval$" + On.getUniqueId();
        stringBuffer.append("int " + string + " = ");
        if (this.onTk != null) {
            stringBuffer.append(this.getCodeLiteral(this.onTk));
        } else {
            stringBuffer.append(this.onVn.getCode());
        }
        stringBuffer.append(".toint();");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("if (");
        stringBuffer.append(string);
        if ((this.untilTk != null || this.untilVn != null) && this.everyTk == null && this.everyVn == null) {
            stringBuffer.append(" > 0 && ");
            stringBuffer.append(this.onCounter);
            stringBuffer.append(" >= ");
            stringBuffer.append(string);
            stringBuffer.append(" && ");
            stringBuffer.append(this.onCounter);
            stringBuffer.append(" < ");
            if (this.untilTk != null) {
                stringBuffer.append(this.getCodeLiteral(this.untilTk));
            } else {
                stringBuffer.append(this.untilVn.getCode());
            }
            stringBuffer.append(".toint()");
        } else {
            stringBuffer.append(" == ");
            stringBuffer.append(this.onCounter);
            if (this.everyTk != null || this.everyVn != null) {
                stringBuffer.append(" || (");
                if (this.untilTk != null || this.untilVn != null) {
                    stringBuffer.append(this.onCounter);
                    stringBuffer.append(" < ");
                    if (this.untilTk != null) {
                        stringBuffer.append(this.getCodeLiteral(this.untilTk));
                    } else {
                        stringBuffer.append(this.untilVn.getCode());
                    }
                    stringBuffer.append(".toint() && ");
                }
                stringBuffer.append(string);
                stringBuffer.append(" > 0 && ");
                stringBuffer.append(string);
                stringBuffer.append(" < ");
                stringBuffer.append(this.onCounter);
                stringBuffer.append(" && (");
                stringBuffer.append(this.onCounter);
                stringBuffer.append(" - ");
                stringBuffer.append(string);
                stringBuffer.append(") % ");
                if (this.everyTk != null) {
                    stringBuffer.append(this.getCodeLiteral(this.everyTk));
                } else {
                    stringBuffer.append(this.everyVn.getCode());
                }
                stringBuffer.append(".toint() == 0)");
            }
        }
        stringBuffer.append(")");
        if (this.onBlock != null) {
            stringBuffer.append(this.onBlock.getCode());
        } else if (this.ns != null) {
            stringBuffer.append("{");
            stringBuffer.append(this.ns.getCode());
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{ // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
        }
        if (this.hasElse) {
            if (this.elseBlock != null) {
                stringBuffer.append(" else ");
                stringBuffer.append(this.elseBlock.getCode());
            } else if (this.ns != null) {
                stringBuffer.append(" else {" + this.ns.getCode());
                stringBuffer.append("}");
            } else {
                stringBuffer.append(" else { // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
            }
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

