/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;
import java.util.Hashtable;

public class Open
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static int BULK_ADDITION = -1;
    private Token sharing;
    private Token fileName;
    private SelectList sels = new SelectList();
    private Hashtable openModes = new Hashtable();
    private Hashtable openLocks = new Hashtable();
    private Hashtable openMass = new Hashtable();
    private Hashtable openBulk = new Hashtable();
    private Hashtable openRewi = new Hashtable();
    private boolean acOpt;

    public Open(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.acOpt = tokenManager.getOptionList().getOption("-ca") != null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 473) {
            this.sharing = token2;
            token2 = this.tm.getToken();
        }
        while (token2.getToknum() == 534 || token2.getToknum() == 623 || token2.getToknum() == 518 || token2.getToknum() == 477) {
            this.parse(token2);
            token2 = this.tm.getToken();
        }
        this.tm.ungetToken();
        if (this.openModes.size() == 0) {
            throw new GeneralErrorException(54, 4, this.keyWord, token2.getWord(), this.error);
        }
    }

    private void parse(Token token) throws GeneralErrorException, EndOfProgramException {
        Token token2;
        Token token3 = new Token(262, "ALL", 0, 0, "dummy");
        if (this.sharing == null) {
            this.sharing = token3;
        }
        if ((token2 = this.tm.getToken()).getToknum() == 722) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.isAll()) {
                token2 = this.sharing = token3;
                this.tm.ungetToken();
            } else {
                this.sharing = token2;
            }
            if (this.sharing.getToknum() == 262 || this.sharing.getToknum() == 596) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 620) {
                    token2 = this.tm.getToken();
                }
            } else if (this.sharing.getToknum() == 666) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 614) {
                    token2 = this.tm.getToken();
                } else {
                    this.error.print(31, 3, token2, "ONLY/" + token2.getWord());
                }
            } else {
                throw new GeneralErrorException(29, 4, this.keyWord, this.sharing.getWord(), this.error);
            }
        }
        while ((this.fileName = token2).getToknum() == 10009) {
            Token token4 = null;
            Token token5 = null;
            Token token6 = null;
            Select select = this.pc.getSelect(this.fileName.getWord());
            if (select == null) {
                throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (select.isSort()) {
                throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (!select.allowsOpenIO() && token.getToknum() == 518) {
                this.error.print(54, 2, this.fileName, this.fileName.getWord());
            }
            this.sels.addItem(select);
            this.openModes.put(select, token);
            token2 = this.tm.getToken();
            if (this.acOpt && token2.getToknum() == 264) {
                this.sharing = this.tm.getToken();
                if (this.sharing.getToknum() == 262 || this.sharing.getToknum() == 596) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 621) {
                        this.tm.ungetToken();
                    }
                } else if (this.sharing.getToknum() == 668) {
                    this.sharing.setToknum(666);
                } else if (this.sharing.getToknum() == 817) {
                    this.sharing.setToknum(262);
                } else if (this.sharing.getToknum() == 794) {
                    this.sharing.setToknum(262);
                } else {
                    throw new GeneralErrorException(15, 4, this.sharing, this.sharing.getWord(), this.error);
                }
                token2 = this.tm.getToken();
            }
            this.tm.ungetToken();
            token2 = Open.myGetToken(this.tm);
            if (token2.getToknum() == 813 || token2.getToknum() == 596 || token2.getToknum() == 570 || token2.getToknum() == 579 || token2.getToknum() == BULK_ADDITION) {
                if (token2.getToknum() == 813) {
                    token2 = Open.myGetToken(this.tm);
                }
                if (token2.getToknum() == 596) {
                    token2 = Open.myGetToken(this.tm);
                    if (token2.getToknum() != 698) {
                        this.error.print(31, 3, token2, "REWIND/" + token2.getWord());
                        this.tm.ungetToken();
                    } else {
                        token6 = token2;
                    }
                } else if (token2.getToknum() == 570) {
                    this.sharing = token2;
                } else if (token2.getToknum() == 579) {
                    token4 = token2;
                } else if (token2.getToknum() == BULK_ADDITION) {
                    token5 = token2;
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = Open.myGetToken(this.tm);
            } else if (token2.getToknum() == 494) {
                token2 = Open.myGetToken(this.tm);
                if (token2.getToknum() == 570) {
                    this.sharing = token2;
                } else if (token2.getToknum() == 579) {
                    token4 = token2;
                } else if (token2.getToknum() == BULK_ADDITION) {
                    token5 = token2;
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = Open.myGetToken(this.tm);
            }
            this.openLocks.put(select, this.sharing);
            if (token6 != null) {
                this.openRewi.put(select, token6);
            }
            if (token4 != null) {
                this.openMass.put(select, token4);
            }
            if (token5 != null) {
                this.openBulk.put(select, token5);
            }
            if (this.sharing.getToknum() == 473) continue;
            this.sharing = token3;
        }
        if (this.sels.getItemNum() == 0) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
    }

    private static Token myGetToken(TokenManager tokenManager) throws EndOfProgramException, GeneralErrorException {
        String string;
        Token token = tokenManager.getToken();
        if (token.getToknum() == 10009 && "BULK-ADDITION".equals(string = token.getWord())) {
            token.setToknum(BULK_ADDITION);
        }
        return token;
    }

    @Override
    public void check() throws GeneralErrorException {
        Select select = this.sels.getFirst();
        while (select != null) {
            Token token = (Token)this.openModes.get(select);
            if (token.getToknum() == 534 || !select.hasLockSupport()) {
                this.sharing = (Token)this.openLocks.get(select);
                if (!(this.sharing == null || this.sharing.getToknum() != 596 && this.sharing.getToknum() != 570 && this.sharing.getToknum() != 473 && this.sharing.getToknum() != 666 || select.hasLockSupport())) {
                    this.error.print(169, 2, this.keyWord, select.fileName.getWord());
                }
                if (select.getLockMode(token.getToknum()) == 473 && !select.hasLockSupport()) {
                    this.error.print(169, 2, this.keyWord, select.fileName.getWord());
                }
            }
            select = this.sels.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        this.getCodeDebug(stringBuffer);
        Select select = this.sels.getFirst();
        while (select != null) {
            Token token = (Token)this.openModes.get(select);
            this.sharing = (Token)this.openLocks.get(select);
            Token token2 = (Token)this.openMass.get(select);
            Token token3 = (Token)this.openBulk.get(select);
            Token token4 = (Token)this.openRewi.get(select);
            boolean bl2 = this.pc.getDeclarative(select) != null || bl;
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(select.getName());
            stringBuffer.append(".open(");
            stringBuffer.append(select.getPathCode());
            stringBuffer.append(",");
            if (token.getToknum() == 534) {
                string = "CobolFile.OPEN_INPUT";
                stringBuffer.append("CobolFile.OPEN_INPUT");
            } else if (token.getToknum() == 623) {
                string = "CobolFile.OPEN_OUTPUT";
                stringBuffer.append("CobolFile.OPEN_OUTPUT");
            } else if (token.getToknum() == 518) {
                string = "CobolFile.OPEN_IO";
                stringBuffer.append("CobolFile.OPEN_IO");
            } else if (token.getToknum() == 477) {
                string = "CobolFile.OPEN_EXTEND";
                stringBuffer.append("CobolFile.OPEN_EXTEND");
            }
            stringBuffer.append(",");
            if (select.getLockMode(token.getToknum()) == 473) {
                stringBuffer.append("CobolFile.LOCK_EXCLUSIVE");
            } else if (this.sharing != null) {
                if (this.sharing.getToknum() == 596 || this.sharing.getToknum() == 570 || this.sharing.getToknum() == 473) {
                    stringBuffer.append("CobolFile.LOCK_EXCLUSIVE");
                } else if (this.sharing.getToknum() == 666) {
                    stringBuffer.append("CobolFile.LOCK_READERS");
                } else {
                    stringBuffer.append("CobolFile.LOCK_NONE");
                }
            } else {
                stringBuffer.append("CobolFile.LOCK_NONE");
            }
            if (select.getLockMode(token.getToknum()) == 290) {
                stringBuffer.append(" + CobolFile.LOCK_AUTOMATIC");
            }
            if (select.getMultipleRecords()) {
                stringBuffer.append(" + CobolFile.LOCK_MULTI");
            }
            if (token3 != null) {
                stringBuffer.append(" + CobolFile.LOCK_BULK+CobolFile.LOCK_MASS_UPDATE");
            } else if (select.getMassUpdate() || token2 != null) {
                stringBuffer.append(" + CobolFile.LOCK_MASS_UPDATE");
            }
            if (select.isWithRollback()) {
                stringBuffer.append(" + CobolFile.LOCK_TRANSACTION");
            }
            if (select.isEncrypted()) {
                stringBuffer.append(" + CobolFile.FILE_ENCRYPTED");
            }
            if (select.hasBefore || select.isExternal() || select.getFD().isExternal()) {
                stringBuffer.append(" + CobolFile.FILE_PRT_MACHINE_CODE");
            }
            stringBuffer.append(");");
            Use.putFileStatus(stringBuffer, select, this.parent.getIndent());
            Use.putDeclaratives(stringBuffer, this.pc, select, this.parent.getIndent(), string, bl2);
            stringBuffer.append(eol);
            select = this.sels.getNext();
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public SelectList getSels() {
        return this.sels;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public Hashtable getOpenModes() {
        return this.openModes;
    }

    public Hashtable getOpenLocks() {
        return this.openLocks;
    }

    public Hashtable getOpenMass() {
        return this.openMass;
    }

    public Hashtable getOpenBulk() {
        return this.openBulk;
    }

    public Hashtable getOpenRewi() {
        return this.openRewi;
    }
}

