/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.interfaces.compiler.IPList;
import java.util.Enumeration;
import java.util.Vector;

public class PList
implements IPList {
    private int currIdx = -1;
    private int size = 0;
    private Vector vec = new Vector();

    void addItemObject(Object object) {
        this.vec.addElement(object);
        ++this.currIdx;
        ++this.size;
    }

    void addItemObject(int n2, Object object) {
        this.vec.add(n2, object);
        ++this.size;
    }

    void addListObject(PList pList) {
        int n2 = pList.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.vec.addElement(pList.vec.elementAt(i2));
        }
        this.size += n2;
    }

    Object getFirstObject() {
        if (this.size > 0) {
            this.currIdx = 0;
            return this.vec.elementAt(0);
        }
        return null;
    }

    Object getLastObject() {
        if (this.size > 0) {
            this.currIdx = this.size - 1;
            return this.vec.elementAt(this.currIdx);
        }
        return null;
    }

    Object getNextObject() {
        Object var1_1;
        if (++this.currIdx < this.size) {
            var1_1 = this.vec.elementAt(this.currIdx);
        } else {
            var1_1 = null;
            --this.currIdx;
        }
        return var1_1;
    }

    Object getPreviousObject() {
        Object var1_1;
        if (--this.currIdx >= 0) {
            var1_1 = this.vec.elementAt(this.currIdx);
        } else {
            var1_1 = null;
            ++this.currIdx;
        }
        return var1_1;
    }

    Object getCurrentObject() {
        Object var1_1 = null;
        try {
            var1_1 = this.vec.elementAt(this.currIdx);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return var1_1;
    }

    Object getAtObject(int n2) {
        Object var2_2;
        if (n2 >= 0 && n2 < this.size) {
            var2_2 = this.vec.elementAt(n2);
            this.currIdx = n2;
        } else {
            var2_2 = null;
        }
        return var2_2;
    }

    Object deleteCurrentObject() {
        Object var1_1;
        if (this.currIdx >= 0 && this.currIdx < this.size) {
            this.vec.removeElementAt(this.currIdx);
            --this.size;
            if (this.currIdx == this.size) {
                --this.currIdx;
            }
            var1_1 = this.currIdx >= 0 ? this.vec.elementAt(this.currIdx) : null;
        } else {
            var1_1 = null;
        }
        return var1_1;
    }

    Object elementAtObject(int n2) {
        return this.vec.elementAt(n2);
    }

    boolean deleteObject(Object object) {
        if (this.vec.removeElement(object)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int getItemNum() {
        return this.size;
    }

    int getCurrentIndex() {
        return this.currIdx;
    }

    Enumeration elements() {
        return this.vec.elements();
    }

    Object[] toArray(Object[] objectArray) {
        return this.vec.toArray(objectArray);
    }

    boolean exists(Object object) {
        Enumeration enumeration = this.vec.elements();
        while (enumeration.hasMoreElements()) {
            if (!object.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.vec.isEmpty();
    }

    boolean atEnd() {
        return this.currIdx == this.size - 1;
    }

    public String toString() {
        return this.vec.toString();
    }
}

