/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.ParagraphCodeAnalyzer;
import com.iscobol.compiler.ParagraphDesc;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IParagraphExtension;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Paragraph
implements CobolToken,
ErrorsNumbers,
IParagraphExtension {
    private static final String DECL_PREF = "declarative$";
    private Map deferredBlocksMap = new HashMap();
    protected LinkedList deferredBlockList = new LinkedList();
    private static int globProg;
    private TokenManager tm;
    private Errors error;
    private Token name;
    private int idNumber;
    private boolean isInDeclaratives;
    private Block paragraphBlock;
    private Pcc pc;
    private int loopCount;
    private int threadCount;
    private boolean isNameDup;
    private int prog;
    private int maxParLines = 0;
    final boolean isSection;
    protected ProcedureDivision procedure;
    private Section section;
    private boolean hasGoto;
    private boolean hasExitSect;
    private boolean goOnlyNextPar = true;
    private String actPerf = "";
    private NextSentenceBlock actNextSentence;

    protected Paragraph() {
        this.isSection = false;
    }

    public Paragraph(Pcc pcc, Token token, TokenManager tokenManager, Errors errors, boolean bl, ProcedureDivision procedureDivision) throws GeneralErrorException, EndOfProgramException {
        Token token2;
        this.procedure = procedureDivision;
        this.error = errors;
        this.tm = tokenManager;
        this.pc = pcc;
        this.name = token;
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.isNameDup = bl;
        if (this.isNameDup) {
            this.prog = ++globProg;
        }
        if ((token2 = this.tm.getToken()).getToknum() == 709) {
            this.isSection = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10002) {
                token2 = this.tm.getToken();
            }
        } else {
            this.isSection = false;
        }
        if (token2.getToknum() != 10006) {
            this.error.print(212, 3, token, token.getWord());
            this.tm.ungetToken();
        }
        this.setParagraphCodeLimit();
        this.init();
    }

    private void init() throws GeneralErrorException, EndOfProgramException {
        switch (this.pc.getTokenManager().getFormat()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (this.name.getOffset() < 4) break;
                this.error.print(253, 2, this.name, this.name.getWord());
            }
        }
        Pcc pcc = this.pc;
        while (pcc != null) {
            if (pcc.getAllVariables().get(this.getName()) != null) {
                this.error.print(254, 2, this.name, this.name.getWord());
                break;
            }
            pcc = pcc.parent;
        }
        this.paragraphBlock = new Block(this, null, this.pc, this.tm, this.error);
        this.paragraphBlock.setRaising(this.procedure.raising);
        this.paragraphBlock.parse(0);
        this.paragraphBlock.setParagraphBlock(true);
    }

    public Paragraph(Pcc pcc, Token token, TokenManager tokenManager, Errors errors, ProcedureDivision procedureDivision) throws GeneralErrorException, EndOfProgramException {
        this.procedure = procedureDivision;
        this.error = errors;
        this.tm = tokenManager;
        this.pc = pcc;
        this.name = token;
        this.isInDeclaratives = false;
        this.isSection = false;
        this.isNameDup = false;
        this.init();
    }

    public static void resetCounters() {
        globProg = 0;
    }

    public void setIdNumber(int n2) {
        this.idNumber = n2;
    }

    @Override
    public int getIdNumber() {
        return this.idNumber;
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.getWord();
    }

    public String getJavaName() {
        String string = this.isInDeclaratives ? DECL_PREF + this.name.getWord().replace('-', Pcc.hyphenRepl) : (Character.isDigit(this.name.getWord().charAt(0)) ? "_" + this.name.getWord().replace('-', Pcc.hyphenRepl) : this.name.getWord().replace('-', Pcc.hyphenRepl));
        if (this.section != null) {
            string = string + "$$" + this.section.getName().replace('-', Pcc.hyphenRepl);
        }
        if (this.isNameDup) {
            string = string + (Pcc.identifierSep + this.prog);
        }
        return string;
    }

    public void check() throws GeneralErrorException {
        this.paragraphBlock.check();
    }

    public void putDeferredBlock(int n2, String string) {
        boolean bl = this.pc.isFactory() && !(this.pc instanceof CobolMethod);
        boolean bl2 = !this.pc.getSplitFlag();
        this.deferredBlocksMap.put(new Integer(n2), new DeferredBlock(string, bl, bl2, this));
    }

    public DeferredBlock getDeferredBlock(int n2) {
        return (DeferredBlock)this.deferredBlocksMap.get(new Integer(n2));
    }

    public void clearDeferredBlocks() {
        this.deferredBlocksMap.clear();
        this.deferredBlockList.clear();
    }

    static Paragraph getDebugSection(Pcc pcc, Paragraph paragraph) {
        if (!pcc.isDebuggingMode()) {
            return null;
        }
        int n2 = pcc.getUseForDebuggingCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Paragraph paragraph2 = pcc.getUseForDebugSection(i2);
            if (paragraph2 == null) continue;
            int n3 = pcc.getDebuggedParagraphNumber(i2);
            boolean bl = false;
            if (n3 < 0) {
                bl = true;
                n3 = -n3;
            }
            if ((n3 != paragraph.getIdNumber() || bl != paragraph.isDeclaratives()) && (n3 != Integer.MAX_VALUE || paragraph.getSection() == paragraph2.getSection())) continue;
            return paragraph2;
        }
        return null;
    }

    public String getCode() {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.pc.getOption("-d") != null;
        stringBuffer.append(eol);
        stringBuffer.append(this.tm.getCommentCode(this.name, "   "));
        if (this.pc.isFactory() && !(this.pc instanceof CobolMethod)) {
            stringBuffer.append("   static ");
        } else {
            stringBuffer.append("   ");
        }
        stringBuffer.append("final ");
        if (!this.pc.getSplitFlag()) {
            stringBuffer.append("private ");
        }
        stringBuffer.append("int " + this.getJavaName());
        stringBuffer.append("() ");
        if (this.procedure.raising != null) {
            this.procedure.getThrows(stringBuffer);
            stringBuffer.append(", GotoException");
        } else {
            stringBuffer.append(" throws GotoException");
        }
        stringBuffer.append(" /* section = " + this.isSection + "*/");
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.pc.data != null) {
            bl2 = this.pc.data.lsSec != null;
            bl3 = this.pc.data.tlsSec != null;
        }
        Paragraph paragraph = Paragraph.getDebugSection(this.pc, this);
        if (bl2 || bl3 || bl || paragraph != null) {
            stringBuffer.append("   {");
            stringBuffer.append(eol + "   ");
            if (bl) {
                this.getDebugEnterCode(stringBuffer);
                stringBuffer.append(eol);
            }
            if (bl2) {
                this.pc.getLocalStorageCode(stringBuffer);
            }
            if (bl3) {
                this.pc.getThreadLocalStorageCode(stringBuffer);
            }
            if (paragraph != null) {
                n3 = paragraph.getIdNumber();
                n2 = paragraph.getLastParagraphInSameSection().getIdNumber();
                stringBuffer.append("   if(Factory.mustExecuteDebugCode()) {");
                stringBuffer.append(eol);
                stringBuffer.append("   ");
                stringBuffer.append("   " + Verb.getDebugItemLocalVar("DEBUG-NAME", this.pc.optionMS, this.pc.capitalizeNames) + ".set(\"");
                stringBuffer.append(this.getName());
                stringBuffer.append("\");");
                stringBuffer.append(eol);
                stringBuffer.append("   declaratives(");
                stringBuffer.append(n3);
                stringBuffer.append(" , ");
                stringBuffer.append(n2);
                stringBuffer.append(");");
                stringBuffer.append(eol);
                stringBuffer.append("      }");
                stringBuffer.append(eol);
            }
        }
        if ((n3 = this.getParagraphCodeLimit()) > 0) {
            int[] nArray = ParagraphCodeAnalyzer.analyze(n3, bl, this);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == 0) continue;
                String string = this.generateDeferredMethodName();
                this.putDeferredBlock(nArray[i2], string);
            }
        }
        n2 = this.paragraphBlock.getNotClosedCode(stringBuffer);
        if (bl && n2 != 0) {
            stringBuffer.append(eol + "   ");
            Paragraph.getDebugExitCode(stringBuffer);
            stringBuffer.append(eol);
        }
        if (bl || bl2 || bl3 || paragraph != null) {
            stringBuffer.append("   }");
            stringBuffer.append(eol);
        }
        if (n2 != 0) {
            this.getExitCode(stringBuffer, "0");
        }
        while (!this.deferredBlockList.isEmpty()) {
            DeferredBlock deferredBlock = (DeferredBlock)this.deferredBlockList.removeFirst();
            stringBuffer.append(deferredBlock.getCode());
        }
        return stringBuffer.toString();
    }

    protected void getExitCode(StringBuffer stringBuffer, String string) {
        if (this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null) {
            stringBuffer.append("      if (");
            if (this.pc.getSplitFlag()) {
                if (this.pc instanceof CobolMethod) {
                    stringBuffer.append("$$theMethod$$.");
                } else {
                    stringBuffer.append("$$theProgram$$.");
                }
            }
            stringBuffer.append(this.isInDeclaratives ? "$dexitPoint$" : "$exitPoint$");
            stringBuffer.append("[");
            stringBuffer.append(this.idNumber);
            stringBuffer.append("] != 0) ");
            stringBuffer.append(this.isInDeclaratives ? "dexit" : "exit");
            stringBuffer.append(" (");
            stringBuffer.append(this.idNumber);
            stringBuffer.append(");");
            stringBuffer.append(eol);
        }
        stringBuffer.append("      return " + string + ";");
        stringBuffer.append(eol);
        stringBuffer.append("   }");
        stringBuffer.append(eol);
    }

    private void getDebugEnterCode(StringBuffer stringBuffer) {
        this.getDebugEnterCode(stringBuffer, null);
    }

    protected void getDebugEnterCode(StringBuffer stringBuffer, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        Pcc pcc = this.pc.getRoot();
        String string6 = this.name.getFileName();
        if (File.separatorChar != '/') {
            string6 = string6.replace(File.separatorChar, '/');
        }
        int n2 = this.name.getFileIndex();
        if (string == null) {
            String string7 = null;
            if (this.pc instanceof CobolMethod) {
                string7 = ((CobolMethod)this.pc).getMethodDesc();
            }
            pcc.addParagraph(new ParagraphDesc(string7, this.name.getWord(), n2, this.name.getFLN(), this.idNumber, this.isInDeclaratives, this.isSection));
            pcc.addLine(new StatementDesc(n2, this.name.getFLN(), this.idNumber, this.isDeclaratives()));
        }
        while (pcc.parent != null) {
            pcc = pcc.parent;
        }
        boolean bl = this.pc.getOption("-dx") != null;
        stringBuffer.append("   Debugger.enterPar");
        if (bl) {
            stringBuffer.append("Ext");
        }
        stringBuffer.append(" (");
        stringBuffer.append(this.name.getFLN());
        stringBuffer.append(", \"");
        stringBuffer.append(string6);
        stringBuffer.append("\"");
        stringBuffer.append(", ");
        stringBuffer.append(n2);
        stringBuffer.append(", \"");
        stringBuffer.append(this.name.getWord());
        stringBuffer.append("\", ");
        stringBuffer.append(this.idNumber);
        stringBuffer.append(", ");
        if (this.pc instanceof CobolMethod) {
            string5 = pcc.getFullClassName() + ".class";
            string4 = this.pc.isFactory() ? "null" : (this.pc.isDefault() ? "$This$" : pcc.getFullClassName() + ".this");
            string3 = ((CobolMethod)this.pc).getLocalDataClass() + ".this";
            string2 = "\"" + ((CobolMethod)this.pc).getMethodName() + "\"";
        } else {
            string5 = pcc.getFullClassName() + ".class";
            string4 = "this";
            if (this.pc.getSplitFlag()) {
                string4 = this.pc.getClassName() + "." + string4;
            }
            if (string != null) {
                string3 = string5;
                string2 = string;
            } else {
                string3 = "null";
                string2 = "null";
            }
        }
        stringBuffer.append(string5);
        stringBuffer.append(", ");
        stringBuffer.append(string4);
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(this.isInDeclaratives);
        }
        stringBuffer.append(");");
    }

    public static void getDebugExitCode(StringBuffer stringBuffer) {
        stringBuffer.append("   Debugger.exitPar ();");
    }

    void enterLoop(boolean bl) {
        ++this.loopCount;
        if (bl) {
            ++this.threadCount;
        }
    }

    void exitLoop(boolean bl) {
        --this.loopCount;
        if (bl) {
            --this.threadCount;
        }
    }

    boolean inLoop() {
        return this.loopCount > 0;
    }

    boolean inThread() {
        return this.threadCount > 0;
    }

    boolean isDuplicate() {
        return this.isNameDup;
    }

    @Override
    public boolean isDeclaratives() {
        return this.isInDeclaratives;
    }

    void setIsDup() {
        this.isNameDup = true;
    }

    boolean isEmpty() {
        return this.paragraphBlock.verbs.getItemNum() == 0;
    }

    void setSection(Section section) {
        this.section = section;
    }

    public Paragraph getParagraphInSameSection(String string) {
        if (this.section != null) {
            return this.section.getParagraph(string);
        }
        return null;
    }

    public Paragraph getLastParagraphInSameSection() {
        if (this.section != null) {
            return this.section.getLastParagraph();
        }
        return null;
    }

    @Override
    public Section getSection() {
        return this.section;
    }

    @Override
    public Block getBlock() {
        return this.paragraphBlock;
    }

    public void setActPerf(String string) {
        this.actPerf = string;
    }

    public NextSentenceBlock getActNextSentence() {
        return this.actNextSentence;
    }

    public void setActNextSentence(NextSentenceBlock nextSentenceBlock) {
        this.actNextSentence = nextSentenceBlock;
    }

    public String getActPerf() {
        return this.actPerf;
    }

    public boolean hasGoto() {
        return this.hasGoto;
    }

    public boolean hasExitSect() {
        return this.hasExitSect;
    }

    public boolean hasGoOnlyNextPar() {
        return this.goOnlyNextPar;
    }

    public void setHasGoto(boolean bl) {
        this.hasGoto = bl;
        if (this.hasGoto) {
            this.goOnlyNextPar = false;
        }
    }

    public void setExitSect(boolean bl) {
        this.hasExitSect = bl;
    }

    public void setHasGoto(Paragraph paragraph) {
        this.hasGoto = true;
        if (paragraph == null || this.getIdNumber() + 1 != paragraph.getIdNumber()) {
            this.goOnlyNextPar = false;
        }
    }

    @Override
    public boolean isSection() {
        return this.isSection;
    }

    public int getPreProcessorIndex() {
        return this.name.getFileIndex();
    }

    public Pcc getPcc() {
        return this.pc;
    }

    public String generateDeferredMethodName() {
        String string = "_dm$" + this.getJavaName() + "$" + Verb.getUniqueId();
        return string;
    }

    public int getParagraphCodeLimit() {
        return this.maxParLines;
    }

    public void setParagraphCodeLimit() {
        try {
            String string = this.pc.getOption("-sns=");
            if (string != null) {
                this.maxParLines = Integer.parseInt(string);
            }
            if (this.pc.getOption("-d") != null) {
                this.maxParLines /= 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

