/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.Continue;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Evaluate;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.If;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Search;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.Vector;

public class ParagraphCodeAnalyzer {
    public static final int EXIT_PERFORM = -1;
    public static final int EXIT_PERFORM_CYCLE = -2;
    public static final int END_NEXT_SENTENCE = -3;
    public static final int EXIT_PARAGRAPH = -4;
    private int limit;
    private Vector blocks = new Vector();
    private int deferredMethodId;
    private boolean debug;

    private ParagraphCodeAnalyzer(int n2, boolean bl, Block block) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("" + n2);
        }
        this.limit = n2;
        this.debug = bl;
        MyBlock myBlock = new MyBlock(0);
        this.blocks.addElement(myBlock);
        this.init(block, myBlock, null, -1);
    }

    public static int[] analyze(int n2, boolean bl, Paragraph paragraph) {
        ParagraphCodeAnalyzer paragraphCodeAnalyzer = new ParagraphCodeAnalyzer(n2, bl, paragraph.getBlock());
        return paragraphCodeAnalyzer.analyze();
    }

    void init(Block block, MyBlock myBlock, MyVerb myVerb, int n2) {
        VerbList verbList = block.getVerbs();
        NextSentenceBlock nextSentenceBlock = null;
        Verb verb = verbList.getFirst();
        while (verb != null) {
            block5: {
                block6: {
                    block4: {
                        if (!(verb instanceof NextSentenceBlock)) break block4;
                        if (nextSentenceBlock != null) break block5;
                        nextSentenceBlock = (NextSentenceBlock)verb;
                        break block6;
                    }
                    if (verb instanceof NextSentenceBlock.End) {
                        nextSentenceBlock = null;
                    }
                }
                MyVerb myVerb2 = new MyVerb(verb, myVerb, n2);
                myBlock.verbs.addElement(myVerb2);
                Block[] blockArray = verb.getNestedBlocks();
                int n3 = 0;
                for (int i2 = 0; i2 < blockArray.length; ++i2) {
                    this.init(blockArray[i2], myBlock, myVerb2, n3);
                    if (blockArray[i2].isEmpty()) continue;
                    ++n3;
                }
                NextSentence nextSentence = verb instanceof If ? ((If)verb).getNextSentence() : (verb instanceof Search ? ((Search)verb).getNextSentence() : null);
                if (nextSentence != null) {
                    MyVerb myVerb3 = new MyVerb(nextSentence, myVerb2, blockArray.length);
                    myBlock.verbs.addElement(myVerb3);
                }
            }
            verb = verbList.getNext();
        }
    }

    int[] analyze() {
        for (int i2 = 0; i2 < this.blocks.size(); ++i2) {
            boolean bl;
            MyBlock myBlock = (MyBlock)this.blocks.elementAt(i2);
            if (myBlock.ok || !(bl = this.analyze0(myBlock))) continue;
            i2 = -1;
        }
        int[] nArray = new int[this.blocks.size()];
        for (int i3 = 0; i3 < this.blocks.size(); ++i3) {
            nArray[i3] = ((MyBlock)this.blocks.elementAt(i3)).deferredMethodId;
        }
        return nArray;
    }

    boolean analyze0(MyBlock myBlock) {
        NextSentenceBlock nextSentenceBlock = null;
        int n2 = myBlock.verbs.size() > 0 ? ((MyVerb)myBlock.verbs.elementAt(0)).blockId : -1;
        int n3 = 0;
        int n4 = 0;
        while (n3 < myBlock.verbs.size()) {
            block21: {
                MyVerb myVerb;
                block23: {
                    block22: {
                        block20: {
                            myVerb = (MyVerb)myBlock.verbs.elementAt(n3);
                            if (!(myVerb.verb instanceof Entry)) break block20;
                            n4 = -1;
                            break block21;
                        }
                        if (!(myVerb.verb instanceof NextSentenceBlock)) break block22;
                        --n4;
                        if (nextSentenceBlock != null) break block21;
                        nextSentenceBlock = (NextSentenceBlock)myVerb.verb;
                        break block23;
                    }
                    if (myVerb.verb instanceof NextSentenceBlock.End) {
                        nextSentenceBlock = null;
                        --n4;
                    } else if (!this.debug && myVerb.verb instanceof Continue) {
                        --n4;
                    }
                }
                MyVerb myVerb2 = myVerb.parent;
                int n5 = myVerb.blockId;
                if (n4 == this.limit) {
                    ++this.deferredMethodId;
                    if (myVerb2 != null) {
                        Object object;
                        boolean bl;
                        MyVerb myVerb3;
                        MyBlock myBlock2 = new MyBlock(this.deferredMethodId);
                        for (int i2 = n3 - 1; i2 >= 0 && (myVerb3 = (MyVerb)myBlock.verbs.elementAt(i2)).isDescendantOf(myVerb2, n5); --i2) {
                            myBlock2.verbs.add(0, myVerb3);
                            myVerb3.verb.setDeferredMethodId(this.deferredMethodId);
                            myBlock.verbs.removeElementAt(i2);
                            --n3;
                        }
                        boolean bl2 = bl = myVerb2.verb instanceof Evaluate && n5 > n2 && n5 > 0;
                        if (bl) {
                            object = (Evaluate)myVerb2.verb;
                            n5 = -1;
                            VerbList verbList = ((Evaluate)object).getObjectSet();
                            boolean bl3 = false;
                            Verb verb = verbList.getFirst();
                            while (verb != null) {
                                if (!bl3) {
                                    boolean bl4 = bl3 = ((EvaluateSuObject)verb).getBlock() == myVerb.verb.getParent();
                                    if (bl3) {
                                        int n6 = verbList.getCurrentIndex();
                                        Verb verb2 = verbList.getPrevious();
                                        while (verb2 != null) {
                                            EvaluateSuObject evaluateSuObject = (EvaluateSuObject)verb2;
                                            if (evaluateSuObject.block != null && !evaluateSuObject.block.isEmpty()) break;
                                            verb2.setDeferredMethodId(this.deferredMethodId);
                                            verb2 = verbList.getPrevious();
                                        }
                                        verbList.getAt(n6);
                                    }
                                }
                                if (bl3) {
                                    verb.setDeferredMethodId(this.deferredMethodId);
                                }
                                verb = verbList.getNext();
                            }
                        }
                        while (n3 < myBlock.verbs.size() && (myVerb3 = (MyVerb)myBlock.verbs.elementAt(n3)).isDescendantOf(myVerb2, n5)) {
                            myBlock2.verbs.addElement(myVerb3);
                            myVerb3.verb.setDeferredMethodId(this.deferredMethodId);
                            myBlock.verbs.removeElementAt(n3);
                        }
                        if (!bl) {
                            for (n3 = 0; n3 < myBlock2.verbs.size(); ++n3) {
                                object = (MyVerb)myBlock2.verbs.elementAt(n3);
                                if (((MyVerb)object).parent != myVerb2) continue;
                                ((MyVerb)object).parent = null;
                            }
                        }
                        this.blocks.addElement(myBlock2);
                        if (myBlock.verbs.size() <= this.limit) {
                            myBlock.ok = true;
                        }
                        if (myBlock2.verbs.size() <= this.limit) {
                            myBlock2.ok = true;
                        }
                        return true;
                    }
                    MyBlock myBlock3 = new MyBlock(this.deferredMethodId);
                    int n7 = n3;
                    while (n7 < myBlock.verbs.size()) {
                        MyVerb myVerb4 = (MyVerb)myBlock.verbs.elementAt(n7);
                        myBlock3.verbs.addElement(myVerb4);
                        myVerb4.verb.setDeferredMethodId(this.deferredMethodId);
                        myBlock.verbs.removeElementAt(n7);
                    }
                    this.blocks.addElement(myBlock3);
                    myBlock.ok = true;
                    if (myBlock3.verbs.size() <= this.limit) {
                        myBlock3.ok = true;
                    }
                    return true;
                }
            }
            ++n3;
            ++n4;
        }
        myBlock.ok = true;
        return false;
    }

    public int[] getBlockSizes() {
        int[] nArray = new int[this.blocks.size()];
        for (int i2 = 0; i2 < this.blocks.size(); ++i2) {
            nArray[i2] = ((MyBlock)this.blocks.elementAt(i2)).verbs.size();
        }
        return nArray;
    }

    private class MyVerb {
        private Verb verb;
        private MyVerb parent;
        private int blockId;

        private MyVerb(Verb verb, MyVerb myVerb, int n2) {
            this.verb = verb;
            this.parent = myVerb;
            this.blockId = n2;
        }

        public String toString() {
            if (this.verb.getKeyWord() != null) {
                return this.verb.getKeyWord().getFLN() + ": " + this.verb.getKeyWord().getWord() + " [" + this.verb.getDeferredMethodId() + "]";
            }
            return this.verb.getClass().getName() + " [" + this.verb.getDeferredMethodId() + "]";
        }

        boolean isDescendantOf(MyVerb myVerb, int n2) {
            if (this.parent == null) {
                return false;
            }
            if (this.parent == myVerb) {
                return n2 == -1 || n2 == this.blockId;
            }
            return this.parent.isDescendantOf(myVerb, n2);
        }
    }

    private class MyBlock {
        private Vector verbs = new Vector();
        private boolean ok;
        private int deferredMethodId;

        MyBlock(int n2) {
            this.deferredMethodId = n2;
        }
    }
}

