/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VaryingAfter;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.io.File;

public class Perform
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final String PERFORM = "perform";
    static final String METHOD_PERFORM = "methodPerform";
    static final String DECLARATIVES = "declaratives";
    private static int uniqueId;
    private LabelName startLabel;
    private LabelName endLabel;
    private Token startName;
    private Token endName;
    private int startNum = -1;
    private int endNum = -1;
    private Token timesTk;
    private VariableName timesVar;
    private Block block;
    boolean testAfter;
    private VerbList afters;
    Condition until;
    private boolean untilExit;
    private boolean isInDeclaratives;
    private String javaMethodName;
    private boolean thread;
    private VariableName threadHandle;
    final boolean optimize;

    public Perform(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.optimize = tokenManager.getOptionList().getOption("-dx") == null;
        this.isInDeclaratives = this.pc.inDeclaratives;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 526 && (token2 = this.tm.getToken()).getToknum() != 763) {
            throw new ExpectedFoundException(token2, this.error, "'THREAD'");
        }
        if (token2.getToknum() == 763) {
            this.thread = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 510) {
                this.handle();
                token2 = this.tm.getToken();
            }
        }
        if (token2.getToknum() == 10009 || token2.getToknum() == 10002) {
            this.startName = token2;
            this.tm.ungetToken();
            if (token2.getToknum() == 10009) {
                this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
                if (this.startLabel != null) {
                    this.startLabel.rewind();
                }
                this.timesVar = VariableName.get(this.tm, this.error, this.pc, true, false);
            } else {
                this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 768 || token2.getToknum() == 767) {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10009 && token2.getToknum() != 10002) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                this.endName = token2;
                this.tm.ungetToken();
                this.endLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
                token2 = this.tm.getToken();
            }
            if (this.thread && token2.getToknum() == 510) {
                this.handle();
                token2 = this.tm.getToken();
            }
        }
        if (token2.getToknum() == 770) {
            if (this.startName == null || this.endName != null) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.tm.ungetToken();
            token2 = this.startName;
            this.startName = null;
            this.startLabel = null;
        }
        boolean bl = false;
        if (token2.getToknum() == 10009 || Token.isIntLit(token2)) {
            this.timesTk = token2;
            if (token2.getToknum() == 10009) {
                if (this.startName != null) {
                    this.tm.ungetToken();
                    this.timesVar = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    this.timesVar.check(this.pc);
                }
            }
            if ((token2 = this.tm.getToken()).getToknum() != 770) {
                throw new ExpectedFoundException(token2, this.error, "'TIMES'");
            }
        } else {
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 760) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 261) {
                    this.testAfter = true;
                } else if (token2.getToknum() != 299) {
                    throw new ExpectedFoundException(token2, this.error, "'AFTER'");
                }
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 807) {
                this.pc.pushLocalVariables();
                this.varying();
                bl = true;
            } else if (token2.getToknum() == 791) {
                this.until();
            } else {
                this.tm.ungetToken();
            }
        }
        if (this.startName == null) {
            this.parent.parent.enterLoop(this.thread);
            this.block = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, this.testAfter);
            if (bl) {
                this.pc.popLocalVariables();
            }
            this.parent.parent.exitLoop(this.thread);
            token2 = this.tm.getToken();
            if (token2.getToknum() != 440) {
                this.error.print(154, 3, token2, "END-PERFORM");
                this.tm.ungetToken();
            }
        }
    }

    public static void resetCounters() {
        uniqueId = 0;
    }

    private void handle() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() != 526) {
            this.tm.ungetToken();
        }
        this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
        if (this.threadHandle == null) {
            token = this.tm.getToken();
            throw new UnexpectedTokenException(token, this.error);
        }
        if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
            throw new ClauseClashException(token, this.error, this.threadHandle.getName());
        }
    }

    private void varying() throws GeneralErrorException, EndOfProgramException {
        this.afters = new VerbList();
        this.afters.addItem(new VaryingAfter(this.keyWord, this.parent, this.pc, this.tm, this.error, this.testAfter, this));
        while (this.tm.getToken().getToknum() == 261) {
            this.afters.addItem(new VaryingAfter(this.keyWord, this.parent, this.pc, this.tm, this.error, this.testAfter, this));
        }
        this.tm.ungetToken();
    }

    private void until() throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() == 476) {
            this.untilExit = true;
        } else {
            this.tm.ungetToken();
            this.until = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
            if (!this.until.isFullCondition()) {
                throw new IllegalConditionException(this.keyWord, this.error);
            }
        }
    }

    private static GeneralErrorInfo findParagraphs(LabelName labelName, LabelName labelName2, int[] nArray, boolean bl) {
        if (labelName != null) {
            GeneralErrorInfo generalErrorInfo = labelName.check(bl);
            if (generalErrorInfo != null) {
                return generalErrorInfo;
            }
            Paragraph paragraph = labelName.getParagraph();
            nArray[0] = paragraph.getIdNumber();
            if (paragraph.isSection) {
                paragraph = paragraph.getLastParagraphInSameSection();
                nArray[1] = paragraph.getIdNumber();
            } else {
                nArray[1] = nArray[0];
            }
            if (labelName2 != null) {
                generalErrorInfo = labelName2.check(bl);
                if (generalErrorInfo != null) {
                    return generalErrorInfo;
                }
                paragraph = labelName2.getParagraph();
                if (paragraph.isSection) {
                    paragraph = paragraph.getLastParagraphInSameSection();
                }
                nArray[1] = paragraph.getIdNumber();
            }
        }
        return null;
    }

    static String check(LabelName labelName, LabelName labelName2, int[] nArray, boolean bl, Pcc pcc) throws GeneralErrorException {
        return Perform.check(labelName, labelName2, nArray, bl, false, pcc);
    }

    static String check(LabelName labelName, LabelName labelName2, int[] nArray, boolean bl, boolean bl2, Pcc pcc) throws GeneralErrorException {
        GeneralErrorInfo generalErrorInfo;
        String string;
        if (bl) {
            string = DECLARATIVES;
            generalErrorInfo = Perform.findParagraphs(labelName, labelName2, nArray, true);
            if (generalErrorInfo != null && generalErrorInfo.type == 105 && Perform.findParagraphs(labelName, labelName2, nArray, false) == null) {
                generalErrorInfo = null;
                string = PERFORM;
            }
        } else {
            string = pcc instanceof CobolMethod ? (bl2 ? PERFORM : METHOD_PERFORM) : PERFORM;
            generalErrorInfo = Perform.findParagraphs(labelName, labelName2, nArray, false);
            if (generalErrorInfo != null && generalErrorInfo.type == 105 && Perform.findParagraphs(labelName, labelName2, nArray, true) == null) {
                generalErrorInfo = null;
                string = DECLARATIVES;
            }
        }
        if (generalErrorInfo != null) {
            throw new GeneralErrorException(generalErrorInfo);
        }
        return string;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.timesVar != null && this.timesVar.getVarDecl() != null) {
            if (this.timesVar.getVarDecl() instanceof VariableDeclarationScreen) {
                throw new GeneralErrorException(165, 4, this.timesVar.getNameToken(), this.timesVar.getName(), this.error);
            }
            if (!this.timesVar.isInteger()) {
                if (!this.timesVar.isNumericVar() || this.timesVar.isEdited()) {
                    throw new GeneralErrorException(46, 4, this.keyWord, this.timesVar.toString(), this.error);
                }
                this.error.print(46, 2, this.timesVar.getNameToken(), this.timesVar.getName());
            }
        }
        int[] nArray = new int[]{this.getStartNum(), this.getEndNum()};
        this.javaMethodName = Perform.check(this.startLabel, this.endLabel, nArray, this.isInDeclaratives, this.thread, this.pc);
        this.startNum = nArray[0];
        this.endNum = nArray[1];
        if (this.afters != null) {
            VaryingAfter varyingAfter = (VaryingAfter)this.afters.getLast();
            while (varyingAfter != null) {
                varyingAfter.check();
                varyingAfter = (VaryingAfter)this.afters.getPrevious();
            }
        }
        if (this.until != null) {
            this.until.check();
        }
    }

    static boolean getPerformCode(Pcc pcc, int n2, int n3, String string, StringBuffer stringBuffer, String string2, LabelName labelName, boolean bl) {
        int n4;
        Paragraph paragraph;
        int n5;
        int n6;
        boolean bl2 = pcc.getSplitFlag();
        if ((pcc.getOption("-pt0") != null || pcc.getOption("-pt2") != null) && (PERFORM.equals(string2) || DECLARATIVES.equals(string2))) {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(" (");
            stringBuffer.append(n2);
            stringBuffer.append(",");
            stringBuffer.append(n3);
            stringBuffer.append(",");
            stringBuffer.append(++uniqueId);
            stringBuffer.append(");");
            return false;
        }
        boolean bl3 = labelName.isInDeclaratives();
        stringBuffer.append(eol);
        stringBuffer.append(string);
        if (bl && (PERFORM.equals(string2) || METHOD_PERFORM.equals(string2))) {
            Paragraph paragraph2 = labelName.getParagraph();
            if (n2 == n3 && !paragraph2.hasGoto()) {
                if (paragraph2.hasExitSect()) {
                    stringBuffer.append("try {");
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                }
                if (bl2) {
                    if (pcc instanceof CobolMethod) {
                        stringBuffer.append("$$theMethod$$");
                    } else {
                        stringBuffer.append("$$theProgram$$");
                    }
                    stringBuffer.append(".");
                }
                stringBuffer.append(paragraph2.getJavaName());
                stringBuffer.append("();");
                if (paragraph2.hasExitSect()) {
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    stringBuffer.append("} catch (ExitSectionException esex) {}");
                }
                return true;
            }
            if (n3 > n2 && paragraph2.hasGoOnlyNextPar() && !pcc.getParagraphById(n3, bl3).hasGoto()) {
                n6 = 0;
                for (n5 = n2; n5 < n3 && (paragraph = pcc.getParagraphById(n5, bl3)).hasGoOnlyNextPar(); ++n5) {
                    if (!paragraph.hasExitSect()) continue;
                    n6 = 1;
                }
                if (n5 == n3) {
                    Section section;
                    paragraph = pcc.getParagraphById(n5, bl3);
                    if (paragraph.hasExitSect()) {
                        n6 = 1;
                    }
                    stringBuffer.append("{");
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    if (n6 != 0) {
                        stringBuffer.append("try {");
                        stringBuffer.append(eol);
                        stringBuffer.append(string);
                        section = paragraph2.getSection();
                    } else {
                        section = null;
                    }
                    for (n5 = n2; n5 <= n3; ++n5) {
                        paragraph = pcc.getParagraphById(n5, bl3);
                        if (n6 != 0 && section != paragraph.getSection()) {
                            stringBuffer.append("} catch (ExitSectionException esex) {}");
                            stringBuffer.append(eol);
                            stringBuffer.append(string);
                            stringBuffer.append("try {");
                            stringBuffer.append(eol);
                            stringBuffer.append(string);
                            section = paragraph.getSection();
                        }
                        if (bl2) {
                            if (pcc instanceof CobolMethod) {
                                stringBuffer.append("$$theMethod$$");
                            } else {
                                stringBuffer.append("$$theProgram$$");
                            }
                            stringBuffer.append(".");
                        }
                        stringBuffer.append(paragraph.getJavaName());
                        stringBuffer.append("();");
                        stringBuffer.append(eol);
                        stringBuffer.append(string);
                    }
                    if (n6 != 0) {
                        stringBuffer.append("} catch (ExitSectionException esex) {}");
                        stringBuffer.append(eol);
                        stringBuffer.append(string);
                    }
                    stringBuffer.append("}");
                    stringBuffer.append(eol);
                    return true;
                }
            }
        }
        for (n4 = n2; n4 < n3 && !(paragraph = pcc.getParagraphById(n4, bl3)).hasExitSect(); ++n4) {
        }
        n6 = n2;
        int n7 = n5 = n4 != n3 ? 1 : 0;
        if (n5 != 0) {
            Section section = labelName.getParagraph().getSection();
            stringBuffer.append("{");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            for (n4 = n2; n4 <= n3; ++n4) {
                paragraph = pcc.getParagraphById(n4, bl3);
                if (section == paragraph.getSection()) continue;
                stringBuffer.append(string2);
                stringBuffer.append(" (");
                stringBuffer.append(n6);
                stringBuffer.append(",");
                stringBuffer.append(n4 - 1);
                stringBuffer.append(");");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                section = paragraph.getSection();
                n6 = n4;
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append(" (");
        stringBuffer.append(n6);
        stringBuffer.append(",");
        stringBuffer.append(n3);
        stringBuffer.append(");");
        if (n5 != 0) {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("}");
        }
        return false;
    }

    static boolean isEmpty(Pcc pcc, int n2, int n3, boolean bl) {
        Paragraph paragraph;
        int n4;
        if (n2 > n3) {
            return false;
        }
        for (n4 = n2; n4 <= n3 && (paragraph = pcc.getParagraphById(n4, bl)).isEmpty(); ++n4) {
        }
        return n4 > n3;
    }

    @Override
    protected void getCodeDebug(StringBuffer stringBuffer) {
        if (this.startName != null) {
            int n2 = this.keyWord.getFLN();
            if (this.keyWord.isLineRepl()) {
                if (n2 != this.pc.lastReplLine) {
                    this.pc.lastReplLine = n2;
                } else {
                    n2 = -n2;
                }
            }
            if (this.pc.getOption("-d") != null) {
                boolean bl;
                int n3 = this.keyWord.getFileIndex();
                boolean bl2 = bl = this.pc.getOption("-dx") != null;
                if (bl) {
                    stringBuffer.append("if(");
                }
                stringBuffer.append("Debugger.outlinePerform");
                if (bl) {
                    stringBuffer.append("Ext");
                }
                stringBuffer.append(" (");
                stringBuffer.append(n2);
                stringBuffer.append(", \"");
                String string = this.keyWord.getFileName();
                if (File.separatorChar != '/') {
                    string = string.replace(File.separatorChar, '/');
                }
                stringBuffer.append(Pcc.escapeString(string));
                stringBuffer.append("\", ");
                stringBuffer.append(n3);
                stringBuffer.append(", ");
                stringBuffer.append(this.getEndNum());
                stringBuffer.append(")");
                if (bl) {
                    stringBuffer.append(") {");
                } else {
                    stringBuffer.append(";");
                }
                stringBuffer.append(eol);
                if (this.parent != null) {
                    stringBuffer.append(this.parent.getIndent());
                }
                Pcc pcc = this.pc;
                while (pcc.parent != null && !(pcc instanceof CobolProgram)) {
                    pcc = pcc.parent;
                }
                int n4 = 0;
                boolean bl3 = false;
                if (this.parent != null && this.parent.getParent() != null && this.parent.getParentVerb() == null) {
                    n4 = this.parent.getParent().getIdNumber();
                    bl3 = this.parent.getParent().isDeclaratives();
                }
                pcc.addLine(new StatementDesc(n3, n2, n4, bl3));
            }
            this.getCodeSMAP(stringBuffer, n2, false);
        } else {
            super.getCodeDebug(stringBuffer);
        }
    }

    @Override
    public String getCode() {
        Object object;
        boolean bl;
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            string2 = this.getBlock().getParent().getActPerf();
        }
        String string3 = "_isPerf_" + Perform.getUniqueId();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        boolean bl2 = bl = this.pc.getOption("-d") != null;
        if (this.thread) {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("new Monitor (");
            if (this.threadHandle != null) {
                stringBuffer.append(this.threadHandle.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(", Factory.getCurrentMonitor()) {");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("final Object $this = Factory.peekCall(1);");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("final Object[] $argv = Factory.peekCallParams();");
            stringBuffer.append(eol);
            if (bl) {
                stringBuffer.append(string);
                stringBuffer.append("final Debugger $dbg = Debugger.newThread();");
                stringBuffer.append(eol);
            }
            stringBuffer.append(string);
            stringBuffer.append("   public void launch () {");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(string + "Debugger.enterThread($dbg);");
                stringBuffer.append(string);
            }
            stringBuffer.append(eol);
            stringBuffer.append(string).append("try {").append(eol);
            stringBuffer.append(string);
            stringBuffer.append("   Factory.activeCallsPush($this");
            if (this.pc instanceof CobolMethod) {
                stringBuffer.append(" != null ? $this : new com.iscobol.java.IsCobol()");
            }
            stringBuffer.append(", $argv);");
            if (this.getBlock() != null && this.pc.data != null && this.pc.data.tlsSec != null) {
                stringBuffer.append(eol);
                stringBuffer.append(string);
                this.pc.getThreadLocalStorageCode(stringBuffer);
            }
        }
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf("");
        }
        if (this.timesTk != null) {
            object = "i$" + Perform.getUniqueId();
            stringBuffer.append(this.parent.getIndent());
            string = string + " ";
            this.setLabel(string3, stringBuffer);
            stringBuffer.append("for (long ");
            stringBuffer.append((String)object);
            stringBuffer.append(" = ");
            if (this.timesVar == null || this.timesVar.getVarDecl() == null) {
                stringBuffer.append(this.timesTk.getAsLong());
            } else {
                stringBuffer.append(this.timesVar.getCode() + ".num().longValue()");
            }
            stringBuffer.append("; ");
            stringBuffer.append((String)object);
            stringBuffer.append(" > 0; ");
            stringBuffer.append((String)object);
            stringBuffer.append("--)");
        } else if (this.afters != null) {
            stringBuffer.append(eol);
            this.setLabel(string3, stringBuffer);
            object = (VaryingAfter)this.afters.getFirst();
            while (object != null) {
                stringBuffer.append(((VaryingAfter)object).getCodeBefore());
                object = (VaryingAfter)this.afters.getNext();
            }
        } else if (this.until != null) {
            stringBuffer.append(this.parent.getIndent());
            this.setLabel(string3, stringBuffer);
            stringBuffer.append("for ( ; ; ) {");
            if (!this.testAfter) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if (");
                stringBuffer.append(this.until.getCode());
                stringBuffer.append(") break;");
                stringBuffer.append(eol);
            }
        } else if (this.untilExit) {
            stringBuffer.append(this.parent.getIndent());
            this.setLabel(string3, stringBuffer);
            stringBuffer.append("for ( ; ; ) {");
            stringBuffer.append("if (null != null) break;");
            stringBuffer.append(eol);
        } else if (this.startName == null) {
            if (this.thread) {
                stringBuffer.append(eol);
            }
            object = "i$" + Perform.getUniqueId();
            stringBuffer.append(this.parent.getIndent());
            string = string + " ";
            this.setLabel(string3, stringBuffer);
            stringBuffer.append("for (int ");
            stringBuffer.append((String)object);
            stringBuffer.append(" = 0;");
            stringBuffer.append((String)object);
            stringBuffer.append(" < 1;");
            stringBuffer.append((String)object);
            stringBuffer.append("++)");
        }
        if (this.startName != null) {
            Perform.getPerformCode(this.pc, this.getStartNum(), this.getEndNum(), string, stringBuffer, this.javaMethodName, this.startLabel, this.optimize);
        } else {
            stringBuffer.append(this.getBlock().getCode());
        }
        stringBuffer.append(eol);
        if (this.afters != null) {
            object = (VaryingAfter)this.afters.getLast();
            while (object != null) {
                stringBuffer.append(((VaryingAfter)object).getCode());
                object = (VaryingAfter)this.afters.getPrevious();
            }
        } else if (this.until != null) {
            if (this.testAfter) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if (");
                stringBuffer.append(this.until.getCode());
                stringBuffer.append(") break;");
                stringBuffer.append(eol);
            }
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}");
            stringBuffer.append(eol);
        } else if (this.untilExit) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}");
            stringBuffer.append(eol);
        } else if (this.untilExit) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}");
            stringBuffer.append(eol);
        }
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf(string2);
        }
        if (this.thread) {
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("Factory.activeCallsPop();");
            stringBuffer.append(eol);
            stringBuffer.append(string).append("} catch(StopRunException srex) {").append(eol);
            stringBuffer.append(string).append("} catch(Throwable ex) { ErrorBox.show(ex); }").append(eol);
            if (bl) {
                stringBuffer.append(string + "Debugger.exitThread();" + eol);
            }
            stringBuffer.append(string);
            stringBuffer.append("   }");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}.start();");
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private void setLabel(String string, StringBuffer stringBuffer) {
        stringBuffer.append("    ");
        stringBuffer.append(string);
        stringBuffer.append(":   ");
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf(" " + string);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public int getEndNum() {
        return this.endNum;
    }

    public Token getTimesToken() {
        return this.timesTk;
    }

    public VariableName getTimesVariable() {
        if (this.timesVar != null && this.timesVar.getVarDecl() != null) {
            return this.timesVar;
        }
        return null;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public boolean isTestAfter() {
        return this.testAfter;
    }

    public Condition getUntil() {
        return this.until;
    }

    public VerbList getAfters() {
        return this.afters;
    }

    public boolean isUntilExit() {
        return this.untilExit;
    }

    public LabelName getStartLabelName() {
        return this.startLabel;
    }

    public LabelName getEndLabelName() {
        return this.endLabel;
    }
}

