/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;

public class PreCondition
implements CobolToken,
ErrorsNumbers {
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private static final int OP_EQ = 1;
    private static final int OP_NE = 2;
    private static final int OP_GE = 3;
    private static final int OP_LE = 4;
    private static final int OP_GT = 5;
    private static final int OP_LT = 6;
    private static final int OP_C_POSITIVE = 7;
    private static final int OP_C_NEGATIVE = 8;
    private static final int OP_C_ZERO = 9;
    private static final int OP_C_NUMERIC = 10;
    private static final int OP_C_ALPHABETIC = 11;
    private static final int OP_C_ALPHABETIC_UPPER = 12;
    private static final int OP_C_ALPHABETIC_LOWER = 13;
    private static final int OP_C_DEFINED = 14;
    private static final byte DJ_END = 0;
    private static final byte DJ_OR = 1;
    private static final byte DJ_AND = 2;
    private static final byte DJ_NOT = 3;
    private static final byte DJ_OPEN_PAR = 4;
    private static final byte DJ_CLOSE_PAR = 5;
    private static final byte DJ_TRUE = 6;
    private static final byte DJ_FALSE = 7;
    private static final char[] djdescr = new char[]{'!', '|', '&', '~', '(', ')', 'T', 'F'};
    private final int D_2STK = 1;
    private final int D_2PFX = 2;
    private final int D_POP = 3;
    private final int D_STOP = 4;
    private final int D_ERR = 5;
    final int[][] decTab = new int[][]{{4, 1, 1, 1, 1, 5}, {2, 2, 1, 1, 1, 2}, {2, 2, 2, 1, 1, 2}, {2, 2, 2, 1, 1, 2}, {5, 1, 1, 1, 1, 3}};
    private TokenList _tl;
    private PreProcessor pp;
    private boolean result;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;

    public PreCondition(PreProcessor preProcessor, TokenList tokenList) {
        this.pp = preProcessor;
        this._tl = tokenList;
    }

    public int parse() {
        CondItem condItem3;
        Stack<CondItem> stack = new Stack<CondItem>();
        Stack<Object> stack2 = new Stack<Object>();
        stack2.add(new CondItem(0));
        Stack<CondItem> stack3 = new Stack<CondItem>();
        do {
            condItem3 = new CondItem();
            stack.add(condItem3);
        } while (condItem3.type > 0 && condItem3.type != 0);
        if (condItem3.type < 0) {
            return -condItem3.type;
        }
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            condItem3 = (CondItem)iterator.next();
            if (condItem3.type == 6 || condItem3.type == 7) {
                stack3.add(condItem3);
                continue;
            }
            boolean bl = true;
            block18: while (bl) {
                CondItem condItem2 = (CondItem)stack2.peek();
                switch (this.decTab[condItem2.type][condItem3.type]) {
                    case 1: {
                        stack2.add(condItem3);
                        bl = false;
                        continue block18;
                    }
                    case 2: {
                        stack3.add((CondItem)stack2.pop());
                        continue block18;
                    }
                    case 3: {
                        stack2.pop();
                        bl = false;
                        continue block18;
                    }
                    case 4: {
                        if (iterator.hasNext()) {
                            throw new InternalErrorException("parse I");
                        }
                        bl = false;
                        continue block18;
                    }
                    case 5: {
                        return 44;
                    }
                }
                throw new InternalErrorException("parse II");
            }
        }
        stack2.clear();
        try {
            block19: for (CondItem condItem3 : stack3) {
                switch (condItem3.type) {
                    case 2: {
                        stack2.push((Boolean)stack2.pop() & (Boolean)stack2.pop() ? TRUE : FALSE);
                        continue block19;
                    }
                    case 1: {
                        stack2.push((Boolean)stack2.pop() | (Boolean)stack2.pop() ? TRUE : FALSE);
                        continue block19;
                    }
                    case 3: {
                        stack2.push((Boolean)stack2.pop() != false ? FALSE : TRUE);
                        continue block19;
                    }
                    case 6: {
                        stack2.push(TRUE);
                        continue block19;
                    }
                    case 7: {
                        stack2.push(FALSE);
                        continue block19;
                    }
                }
                return 43;
            }
            if (stack2.size() != 1) {
                return 43;
            }
            this.result = (Boolean)stack2.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return 43;
        }
        return 0;
    }

    public boolean evaluate() {
        return this.result;
    }

    private Token getPrevious() {
        return this._tl.getPrevious();
    }

    private Token getNext() {
        Token token = this._tl.getNext();
        if (token != null && (token.getToknum() == 10005 || token.getToknum() == 10020)) {
            token = null;
        }
        return token;
    }

    class CondItem {
        final int type;
        Long[] lngOperand;
        String[] strOperand;

        private CondItem(int n2) {
            this.type = n2;
        }

        private CondItem() {
            Token token = PreCondition.this.getNext();
            if (token == null) {
                this.type = 0;
            } else {
                switch (token.getToknum()) {
                    case 617: {
                        this.type = 1;
                        break;
                    }
                    case 274: {
                        this.type = 2;
                        break;
                    }
                    case 598: {
                        this.type = 3;
                        break;
                    }
                    case 40: {
                        this.type = 4;
                        break;
                    }
                    case 41: {
                        this.type = 5;
                        break;
                    }
                    default: {
                        PreCondition.this.getPrevious();
                        this.type = this.parse();
                    }
                }
            }
        }

        private int parse() {
            boolean bl = false;
            int n2 = this.findValue(0);
            if (n2 == 0) {
                int n3;
                Token token = PreCondition.this.getNext();
                if (token == null) {
                    return -43;
                }
                if (token.getToknum() == 545 && (token = PreCondition.this.getNext()) == null) {
                    return -43;
                }
                if (token.getToknum() == 598) {
                    bl = true;
                    token = PreCondition.this.getNext();
                    if (token == null) {
                        return -43;
                    }
                }
                try {
                    switch (token.getToknum()) {
                        case 61: 
                        case 462: {
                            n3 = 1;
                            token = PreCondition.this.getNext();
                            if (token.getToknum() != 773) {
                                PreCondition.this.getPrevious();
                            }
                            break;
                        }
                        case 60: 
                        case 62: 
                        case 507: 
                        case 560: {
                            if (token.getToknum() == 60) {
                                Token token2 = PreCondition.this.getNext();
                                if (token2.getToknum() == 62) {
                                    n3 = 2;
                                    break;
                                }
                                PreCondition.this.getPrevious();
                            }
                            n3 = token.getToknum() == 560 || token.getToknum() == 60 ? 6 : 5;
                            token = PreCondition.this.getNext();
                            if (token.getToknum() == 761) {
                                token = PreCondition.this.getNext();
                            }
                            if (token.getToknum() == 617 || token.getToknum() == 61) {
                                if (token.getToknum() == 617) {
                                    token = PreCondition.this.getNext();
                                }
                                if (token.getToknum() == 462 || token.getToknum() == 61) {
                                    switch (n3) {
                                        case 3: {
                                            n3 = 5;
                                            break;
                                        }
                                        case 6: {
                                            n3 = 4;
                                            break;
                                        }
                                        case 4: {
                                            n3 = 6;
                                            break;
                                        }
                                        case 5: {
                                            n3 = 3;
                                        }
                                    }
                                    token = PreCondition.this.getNext();
                                    if (token.getToknum() != 773) {
                                        PreCondition.this.getPrevious();
                                    }
                                }
                                break;
                            }
                            PreCondition.this.getPrevious();
                            break;
                        }
                        case 603: {
                            n3 = 10;
                            if (this.lngOperand == null) {
                                n2 = 7;
                                break;
                            }
                            n2 = 6;
                            break;
                        }
                        case 266: {
                            n3 = 11;
                            if (this.strOperand == null) {
                                n2 = 7;
                                break;
                            }
                            n2 = 6;
                            break;
                        }
                        case 267: {
                            n3 = 13;
                            if (this.strOperand == null) {
                                return -43;
                            }
                            n2 = 6;
                            char[] cArray = this.strOperand[0].toCharArray();
                            for (int i2 = cArray.length - 1; i2 > 0; --i2) {
                                if (Character.isLowerCase(cArray[i2])) continue;
                                n2 = 7;
                            }
                            break;
                        }
                        case 268: {
                            n3 = 12;
                            if (this.strOperand == null) {
                                return -43;
                            }
                            n2 = 6;
                            char[] cArray = this.strOperand[0].toCharArray();
                            for (int i3 = cArray.length - 1; i3 > 0; --i3) {
                                if (Character.isUpperCase(cArray[i3])) continue;
                                n2 = 7;
                            }
                            break;
                        }
                        case 642: {
                            n3 = 7;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            n2 = this.lngOperand[0] > 0L ? 6 : 7;
                            break;
                        }
                        case 594: {
                            n3 = 8;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            n2 = this.lngOperand[0] < 0L ? 6 : 7;
                            break;
                        }
                        case 822: {
                            n3 = 9;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            n2 = this.lngOperand[0] == 0L ? 6 : 7;
                            break;
                        }
                        case 10002: {
                            if ("0".equals(token.getWord())) {
                                n3 = 9;
                                if (this.lngOperand == null) {
                                    return -43;
                                }
                                n2 = this.lngOperand[0] == 0L ? 6 : 7;
                                break;
                            }
                            return -43;
                        }
                        case 10009: {
                            if ("DEFINED".equals(token.getWord())) {
                                n3 = 14;
                                if (this.strOperand != null && this.strOperand[0] != null) {
                                    n2 = 6;
                                    break;
                                }
                                n2 = 7;
                                break;
                            }
                            return -43;
                        }
                        default: {
                            return -43;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    return -43;
                }
                if (n2 != 6 && n2 != 7 && (n2 = this.findValue(1)) == 0) {
                    try {
                        long l2 = this.compare();
                        switch (n3) {
                            case 1: {
                                n2 = l2 == 0L ? 6 : 7;
                                break;
                            }
                            case 2: {
                                n2 = l2 != 0L ? 6 : 7;
                                break;
                            }
                            case 3: {
                                n2 = l2 >= 0L ? 6 : 7;
                                break;
                            }
                            case 4: {
                                n2 = l2 <= 0L ? 6 : 7;
                                break;
                            }
                            case 5: {
                                n2 = l2 > 0L ? 6 : 7;
                                break;
                            }
                            case 6: {
                                n2 = l2 < 0L ? 6 : 7;
                                break;
                            }
                            default: {
                                throw new InternalErrorException("op=" + n3);
                            }
                        }
                    }
                    catch (Exception exception) {
                        return -43;
                    }
                }
            }
            if (bl) {
                n2 = n2 == 6 ? 7 : 6;
            }
            return n2;
        }

        private int findValue(int n2) {
            int n3 = 0;
            Token token = PreCondition.this.getNext();
            if (token == null) {
                return -43;
            }
            switch (token.getToknum()) {
                case 10002: {
                    if (this.lngOperand == null) {
                        this.lngOperand = new Long[2];
                    }
                    this.lngOperand[n2] = new Long(token.getWord());
                    break;
                }
                case 10001: {
                    if (this.strOperand == null) {
                        this.strOperand = new String[2];
                    }
                    this.strOperand[n2] = token.getWord();
                    this.strOperand[n2] = this.strOperand[n2].substring(1, this.strOperand[n2].length() - 1);
                    break;
                }
                case 10009: {
                    Token token2 = PreCondition.this.pp.getConstant(token.getWord());
                    if (token2 == null) break;
                    String string = token2.getWord();
                    if (token2.getToknum() == 10001) {
                        string = string.substring(1, string.length() - 1);
                    }
                    try {
                        Long l2 = new Long(string);
                        if (this.lngOperand == null) {
                            this.lngOperand = new Long[2];
                        }
                        this.lngOperand[n2] = l2;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (this.strOperand == null) {
                        this.strOperand = new String[2];
                    }
                    this.strOperand[n2] = string;
                    break;
                }
                default: {
                    return -43;
                }
            }
            return n3;
        }

        private long compare() throws Exception {
            long l2;
            if (this.lngOperand != null && this.lngOperand[0] != null && this.lngOperand[1] != null) {
                l2 = this.lngOperand[0] - this.lngOperand[1];
            } else if (this.strOperand != null && this.strOperand[0] != null && this.strOperand[1] != null) {
                l2 = this.strOperand[0].compareTo(this.strOperand[1]);
            } else {
                throw new Exception();
            }
            return l2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            if (this.lngOperand != null && this.lngOperand[0] != null && this.lngOperand[1] != null) {
                stringBuffer.append(this.lngOperand[0]);
                stringBuffer.append(',');
                stringBuffer.append(this.lngOperand[1]);
                stringBuffer.append(',');
                stringBuffer.append(djdescr[this.type]);
            } else if (this.strOperand != null && this.strOperand[0] != null && this.strOperand[1] != null) {
                stringBuffer.append(this.strOperand[0]);
                stringBuffer.append(',');
                stringBuffer.append(this.strOperand[1]);
                stringBuffer.append(',');
                stringBuffer.append(djdescr[this.type]);
            } else {
                stringBuffer.append(djdescr[this.type]);
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

