/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.ANSIFixedFormatListing;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreCondition;
import com.iscobol.compiler.PreProcsChain;
import com.iscobol.compiler.Replace;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.ReplacedToken;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.custpreproc.LinePreProcessor;
import com.iscobol.compiler.custpreproc.ProcessException;
import com.iscobol.compiler.custpreproc.ProcessResult;
import com.iscobol.interfaces.compiler.CachedFileFinder;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.OptionedFileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PreProcessor
implements CobolToken,
ErrorsNumbers,
IPreProcessor {
    static final String[] cvCobolReservedWords;
    static final String[] cmCobolReservedWords;
    static final String[] cmsCobolReservedWords;
    public static final int TODO_TASK = 0;
    public static final int FIXME_TASK = 1;
    private static final Pattern TASK_PATTERN;
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FIXED = 1;
    public static final int TERMINAL_FIXED = 2;
    public static final int ANSI_FREE = 3;
    public static final int VARIABLE = 4;
    public static final int LONG_LINE = 5;
    public static final int DEF_TAB_EQUIV = 8;
    private String replacingString;
    private String replacingStringHex;
    int vardeclProg;
    private int[] tabEquiv;
    private String[] tabStr;
    private char[] lineBuffer = new char[513];
    private int lineBufferIncr = 512;
    private final LineLen _len_ = new LineLen();
    private LineBuffer lookAheadLine;
    protected LineNumberReader src;
    private PreProcsChain ppChain;
    private byte debugListing;
    private final boolean debugReplSrc = Config.b(".compiler.debug.replaced_source", true);
    private PrintWriter debugTmpFile;
    private boolean debugTmpFileHdrWritten;
    private final boolean optionDebug;
    private boolean ignoreConditions;
    Writer lst;
    private Writer lstSave;
    private boolean lstHold;
    private Vector lstBuff;
    private String fileName;
    private File file;
    private PreProcessor copy;
    private PreProcessor parent;
    private int lineCount;
    protected int parentFileIndex;
    protected int lineBeforeCopy;
    private int format;
    private Stack formatStack = new Stack();
    private char decimalPoint = (char)46;
    private boolean execSql;
    private boolean inExecSql;
    private boolean inReplace;
    private boolean inExec;
    private String envName = "";
    private String envValue = "";
    private ReplaceList replaceList = new ReplaceList();
    private Errors error;
    private Hashtable notReservedWords;
    private final OptionList ol;
    public static final String START_COPY = "      *>>((file: ";
    public static final String MAIN_FILE = "      *((program: ";
    public static final String END_COPY = "      *<<((file: ";
    static final int NEXT_HEX = 1;
    static final int NEXT_XHEX = 2;
    static final int NEXT_BIN = 3;
    static final int NEXT_OCT = 4;
    static final int CM_IDX = 0;
    static final int CCBAS_IDX = 1;
    static final int TASKS_IDX = 2;
    static final int COPY_STMT_IDX = 3;
    static final int JJMS_IDX = 4;
    static final int FLAGS_LEN = 5;
    static final Set<String> EXTRA_INFO_KEYWORDS;
    boolean[] compFlags = new boolean[5];
    private Vector children = new Vector();
    private Vector allPreProcessors;
    private int nextStrHex;
    private boolean constVarsDisabled;
    private Hashtable constVars;
    private Hashtable preProcConst;
    private boolean propagate;
    private String outputPath;
    private String origFilename;
    private boolean picture;
    private final Stack skipping;
    private boolean panvalet;
    private Vector regexpes;
    private Vector<LinePreProcessor> customPreprocs;
    private int customPreprocIdx;
    private ArrayList<String> custPPlines = new ArrayList(10);
    private boolean cppFileFooter;
    private ANSIFixedFormatListing ansiFixListing;
    private Hashtable includeCopyBooks;
    private FileFinder fileFinder = new DefaultFileFinder();
    private PreProcessorReaderProvider isProvider = new DefaultReaderProvider();
    private boolean programStarted;
    private static final String copyLocation;
    private static final Map<String, DefFile> defFiles;

    public static String version() {
        return "$Id: PreProcessor.java 38564 2024-08-26 15:17:20Z gianni_578 $";
    }

    protected PreProcessor(PreProcessor preProcessor, File file, Writer writer, int n2, ReplaceList replaceList, Errors errors, OptionList optionList, char c2) {
        this.debugListing = preProcessor.debugListing;
        this.ignoreConditions = preProcessor.ignoreConditions;
        this.includeCopyBooks = preProcessor.includeCopyBooks;
        this.programStarted = preProcessor.programStarted;
        if (preProcessor.ppChain != null) {
            this.ppChain = preProcessor.ppChain.duplicate();
        }
        this.fileName = file.getPath();
        this.file = file;
        this.parent = preProcessor;
        this.lineBeforeCopy = preProcessor.getLineCount();
        this.parentFileIndex = preProcessor.index();
        this.lst = writer;
        if (optionList.getOption("-smat") == null && optionList.getOption("-xoldsmat") == null) {
            this.setFormat(n2);
        }
        this.replaceList = replaceList;
        this.error = errors;
        this.ol = optionList;
        this.optionDebug = this.ol.getOption("-d") != null;
        this.initRW(true);
        this.ansiFixListing = preProcessor.ansiFixListing;
        this.fileHeader();
        this.constVars = preProcessor.constVars;
        this.preProcConst = preProcessor.preProcConst;
        this.outputPath = preProcessor.outputPath;
        this.decimalPoint = c2;
        this.skipping = preProcessor.skipping;
        this.panvalet = preProcessor.panvalet;
        this.regexpes = preProcessor.regexpes;
        this.customPreprocs = preProcessor.customPreprocs;
        this.compFlags = preProcessor.compFlags;
        this.getAllPreProcessors().addElement(this);
    }

    public PreProcessor(String string, String string2, OptionList optionList, Errors errors) {
        this(string, string2, optionList, errors, null, null);
    }

    public PreProcessor(String string, String string2, OptionList optionList, Errors errors, FileFinder fileFinder, PreProcessorReaderProvider preProcessorReaderProvider) {
        boolean bl;
        String string3;
        this.origFilename = string;
        this.fileName = string;
        this.setFileFinder(fileFinder);
        this.setReaderProvider(preProcessorReaderProvider);
        this.ol = optionList;
        this.optionDebug = this.ol.getOption("-d") != null;
        this.error = errors;
        if (this.getFileFinder() instanceof OptionedFileFinder) {
            ((OptionedFileFinder)this.getFileFinder()).setOptionList(this.ol);
        }
        this.file = this.getFileFinder().findFile(string);
        if (this.file != null) {
            this.fileName = this.file.getPath();
            this.initRW(false);
            this.fileHeader();
        } else {
            this.initRW(false);
        }
        this.constVars = new Hashtable();
        this.compFlags[0] = this.ol.getOption("-cm") != null;
        this.compFlags[1] = this.ol.getOption("-ccbas") != null;
        this.compFlags[2] = this.ol.getOption("-tasks") != null;
        this.compFlags[4] = this.ol.getOption("-jjms") != null;
        this.preProcConst = new Hashtable();
        this.outputPath = string2;
        this.skipping = new Stack();
        this.panvalet = this.ol.getOption("-cpanv") != null;
        String string4 = Config.a(".compiler.regexp", null);
        if (string4 != null && this.analyzeRegExp(string4)) {
            this.regexpes = null;
            this.error.print(203, 4, 0, 0, "compiler.regexp=" + string4, null, this.fileName);
        }
        if ((string3 = Config.a(".compiler.custompreproc", null)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            this.customPreprocs = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                try {
                    Class<?> clazz = Class.forName(string5, true, Thread.currentThread().getContextClassLoader());
                    if (!LinePreProcessor.class.isAssignableFrom(clazz)) {
                        this.error.print(203, 4, 0, 0, "compiler.custompreproc: '" + string5 + "' does not implement com.iscobol.compiler.LinePreProcessor interface", null, this.fileName);
                        this.customPreprocs = null;
                        break;
                    }
                    this.customPreprocs.addElement((LinePreProcessor)clazz.newInstance());
                }
                catch (Exception exception) {
                    this.error.print(203, 4, 0, 0, "compiler.custompreproc: " + exception, null, this.fileName);
                    this.customPreprocs = null;
                    break;
                }
            }
        }
        boolean bl2 = bl = this.ol.getOption("-po") != null;
        if (this.ol.getOption("-la") != null || bl) {
            this.ansiFixListing = new ANSIFixedFormatListing(bl);
        }
        this.allPreProcessors = new Vector();
        this.allPreProcessors.addElement(this);
    }

    protected PreProcessor createCopyPreProcessor(PreProcessor preProcessor, File file, Writer writer, int n2, ReplaceList replaceList, Errors errors, OptionList optionList, char c2) {
        return new PreProcessor(preProcessor, file, writer, n2, replaceList, errors, optionList, c2);
    }

    private boolean analyzeRegExp(String string) {
        char[] cArray = string.toCharArray();
        this.regexpes = new Vector();
        int n2 = -1;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '\"') {
                if (n2 == -1) {
                    n2 = i2;
                    continue;
                }
                String string2 = new String(cArray, n2 + 1, i2 - n2 - 1);
                if ((this.regexpes.size() & 1) == 1) {
                    this.regexpes.addElement(string2);
                } else {
                    try {
                        this.regexpes.addElement(Pattern.compile(string2));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        return true;
                    }
                }
                n2 = -1;
                continue;
            }
            if (cArray[i2] != '\\' || i2 + 1 >= cArray.length) continue;
            ++i2;
        }
        return (this.regexpes.size() & 1) == 1;
    }

    private String doCustPreProc(int[] nArray) {
        Object object;
        Object object2;
        String string = nArray[0] > 0 ? new String(this.lineBuffer, 0, nArray[0]) : "";
        if (this.regexpes != null && string.length() > 0) {
            int n2;
            int n3 = this.regexpes.size();
            int n4 = -1;
            int n5 = -1;
            object2 = "";
            String string2 = "";
            switch (this.format) {
                case 1: {
                    n4 = 6;
                    n5 = 72;
                    break;
                }
                case 5: {
                    n4 = 6;
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                case 4: {
                    n4 = 6;
                    n5 = 250;
                }
            }
            String string3 = string;
            if (n4 > 0) {
                if (string3.length() >= n4) {
                    object2 = string3.substring(0, n4);
                    if (string3.length() >= n5) {
                        string2 = string3.substring(n5);
                        string3 = string3.substring(n4, n5);
                    } else {
                        string3 = string3.substring(n4);
                    }
                } else {
                    object2 = string3;
                    string3 = "";
                }
            }
            if ((n2 = string3.length()) > 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    object = (Pattern)this.regexpes.elementAt(i2);
                    String string4 = (String)this.regexpes.elementAt(++i2);
                    string3 = ((Pattern)object).matcher(string3).replaceAll(string4);
                }
                nArray[1] = string3.length() - n2;
                string = (String)object2 + string3 + string2;
            }
        }
        if (this.customPreprocs != null) {
            object = new String[this.ol.getAllKeyCount()];
            int n6 = 0;
            Enumeration enumeration = this.ol.getAllKeys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                String string6 = this.ol.getOption(string5);
                object[n6] = string6 != null ? string5 + string6 : string5;
                ++n6;
            }
            int n7 = this.lineCount + 1;
            ProcessResult processResult = new ProcessResult();
            while (this.customPreprocIdx < this.customPreprocs.size()) {
                LinePreProcessor linePreProcessor = this.customPreprocs.elementAt(this.customPreprocIdx);
                this.custPPlines.clear();
                if (this.customPreprocIdx > 0) {
                    object2 = new StringTokenizer(string, "\r\n");
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            this.custPPlines.add(((StringTokenizer)object2).nextToken());
                        }
                    } else {
                        this.custPPlines.add("");
                    }
                } else {
                    this.custPPlines.add(string);
                }
                string = "";
                for (n6 = 0; n6 < this.custPPlines.size(); ++n6) {
                    object2 = this.custPPlines.get(n6);
                    processResult.setReplace((String)object2);
                    processResult.setComment(false);
                    try {
                        linePreProcessor.process((String)object2, this.format, this.fileName, n7, (String[])object, processResult);
                        if (processResult.getReplace() != object2) {
                            object2 = processResult.getReplace();
                        }
                        if (object2 == null) {
                            if (n6 != this.custPPlines.size() - 1) continue;
                            this.customPreprocIdx = 0;
                            return null;
                        }
                        if (string.length() > 0) {
                            string = string + "\n";
                        }
                        if (processResult.isComment()) {
                            object2 = this.getCommentedLines((String)object2);
                        }
                        string = string + (String)object2;
                        continue;
                    }
                    catch (ProcessException processException) {
                        this.error.print(295, processException.getSeverity(), n7, 0, processException.getMessage(), null, this.fileName);
                        if (processException.getSeverity() == 4 || processException.getResult() == null) continue;
                        object2 = processException.getResult().getReplace();
                        if (string.length() > 0) {
                            string = string + "\n";
                        }
                        if (processException.getResult().isComment()) {
                            object2 = this.getCommentedLines((String)object2);
                        }
                        string = string + (String)object2;
                    }
                }
                ++this.customPreprocIdx;
            }
            this.customPreprocIdx = 0;
        }
        this.checkDebugReplSrc(string);
        return string;
    }

    private String doCustPreProcFF() {
        String string = null;
        if (this.customPreprocs != null) {
            String string2;
            Object object;
            String[] stringArray = new String[this.ol.getAllKeyCount()];
            int n2 = 0;
            Object object2 = this.ol.getAllKeys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = this.ol.getOption((String)object);
                stringArray[n2] = string2 != null ? (String)object + string2 : object;
                ++n2;
            }
            object2 = new ProcessResult();
            for (n2 = 0; n2 < this.customPreprocs.size(); ++n2) {
                object = this.customPreprocs.elementAt(n2);
                ((ProcessResult)object2).setReplace(null);
                ((ProcessResult)object2).setComment(false);
                try {
                    object.process(null, this.format, this.fileName, 0, stringArray, (ProcessResult)object2);
                    if (((ProcessResult)object2).getReplace() == null) continue;
                    string2 = ((ProcessResult)object2).getReplace();
                    if (((ProcessResult)object2).isComment()) {
                        string2 = this.getCommentedLines(string2);
                    }
                    if (string == null) {
                        string = string2;
                        continue;
                    }
                    string = string + "\n" + string2;
                    continue;
                }
                catch (ProcessException processException) {
                    this.error.print(295, processException.getSeverity(), 0, 0, processException.getMessage(), null, this.fileName);
                    if (processException.getSeverity() == 4 || processException.getResult() == null) continue;
                    string = string == null ? ((ProcessResult)object2).getReplace() : string + "\n" + ((ProcessResult)object2).getReplace();
                }
            }
        }
        this.checkDebugReplSrc(string);
        return string;
    }

    private void checkDebugReplSrc(String string) {
        if (this.debugReplSrc && this.optionDebug && string != null) {
            PreProcessor preProcessor = this;
            while (preProcessor.parent != null) {
                preProcessor = preProcessor.parent;
            }
            if (preProcessor.debugTmpFile == null) {
                String string2 = System.getProperty("java.io.tmpdir");
                try {
                    preProcessor.debugTmpFile = PreProcessor.newPrintWriter(string2 + File.separator + preProcessor.file.getName() + ".filelist");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!this.debugTmpFileHdrWritten) {
                preProcessor.debugTmpFile.println(START_COPY + this.file.getPath() + "))");
                this.debugTmpFileHdrWritten = true;
            }
            preProcessor.debugTmpFile.println(string);
        }
    }

    private String getCommentedLines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(this.getCommentedLine(stringTokenizer.nextToken()));
        }
        return stringBuffer.toString();
    }

    private String getCommentedLine(String string) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
            if (stringBuffer.charAt(n2) != '\t') continue;
            if (bl) {
                stringBuffer.replace(n2, n2 + 1, this.tabStr[0]);
                n2 += this.tabStr[0].length() - 1;
                bl = false;
                continue;
            }
            stringBuffer.replace(n2, n2 + 1, this.tabStr[1]);
            n2 += this.tabStr[1].length() - 1;
        }
        switch (this.format) {
            case 1: 
            case 4: 
            case 5: {
                if (stringBuffer.length() > 6) {
                    stringBuffer.insert(6, '*');
                    break;
                }
                for (n2 = stringBuffer.length(); n2 < 6; ++n2) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('*');
                break;
            }
            default: {
                stringBuffer.insert(0, "*>");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public int index() {
        return this.getAllPreProcessors().indexOf(this);
    }

    @Override
    public Vector getAllPreProcessors() {
        if (this.allPreProcessors != null) {
            return this.allPreProcessors;
        }
        if (this.parent != null) {
            return this.parent.getAllPreProcessors();
        }
        return new Vector();
    }

    @Override
    public int getCopyLineNumber() {
        return this.lineBeforeCopy;
    }

    @Override
    public FileFinder getFileFinder() {
        return this.fileFinder;
    }

    public PreProcessorReaderProvider getReaderProvider() {
        return this.isProvider;
    }

    @Override
    public void setFileFinder(FileFinder fileFinder) {
        if (fileFinder != null) {
            this.fileFinder = fileFinder;
        }
    }

    public void setReaderProvider(PreProcessorReaderProvider preProcessorReaderProvider) {
        if (preProcessorReaderProvider != null) {
            this.isProvider = preProcessorReaderProvider;
        }
    }

    void addConstant(VariableDeclaration variableDeclaration) {
        this.addConstVar(variableDeclaration);
    }

    void addPreProcConstant(Token token, Token token2) {
        this.preProcConst.put(token.getWord(), VariableDeclaration.getConstant(token, token2, this.ol));
        this.constVars.put(token.getWord(), VariableDeclaration.getConstant(token, token2, this.ol));
    }

    void removeConstant(Token token) {
        this.preProcConst.remove(token.getWord());
        this.constVars.remove(token.getWord());
    }

    void disableConstVars() {
        this.constVarsDisabled = true;
    }

    private Token getConstant(Token token) {
        return this.getConstant(token.getWord());
    }

    Token getConstant(String string) {
        return this.getConstVar(string, true);
    }

    public String getReplacingString() {
        return this.replacingString;
    }

    public String getReplacingStringHex() {
        return this.replacingStringHex;
    }

    void addConstVar(VariableDeclaration variableDeclaration) {
        this.constVars.put(variableDeclaration.name.getWord(), variableDeclaration);
    }

    Hashtable getConstVarsClone() {
        return (Hashtable)this.constVars.clone();
    }

    void setConstVars(Hashtable hashtable) {
        this.constVars = hashtable;
    }

    Token getConstVar(String string) {
        return this.getConstVar(string, false);
    }

    Token getConstVar(String string, boolean bl) {
        if (this.constVarsDisabled && !bl) {
            return null;
        }
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.constVars.get(string);
        if (variableDeclaration != null) {
            variableDeclaration.constUsed = true;
            return new Token(variableDeclaration.value);
        }
        variableDeclaration = (VariableDeclaration)this.preProcConst.get(string);
        if (variableDeclaration != null) {
            return new Token(variableDeclaration.value);
        }
        return null;
    }

    public void setFormat(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.format = n2;
                this.formatStack.push(new Integer(this.format));
            }
        }
    }

    @Override
    public int getFormat() {
        if (this.formatStack.size() > 0) {
            return (Integer)this.formatStack.peek();
        }
        return 0;
    }

    private void resetFormat() {
        try {
            this.formatStack.pop();
            Integer n2 = (Integer)this.formatStack.peek();
            this.format = n2;
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void initRW(boolean bl) {
        StringTokenizer stringTokenizer;
        String string;
        String string2;
        String string3 = this.ol.getOption("-rw=");
        boolean bl2 = this.ol.getOption("-cv") != null;
        boolean bl3 = this.ol.getOption("-cm") != null;
        boolean bl4 = this.ol.getOption("-cms") != null;
        boolean bl5 = this.ol.getOption("-cr") != null;
        String string4 = this.ol.getOption("-rc=");
        String string5 = this.ol.getOption("-rm=");
        this.notReservedWords = new Hashtable();
        if (string3 != null) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken().toUpperCase(Locale.US);
                this.notReservedWords.put(string3, string3);
            }
        }
        if (!bl3 && !bl2) {
            this.notReservedWords.put("RECURSIVE", "RECURSIVE");
        }
        if (bl5) {
            this.notReservedWords.put("PROGRAM-ID", "PROGRAM-ID");
        }
        if (!bl2) {
            for (int i2 = 0; i2 < cvCobolReservedWords.length; ++i2) {
                this.notReservedWords.put(cvCobolReservedWords[i2], cvCobolReservedWords[i2]);
            }
        }
        if (!bl3) {
            for (int i3 = 0; i3 < cmCobolReservedWords.length; ++i3) {
                this.notReservedWords.put(cmCobolReservedWords[i3], cmCobolReservedWords[i3]);
            }
        }
        if (!bl4) {
            for (int i4 = 0; i4 < cmsCobolReservedWords.length; ++i4) {
                this.notReservedWords.put(cmsCobolReservedWords[i4], cmsCobolReservedWords[i4]);
            }
        } else {
            this.notReservedWords.put("COL", "COL");
        }
        if (!bl && string4 != null) {
            String string6 = null;
            string2 = null;
            string = null;
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()) != null) {
                if (!Token.changeKeyword(string2, string)) {
                    string6 = string6 == null ? "-rc=" : string6 + ",";
                    string6 = string6 + string2;
                    string6 = string6 + ",";
                    string6 = string6 + string;
                }
                string = null;
                string2 = null;
            }
            if (string2 != null && string == null) {
                string6 = string6 == null ? "-rc=" : string6 + ",";
                string6 = string6 + string2;
            }
            if (string6 != null) {
                this.error.print(159, 3, 0, 0, string6, null, this.fileName);
            }
        }
        if (!bl && string5 != null) {
            String string7 = null;
            string2 = null;
            string = null;
            stringTokenizer = new StringTokenizer(string5, ",");
            while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()) != null) {
                if (!Token.replaceMeaning(string2, string)) {
                    string7 = string7 == null ? "-rm=" : string7 + ",";
                    string7 = string7 + string2;
                    string7 = string7 + ",";
                    string7 = string7 + string;
                }
                string = null;
                string2 = null;
            }
            if (string2 != null && string == null) {
                string7 = string7 == null ? "-rm=" : string7 + ",";
                string7 = string7 + string2;
            }
            if (string7 != null) {
                this.error.print(159, 3, 0, 0, string7, null, this.fileName);
            }
        }
        this.tabEquiv = new int[2];
        String string8 = this.ol.getOption("-stl=");
        if (string8 == null) {
            this.tabEquiv[1] = 8;
            this.tabEquiv[0] = 8;
        } else {
            try {
                int n2 = string8.indexOf(44);
                if (n2 > 0) {
                    this.tabEquiv[0] = Integer.parseInt(string8.substring(0, n2));
                    this.tabEquiv[1] = Integer.parseInt(string8.substring(n2 + 1, string8.length()));
                } else {
                    this.tabEquiv[0] = this.tabEquiv[1] = Integer.parseInt(string8);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tabEquiv[1] = 8;
                this.tabEquiv[0] = 8;
                this.error.print(159, 3, 0, 0, string8, null, this.fileName);
            }
        }
        this.tabStr = new String[2];
        for (int i5 = 0; i5 < this.tabEquiv.length; ++i5) {
            this.tabStr[i5] = "";
            for (int i6 = 0; i6 < this.tabEquiv[0]; ++i6) {
                int n3 = i5;
                this.tabStr[n3] = this.tabStr[n3] + " ";
            }
        }
    }

    Hashtable getNotReservedWords() {
        return this.notReservedWords;
    }

    private String bldLstStr(String string, int n2) {
        return this.bldLstStr(string, n2, true);
    }

    private boolean isDebugListing() {
        return this.debugListing != 0;
    }

    private String bldLstStr(String string, int n2, boolean bl) {
        String string2 = !this.isDebugListing() && n2 >= 0 ? (this.ansiFixListing != null ? string.substring(0, n2) + "      *>" + string.substring(n2, string.length()) : string.substring(0, n2) + "*>" + string.substring(n2, string.length())) : string;
        if (bl) {
            string2 = string2 + eol;
        }
        return string2;
    }

    private void writeListing(StringBuffer stringBuffer, TokenList tokenList, int n2) {
        if (this.ansiFixListing != null) {
            if (!this.lstHold) {
                this.writeListing(this.ansiFixListing.doListing(tokenList, n2, this.getLineCount()), -1);
            }
        } else {
            this.writeListing(stringBuffer.toString(), n2);
        }
    }

    private void writeListing(String string, int n2) {
        if (this.lst == null) {
            return;
        }
        if (this.lstHold) {
            if (this.lstBuff == null) {
                this.lstBuff = new Vector();
            }
            this.lstBuff.add(this.bldLstStr(string, n2, false));
        } else {
            try {
                this.lst.write(this.bldLstStr(string, n2));
                if (this.lstBuff != null) {
                    for (int i2 = 0; i2 < this.lstBuff.size(); ++i2) {
                        this.lst.write(this.bldLstStr((String)this.lstBuff.elementAt(i2), n2));
                    }
                    this.lstBuff = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeSource() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((PreProcessor)this.children.elementAt(i2)).closeSource();
        }
        if (this.src != null) {
            try {
                this.src.close();
                this.src = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.debugReplSrc && this.optionDebug && (this.regexpes != null || this.customPreprocs != null)) {
                PreProcessor preProcessor = this;
                while (preProcessor.parent != null) {
                    preProcessor = preProcessor.parent;
                }
                if (preProcessor.debugTmpFile != null) {
                    if (!this.debugTmpFileHdrWritten) {
                        preProcessor.debugTmpFile.println(START_COPY + this.file.getPath() + "))");
                        this.debugTmpFileHdrWritten = true;
                    }
                    preProcessor.debugTmpFile.println(END_COPY + this.file.getPath() + "))");
                }
                if (preProcessor == this) {
                    this.debugTmpFile.close();
                    this.debugTmpFile = null;
                }
            }
        }
    }

    boolean isDebugReplSrc() {
        return this.debugReplSrc && (this.regexpes != null || this.customPreprocs != null);
    }

    @Override
    public void closeListing() {
        try {
            if (this.ol.getOption("-po") == null) {
                Vector vector = this.error.getAllMessages();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    if (this.ansiFixListing != null) {
                        this.lst.write("      *> " + enumeration.nextElement() + eol);
                        continue;
                    }
                    this.lst.write("*> " + enumeration.nextElement() + eol);
                }
            }
            this.lst.flush();
            this.lst.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fileHeader() {
        if (!this.isDebugListing()) {
            if (this.ol.getOption("-po") != null) {
                if (this.lst != null) {
                    try {
                        this.lst.write(START_COPY + this.file.getName() + "))" + eol);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.writeListing("vvv-> file: " + this.file.getPath(), 0);
            }
        }
    }

    private void fileFooter() {
        if (!this.isDebugListing()) {
            if (this.ol.getOption("-po") != null) {
                if (this.lst != null) {
                    try {
                        this.lst.write(END_COPY + this.file.getName() + "))" + eol);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.writeListing("^^^-> file: " + this.file.getPath(), 0);
            }
        }
    }

    void setSourceFormatAnsi() {
        this.setFormat(1);
    }

    void setSourceFormatTerminal() {
        this.setFormat(2);
    }

    void setSourceFormatVariable() {
        this.setFormat(4);
    }

    void setSourceFormatLongLine() {
        this.setFormat(5);
    }

    void setSourceFormatFree() {
        this.setFormat(3);
    }

    static PrintWriter newPrintWriter(String string) throws IOException {
        return PreProcessor.newPrintWriter(new File(string), false);
    }

    static PrintWriter newPrintWriter(String string, boolean bl) throws IOException {
        return PreProcessor.newPrintWriter(new File(string), bl);
    }

    static PrintWriter newPrintWriter(File file) throws IOException {
        return PreProcessor.newPrintWriter(file, false);
    }

    static PrintWriter newPrintWriter(File file, boolean bl) throws IOException {
        try {
            return new PrintWriter((Writer)new BufferedWriter(PreProcessor.newOutputStreamWriter(file)), bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), bl);
        }
    }

    static OutputStreamWriter newOutputStreamWriter(File file) throws UnsupportedEncodingException, IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), System.getProperty("file.encoding"));
    }

    @Override
    public boolean start(Reader reader, File file) {
        PrintWriter printWriter;
        block10: {
            printWriter = null;
            if (file != null) {
                try {
                    printWriter = PreProcessor.newPrintWriter(file);
                    this.lst = printWriter;
                    if (this.ol.getOption("-po") == null) {
                        String string;
                        this.writeListing("compiler version: " + Version.getRelease(), 0);
                        this.writeListing("source file name: " + this.fileName, 0);
                        this.writeListing("date generated  : " + new Date(), 0);
                        this.writeListing("compiler options: " + this.ol.getAll().replace('\\', '/'), 0);
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        Properties properties = Config.e();
                        int n2 = 0;
                        Object object = properties.propertyNames();
                        while (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                            if (!string.startsWith("iscobol.compiler.") || string.startsWith("iscobol.compiler.license.")) continue;
                            if (string.length() > n2) {
                                n2 = string.length();
                            }
                            treeMap.put(string, properties.getProperty(string));
                        }
                        if (n2 > 0) {
                            object = new char[n2];
                            Arrays.fill((char[])object, ' ');
                            string = new String((char[])object);
                            for (String string2 : treeMap.keySet()) {
                                this.writeListing(string2 + string.substring(string2.length()) + ": " + (String)treeMap.get(string2), 0);
                            }
                        }
                        break block10;
                    }
                    try {
                        this.lst.write(MAIN_FILE + this.file.getName() + "))" + eol);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {
                    this.error.print(39, 2, 0, 0, null, null, exception.getMessage());
                }
            }
        }
        return this.start(reader, printWriter, (byte)0, null, false, false);
    }

    @Override
    public boolean start(Reader reader, Writer writer, boolean bl, Hashtable hashtable) {
        return this.start(reader, writer, bl ? (byte)2 : 0, hashtable, true, false);
    }

    public boolean start(Reader reader, Writer writer, byte by, Hashtable hashtable, boolean bl) {
        return this.start(reader, writer, by, hashtable, true, bl);
    }

    private boolean start(Reader reader, Writer writer, byte by, Hashtable hashtable, boolean bl, boolean bl2) {
        int n2 = this.error.getErrorCount(4);
        if (reader != null) {
            this.src = new LineNumberReader(reader);
            if (reader instanceof PreProcsChain) {
                this.ppChain = (PreProcsChain)reader;
            }
        } else if (this.file != null) {
            if (!this.open(this.file.getPath())) {
                this.error.print(10, 4, 0, 0, null, null, this.fileName);
                return false;
            }
        } else {
            if (this.fileName == null) {
                System.err.println("usage: java Pcc -help|[options] source_file");
            } else {
                this.error.print(10, 4, 0, 0, null, null, this.fileName);
            }
            return false;
        }
        this.lst = writer;
        this.debugListing = by;
        this.ignoreConditions = bl2;
        this.includeCopyBooks = hashtable;
        if (bl && this.lst != null && this.ol.getOption("-po") != null) {
            try {
                this.lst.write(MAIN_FILE + new File(this.fileName).getName() + "))" + eol);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.error.getErrorCount(4) == n2;
    }

    void checkFormat(int n2) {
        if (this.format == 0) {
            boolean bl = this.ol.getOption("-smat") != null;
            boolean bl2 = this.ol.getOption("-xoldsmat") != null;
            boolean bl3 = true;
            if (bl) {
                for (int i2 = 0; i2 < n2 && bl3; ++i2) {
                    if (this.lineBuffer[i2] == ' ') continue;
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
            if (n2 > 0 && !bl3) {
                int n3;
                if (this.lineBuffer[0] == '*' && (bl || bl2 || n2 == 1 || this.lineBuffer[1] != '>')) {
                    this.setFormat(2);
                    return;
                }
                if (bl) {
                    if (this.lineBuffer[0] == ' ' || this.lineBuffer[0] >= '0' && this.lineBuffer[0] <= '9') {
                        this.setFormat(1);
                        return;
                    }
                    this.setFormat(2);
                    return;
                }
                if (this.lineBuffer[0] == '/' || this.lineBuffer[0] == '$') {
                    this.setFormat(2);
                    return;
                }
                for (n3 = 0; n3 < n2 && (this.lineBuffer[n3] == ' ' || this.lineBuffer[n3] == '\t'); ++n3) {
                }
                if (n3 < n2) {
                    if (n2 > 6 && (this.lineBuffer[6] == '*' || this.lineBuffer[6] == '$') || n2 > 7 && this.lineBuffer[6] == ' ' || this.lineBuffer[6] == '/') {
                        for (n3 = 0; n3 < 6; ++n3) {
                            if ((this.lineBuffer[n3] != '*' || this.lineBuffer[n3 + 1] != '>') && (this.lineBuffer[n3] != '>' || this.lineBuffer[n3 + 1] != '>')) continue;
                            if (bl2) {
                                this.setFormat(2);
                                break;
                            }
                            this.setFormat(3);
                            break;
                        }
                        if (this.format == 0) {
                            this.setFormat(1);
                        }
                    } else if (bl2) {
                        this.setFormat(2);
                    } else {
                        this.setFormat(3);
                    }
                }
            }
        }
    }

    private void fillLookAhead(TokenList tokenList, Token token) {
        int n2 = token.getOffset();
        char[] cArray = new char[n2 + (this.format == 1 ? 7 : 0)];
        n2 = cArray.length;
        String string = null;
        Arrays.fill(cArray, ' ');
        this.lookAheadLine = new LineBuffer(0);
        this.lookAheadLine.buf.append(cArray);
        do {
            if (string != null && n2 > token.getOffset()) {
                cArray = new char[token.getOffset() + (this.format == 1 ? 7 : 0)];
                Arrays.fill(cArray, ' ');
                this.lookAheadLine.buf.append('\n');
                this.lookAheadLine.buf.append(cArray);
            }
            string = token.getOriginalWord();
            this.lookAheadLine.buf.append(string);
            n2 = token.getOffset() + string.length();
        } while ((token = tokenList.getNextWithSep()) != null);
    }

    private void expandLineBuffer() {
        char[] cArray = this.lineBuffer;
        this.lineBuffer = new char[cArray.length + this.lineBufferIncr];
        System.arraycopy(cArray, 0, this.lineBuffer, 0, cArray.length);
        this.lineBufferIncr <<= 1;
    }

    private LineLen getLine(boolean bl) {
        LineLen lineLen;
        while (true) {
            block28: {
                int n2;
                int n3;
                if (this.lookAheadLine != null) {
                    if (this.lookAheadLine.type == 1) {
                        if (bl) {
                            lineLen = this._len_.init(this._len_.replDiff);
                        } else {
                            lineLen = this._len_.init(0);
                            this.lookAheadLine.type = 2;
                        }
                    } else {
                        lineLen = this._len_.init(0);
                    }
                    lineLen.length = this.lookAheadLine.buf.length();
                    n3 = this.lineBuffer.length - 2;
                    for (n2 = 0; n2 < lineLen.length; ++n2) {
                        if (n2 > n3) {
                            this.expandLineBuffer();
                            n3 = this.lineBuffer.length - 2;
                        }
                        this.lineBuffer[n2] = this.lookAheadLine.buf.charAt(n2);
                        if (this.lineBuffer[n2] == '\n') break;
                    }
                    if (n2 == lineLen.length) {
                        this.lineBuffer[n2] = '\u0000';
                        lineLen.type = this.lookAheadLine.type;
                        this.lookAheadLine = null;
                    } else {
                        lineLen.length = n2;
                        this.lineBuffer[n2] = '\u0000';
                        this.lookAheadLine.buf.delete(0, n2 + 1);
                        lineLen.type = this.lookAheadLine.type;
                    }
                    return lineLen;
                }
                lineLen = this._len_.init(0);
                n2 = 0;
                try {
                    n3 = this.src.read();
                    if (n3 == -1) break block28;
                    if (this.format == 5) {
                        while (true) {
                            if (n3 == 9) {
                                int n4 = n2 < this.tabEquiv[0] ? this.tabEquiv[0] : this.tabEquiv[1];
                                int n5 = n2 + (n4 - n2 % n4);
                                if (n5 > this.lineBuffer.length) {
                                    this.expandLineBuffer();
                                }
                                while (n2 < this.lineBuffer.length && n2 < n5) {
                                    this.lineBuffer[n2] = 32;
                                    ++n2;
                                }
                                n3 = this.src.read();
                                continue;
                            }
                            if (n3 == 10 || n3 == -1) {
                                if (n2 >= this.lineBuffer.length) {
                                    this.expandLineBuffer();
                                }
                                break;
                            }
                            if (n2 >= this.lineBuffer.length - 1) {
                                this.expandLineBuffer();
                            }
                            this.lineBuffer[n2++] = (char)n3;
                            n3 = this.src.read();
                        }
                        this.lineBuffer[n2] = '\u0000';
                        this.lineBuffer[n2] = '\u0000';
                        lineLen.length = n2;
                    } else {
                        do {
                            if (n3 == 9) {
                                int n6 = n2 < this.tabEquiv[0] ? this.tabEquiv[0] : this.tabEquiv[1];
                                int n7 = n2 + (n6 - n2 % n6);
                                while (n2 < this.lineBuffer.length && n2 < n7) {
                                    this.lineBuffer[n2] = 32;
                                    ++n2;
                                }
                                n3 = this.src.read();
                                continue;
                            }
                            if (n3 == 10 || n3 == -1) {
                                this.lineBuffer[n2] = '\u0000';
                                break;
                            }
                            this.lineBuffer[n2++] = (char)n3;
                            n3 = this.src.read();
                        } while (n2 < this.lineBuffer.length - 1);
                        if (n3 != 10 && n3 != -1) {
                            this.error.print(251, 2, this.lineCount + 1, 0, null, null, this.fileName);
                        }
                        this.lineBuffer[n2] = '\u0000';
                        lineLen.length = n2;
                    }
                    while (n3 != 10 && n3 != -1) {
                        n3 = this.src.read();
                    }
                }
                catch (IOException iOException) {
                    lineLen.length = -1;
                }
            }
            if (this.regexpes == null && this.customPreprocs == null || lineLen.length < 0) break;
            int[] nArray = new int[]{lineLen.length, 0};
            String string = this.doCustPreProc(nArray);
            if (string != null) {
                if (string.length() <= 0 && lineLen.length <= 0) break;
                this.lookAheadLine = new LineBuffer(1);
                this.lookAheadLine.buf.append(string);
                lineLen.replDiff = nArray[1];
                return this.getLine(true);
            }
            if (this.debugReplSrc) continue;
            ++this.lineCount;
        }
        return lineLen;
    }

    private static void fill72(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            cArray[i2] = 32;
        }
    }

    private static void fill72(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = 32;
        }
    }

    private static final boolean isPreProcSep(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == ',' || c2 == ';';
    }

    private static final boolean isPreProcSep(byte by) {
        return by == 32 || by == 9 || by == 44 || by == 59;
    }

    private void dollarHandling(int n2, StringBuffer stringBuffer, int n3) {
        while (this.lineBuffer[n3 - 1] <= ' ') {
            --n3;
        }
        if (n3 > n2 + 2) {
            if (!(this.lineBuffer[n2] != 'I' && this.lineBuffer[n2] != 'i' || this.lineBuffer[n2 + 1] != 'F' && this.lineBuffer[n2 + 1] != 'f')) {
                if (PreProcessor.isPreProcSep(this.lineBuffer[n2 + 2])) {
                    stringBuffer.append(">>");
                    stringBuffer.append(this.lineBuffer, n2, n3 - n2);
                    return;
                }
                this.error.print(200, 2, this.lineCount, n2, new String(this.lineBuffer).trim(), null, this.fileName);
            }
            if (!(this.lineBuffer[n2] != 'E' && this.lineBuffer[n2] != 'e' || this.lineBuffer[n2 + 1] != 'N' && this.lineBuffer[n2 + 1] != 'n' || this.lineBuffer[n2 + 2] != 'D' && this.lineBuffer[n2 + 2] != 'd')) {
                if (n3 == n2 + 3 || PreProcessor.isPreProcSep(this.lineBuffer[n2 + 3])) {
                    stringBuffer.append(">>END-IF");
                    stringBuffer.append(this.lineBuffer, n2 += 3, n3 - n2);
                    return;
                }
                if (n3 != n2 + 7 && (n3 <= n2 + 7 || !PreProcessor.isPreProcSep(this.lineBuffer[n2 + 7])) || this.lineBuffer[n2 + 3] != '-' && this.lineBuffer[n2 + 3] != '_' || this.lineBuffer[n2 + 4] != 'D' && this.lineBuffer[n2 + 4] != 'd' || this.lineBuffer[n2 + 5] != 'O' && this.lineBuffer[n2 + 5] != 'o' || this.lineBuffer[n2 + 6] != 'C' && this.lineBuffer[n2 + 6] != 'c') {
                    this.error.print(200, 2, this.lineCount, n2, new String(this.lineBuffer).trim(), null, this.fileName);
                }
            }
        }
        if (n3 > n2 + 3) {
            if (!(this.lineBuffer[n2] != 'S' && this.lineBuffer[n2] != 's' || this.lineBuffer[n2 + 1] != 'E' && this.lineBuffer[n2 + 1] != 'e' || this.lineBuffer[n2 + 2] != 'T' && this.lineBuffer[n2 + 2] != 't')) {
                if (PreProcessor.isPreProcSep(this.lineBuffer[n2 + 3])) {
                    stringBuffer.append(">>");
                    stringBuffer.append(this.lineBuffer, n2, n3 - n2);
                    return;
                }
                this.error.print(200, 2, this.lineCount, n2, new String(this.lineBuffer).trim(), null, this.fileName);
            }
            if (!(this.lineBuffer[n2] != 'E' && this.lineBuffer[n2] != 'e' || this.lineBuffer[n2 + 1] != 'L' && this.lineBuffer[n2 + 1] != 'l' || this.lineBuffer[n2 + 2] != 'S' && this.lineBuffer[n2 + 2] != 's' || this.lineBuffer[n2 + 3] != 'E' && this.lineBuffer[n2 + 3] != 'e' || n3 != n2 + 4 && !PreProcessor.isPreProcSep(this.lineBuffer[n2 + 4]))) {
                stringBuffer.append(">>");
                stringBuffer.append(this.lineBuffer, n2, n3 - n2);
                return;
            }
        }
        stringBuffer.append("*>((");
        stringBuffer.append(this.lineBuffer, n2, n3 - n2);
        stringBuffer.append("))");
    }

    private void dollarHandlingB(byte[] byArray, int n2, StringBuffer stringBuffer, int n3) {
        while (byArray[n3 - 1] <= 32) {
            --n3;
        }
        if (n3 > n2 + 2) {
            if (!(byArray[n2] != 73 && byArray[n2] != 105 || byArray[n2 + 1] != 70 && byArray[n2 + 1] != 102)) {
                if (PreProcessor.isPreProcSep(byArray[n2 + 2])) {
                    stringBuffer.append(">>");
                    stringBuffer.append(new String(byArray, n2, n3 - n2));
                    return;
                }
                this.error.print(200, 2, this.lineCount, n2, new String(byArray).trim(), null, this.fileName);
            }
            if (!(byArray[n2] != 69 && byArray[n2] != 101 || byArray[n2 + 1] != 78 && byArray[n2 + 1] != 110 || byArray[n2 + 2] != 68 && byArray[n2 + 2] != 100)) {
                if (n3 == n2 + 3 || PreProcessor.isPreProcSep(byArray[n2 + 3])) {
                    stringBuffer.append(">>END-IF");
                    stringBuffer.append(new String(byArray, n2 += 3, n3 - n2));
                    return;
                }
                if (n3 != n2 + 7 && (n3 <= n2 + 7 || !PreProcessor.isPreProcSep(byArray[n2 + 7])) || byArray[n2 + 3] != 45 && byArray[n2 + 3] != 95 || byArray[n2 + 4] != 68 && byArray[n2 + 4] != 100 || byArray[n2 + 5] != 79 && byArray[n2 + 5] != 111 || byArray[n2 + 6] != 67 && byArray[n2 + 6] != 99) {
                    this.error.print(200, 2, this.lineCount, n2, new String(byArray).trim(), null, this.fileName);
                }
            }
        }
        if (n3 > n2 + 3) {
            if (!(byArray[n2] != 83 && byArray[n2] != 115 || byArray[n2 + 1] != 69 && byArray[n2 + 1] != 101 || byArray[n2 + 2] != 84 && byArray[n2 + 2] != 116)) {
                if (PreProcessor.isPreProcSep(byArray[n2 + 3])) {
                    stringBuffer.append(">>");
                    stringBuffer.append(new String(byArray, n2, n3 - n2));
                    return;
                }
                this.error.print(200, 2, this.lineCount, n2, new String(byArray).trim(), null, this.fileName);
            }
            if (!(byArray[n2] != 69 && byArray[n2] != 101 || byArray[n2 + 1] != 76 && byArray[n2 + 1] != 108 || byArray[n2 + 2] != 83 && byArray[n2 + 2] != 115 || byArray[n2 + 3] != 69 && byArray[n2 + 3] != 101 || n3 != n2 + 4 && !PreProcessor.isPreProcSep(byArray[n2 + 4]))) {
                stringBuffer.append(">>");
                stringBuffer.append(new String(byArray, n2, n3 - n2));
                return;
            }
        }
        stringBuffer.append("*>((");
        stringBuffer.append(new String(byArray, n2, n3 - n2));
        stringBuffer.append("))");
    }

    @Override
    public Vector getSvrFileNames() {
        return null;
    }

    private void getLineVariable(StringBuffer stringBuffer, LineLen lineLen) {
        if (this.compFlags[1]) {
            switch (this.lineBuffer[0]) {
                case '\t': {
                    this.getLineFixedB(stringBuffer, lineLen, 250);
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.lineBuffer[0] >= ' ') {
                        this.getLineFixedB(stringBuffer, lineLen, 250);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            switch (this.lineBuffer[0]) {
                case '\t': {
                    this.getLineFixed(stringBuffer, lineLen, 250);
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.lineBuffer[0] < ' ') break;
                    this.getLineFixed(stringBuffer, lineLen, 250);
                }
            }
        }
    }

    private void getLineLong(StringBuffer stringBuffer, LineLen lineLen) {
        if (this.compFlags[1]) {
            this.getLineFixedB(stringBuffer, lineLen, 0);
        } else {
            this.getLineFixed(stringBuffer, lineLen, 0);
        }
    }

    private void getLineAnsiFixed(StringBuffer stringBuffer, LineLen lineLen) {
        if (this.compFlags[1]) {
            this.getLineFixedB(stringBuffer, lineLen, 72);
        } else {
            this.getLineFixed(stringBuffer, lineLen, 72);
        }
    }

    private void getLineFixed(StringBuffer stringBuffer, LineLen lineLen, int n2) {
        int n3 = lineLen.length;
        int n4 = 0;
        int n5 = 0;
        if (this.ansiFixListing != null) {
            this.ansiFixListing.add1_7(new String(this.lineBuffer, 0, Math.min(n3, 7)));
            this.ansiFixListing.setRemoveCommentPrefix(false);
        }
        if (n2 > 0) {
            int n6 = n2 + lineLen.replDiff;
            if (n3 > n6) {
                if (n2 > 72) {
                    this.error.print(251, 2, this.lineCount, 0, null, null, this.fileName);
                }
                n3 = n6;
            } else if (n3 < n6) {
                PreProcessor.fill72(this.lineBuffer, n3, n6);
                n3 = n6;
            }
        } else if (n3 < 72) {
            PreProcessor.fill72(this.lineBuffer, n3, 72);
            n3 = 72;
        }
        stringBuffer.setLength(0);
        if (n3 >= 7) {
            if (this.lineBuffer[6] == '*') {
                if (this.ansiFixListing != null) {
                    this.ansiFixListing.setRemoveCommentPrefix(true);
                }
                stringBuffer.append("*>");
                stringBuffer.append(this.lineBuffer, 7, n3 - 7);
            } else if (this.lineBuffer[6] == '$') {
                this.dollarHandling(7, stringBuffer, n3);
            } else if (this.lineBuffer[6] == 'D' || this.lineBuffer[6] == 'd') {
                stringBuffer.append(">>D ");
                stringBuffer.append(this.lineBuffer, 7, n3 - 7);
            } else if (this.lineBuffer[6] == '/') {
                stringBuffer.append(">>PAGE ");
            } else if (this.panvalet && this.lineBuffer[7] == '+' && this.lineBuffer[8] == '+' && this.lineBuffer[9] == 'I' && this.lineBuffer[10] == 'N' && this.lineBuffer[11] == 'C' && this.lineBuffer[12] == 'L' && this.lineBuffer[13] == 'U' && this.lineBuffer[14] == 'D' && this.lineBuffer[15] == 'E' && this.lineBuffer[16] == ' ' || this.lineBuffer[16] == '\t') {
                int n7;
                StringBuffer stringBuffer2 = new StringBuffer("COPY ");
                for (n7 = 17; n7 < n3 && this.lineBuffer[n7] <= ' '; ++n7) {
                }
                while (n7 < n3 && this.lineBuffer[n7] > ' ') {
                    stringBuffer2.append(this.lineBuffer[n7]);
                    ++n7;
                }
                stringBuffer2.append('.');
                stringBuffer.append(stringBuffer2);
            } else {
                if (this.lineBuffer[6] != ' ' && this.lineBuffer[6] != '\t' && this.lineBuffer[6] != '-' && this.lineBuffer[6] != '>') {
                    this.error.print(309, 3, this.lineCount, 7, "<" + new String(this.lineBuffer, 6, 1) + ">", null, this.fileName);
                    this.lineBuffer[6] = 32;
                }
                if (this.lineBuffer[6] == '>') {
                    stringBuffer.append(">");
                }
                for (int i2 = 7; i2 < n3 && ((this.lineBuffer[i2] != '|' || this.inExecSql) && (this.lineBuffer[i2] != '*' || i2 + 1 >= n3 || this.lineBuffer[i2 + 1] != '>') || n5 & true || n4 & true); ++i2) {
                    if (this.lineBuffer[i2] == '\'') {
                        if (n5 & true) continue;
                        ++n4;
                        continue;
                    }
                    if (this.lineBuffer[i2] != '\"' || (n4 & 1) != 0) continue;
                    ++n5;
                }
                if (this.lineBuffer[6] == '-') {
                    this.lineBuffer[6] = '\u0001';
                    stringBuffer.append(this.lineBuffer, 6, n3 - 6);
                } else {
                    stringBuffer.append(this.lineBuffer, 7, n3 - 7);
                }
            }
        }
    }

    private void getLineFixedB(StringBuffer stringBuffer, LineLen lineLen, int n2) {
        Object object;
        int n3 = 0;
        int n4 = 0;
        String string = new String(this.lineBuffer, 0, lineLen.length);
        byte[] byArray = string.getBytes();
        int n5 = byArray.length;
        if (this.ansiFixListing != null) {
            this.ansiFixListing.add1_7(new String(byArray, 0, Math.min(n5, 7)));
        }
        if (n2 > 0) {
            if (n5 < n2) {
                object = byArray;
                byArray = new byte[n2];
                System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                PreProcessor.fill72(byArray, n5, n2);
            } else if (n5 > n2 && n2 > 72) {
                this.error.print(251, 2, this.lineCount, 0, null, null, this.fileName);
            }
            n5 = n2;
        } else if (n5 < 72) {
            object = byArray;
            byArray = new byte[72];
            System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
            PreProcessor.fill72(byArray, n5, 72);
            n5 = 72;
        }
        stringBuffer.setLength(0);
        if (n5 >= 7) {
            if (byArray[6] == 42) {
                stringBuffer.append("*>");
                stringBuffer.append(new String(byArray, 7, n5 - 7));
            } else if (byArray[6] == 36) {
                this.dollarHandlingB(byArray, 7, stringBuffer, n5);
            } else if (byArray[6] == 68 || byArray[6] == 100) {
                stringBuffer.append(">>D ");
                stringBuffer.append(new String(byArray, 7, n5 - 7));
            } else if (byArray[6] == 47) {
                stringBuffer.append(">>PAGE ");
            } else if (this.panvalet && byArray[7] == 43 && byArray[8] == 43 && byArray[9] == 73 && byArray[10] == 78 && byArray[11] == 67 && byArray[12] == 76 && byArray[13] == 85 && byArray[14] == 68 && byArray[15] == 69 && byArray[16] == 32 || byArray[16] == 9) {
                int n6;
                object = new StringBuffer("COPY ");
                for (n6 = 17; n6 < n5 && byArray[n6] <= 32; ++n6) {
                }
                int n7 = n6;
                while (n6 < n5 && byArray[n6] > 32) {
                    ++n6;
                }
                ((StringBuffer)object).append(new String(byArray, n7, n6 - n7));
                ((StringBuffer)object).append('.');
                stringBuffer.append((StringBuffer)object);
            } else {
                if (byArray[6] != 32 && byArray[6] != 9 && byArray[6] != 45 && byArray[6] != 62) {
                    this.error.print(309, 3, this.lineCount, 7, "<" + new String(byArray, 6, 1) + ">", null, this.fileName);
                    this.lineBuffer[6] = 32;
                }
                if (byArray[6] == 62) {
                    stringBuffer.append(">");
                }
                for (int i2 = 7; i2 < n5 && ((byArray[i2] != 124 || this.inExecSql) && (byArray[i2] != 42 || i2 + 1 >= n5 || byArray[i2 + 1] != 62) || n4 & true || n3 & true); ++i2) {
                    if (byArray[i2] == 39) {
                        if (n4 & true) continue;
                        ++n3;
                        continue;
                    }
                    if (byArray[i2] != 34 || (n3 & 1) != 0) continue;
                    ++n4;
                }
                if (byArray[6] == 45) {
                    byArray[6] = 1;
                    stringBuffer.append(new String(byArray, 6, n5 - 6));
                } else {
                    stringBuffer.append(new String(byArray, 7, n5 - 7));
                }
            }
        }
    }

    private void getLineTerminalFixed(StringBuffer stringBuffer, int n2) {
        int n3 = 0;
        int n4 = 0;
        stringBuffer.setLength(0);
        if (n2 >= 1) {
            if (this.lineBuffer[0] == '*') {
                stringBuffer.append("*>");
                stringBuffer.append(this.lineBuffer, 1, n2 - 1);
            } else if (this.lineBuffer[0] == '$') {
                this.dollarHandling(1, stringBuffer, n2);
            } else if (this.lineBuffer[0] == '\\' && n2 > 1 && (this.lineBuffer[1] == 'D' || this.lineBuffer[1] == 'd')) {
                stringBuffer.append(">>D ");
                stringBuffer.append(this.lineBuffer, 2, n2 - 2);
            } else if (this.lineBuffer[0] == '/') {
                stringBuffer.append(">>PAGE ");
            } else {
                for (int i2 = 0; i2 < n2 && ((this.lineBuffer[i2] != '|' || this.inExecSql) && (this.lineBuffer[i2] != '*' || i2 + 1 >= n2 || this.lineBuffer[i2 + 1] != '>') || n4 & true || n3 & true); ++i2) {
                    if (this.lineBuffer[i2] == '\'') {
                        if (n4 & true) continue;
                        ++n3;
                        continue;
                    }
                    if (this.lineBuffer[i2] != '\"' || (n3 & 1) != 0) continue;
                    ++n4;
                }
                if (this.lineBuffer[0] == '-') {
                    this.lineBuffer[0] = '\u0001';
                }
                stringBuffer.append(this.lineBuffer, 0, n2);
            }
        }
    }

    private void getLineAnsiFree(StringBuffer stringBuffer, int n2) {
        stringBuffer.append(new String(this.lineBuffer, 0, n2));
    }

    private void formatLine(StringBuffer stringBuffer, LineLen lineLen) {
        int n2 = lineLen.length;
        this.checkFormat(n2);
        if (this.debugListing == 2) {
            this.getLineAnsiFree(stringBuffer, n2);
        } else {
            switch (this.format) {
                case 1: {
                    this.getLineAnsiFixed(stringBuffer, lineLen);
                    break;
                }
                case 2: {
                    this.getLineTerminalFixed(stringBuffer, n2);
                    break;
                }
                case 4: {
                    this.getLineVariable(stringBuffer, lineLen);
                    break;
                }
                case 5: {
                    this.getLineLong(stringBuffer, lineLen);
                    break;
                }
                default: {
                    this.getLineAnsiFree(stringBuffer, n2);
                }
            }
        }
    }

    private TokenList getTokenizedLine(StringBuffer stringBuffer, boolean bl) {
        return this.getTokenizedLine(stringBuffer, -1, false, bl);
    }

    private boolean findEndDotCopyReplace(TokenList tokenList) {
        Token token;
        boolean bl = false;
        this.lstHold = true;
        boolean bl2 = false;
        boolean bl3 = true;
        while ((token = this.getNextCrossLineToken(tokenList, false, false)) != null) {
            if (bl3 && "RESOURCE".equals(token.getWord())) {
                bl2 = true;
            } else if (token.getToknum() == 10004) {
                bl = !bl;
            } else if (token.getToknum() == 10006 && !bl) break;
            bl3 = false;
        }
        this.lstHold = false;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenList getTokenizedLine(StringBuffer stringBuffer, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        Object object;
        Object object2;
        Token token;
        int n5;
        Token token2;
        Token token3;
        TokenList tokenList = null;
        if (this.src == null) {
            return null;
        }
        LineLen lineLen = this.getLine(false);
        if (lineLen.length < 0) {
            if (this.cppFileFooter || this.customPreprocs == null) return null;
            this.cppFileFooter = true;
            String string = this.doCustPreProcFF();
            if (string == null) return null;
            this.lookAheadLine = new LineBuffer(1);
            this.lookAheadLine.buf.append(string);
            lineLen.length = string.length();
            lineLen = this.getLine(true);
        }
        int n6 = this.lineCount;
        this.formatLine(stringBuffer, lineLen);
        int n7 = stringBuffer.length();
        tokenList = new TokenList();
        if (this.error != null) {
            boolean bl3 = this.error.ignoreInvString;
            this.error.ignoreInvString = true;
            this.tokenizer(tokenList, stringBuffer, bl2);
            this.error.ignoreInvString = bl3;
        } else {
            this.tokenizer(tokenList, stringBuffer, bl2);
        }
        if (this.compFlags[4] && this.format == 1 && (token3 = tokenList.getLast()) != null && token3.getToknum() == 10005 && lineLen.length > 72) {
            token3.setWord(token3.getWord() + new String(this.lineBuffer, 72, lineLen.length - 72));
        }
        String string = "";
        if (this.isDebugListing() && lineLen.type != 0 && (token2 = tokenList.getLastWithSep()) != null && (n5 = token2.getOffset() + token2.getWord().length()) < n7) {
            string = stringBuffer.substring(n5);
        }
        if (!bl && (token = tokenList.getFirst()) != null && !token.getWord().equals("REPLACE")) {
            this.doReplace(tokenList);
            int n8 = this.getLineCount() - n6;
            if (n8 > 0 && this.isDebugListing()) {
                object2 = (StringWriter)this.lst;
                object = ((StringWriter)object2).getBuffer();
                for (n4 = 0; n4 <= n8; ++n4) {
                    n3 = ((StringBuffer)object).lastIndexOf(eol);
                    if (n3 < 0) continue;
                    if (n4 == n8) {
                        n3 += eol.length();
                    }
                    ((StringBuffer)object).delete(n3, ((StringBuffer)object).length());
                }
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        object2 = new TokenList();
        object = null;
        n4 = this.compFlags[2];
        this.compFlags[2] = false;
        Token token4 = tokenList.getFirstWithSep();
        while (token4 != null) {
            if (object != null && ((Token)object).getWord().equals(eol)) {
                this.lineCount = ++n6;
                this.tokenizer((TokenList)object2, stringBuffer2, bl2);
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            stringBuffer2.append(token4.getWord());
            object = token4;
            token4 = tokenList.deleteCurrentWithSep();
        }
        tokenList = object2;
        switch (lineLen.type) {
            case 0: {
                break;
            }
            case 2: {
                if (!this.debugReplSrc) break;
            }
            default: {
                ++n6;
            }
        }
        this.lineCount = n6;
        this.tokenizer(tokenList, stringBuffer2, bl2);
        this.compFlags[2] = n4;
        stringBuffer2.delete(0, stringBuffer2.length());
        n3 = this.index();
        token4 = tokenList.getFirstWithSep();
        while (token4 != null) {
            stringBuffer2.append(token4.getWord());
            Token token5 = tokenList.getNextWithSep();
            switch (token4.getToknum()) {
                case 10000: {
                    token4.putKeyword(this.notReservedWords);
                    break;
                }
                case 36: {
                    if (token5 == null || token5.getToknum() != 10000 || !Function.is(Token.getUpperCaseWord(token5.getWord()))) break;
                    token4.setWord("FUNCTION");
                    token4.setToknum(10009);
                }
            }
            token4.setFileIndex(n3);
            token4 = token5;
        }
        token4 = tokenList.getFirst();
        if (this.isDebugListing()) {
            if (lineLen.type == 0) return tokenList;
            stringBuffer2.append(string);
            this.writeListing(stringBuffer2.toString(), 0);
            return tokenList;
        } else if (token4 != null) {
            switch (token4.getToknum()) {
                case 379: 
                case 682: {
                    if (!this.inExec) {
                        this.saveLst();
                        boolean bl4 = this.findEndDotCopyReplace(tokenList);
                        this.writeListing(stringBuffer2, tokenList, bl4 ? -1 : 0);
                        return tokenList;
                    }
                    this.writeListing(stringBuffer2, tokenList, n2);
                    return tokenList;
                }
                case 474: {
                    this.inExec = true;
                    this.lstHold = true;
                    token4 = this.getNextCrossLineToken(tokenList);
                    if (token4 != null && token4.getWord().equals("SQL")) {
                        this.inExecSql = true;
                        token4 = this.getNextCrossLineToken(tokenList);
                        if (token4 != null) {
                            if (token4.getWord().equals("INCLUDE")) {
                                this.inExecSql = false;
                                while ((token4 = this.getNextCrossLineToken(tokenList)) != null && token4.getToknum() != 432) {
                                }
                                this.lstHold = false;
                                this.writeListing(stringBuffer2, tokenList, 0);
                                return tokenList;
                            }
                            if (token4.getWord().equals("BEGIN") || token4.getWord().equals("END")) {
                                this.inExecSql = false;
                                this.lstHold = false;
                                this.writeListing(stringBuffer2, tokenList, n2);
                                return tokenList;
                            }
                            this.lstHold = false;
                            this.writeListing(stringBuffer2, tokenList, n2);
                            return tokenList;
                        }
                        this.lstHold = false;
                        this.writeListing(stringBuffer2, tokenList, n2);
                        return tokenList;
                    }
                    this.lstHold = false;
                    this.writeListing(stringBuffer2, tokenList, n2);
                    return tokenList;
                }
                case 10003: {
                    token4 = tokenList.getNext();
                    if (token4 != null && token4.getWord().equals("SOURCE") && (token4 = tokenList.getNext()) != null && token4.getWord().equals("FORMAT")) {
                        this.writeListing(stringBuffer2, tokenList, 0);
                        return tokenList;
                    }
                    this.writeListing(stringBuffer2, tokenList, n2);
                    return tokenList;
                }
                case 432: {
                    this.inExec = false;
                    this.inExecSql = false;
                }
                default: {
                    if (n2 < 0 && !this.inExec) {
                        token4 = tokenList.getNext();
                        while (token4 != null) {
                            if (token4.getToknum() == 379 || token4.getToknum() == 682) {
                                this.saveLst();
                                n2 = token4.getOffset();
                                this.findEndDotCopyReplace(tokenList);
                                break;
                            }
                            token4 = tokenList.getNext();
                        }
                    }
                    if (bl) return tokenList;
                    this.writeListing(stringBuffer2, tokenList, n2);
                    return tokenList;
                }
            }
        } else {
            this.writeListing(stringBuffer2, tokenList, -1);
        }
        return tokenList;
    }

    private void saveLst() {
        if (this.ol.getOption("-po") != null && this.lst != null) {
            this.lstSave = this.lst;
            this.lst = new StringWriter();
        }
    }

    void restoreLst(int n2) {
        if (this.ol.getOption("-po") != null && this.lstSave != null && this.lst != null) {
            try {
                StringWriter stringWriter = (StringWriter)this.lst;
                if (n2 != 3) {
                    this.lstSave.write(stringWriter.toString());
                } else {
                    StringBuffer stringBuffer = stringWriter.getBuffer();
                    int n3 = 0;
                    int n4 = stringBuffer.indexOf(eol);
                    while (n3 < stringBuffer.length() && n4 >= 0) {
                        if (stringBuffer.charAt(n3 + 6) == '*') {
                            stringBuffer.setCharAt(n3 + 6, ' ');
                        }
                        n3 = n4 + eol.length();
                    }
                    this.lstSave.write(stringBuffer.toString());
                }
                stringWriter.close();
                this.lst = this.lstSave;
                this.lstSave = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isSeparator(char c2) {
        return c2 == ' ' || c2 == '\u001a' || c2 == '\n' || c2 == '\r' || c2 == '\t';
    }

    static long binToNum(char[] cArray, int[] nArray, int n2) {
        long l2 = 0L;
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': {
                    l2 = (l2 << 1) + (long)(cArray[nArray[0]] - 48);
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return l2;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return l2;
    }

    static long hexToNum(char[] cArray, int[] nArray, int n2) {
        long l2 = 0L;
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    l2 = l2 * 16L + (long)(cArray[nArray[0]] - 48);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    l2 = l2 * 16L + (long)cArray[nArray[0]] - 65L + 10L;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    l2 = l2 * 16L + (long)cArray[nArray[0]] - 97L + 10L;
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return l2;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return l2;
    }

    static long octToNum(char[] cArray, int[] nArray, int n2) {
        long l2 = 0L;
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    l2 = l2 * 8L + (long)(cArray[nArray[0]] - 48);
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return l2;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return l2;
    }

    static String binToString(char[] cArray, int[] nArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': {
                    stringBuffer.append(cArray[nArray[0]]);
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return stringBuffer.toString();
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return stringBuffer.toString();
    }

    static String hexToString(char[] cArray, int[] nArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    stringBuffer.append(cArray[nArray[0]]);
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return stringBuffer.toString();
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return stringBuffer.toString();
    }

    static String octToString(char[] cArray, int[] nArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (nArray[0] < n2) {
            switch (cArray[nArray[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    stringBuffer.append(cArray[nArray[0]]);
                    break;
                }
                default: {
                    nArray[0] = nArray[0] - 1;
                    return stringBuffer.toString();
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return stringBuffer.toString();
    }

    private static String[] checkHexString(String string, char c2, int n2) {
        long l2;
        int n3;
        char[] cArray = string.toCharArray();
        for (n3 = 0; n3 < 3 && cArray[n3] != c2; ++n3) {
        }
        if (n3 == 3) {
            return new String[2];
        }
        if (n2 == 2) {
            ++n3;
            while (n3 < cArray.length) {
                switch (cArray[n3]) {
                    case '\"': 
                    case '\'': {
                        return new String[]{string};
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        break;
                    }
                    default: {
                        return new String[]{null, String.valueOf(cArray[n3])};
                    }
                }
                ++n3;
            }
            return new String[]{string};
        }
        StringBuffer stringBuffer = new StringBuffer();
        ++n3;
        block16: while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '\"': 
                case '\'': {
                    break block16;
                }
                case '0': 
                case '1': {
                    stringBuffer.append(cArray[n3]);
                    break;
                }
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (n2 == 4 || n2 == 1) {
                        stringBuffer.append(cArray[n3]);
                        break;
                    }
                }
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (n2 == 1) {
                        stringBuffer.append(cArray[n3]);
                        break;
                    }
                }
                default: {
                    return new String[]{null, String.valueOf(cArray[n3])};
                }
            }
            ++n3;
        }
        cArray = stringBuffer.toString().toCharArray();
        int[] nArray = new int[1];
        switch (n2) {
            case 3: {
                l2 = PreProcessor.binToNum(cArray, nArray, cArray.length);
                break;
            }
            case 4: {
                l2 = PreProcessor.octToNum(cArray, nArray, cArray.length);
                break;
            }
            default: {
                l2 = PreProcessor.hexToNum(cArray, nArray, cArray.length);
            }
        }
        return new String[]{Long.toString(l2)};
    }

    boolean hexToString(char[] cArray, int[] nArray, int n2, char c2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer().append(c2);
        while (nArray[0] < n2 - 1 && cArray[nArray[0]] != c2) {
            int n3 = 0;
            for (int i2 = 0; i2 < 2 && cArray[nArray[0]] != c2; ++i2) {
                switch (cArray[nArray[0]]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n3 <<= 4;
                        n3 += (char)(cArray[nArray[0]] - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        n3 <<= 4;
                        n3 += (char)(cArray[nArray[0]] - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n3 <<= 4;
                        n3 += (char)(cArray[nArray[0]] - 97 + 10);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                nArray[0] = nArray[0] + 1;
            }
            stringBuffer.append((char)n3);
        }
        stringBuffer.append(c2);
        stringArray[0] = stringBuffer.toString();
        if (stringArray[0].length() > 2) {
            int n4 = nArray[0];
            char c3 = cArray[n4];
            cArray[n4] = (char)(c3 + '\u0001');
            if (c3 == c2) {
                return true;
            }
        }
        return false;
    }

    private void tokenizer(TokenList tokenList, StringBuffer stringBuffer, boolean bl) {
        int n2 = this.lineCount;
        if (!(this.debugReplSrc || this._len_.type != 2 && this._len_.type != 1)) {
            n2 = -n2;
            if (this.cppFileFooter) {
                n2 -= 100000000;
            }
        }
        this.nextStrHex = PreProcessor.tokenizer(tokenList, stringBuffer, n2, this.fileName, this.nextStrHex, this.decimalPoint, this.compFlags, this.error, this.inExecSql, this.isDebugListing(), this.format, bl);
    }

    public static TokenList tokenizer(StringBuffer stringBuffer, char c2, boolean bl, Hashtable hashtable) {
        return PreProcessor.tokenizer(stringBuffer, c2, false, bl, hashtable);
    }

    public static TokenList tokenizer(StringBuffer stringBuffer, char c2, boolean bl, boolean bl2, Hashtable hashtable) {
        return PreProcessor.tokenizer(stringBuffer, 0, "", c2, bl, bl2, hashtable);
    }

    static TokenList tokenizer(StringBuffer stringBuffer, int n2, String string, char c2, boolean bl, boolean bl2, Hashtable hashtable) {
        TokenList tokenList = new TokenList();
        PreProcessor.tokenizer(tokenList, stringBuffer, n2, string, 0, c2, null, null, false, bl, 0, false);
        if (bl2) {
            Token token = tokenList.getFirst();
            while (token != null) {
                if (token.getToknum() == 10000) {
                    token.putKeyword(hashtable);
                }
                token = tokenList.getNext();
            }
        }
        return tokenList;
    }

    private static boolean isStringCont(int n2, int n3, char[] cArray, char c2) {
        if (n2 + 1 < n3 && cArray[n2 + 1] == '-') {
            if (n2 + 2 < n3) {
                return cArray[n2 + 2] <= ' ' || cArray[n2 + 2] == c2;
            }
            return true;
        }
        return false;
    }

    public static int tokenizer(TokenList tokenList, StringBuffer stringBuffer, int n2, String string, int n3, char c2, boolean[] blArray, Errors errors, boolean bl) {
        return PreProcessor.tokenizer(tokenList, stringBuffer, n2, string, n3, c2, blArray, errors, bl, false, 0, false);
    }

    public static int tokenizer(TokenList tokenList, StringBuffer stringBuffer, int n2, String string, int n3, char c2, boolean[] blArray, Errors errors, boolean bl, boolean bl2, int n4) {
        return PreProcessor.tokenizer(tokenList, stringBuffer, n2, string, n3, c2, blArray, errors, bl, bl2, n4, false);
    }

    private static int tokenizer(TokenList tokenList, StringBuffer stringBuffer, int n2, String string, int n3, char c2, boolean[] blArray, Errors errors, boolean bl, boolean bl2, int n4, boolean bl3) {
        if (blArray == null) {
            blArray = new boolean[5];
        }
        int n5 = stringBuffer.length();
        char[] cArray = new char[n5];
        stringBuffer.toString().getChars(0, n5, cArray, 0);
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl) {
            c2 = (char)46;
        }
        int n6 = 0;
        block44: for (int i2 = 0; i2 < n5; ++i2) {
            boolean bl6 = false;
            switch (cArray[i2]) {
                case '>': {
                    if (i2 + 1 < n5 && cArray[i2 + 1] == '>') {
                        if (i2 + 3 < n5 && (cArray[i2 + 2] == 'D' || cArray[i2 + 2] == 'd') && cArray[i2 + 3] == ' ') {
                            if (bl3) {
                                tokenList.addItem(new Token(10016, "   ", n2, i2, string));
                                i2 += 3;
                                continue block44;
                            }
                            tokenList.addItem(new Token(10016, cArray, i2, n5 - i2, n2, i2, string));
                            i2 = n5;
                            continue block44;
                        }
                        String string2 = new String(cArray, i2 + 2, n5 - i2 - 2).trim();
                        int n7 = string2.indexOf(32);
                        String string3 = n7 >= 0 ? string2.substring(0, n7).toLowerCase() : string2;
                        if (EXTRA_INFO_KEYWORDS.contains(string3)) {
                            tokenList.addItem(new Token(10020, "*>((" + string2 + "))", n2, i2, string));
                            i2 = n5;
                            continue block44;
                        }
                        tokenList.addItem(new Token(10003, cArray, i2, 2, n2, i2, string));
                        ++i2;
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                    continue block44;
                }
                case '|': {
                    if (bl) {
                        tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                        continue block44;
                    }
                    Token token = tokenList.getLast();
                    if (token != null && token.getToknum() == 10006) {
                        token.setWord(bl2 ? "." : ". ");
                    }
                    tokenList.addItem(new Token(blArray[4] ? 10005 : 10016, cArray, i2, n5 - i2, n2, i2, string));
                    if (blArray[2]) {
                        PreProcessor.parseTasks(cArray, i2, n5 - i2, n2, string, n4 == 1 ? 6 : 0, errors);
                    }
                    i2 = n5;
                    ++i2;
                    continue block44;
                }
                case '$': 
                case '*': {
                    Token token;
                    if (i2 + 1 < n5 && cArray[i2 + 1] == '>' || bl2 && i2 == 6 && n4 == 1 || bl2 && i2 == 0 && n4 == 2) {
                        String string4;
                        token = tokenList.getLast();
                        if (token != null && token.getToknum() == 10006) {
                            token.setWord(bl2 ? "." : ". ");
                        }
                        if ((string4 = new String(cArray, i2, n5 - i2).trim()).startsWith("*>((") && string4.endsWith("))")) {
                            tokenList.addItem(new Token(10020, string4, n2, i2, string));
                        } else {
                            if (string4.startsWith("*>((") && !string4.endsWith("))") && errors != null) {
                                errors.print(106, 2, i2, 7, string4, null, string);
                            }
                            tokenList.addItem(new Token(10005, cArray, i2, n5 - i2, n2, i2, string));
                            if (blArray[2]) {
                                PreProcessor.parseTasks(cArray, i2, n5 - i2, n2, string, n4 == 1 ? 6 : 0, errors);
                            }
                        }
                        i2 = n5;
                        ++i2;
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                    continue block44;
                }
                case '=': {
                    if (i2 + 1 < n5 && cArray[i2 + 1] == '=') {
                        tokenList.addItem(new Token(10004, cArray, i2, 2, n2, i2, string));
                        ++i2;
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                    continue block44;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case ' ': {
                    n6 = i2++;
                    while (i2 < n5 && PreProcessor.isSeparator(cArray[i2])) {
                        ++i2;
                    }
                    tokenList.addItem(new Token(10016, cArray, n6, --i2 - n6 + 1, n2, n6, string));
                    continue block44;
                }
                case ':': {
                    StringBuffer stringBuffer2;
                    boolean bl7 = false;
                    if (i2 + 1 < n5 && ((bl7 = cArray[i2 + 1] == ':') || cArray[i2 + 1] == '>')) {
                        tokenList.addItem(new Token(10018, cArray, i2, 2, n2, i2, string));
                        if (!bl7 && !bl2) {
                            cArray[i2 + 1] = 58;
                        }
                        if (++i2 + 1 < n5 && (cArray[i2 + 1] == '\"' || cArray[i2 + 1] == '\'')) continue block44;
                        n6 = i2;
                        stringBuffer2 = new StringBuffer();
                        if (bl2) {
                            ++n6;
                        } else {
                            stringBuffer2.append('\"');
                        }
                        ++i2;
                        while (i2 < n5 && (Character.isLetter(cArray[i2]) || Character.isDigit(cArray[i2]) || cArray[i2] == '_')) {
                            stringBuffer2.append(cArray[i2]);
                            ++i2;
                        }
                        --i2;
                        if (!bl2) {
                            stringBuffer2.append('\"');
                        }
                        tokenList.addItem(new Token(10001, stringBuffer2.toString(), n2, n6, string));
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                    continue block44;
                }
                case ';': {
                    if (i2 + 1 < n5 && cArray[i2 + 1] == ';') {
                        tokenList.addItem(new Token(372, cArray, i2, 2, 0, i2, string));
                        ++i2;
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                    continue block44;
                }
                case ',': {
                    i2 = PreProcessor.comma(tokenList, cArray, i2, n5, n2, string, c2, bl2);
                    continue block44;
                }
                case '.': {
                    blArray[3] = false;
                    if (bl2) {
                        tokenList.addItem(new Token(10006, ".", n2, i2, string));
                        continue block44;
                    }
                    i2 = PreProcessor.dot(tokenList, cArray, i2, n5, n2, string, c2);
                    continue block44;
                }
                case '\"': 
                case '\'': {
                    char c3 = cArray[i2];
                    n6 = i2;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (bl4) {
                        switch (cArray[i2 - 1]) {
                            case 'B': 
                            case 'b': {
                                n3 = 3;
                                stringBuffer2.append('B');
                                break;
                            }
                            case 'O': 
                            case 'o': {
                                n3 = 4;
                                stringBuffer2.append('O');
                                break;
                            }
                            case 'H': 
                            case 'h': {
                                n3 = 1;
                                stringBuffer2.append('H');
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                n3 = 2;
                                if (i2 > 1 && (cArray[i2 - 2] == 'N' || cArray[i2 - 2] == 'n')) {
                                    stringBuffer2.append("NX");
                                    break;
                                }
                                stringBuffer2.append('X');
                                break;
                            }
                            case 'N': 
                            case 'n': {
                                stringBuffer2.append('N');
                                break;
                            }
                            case 'R': 
                            case 'r': {
                                stringBuffer2.append('R');
                            }
                        }
                        bl4 = false;
                    }
                    stringBuffer2.append(cArray[i2]);
                    ++i2;
                    while (i2 < n5) {
                        stringBuffer2.append(cArray[i2]);
                        if (cArray[i2] == c3) {
                            if (i2 + 1 >= n5 || cArray[i2 + 1] != c3) break;
                            stringBuffer2.append(cArray[++i2]);
                        }
                        ++i2;
                    }
                    if (i2 < n5) {
                        Token token;
                        int n8;
                        String[] stringArray = null;
                        int n9 = n3;
                        if (n9 == 1 && !blArray[0]) {
                            n9 = 2;
                        }
                        switch (n9) {
                            case 1: 
                            case 2: {
                                n8 = 311;
                                break;
                            }
                            case 3: {
                                n8 = 310;
                                break;
                            }
                            case 4: {
                                n8 = 312;
                                break;
                            }
                            default: {
                                n8 = 1;
                            }
                        }
                        if (PreProcessor.isStringCont(i2, n5, cArray, c3)) {
                            stringBuffer2.append(cArray[++i2]);
                            if (errors != null && n9 == 2 && (stringArray = PreProcessor.checkHexString(stringBuffer2.toString(), c3, n9)).length == 2) {
                                errors.print(n8, 4, n2, n6, stringArray[1], null, string);
                            }
                            tokenList.addItem(new Token(10014, stringArray != null && stringArray.length == 1 ? stringArray[0] : stringBuffer2.toString(), n2, n6, string));
                            continue block44;
                        }
                        if (errors != null && n3 != 0 && (stringArray = PreProcessor.checkHexString(stringBuffer2.toString(), c3, n9)).length == 2) {
                            errors.print(n8, 4, n2, n6, stringArray[1], null, string);
                        }
                        switch (n3) {
                            default: {
                                if (blArray[0] && stringArray != null && stringArray.length == 1 && !bl2) {
                                    token = new Token(10002, stringArray[0], n2, n6, string);
                                    break;
                                }
                                token = new Token(10001, stringArray != null && stringArray.length == 1 ? stringArray[0] : stringBuffer2.toString(), n2, n6, string);
                                break;
                            }
                            case 2: {
                                token = new Token(10001, stringArray != null && stringArray.length == 1 ? stringArray[0] : stringBuffer2.toString(), n2, n6, string);
                                break;
                            }
                            case 3: {
                                if (stringArray != null && stringArray.length == 1 && !bl2) {
                                    token = new Token(10002, stringArray[0], n2, n6, string);
                                    token.setBitLen(stringBuffer2.length() - 3);
                                    token.setWord(stringBuffer2.toString());
                                    break;
                                }
                                token = new Token(10001, stringBuffer2.toString(), n2, n6, string);
                                break;
                            }
                            case 4: {
                                token = stringArray != null && stringArray.length == 1 && !bl2 ? new Token(10002, stringArray[0], n2, n6, string) : new Token(10001, stringBuffer2.toString(), n2, n6, string);
                            }
                        }
                        tokenList.addItem(token);
                        n3 = 0;
                        continue block44;
                    }
                    tokenList.addItem(new Token(10024, stringBuffer2.toString(), n2, n6, string));
                    n3 = 0;
                    continue block44;
                }
                case '-': {
                    StringBuffer stringBuffer2;
                    if (i2 + 1 < n5 && cArray[i2 + 1] == '>') {
                        n6 = ++i2;
                        stringBuffer2 = new StringBuffer("->");
                        ++i2;
                        while (i2 < n5 && (Character.isLetterOrDigit(cArray[i2]) || cArray[i2] == '_' || cArray[i2] == '-')) {
                            stringBuffer2.append(cArray[i2]);
                            ++i2;
                        }
                        --i2;
                        tokenList.addItem(new Token(10009, stringBuffer2.toString(), n2, n6, string));
                        continue block44;
                    }
                }
                case '+': {
                    i2 = PreProcessor.plusMinus(tokenList, cArray, i2, n5, n2, string, c2);
                    continue block44;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    i2 = PreProcessor.number(tokenList, cArray, i2, n5, n2, string, c2);
                    continue block44;
                }
                case 'H': 
                case 'R': 
                case 'X': 
                case 'h': 
                case 'r': 
                case 'x': {
                    if (i2 + 1 < n5 && (cArray[i2 + 1] == '\'' || cArray[i2 + 1] == '\"')) {
                        bl4 = true;
                        continue block44;
                    }
                    bl6 = true;
                }
                case 'N': 
                case 'n': {
                    if (!bl6) {
                        if (i2 + 1 < n5 && (cArray[i2 + 1] == '\'' || cArray[i2 + 1] == '\"')) {
                            bl4 = true;
                            continue block44;
                        }
                        if (!(i2 + 2 >= n5 || cArray[i2 + 1] != 'X' && cArray[i2 + 1] != 'x' || cArray[i2 + 2] != '\'' && cArray[i2 + 2] != '\"')) {
                            bl4 = true;
                            continue block44;
                        }
                    }
                    bl6 = true;
                }
                case 'B': 
                case 'O': 
                case 'b': 
                case 'o': {
                    n6 = i2;
                    char c3 = '\u0000';
                    if (cArray[i2] == 'B' || cArray[i2] == 'b') {
                        if (i2 + 1 < n5) {
                            switch (cArray[i2 + 1]) {
                                case '#': {
                                    int[] nArray = new int[]{i2 += 2};
                                    String string5 = bl2 ? "" + cArray[i2 - 2] + "#" + PreProcessor.binToString(cArray, nArray, n5) : Long.toString(PreProcessor.binToNum(cArray, nArray, n5));
                                    tokenList.addItem(new Token(10002, string5, n2, n6, string));
                                    i2 = nArray[0];
                                    continue block44;
                                }
                                case '\"': 
                                case '\'': {
                                    bl4 = true;
                                    continue block44;
                                }
                            }
                        }
                    } else if (cArray[i2] == 'O' || cArray[i2] == 'o') {
                        if (i2 + 1 < n5) {
                            switch (cArray[i2 + 1]) {
                                case '#': {
                                    int[] nArray = new int[]{i2 += 2};
                                    String string6 = bl2 ? "" + cArray[i2 - 2] + "#" + PreProcessor.octToString(cArray, nArray, n5) : Long.toString(PreProcessor.octToNum(cArray, nArray, n5));
                                    tokenList.addItem(new Token(10002, string6, n2, n6, string));
                                    i2 = nArray[0];
                                    continue block44;
                                }
                                case '\"': 
                                case '\'': {
                                    if (!blArray[0]) break;
                                    bl4 = true;
                                    continue block44;
                                }
                            }
                        }
                    } else if (i2 + 1 < n5 && cArray[i2 + 1] == '#') {
                        int[] nArray = new int[]{i2 += 2};
                        String string7 = bl2 ? "" + cArray[i2 - 2] + "#" + PreProcessor.hexToString(cArray, nArray, n5) : Long.toString(PreProcessor.hexToNum(cArray, nArray, n5));
                        tokenList.addItem(new Token(10002, string7, n2, n6, string));
                        i2 = nArray[0];
                        continue block44;
                    }
                    bl6 = true;
                }
                default: {
                    if (Character.isLetter(cArray[i2])) {
                        if (i2 > 0 && (cArray[i2 - 1] == '-' || cArray[i2 - 1] == '_') && tokenList.getItemNum() >= 2 && tokenList.getFirst().getToknum() == 1) {
                            tokenList.getLast();
                            while (i2 > 0 && (cArray[i2 - 1] == '-' || cArray[i2 - 1] == '_')) {
                                --i2;
                                tokenList.deleteCurrent();
                            }
                        }
                        n6 = i2++;
                        while (i2 < n5 && (Character.isLetter(cArray[i2]) || Character.isDigit(cArray[i2]) || cArray[i2] == '-' || cArray[i2] == '_' || cArray[i2] == '.' && blArray[3] && i2 + 1 < n5 && (Character.isLetter(cArray[i2 + 1]) || Character.isDigit(cArray[i2 + 1])))) {
                            ++i2;
                        }
                        Token token = new Token(10000, cArray, n6, --i2 - n6 + 1, n2, n6, string);
                        tokenList.addItem(token);
                        if (token.getWord().equalsIgnoreCase("COPY")) {
                            blArray[3] = true;
                            continue block44;
                        }
                        if (token.getWord().equalsIgnoreCase("EXEC")) {
                            bl5 = true;
                            continue block44;
                        }
                        if (!token.getWord().equalsIgnoreCase("SQL") || !bl5) continue block44;
                        bl = true;
                        continue block44;
                    }
                    tokenList.addItem(new Token(cArray[i2], n2, i2, string));
                }
            }
        }
        return n3;
    }

    private static void parseTasks(char[] cArray, int n2, int n3, int n4, String string, int n5, Errors errors) {
        String string2 = new String(cArray, n2, n3);
        String string3 = string2.toLowerCase();
        Matcher matcher = TASK_PATTERN.matcher(string3);
        int n6 = -1;
        int n7 = -1;
        while (matcher.find()) {
            if (n6 >= 0) {
                errors.printTask(n7, n4, n6 + n5, string2.substring(n6, matcher.start()), string);
            }
            n6 = matcher.start();
            n7 = string3.substring(matcher.start(), matcher.end()).equals("todo") ? 0 : 1;
        }
        if (n6 >= 0) {
            errors.printTask(n7, n4, n6 + n5, string2.substring(n6), string);
        }
    }

    private static int number(TokenList tokenList, char[] cArray, int n2, int n3, int n4, String string, char c2) {
        int n5 = n2++;
        while (n2 < n3 && Character.isDigit(cArray[n2])) {
            ++n2;
        }
        if (n2 < n3 && (Character.isLetter(cArray[n2]) || cArray[n2] == '-' || cArray[n2] == '_')) {
            ++n2;
            while (n2 < n3 && (Character.isLetter(cArray[n2]) || Character.isDigit(cArray[n2]) || cArray[n2] == '-' || cArray[n2] == '_')) {
                ++n2;
            }
            --n2;
            while (cArray[n2] == '-' || cArray[n2] == '_') {
                --n2;
            }
            tokenList.addItem(new Token(10000, cArray, n5, n2 - n5 + 1, n4, n5, string));
        } else {
            tokenList.addItem(new Token(10002, cArray, n5, --n2 - n5 + 1, n4, n5, string));
        }
        if (n2 + 2 < n3 && cArray[n2 + 1] == c2 && Character.isDigit(cArray[n2 + 2])) {
            if (c2 == '.') {
                tokenList.addItem(new Token(10006, ".", n4, ++n2, string));
            } else {
                tokenList.addItem(new Token(44, ",", n4, ++n2, string));
            }
            ++n2;
            n5 = n2++;
            while (n2 < n3 && Character.isDigit(cArray[n2])) {
                ++n2;
            }
            if (--n2 >= n5) {
                tokenList.addItem(new Token(10002, cArray, n5, n2 - n5 + 1, n4, n5, string));
                if (n2 + 2 < n3 && (cArray[n2 + 1] == 'E' || cArray[n2 + 1] == 'e')) {
                    tokenList.addItem(new Token(10022, "E", n4, ++n2, string));
                }
            }
        }
        return n2;
    }

    private static int dot(TokenList tokenList, char[] cArray, int n2, int n3, int n4, String string, char c2) {
        while (n3 > 1 && PreProcessor.isSeparator(cArray[n3 - 1])) {
            --n3;
        }
        if ('.' == c2 && n2 + 1 < n3 && Character.isDigit(cArray[n2 + 1]) && (n2 == 0 || !Character.isLetter(cArray[n2 - 1]))) {
            tokenList.addItem(new Token(10002, "", n4, n2, string));
            tokenList.addItem(new Token(10006, ".", n4, n2, string));
        } else {
            int n5 = n2++;
            while (n2 < n3 && PreProcessor.isSeparator(cArray[n2])) {
                ++n2;
            }
            if (n2 == n3 && n2 - n5 == 1) {
                tokenList.addItem(new Token(10006, ". ", n4, n5, string));
            } else {
                int n6;
                n6 = (n6 = --n2 - n5 + 1) > 2 ? 2 : n6;
                tokenList.addItem(new Token(10006, cArray, n5, n6, n4, n5, string));
            }
        }
        return n2;
    }

    private static int comma(TokenList tokenList, char[] cArray, int n2, int n3, int n4, String string, char c2, boolean bl) {
        if (',' == c2 && n2 + 1 < n3 && Character.isDigit(cArray[n2 + 1]) && (n2 == 0 || !Character.isLetter(cArray[n2 - 1]))) {
            tokenList.addItem(new Token(10002, "", n4, n2, string));
            tokenList.addItem(new Token(44, ",", n4, n2, string));
        } else {
            int n5 = n2++;
            while (n2 < n3 && PreProcessor.isSeparator(cArray[n2])) {
                ++n2;
            }
            if (n2 == n3 && n2 - n5 == 1) {
                tokenList.addItem(new Token(44, ", ", n4, n5, string));
            } else if (!bl && (n2 < n3 && cArray[n2] == '|' || n2 + 1 < n3 && cArray[n2] == '*' && cArray[n2 + 1] == '>')) {
                --n2;
                tokenList.addItem(new Token(44, ", ", n4, n5, string));
            } else {
                tokenList.addItem(new Token(44, cArray, n5, --n2 - n5 + 1, n4, n5, string));
            }
        }
        return n2;
    }

    private static int plusMinus(TokenList tokenList, char[] cArray, int n2, int n3, int n4, String string, char c2) {
        if (n2 + 2 < n3 && cArray[n2 + 1] == c2 && Character.isDigit(cArray[n2 + 2])) {
            tokenList.addItem(new Token(10002, "" + cArray[n2], n4, n2, string));
            if (c2 == '.') {
                tokenList.addItem(new Token(10006, ".", n4, ++n2, string));
            } else {
                tokenList.addItem(new Token(44, ",", n4, ++n2, string));
            }
        } else if (n2 + 1 < n3 && Character.isDigit(cArray[n2 + 1])) {
            n2 = PreProcessor.number(tokenList, cArray, n2, n3, n4, string, c2);
        } else {
            tokenList.addItem(new Token(cArray[n2], n4, n2, string));
        }
        return n2;
    }

    int compare(Token token, Token token2) {
        try {
            int n2 = Integer.parseInt(token.getCode());
            int n3 = Integer.parseInt(token2.getCode());
            return n2 - n3;
        }
        catch (NumberFormatException numberFormatException) {
            return token.getCode().compareTo(token2.getCode());
        }
    }

    private Token getPicture(TokenList tokenList, Token token) {
        Token token2 = null;
        if (token != null) {
            if (token.getToknum() == 545) {
                token = tokenList.getNext();
            }
            if (token != null) {
                boolean bl = false;
                token.setToknum(10023);
                Token token3 = tokenList.atEnd() ? this.getNextCrossLineToken(tokenList, true) : tokenList.getNextWithSep();
                while (token3 != null && token3.getToknum() != 59 && (token3.getToknum() != 10016 || token2 != null && token2.getToknum() == 1 || bl)) {
                    if ((token3.getToknum() == 10006 || token3.getToknum() == 44) && token3.getWord().length() > 1) {
                        tokenList.getPreviousWithSep();
                        break;
                    }
                    if (token3.getToknum() != 10016 && token3.getToknum() != 1) {
                        if (token3.getToknum() == 40) {
                            bl = true;
                        } else if (token3.getToknum() == 41) {
                            bl = false;
                        }
                        token.setWord(token.getWord() + token3.getWord());
                    }
                    token2 = token3;
                    if (!tokenList.atEnd()) {
                        token3 = tokenList.deleteCurrentWithSep();
                        continue;
                    }
                    token3 = this.getNextCrossLineToken(tokenList, true);
                    if (token3 == null || token3.getToknum() == 1 || bl) continue;
                    tokenList.getPreviousWithSep();
                    break;
                }
            }
        }
        return token;
    }

    private void addElement(Vector vector, Token token) {
        if (vector != null) {
            vector.addElement(token);
        }
    }

    @Override
    public int getLine(Vector vector) {
        return this.getLine(vector, null);
    }

    private static boolean nextEquals(TokenList tokenList, String string) {
        Token token = tokenList.getNext();
        if (token != null && string.equals(token.getWord())) {
            return true;
        }
        tokenList.getPrevious();
        return false;
    }

    void setFormat() {
        if (this.ol.getOption("-sa") != null) {
            this.setSourceFormatAnsi();
        } else if (this.ol.getOption("-st") != null) {
            this.setSourceFormatTerminal();
        } else if (this.ol.getOption("-sv") != null) {
            this.setSourceFormatVariable();
        } else if (this.ol.getOption("-sl") != null) {
            this.setSourceFormatLongLine();
        } else if (this.ol.getOption("-sf") != null) {
            this.setSourceFormatFree();
        }
    }

    int getLine(Vector vector, TokenManager tokenManager) {
        Token token;
        StringBuffer stringBuffer;
        TokenList tokenList;
        boolean bl;
        int n2 = 0;
        if (this.copy != null) {
            int n3 = this.copy.getLine(vector, tokenManager);
            if (n3 < 0) {
                this.copy.fileFooter();
                this.copy.closeSource();
                this.copy = null;
            } else {
                return n3;
            }
        }
        Branch branch = this.skipping.isEmpty() ? null : (Branch)this.skipping.peek();
        boolean bl2 = false;
        boolean bl3 = bl = tokenManager != null ? tokenManager.debuggingMode : false;
        if (branch != null) {
            for (int i2 = this.skipping.size() - 1; i2 >= 0 && !bl2; --i2) {
                bl2 = ((Branch)this.skipping.elementAt((int)i2)).skip;
            }
        }
        if ((tokenList = this.getTokenizedLine(stringBuffer = new StringBuffer(), bl)) == null) {
            return -1;
        }
        stringBuffer.delete(0, stringBuffer.length());
        if (bl2 && !this.isDebugListing()) {
            if (tokenList.getItemNum() < 2) {
                return 1;
            }
            token = tokenList.getFirst();
            if (token == null || token.getToknum() != 10003) {
                return 1;
            }
            token = tokenList.getNext();
            if (token == null) {
                return 1;
            }
            switch (token.getToknum()) {
                case 417: 
                case 431: 
                case 433: 
                case 467: 
                case 524: 
                case 810: {
                    break;
                }
                default: {
                    return 1;
                }
            }
        }
        token = tokenList.getFirst();
        if (this.picture && token != null && token.getToknum() != 10003) {
            if (token.getOffset() == 0 && token.getWord().charAt(0) == '*' && token.getWord().charAt(1) == '>') {
                return 0;
            }
            if ((token = this.getPicture(tokenList, token)) != null) {
                this.addElement(vector, token);
                ++n2;
                this.picture = false;
                token = tokenList.getNext();
            }
        }
        while (token != null) {
            int n4;
            if (this.isDebugListing()) {
                switch (token.getToknum()) {
                    case 379: 
                    case 682: 
                    case 10003: 
                    case 10004: {
                        break;
                    }
                    case 474: {
                        int n5 = tokenList.getCurrentIndex();
                        n4 = 0;
                        token = this.getNextCrossLineToken(tokenList);
                        if (token != null && token.getWord().equals("SQL") && (token = this.getNextCrossLineToken(tokenList)) != null && token.getWord().equals("INCLUDE")) {
                            n4 = 1;
                            n2 = 0;
                        }
                        token = tokenList.getAt(n5);
                        if (n4 != 0) break;
                    }
                    default: {
                        this.addElement(vector, token);
                        ++n2;
                        break;
                    }
                }
            } else if (this.inExecSql) {
                this.addElement(vector, token);
                ++n2;
                if (token.getToknum() == 432) {
                    this.inExecSql = false;
                    this.inExec = false;
                }
            } else {
                switch (token.getToknum()) {
                    case 10003: {
                        Object object;
                        Token token2 = token;
                        if (n2 > 0) {
                            this.error.print(4, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        }
                        Token token3 = token;
                        token = tokenList.getNext();
                        if (token != null) {
                            if (token.getToknum() == 629) break;
                            if ("SOURCE".equals(token.getWord()) && (token = tokenList.getNext()) != null && "FORMAT".equals(token.getWord())) {
                                token = tokenList.getNext();
                                if (token != null && "IS".equals(token.getWord())) {
                                    token = tokenList.getNext();
                                }
                                if (token != null) {
                                    if ("FIXED".equals(token.getWord())) {
                                        this.setFormat(1);
                                        break;
                                    }
                                    if ("FREE".equals(token.getWord())) {
                                        this.setFormat(3);
                                        break;
                                    }
                                    if ("TERMINAL".equals(token.getWord())) {
                                        this.setFormat(2);
                                        break;
                                    }
                                    if ("VARIABLE".equals(token.getWord())) {
                                        this.setFormat(4);
                                        break;
                                    }
                                    if ("PREVIOUS".equals(token.getWord())) {
                                        this.resetFormat();
                                        break;
                                    }
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if (token.getToknum() == 524) {
                                if (this.ignoreConditions) break;
                                PreCondition preCondition = new PreCondition(this, tokenList);
                                int n6 = preCondition.parse();
                                if (n6 != 0 && !bl2) {
                                    this.error.print(n6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                }
                                if (preCondition.evaluate()) {
                                    this.skipping.push(new Branch(token, false));
                                    break;
                                }
                                this.skipping.push(new Branch(token, true));
                                break;
                            }
                            if (token.getToknum() == 417) {
                                if (this.ignoreConditions) break;
                                if (branch == null) {
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                branch.skip = !branch.skip;
                                break;
                            }
                            if (token.getToknum() == 433) {
                                if (this.ignoreConditions) break;
                                if (branch == null) {
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                this.skipping.pop();
                                break;
                            }
                            if (token.getToknum() == 467) {
                                if (this.ignoreConditions) break;
                                token = tokenList.getNext();
                                if (token != null) {
                                    Token token4 = this.getConstant(token.getWord());
                                    if (token4 != null) {
                                        this.skipping.push(new Branch(token, token4));
                                        break;
                                    }
                                    this.error.print(111, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if (token.getToknum() == 431) {
                                if (this.ignoreConditions) break;
                                if (branch == null || branch.eval == null) {
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                this.skipping.pop();
                                break;
                            }
                            if (token.getToknum() == 810) {
                                if (this.ignoreConditions) break;
                                if (branch == null || branch.eval == null) {
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                token = tokenList.getNext();
                                if (token != null) {
                                    if (token.getToknum() == 620) {
                                        branch.skip = branch.eval.getWord() == null;
                                    } else {
                                        boolean bl4 = branch.skip = branch.eval.getWord() == null || this.compare(token, branch.eval) != 0;
                                    }
                                    if (branch.skip) break;
                                    branch.eval.setWord(null);
                                    break;
                                }
                                this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if ("PROPAGATE".equals(token.getWord())) {
                                token = tokenList.getNext();
                                if (token == null || token.getToknum() == 613) {
                                    this.propagate = true;
                                    break;
                                }
                                if (token.getToknum() == 610) {
                                    this.propagate = false;
                                    break;
                                }
                                this.error.print(5, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                break;
                            }
                            if ("IMP".equals(token.getWord())) {
                                token = tokenList.getNext();
                                if (token != null) {
                                    if ("OPTION".equals(token.getWord())) {
                                        token = tokenList.getNext();
                                        if (token != null && token.getToknum() == 10001) {
                                            String string = token.getPlain();
                                            object = new StringTokenizer(string);
                                            while (((StringTokenizer)object).hasMoreTokens()) {
                                                String string2;
                                                String string3 = ((StringTokenizer)object).nextToken();
                                                if (string3.toLowerCase(Locale.US).equals("#smfu") || string3.toLowerCase(Locale.US).equals("-no-smfu")) {
                                                    Pcc.hyphenRepl = (char)95;
                                                    Pcc.identifierSep = (char)36;
                                                }
                                                if ((string2 = this.ol.addOption(string3)) == null) {
                                                    this.error.print(5, 4, token.getFLN(), token.getOffset(), string3, null, this.fileName);
                                                    continue;
                                                }
                                                if (!string2.equals("-sp=") && !string2.equals("-ce=") || !(this.getFileFinder() instanceof CachedFileFinder)) continue;
                                                ((CachedFileFinder)this.getFileFinder()).clearCache();
                                            }
                                            this.panvalet = this.ol.getOption("-cpanv") != null;
                                            this.ol.checkOptions();
                                            if (this.ol.hasErrors()) {
                                                this.error.print(this.ol.getErrorNum(), 4, token.getFLN(), token.getOffset(), string, null, this.fileName);
                                            }
                                            this.initRW(false);
                                            this.setFormat();
                                        } else {
                                            this.error.print(5, 4, token.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                        }
                                        this.ol.notifyListChanges();
                                        break;
                                    }
                                    if ("MARGIN-R".equals(token.getWord()) && PreProcessor.nextEquals(tokenList, "IS") && PreProcessor.nextEquals(tokenList, "AFTER") && PreProcessor.nextEquals(tokenList, "END") && PreProcessor.nextEquals(tokenList, "OF") && PreProcessor.nextEquals(tokenList, "RECORD")) {
                                        this.setFormat(5);
                                        break;
                                    }
                                    this.error.print(5, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                                    break;
                                }
                                this.error.print(5, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                break;
                            }
                            if (token.getToknum() == 465) {
                                n4 = token.getOffset();
                                int n7 = token.getFLN();
                                String string = "";
                                while ((token = tokenList.getNext()) != null) {
                                    string = string + token.getWord() + " ";
                                }
                                token = new Token(10026, string, n7, n4, this.fileName);
                                this.addElement(vector, token);
                                break;
                            }
                            if ("DEFINE".equals(token.getWord())) {
                                token = tokenList.getNext();
                                if (token != null) {
                                    if (token.getToknum() == 10009) {
                                        Token token5 = token;
                                        Token token6 = null;
                                        boolean bl5 = false;
                                        boolean bl6 = false;
                                        token = tokenList.getNext();
                                        if (token != null && token.getToknum() == 280) {
                                            token = tokenList.getNext();
                                        }
                                        if (token != null) {
                                            Object object2;
                                            switch (token.getToknum()) {
                                                case 610: {
                                                    bl5 = true;
                                                    break;
                                                }
                                                case 10009: {
                                                    if ("PARAMETER".equals(token.getWord())) {
                                                        object2 = Config.a("." + token5.getWord().toLowerCase(Locale.US), null);
                                                        if (object2 == null) {
                                                            this.error.print(111, 4, token.getFLN(), token.getOffset(), token5.getWord() + " PARAMETER", null, this.fileName);
                                                            break;
                                                        }
                                                        token6 = new Token(token);
                                                        token6.setWord((String)object2);
                                                        break;
                                                    }
                                                    this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                                    break;
                                                }
                                                case 10001: 
                                                case 10002: {
                                                    token6 = token;
                                                    break;
                                                }
                                                default: {
                                                    this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                                }
                                            }
                                            token = tokenList.getNext();
                                            if (token != null) {
                                                if (token.getToknum() == 626) {
                                                    bl6 = true;
                                                } else {
                                                    tokenList.getPrevious();
                                                }
                                            }
                                            if (token6 == null && !bl5) break;
                                            if (!bl6) {
                                                object2 = this.getConstant(token5);
                                                if (bl5) {
                                                    if (object2 == null) {
                                                        this.error.print(111, 4, token2.getFLN(), token2.getOffset(), token5.getWord(), null, this.fileName);
                                                        break;
                                                    }
                                                    this.removeConstant(token5);
                                                    break;
                                                }
                                                if (object2 != null && this.compare((Token)object2, token6) != 0) {
                                                    this.error.print(157, 4, token2.getFLN(), token2.getOffset(), token5.getWord(), null, this.fileName);
                                                    break;
                                                }
                                                this.addPreProcConstant(token5, token6);
                                                break;
                                            }
                                            if (bl5) {
                                                this.removeConstant(token5);
                                                break;
                                            }
                                            this.addPreProcConstant(token5, token6);
                                            break;
                                        }
                                        this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                        break;
                                    }
                                    this.error.print(100, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if ("SET".equals(token.getWord())) {
                                n4 = tokenList.getCurrentIndex();
                                boolean bl7 = true;
                                token = tokenList.getNext();
                                if (token != null && token.getToknum() == 369 && (token = tokenList.getNext()) != null) {
                                    if (token.getToknum() == 10009) {
                                        Token token7 = token;
                                        object = null;
                                        token = tokenList.getNext();
                                        if (token != null) {
                                            if (token.getToknum() == 40) {
                                                token = tokenList.getNext();
                                                if (token != null && token.getToknum() == 10002) {
                                                    object = token;
                                                    token = tokenList.getNext();
                                                    if (token == null || token.getToknum() != 41) {
                                                        object = null;
                                                    }
                                                }
                                            } else if (token.getToknum() == 10002 || token.getToknum() == 10001) {
                                                object = token;
                                            }
                                            if (object != null) {
                                                Token token8 = this.getConstant(token7);
                                                if (token8 != null && this.compare(token8, (Token)object) != 0) {
                                                    bl7 = false;
                                                    this.error.print(157, 4, token2.getFLN(), token2.getOffset(), token7.getWord(), null, this.fileName);
                                                } else {
                                                    this.addPreProcConstant(token7, (Token)object);
                                                }
                                            } else {
                                                bl7 = false;
                                                this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                            }
                                        } else {
                                            bl7 = false;
                                            this.error.print(100, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                                        }
                                    } else {
                                        bl7 = false;
                                        this.error.print(100, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                    }
                                } else if (token != null && (token.getToknum() == 10009 || token.getToknum() == 10001)) {
                                    Token token9 = null;
                                    object = token;
                                    token = tokenList.getNext();
                                    if (token != null) {
                                        if (token.getToknum() == 40) {
                                            token = tokenList.getNext();
                                            if (token != null) {
                                                switch (token.getToknum()) {
                                                    case 480: 
                                                    case 780: 
                                                    case 10001: 
                                                    case 10002: {
                                                        token9 = token;
                                                        token = tokenList.getNext();
                                                        if (token != null && token.getToknum() == 41) break;
                                                        token9 = null;
                                                    }
                                                }
                                            }
                                        } else {
                                            switch (token.getToknum()) {
                                                case 480: 
                                                case 780: 
                                                case 10001: 
                                                case 10002: {
                                                    token9 = token;
                                                }
                                            }
                                        }
                                        if (token9 != null) {
                                            if (((Token)object).getToknum() == 10009 && ((Token)object).getWord().equals("SOURCEFORMAT")) {
                                                if (token9.getToknum() == 10001) {
                                                    String string = token9.getWord().substring(1, token9.getWord().length() - 1).toUpperCase();
                                                    if ("FIXED".equals(string)) {
                                                        this.setFormat(1);
                                                    } else if ("FREE".equals(string)) {
                                                        this.setFormat(3);
                                                    } else if ("TERMINAL".equals(string)) {
                                                        this.setFormat(2);
                                                    } else if ("VARIABLE".equals(string)) {
                                                        this.setFormat(4);
                                                    } else if ("PREVIOUS".equals(string)) {
                                                        this.resetFormat();
                                                    } else {
                                                        this.error.print(100, 4, ((Token)object).getFLN(), ((Token)object).getOffset(), null, null, this.fileName);
                                                    }
                                                } else {
                                                    this.error.print(100, 4, ((Token)object).getFLN(), ((Token)object).getOffset(), null, null, this.fileName);
                                                }
                                            } else {
                                                this.ol.setProperty((Token)object, token9, this.format);
                                            }
                                        } else {
                                            bl7 = false;
                                            this.showIgnoredDirectiveMessage(token2, tokenList, n4);
                                        }
                                    } else {
                                        bl7 = false;
                                        this.showIgnoredDirectiveMessage(token2, tokenList, n4);
                                    }
                                } else if (token != null && token.getToknum() == 596 && (token = tokenList.getNext()) != null && (token.getToknum() == 10009 || token.getToknum() == 10001)) {
                                    this.ol.setProperty(token, null, this.format);
                                } else {
                                    bl7 = false;
                                    this.showIgnoredDirectiveMessage(token2, tokenList, n4);
                                }
                                if (!bl7 || (token3 = tokenList.getNext()) == null || token3.getToknum() == 10006) break;
                                tokenList.getPrevious();
                                break;
                            }
                            this.error.print(5, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                            break;
                        }
                        this.error.print(5, 4, token3.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                        break;
                    }
                    case 474: {
                        Token token10;
                        if (n2 == 0) {
                            this.inExec = true;
                            token10 = this.getNextCrossLineToken(tokenList);
                            if (token10 != null) {
                                if (token10.getWord().equalsIgnoreCase("SQL")) {
                                    this.execSql = true;
                                    this.inExecSql = true;
                                    Token token11 = this.getNextCrossLineToken(tokenList);
                                    if (token11 != null) {
                                        if (token11.getWord().equalsIgnoreCase("INCLUDE")) {
                                            this.doInclude(tokenList, token11);
                                            this.inExecSql = false;
                                            this.inExec = false;
                                            tokenList.getLast();
                                            break;
                                        }
                                        if (token11.getWord().equalsIgnoreCase("BEGIN") || token11.getWord().equalsIgnoreCase("END")) {
                                            token11 = this.getNextCrossLineToken(tokenList);
                                            if (token11 != null) {
                                                if (token11.getWord().equalsIgnoreCase("DECLARE")) {
                                                    while ((token11 = this.getNextCrossLineToken(tokenList)) != null && token11.getToknum() != 432) {
                                                    }
                                                    this.inExecSql = false;
                                                    this.inExec = false;
                                                    tokenList.getLast();
                                                    break;
                                                }
                                                this.ungetNextCrossLineToken(tokenList);
                                                this.ungetNextCrossLineToken(tokenList);
                                                this.ungetNextCrossLineToken(tokenList);
                                                this.addElement(vector, token);
                                                ++n2;
                                                break;
                                            }
                                            this.ungetNextCrossLineToken(tokenList);
                                            this.ungetNextCrossLineToken(tokenList);
                                            this.addElement(vector, token);
                                            ++n2;
                                            break;
                                        }
                                        this.ungetNextCrossLineToken(tokenList);
                                        this.ungetNextCrossLineToken(tokenList);
                                        this.addElement(vector, token);
                                        ++n2;
                                        break;
                                    }
                                    this.ungetNextCrossLineToken(tokenList);
                                    this.addElement(vector, token);
                                    ++n2;
                                    break;
                                }
                                this.ungetNextCrossLineToken(tokenList);
                                this.addElement(vector, token);
                                ++n2;
                                break;
                            }
                            this.addElement(vector, token);
                            ++n2;
                            break;
                        }
                        this.addElement(vector, token);
                        ++n2;
                        break;
                    }
                    case 379: {
                        Token token10 = tokenList.getNext();
                        if (token10 != null) {
                            if ("RESOURCE".equals(token10.getWord())) {
                                File file = this.doCopyResource(tokenList, token10);
                                if (file == null || tokenManager == null) break;
                                tokenManager.addCopyResource(file);
                                break;
                            }
                            tokenList.getPrevious();
                            if (!this.doCopy(tokenList, token)) break;
                            while ((token = this.getNextCrossLineToken(tokenList)) != null && token.getToknum() != 10006) {
                            }
                            break;
                        }
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        break;
                    }
                    case 682: {
                        this.setReplaceList(tokenList, token);
                        break;
                    }
                    case 416: 
                    case 456: 
                    case 729: 
                    case 730: 
                    case 731: {
                        Token token10;
                        if (n2 > 0) {
                            if (this.inExec) {
                                this.addElement(vector, token);
                                break;
                            }
                            this.error.print(4, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            break;
                        }
                        while ((token10 = tokenList.getNext()) != null) {
                        }
                        break;
                    }
                    case 633: 
                    case 634: {
                        this.addElement(vector, token);
                        ++n2;
                        token = this.getPicture(tokenList, tokenList.getNext());
                        if (token != null) {
                            this.addElement(vector, token);
                            ++n2;
                            break;
                        }
                        this.picture = true;
                        break;
                    }
                    case 10005: {
                        this.addElement(vector, token);
                        n2 = 0;
                        break;
                    }
                    case 390: {
                        if (vector != null && vector.size() > 0 && ((Token)vector.elementAt(vector.size() - 1)).getToknum() == 498) {
                            vector.addElement(token);
                            break;
                        }
                    }
                    case 285: 
                    case 391: 
                    case 538: 
                    case 680: 
                    case 711: {
                        this.addElement(vector, token);
                        ++n2;
                        if (this.getFormat() == 3 || (token = this.getNextCrossLineToken(tokenList, false, false)) == null) break;
                        if (token.getToknum() == 10006) {
                            this.addElement(vector, token);
                            ++n2;
                            while ((token = this.getNextCrossLineToken(tokenList, false, false)) != null && token.getOffset() >= 4) {
                            }
                            n2 = 0;
                        }
                        token = this.ungetNextCrossLineToken(tokenList);
                        break;
                    }
                    case 316: 
                    case 652: {
                        Token token10;
                        if (!this.programStarted && n2 == 0) {
                            while ((token10 = tokenList.getNext()) != null) {
                            }
                            break;
                        }
                    }
                    case 10004: {
                        if (this.inReplace) {
                            this.ungetNextCrossLineToken(tokenList);
                            this.setReplaceList(tokenList, token);
                            break;
                        }
                    }
                    case 10006: {
                        if (this.inReplace) {
                            this.setInReplace(false);
                            break;
                        }
                    }
                    default: {
                        Object object;
                        if (vector != null) {
                            int n8 = vector.size();
                            if (n8 >= 2 && ((Token)vector.elementAt(n8 - 1)).getToknum() == 1) {
                                boolean bl8;
                                Token token12 = (Token)vector.elementAt(n8 - 2);
                                String string = token12.getWord() + token.getWord();
                                if (token12.getToknum() == 10001 && ((bl8 = token12.getWord().endsWith("\"") && token.getWord().equals("\"\"")) || token12.getWord().endsWith("'") && token.getWord().equals("''"))) {
                                    Token token13 = tokenList.getNext();
                                    object = new String(this.lineBuffer);
                                    int n9 = bl8 ? ((String)object).lastIndexOf(34) : ((String)object).lastIndexOf(39);
                                    object = ((String)object).substring(8).trim();
                                    object = ((String)object).substring(1, (bl8 ? ((String)object).lastIndexOf(34) : ((String)object).lastIndexOf(39)) + 1);
                                    token12.setWord(token12.getWord() + (String)object);
                                    boolean bl9 = false;
                                    while (token13 != null && token13.getOffset() <= n9 && token13.getFLN() == token.getFLN()) {
                                        if (token13.getOffset() + token13.getWord().length() > n9) {
                                            token = token13;
                                            object = new String(this.lineBuffer);
                                            object = ((String)object).substring(0, 72);
                                            object = ((String)object).substring((bl8 ? ((String)object).lastIndexOf(34) : ((String)object).lastIndexOf(39)) + 1);
                                            tokenList = new TokenList();
                                            this.tokenizer(tokenList, new StringBuffer("UU " + (String)object), bl);
                                            Token token14 = tokenList.getFirst();
                                            while (token14 != null) {
                                                if (token14.getToknum() == 10000) {
                                                    if (Token.reservedWords.get(token14.getWord().toUpperCase()) != null) {
                                                        token14.setToknum((Integer)Token.reservedWords.get(token14.getWord().toUpperCase()));
                                                    } else {
                                                        token14.setToknum(10009);
                                                    }
                                                }
                                                token14 = tokenList.getNext();
                                            }
                                            tokenList.getFirst();
                                            bl9 = true;
                                            break;
                                        }
                                        token13 = tokenList.getNext();
                                    }
                                    if (bl9) break;
                                    if (token13 != null) {
                                        token13 = tokenList.getPrevious();
                                    }
                                }
                                if (string.equals("PIC") || string.equals("PICTURE")) {
                                    vector.removeElementAt(n8 - 1);
                                    token12.setToknum(634);
                                    token12.setWord("PICTURE");
                                    token = this.getPicture(tokenList, tokenList.getNext());
                                    if (token != null) {
                                        this.addElement(vector, token);
                                        ++n2;
                                        break;
                                    }
                                    this.picture = true;
                                    break;
                                }
                            }
                            vector.addElement(token);
                        }
                        ++n2;
                    }
                }
            }
            token = tokenList.getNext();
        }
        if (this.inExecSql) {
            this.addElement(vector, new Token(10021, "\n", 0, 0, this.fileName));
        }
        if (vector != null && vector.size() > 0) {
            token = (Token)vector.elementAt(vector.size() - 1);
            if (token.getToknum() == 10024) {
                token.doc = "\"";
            }
            if (!this.programStarted) {
                this.programStarted = true;
            }
        }
        return 1;
    }

    private void showIgnoredDirectiveMessage(Token token, TokenList tokenList, int n2) {
        String string = "";
        Token token2 = tokenList.getAt(n2);
        if (token2 != null) {
            do {
                if (string.length() > 0) {
                    string = string + " ";
                }
                string = string + token2.getWord();
            } while ((token2 = tokenList.getNext()) != null);
        }
        this.error.print(106, 2, token.getFLN(), token.getOffset(), string, null, this.fileName);
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    void doReplace(TokenList tokenList) {
        if (this.replaceList.getFirst() == null) {
            return;
        }
        TokenList tokenList2 = new TokenList();
        Token token = tokenList.getFirstWithSep();
        while (token != null) {
            TokenList tokenList3 = null;
            Replace replace = this.replaceList.getFirst();
            while (tokenList3 == null && replace != null) {
                int n2 = replace.getMode();
                switch (n2) {
                    case 2: {
                        Token token2 = replace.getFirstFromBefore();
                        String string = token2.getWord();
                        String string2 = "";
                        if (replace.getFirstFromAfter() != null) {
                            string2 = replace.getFirstFromAfter().getWord();
                        }
                        int n3 = string.length();
                        int n4 = string2.length();
                        String string3 = token.getWord();
                        int n5 = string3.length();
                        if (!this.match(token, token2, 2)) break;
                        tokenList3 = new TokenList();
                        tokenList3.addItem(new ReplacedToken(token.getToknum(), string2 + string3.substring(n3), n4 + n5 - n3, token.getOffset(), this.fileName));
                        break;
                    }
                    case 3: {
                        Token token2 = replace.getFirstFromBefore();
                        String string = token2.getWord();
                        String string2 = "";
                        if (replace.getFirstFromAfter() != null) {
                            string2 = replace.getFirstFromAfter().getWord();
                        }
                        int n3 = string.length();
                        int n4 = string2.length();
                        String string3 = token.getWord();
                        int n5 = string3.length();
                        if (!this.match(token, token2, 3)) break;
                        tokenList3 = new TokenList();
                        tokenList3.addItem(new ReplacedToken(token.getToknum(), string3.substring(0, n5 - n3) + string2, n4 + n5 - n3, token.getOffset(), this.fileName));
                        break;
                    }
                    default: {
                        Token token2;
                        int n6 = replace.getBeforeItemNum();
                        int n7 = 0;
                        int n8 = 0;
                        Token token3 = replace.getAtFromBefore(n7);
                        TokenList tokenList4 = tokenList;
                        if (this.match(token, token3, n2)) {
                            ++n7;
                            while (n7 < n6) {
                                token3 = replace.getAtFromBefore(n7);
                                token2 = tokenList4.getNextWithSep();
                                if (token2 == null) {
                                    if (tokenList4 == tokenList) {
                                        tokenList4 = new TokenList();
                                        this.getNextCrossLineToken(tokenList4, true, true, true, true);
                                        token2 = tokenList4.getFirstWithSep();
                                    } else {
                                        token2 = this.getNextCrossLineToken(tokenList4, true, true, true, true);
                                    }
                                }
                                if (token2 == null) break;
                                if (!this.match(token2, token3, n2)) {
                                    if (token2.getToknum() == 10005 || token2.getToknum() == 10016) {
                                        --n7;
                                        ++n8;
                                    } else {
                                        if (token3.getToknum() != 10005 && token3.getToknum() != 10016) break;
                                        token2 = tokenList4.getPreviousWithSep();
                                        --n8;
                                    }
                                }
                                ++n7;
                            }
                        }
                        token2 = tokenList.getFirstWithSep();
                        if (n7 == n6) {
                            tokenList3 = new TokenList();
                            token2 = replace.getFirstFromAfter();
                            while (token2 != null) {
                                tokenList3.addItem(token2);
                                token2 = replace.getNextFromAfter();
                            }
                            if (tokenList4 != tokenList) {
                                token2 = tokenList4.getFirstWithSep();
                                while (token2 != null) {
                                    tokenList.addItem(token2);
                                    token2 = tokenList4.deleteCurrentWithSep();
                                }
                                token2 = tokenList.getFirstWithSep();
                            }
                            for (int i2 = 1 - n8; i2 < n6; ++i2) {
                                token2 = tokenList.deleteCurrentWithSep();
                            }
                            break;
                        }
                        if (tokenList4 == tokenList) break;
                        this.fillLookAhead(tokenList4, tokenList4.getFirstWithSep());
                    }
                }
                replace = this.replaceList.getNext();
            }
            if (tokenList3 == null) {
                tokenList2.addItem(token);
            } else {
                token = tokenList3.getFirstWithSep();
                while (token != null) {
                    tokenList2.addItem(token);
                    token = tokenList3.deleteCurrentWithSep();
                }
            }
            token = tokenList.deleteCurrentWithSep();
        }
        token = tokenList2.getFirstWithSep();
        while (token != null) {
            tokenList.addItem(token);
            token = tokenList2.deleteCurrentWithSep();
        }
    }

    private File doCopyResource(TokenList tokenList, Token token) {
        File file;
        String string = "";
        String string2 = "";
        Token token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return null;
        }
        Token token3 = token2;
        try {
            string = this.getStrLiteral(tokenList, token2);
            if (string == null) {
                string = token2.getOriginalWord();
            }
        }
        catch (GeneralErrorException generalErrorException) {
            return null;
        }
        token = token2;
        token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return null;
        }
        if (token2.getToknum() == 609 || token2.getToknum() == 526) {
            token = token2;
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return null;
            }
            string2 = token2.getToknum() == 10001 ? token2.getWord().substring(1, token2.getWord().length() - 1) : token2.getWord();
            token = token2;
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return null;
            }
        }
        if (string2.length() > 0) {
            string2 = string2 + File.separator;
        }
        if ((file = this.getFileFinder().findFile(string2 + string)) == null) {
            this.error.print(285, 3, token3.getFLN(), token3.getOffset(), null, null, this.fileName);
        }
        return file;
    }

    private Token checkReplVarName(Token token, ReplaceAddTo replaceAddTo, TokenList tokenList, Token token2) {
        replaceAddTo.add(new Token(token));
        if (token.getToknum() == 10014) {
            while (token.getToknum() == 10014) {
                token = this.getNextCrossLineToken(tokenList);
                if (token == null) {
                    this.error.print(6, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                    return null;
                }
                if (token.getToknum() != 10014 && token.getToknum() != 10001) {
                    this.error.print(8, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                    return null;
                }
                replaceAddTo.add(new Token(token));
            }
            token = this.getNextCrossLineToken(tokenList);
            if (token == null) {
                this.error.print(6, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                return null;
            }
        } else {
            while ((token = this.getNextCrossLineToken(tokenList)) != null) {
                if (token.getToknum() == 526 || token.getToknum() == 609) {
                    replaceAddTo.add(new Token(token));
                    token = this.getNextCrossLineToken(tokenList);
                    if (token == null) {
                        this.error.print(6, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return null;
                    }
                    if (!token.isWord()) {
                        this.error.print(8, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                        return null;
                    }
                    replaceAddTo.add(new Token(token));
                    continue;
                }
                if (token.getToknum() != 40) break;
                int n2 = 1;
                replaceAddTo.add(new Token(token));
                while ((token = this.getNextCrossLineToken(tokenList)) != null && n2 > 0) {
                    if (token.getToknum() == 41) {
                        --n2;
                    } else if (token.getToknum() == 40) {
                        ++n2;
                    } else if (!token.isWord() && token.getToknum() != 10002 && token.getToknum() != 43 && token.getToknum() != 45 && token.getToknum() != 58) {
                        this.error.print(8, 4, token.getFLN(), token.getOffset(), token.getWord(), null, this.fileName);
                        return null;
                    }
                    replaceAddTo.add(new Token(token));
                }
                break block1;
            }
        }
        if (token == null) {
            this.error.print(6, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
            return null;
        }
        return token;
    }

    private String getStrLiteral(TokenList tokenList, Token token) throws GeneralErrorException {
        String string = null;
        Token token2 = token;
        if (token.getToknum() == 10001) {
            string = token.getWord().substring(1, token.getWord().length() - 1);
        } else if (token.getToknum() == 10014) {
            string = token.getWord().substring(1, token.getWord().length() - 2);
            do {
                if ((token = this.getNextCrossLineToken(tokenList)) == null) {
                    throw new GeneralErrorException(1, 4, token2, "", this.error);
                }
                if (token.getToknum() == 10001) {
                    string = string + token.getWord().substring(1, token.getWord().length() - 1);
                    continue;
                }
                if (token.getToknum() == 10014) {
                    string = string + token.getWord().substring(1, token.getWord().length() - 2);
                    continue;
                }
                throw new GeneralErrorException(1, 4, token2, "", this.error);
            } while (token.getToknum() != 10001);
        } else if (token.getToknum() == 10024) {
            string = token.getWord().substring(1, token.getWord().length());
            do {
                if ((token = this.getNextCrossLineToken(tokenList)) == null || token.getToknum() != 1) {
                    throw new GeneralErrorException(1, 4, token2, "", this.error);
                }
                token = this.getNextCrossLineToken(tokenList);
                if (token == null) {
                    throw new GeneralErrorException(1, 4, token2, "", this.error);
                }
                if (token.getToknum() == 10001) {
                    string = string + token.getWord().substring(1, token.getWord().length() - 1);
                    continue;
                }
                if (token.getToknum() == 10024) {
                    string = string + token.getWord().substring(1, token.getWord().length());
                    continue;
                }
                throw new GeneralErrorException(1, 4, token2, "", this.error);
            } while (token.getToknum() != 10001);
        }
        return string;
    }

    protected boolean doCopy(TokenList tokenList, Token token) {
        String string;
        int n2;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        ReplaceList replaceList = new ReplaceList(this.replaceList);
        boolean bl2 = false;
        String string4 = null;
        Token token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return true;
        }
        Token token3 = token2;
        try {
            string2 = this.getStrLiteral(tokenList, token2);
            if (string2 == null) {
                if (token2.getToknum() == 10009) {
                    bl2 = true;
                }
                string2 = token2.getOriginalWord();
            }
        }
        catch (GeneralErrorException generalErrorException) {
            return true;
        }
        token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return true;
        }
        if (token2.getToknum() == 10006 && bl2) {
            int n3 = token2.getOffset() + 1;
            token2 = tokenList.getNext();
            if (token2 != null) {
                if (token2.getToknum() == 10009 && n3 == token2.getOffset()) {
                    string2 = string2 + '.' + token2.getOriginalWord();
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 == null) {
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return true;
                    }
                } else {
                    token2 = tokenList.getPrevious();
                }
            } else {
                token2 = tokenList.getLast();
            }
        }
        if (token2.getToknum() == 1) {
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
            if (token2.getToknum() != 10009) {
                this.error.print(8, 4, token3.getFLN(), token3.getOffset(), token2.getWord(), null, this.fileName);
                return true;
            }
            string2 = string2 + token2.getWord();
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
        }
        if (token2.getToknum() == 609 || token2.getToknum() == 526) {
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
            string3 = token2.getToknum() == 10001 ? token2.getWord().substring(1, token2.getWord().length() - 1) : token2.getOriginalWord();
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
        }
        if (token2.getToknum() == 748) {
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
            if (token2.getToknum() == 647 && (token2 = this.getNextCrossLineToken(tokenList)) == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
            bl = true;
        }
        if (token2.getToknum() != 683 && token2.getToknum() != 10006) {
            Token token4 = this.ungetNextCrossLineToken(tokenList);
            if (token4.getFLN() != token2.getFLN()) {
                this.error.print(188, 3, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                token2 = new Token(10006, ".", 0, 0, ".");
            } else {
                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                return true;
            }
        }
        if (token2.getToknum() == 683) {
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return true;
            }
            if (token2.getToknum() == 10006) {
                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                return true;
            }
            if (replaceList.hasReplacing()) {
                this.error.print(223, 2, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
            }
            int n4 = tokenList.getCurrentIndex();
            block7: do {
                Replace replace = new Replace(true);
                switch (token2.getToknum()) {
                    case 379: {
                        this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                        return true;
                    }
                    case 10004: {
                        token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                        if (token2 == null) {
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (token2.getToknum() == 10004) {
                            this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                            return true;
                        }
                        do {
                            replace.addToBefore(new Token(token2));
                            token2 = this.getNextCrossLineToken(tokenList, true, false, true);
                            if (token2 != null) continue;
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        } while (token2.getToknum() != 10004);
                        replace.endBefore();
                        token2 = this.getNextCrossLineToken(tokenList);
                        if (token2 != null) break;
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    case 556: 
                    case 776: {
                        Token token5 = token2;
                        token2 = this.getNextCrossLineToken(tokenList);
                        if (token2 == null) {
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (token2.getToknum() == 312) {
                            replace.addToBefore(new Token(token5));
                            break;
                        }
                        if (token5.getToknum() == 556) {
                            replace.setMode(2);
                        } else {
                            replace.setMode(3);
                        }
                        if (token2.getToknum() == 10004) {
                            token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                            if (token2 == null) {
                                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (token2.getToknum() == 10004) {
                                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                return true;
                            }
                            if (token2.getToknum() == 10001 || token2.getToknum() == 10014) {
                                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                return true;
                            }
                            replace.addToBefore(new Token(token2));
                            token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                            if (token2 == null) {
                                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (token2.getToknum() != 10004) {
                                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                return true;
                            }
                        } else if (token2.getToknum() == 10001) {
                            token2.setWord(token2.getWord().substring(1, token2.getWord().length() - 1));
                            token2.setToknum(10009);
                            replace.addToBefore(new Token(token2));
                        } else {
                            this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                            return true;
                        }
                        if ((token2 = this.getNextCrossLineToken(tokenList)) == null) {
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (token2.getToknum() != 312) {
                            this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                            return true;
                        }
                        token2 = this.getNextCrossLineToken(tokenList);
                        if (token2 == null) {
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (token2.getToknum() == 10004) {
                            token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                            if (token2 == null) {
                                this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (token2.getToknum() == 10001 || token2.getToknum() == 10014) {
                                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                return true;
                            }
                            if (token2.getToknum() != 10004) {
                                replace.addToAfter(new Token(token2));
                                token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                                if (token2 == null) {
                                    this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                                    return true;
                                }
                            }
                            if (token2.getToknum() != 10004) {
                                this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                                return true;
                            }
                        } else if (token2.getToknum() == 10001) {
                            token2.setWord(token2.getWord().substring(1, token2.getWord().length() - 1));
                            token2.setToknum(10009);
                            replace.addToAfter(new Token(token2));
                        } else {
                            this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                            return true;
                        }
                        if ((token2 = this.getNextCrossLineToken(tokenList)) == null) {
                            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        replaceList.addItem(replace);
                        continue block7;
                    }
                    default: {
                        token2 = this.checkReplVarName(token2, new ReplaceAddToBefore(replace), tokenList, token);
                        if (token2 != null) break;
                        return true;
                    }
                }
                if (token2.getToknum() != 312) {
                    this.error.print(8, 4, token2.getFLN(), token2.getOffset(), token2.getWord(), null, this.fileName);
                    return true;
                }
                token2 = this.getNextCrossLineToken(tokenList);
                if (token2 == null) {
                    this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                    return true;
                }
                if (token2.getToknum() == 10004) {
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    while (token2.getToknum() != 10004) {
                        replace.addToAfter(new Token(token2));
                        token2 = this.getNextCrossLineToken(tokenList, true, false, true);
                        if (token2 != null) continue;
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    replace.endAfter();
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 == null) {
                        this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return true;
                    }
                } else if ((token2 = this.checkReplVarName(token2, new ReplaceAddToAfter(replace), tokenList, token)) == null) {
                    return true;
                }
                replaceList.addItem(replace);
            } while (token2.getToknum() != 10006);
            n2 = tokenList.getCurrentIndex();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = n4; i2 <= n2; ++i2) {
                stringBuffer.append(((Token)tokenList.getAtObject(i2)).getCode());
            }
            string4 = stringBuffer.toString();
            string4 = string4.substring(0, string4.lastIndexOf(46)).trim();
        } else if (token2.getToknum() != 10006) {
            this.error.print(6, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
        }
        if (!(token2.getFLN() == 0 || (token2 = tokenList.getNext()) == null || token2.getToknum() == 10005 || this.debugListing > 0 && (this.getFormat() == 1 && token2.getOffset() >= 72 || this.getFormat() == 4 && token2.getOffset() >= 250))) {
            this.fillLookAhead(tokenList, token2);
        }
        if (string3.length() > 0) {
            string3 = string3 + File.separator;
        }
        if ((n2 = this.readCopy(token, string = this.expandName(string3 + string2), bl, replaceList)) != 0 && bl2) {
            string = this.expandName(string3 + string2.toUpperCase(Locale.US));
            n2 = this.readCopy(token, string, bl, replaceList);
        }
        if (this.copy != null) {
            this.copy.replacingString = string4;
            if (string4 != null) {
                this.copy.replacingStringHex = Integer.toHexString(string4.hashCode());
            }
        }
        if (n2 != 0) {
            this.error.print(n2, 4, token3.getFLN(), token3.getOffset(), string, null, this.fileName);
        }
        this.restoreLst(n2);
        return false;
    }

    private String expandName(String string) {
        String string2;
        if (this.ol.getOption("-sevc") == null) {
            string2 = string;
        } else {
            String string3 = "\\".equals(File.separator) ? "\\/" : File.separator;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.charAt(0) == '$') {
                    String string5 = "." + string4.substring(1).toLowerCase();
                    stringBuffer.append(Config.a(string5, string4));
                    continue;
                }
                stringBuffer.append(string4);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private Token getNextCrossLineToken(TokenList tokenList) {
        return this.getNextCrossLineToken(tokenList, false, false, false);
    }

    private Token getNextCrossLineToken(TokenList tokenList, boolean bl) {
        return this.getNextCrossLineToken(tokenList, bl, false, false);
    }

    private Token getNextCrossLineToken(TokenList tokenList, boolean bl, boolean bl2) {
        return this.getNextCrossLineToken(tokenList, bl, bl2, false);
    }

    private Token getNextCrossLineToken(TokenList tokenList, boolean bl, boolean bl2, boolean bl3) {
        return this.getNextCrossLineToken(tokenList, bl, bl2, bl3, false);
    }

    private Token getNextCrossLineToken(TokenList tokenList, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Token token;
        StringBuffer stringBuffer = new StringBuffer();
        while ((token = tokenList.getNext(bl)) == null || token.getToknum() == 44 && !bl3 || token.getToknum() == 10005 && !bl4) {
            if (token != null) continue;
            stringBuffer.setLength(0);
            TokenList tokenList2 = this.getTokenizedLine(stringBuffer, -1, bl2, false);
            if (tokenList2 == null) {
                return null;
            }
            int n2 = tokenList2.getItemNum();
            token = tokenList2.getFirstWithSep();
            while (token != null) {
                tokenList.addItem(token);
                token = tokenList2.deleteCurrentWithSep();
            }
            while (n2-- > 0) {
                tokenList.getPreviousWithSep();
            }
        }
        return token;
    }

    private Token ungetNextCrossLineToken(TokenList tokenList) {
        Token token;
        while ((token = tokenList.getPrevious()) != null && token.getToknum() == 10005) {
        }
        return token;
    }

    private void doInclude(TokenList tokenList, Token token) {
        String string = "";
        ReplaceList replaceList = new ReplaceList(this.replaceList);
        Token token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return;
        }
        string = token2.getToknum() == 10001 ? token2.getWord().substring(1, token2.getWord().length() - 1) : token2.getOriginalWord().toUpperCase();
        token = token2;
        token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null || token2.getToknum() != 432) {
            this.error.print(6, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return;
        }
        int n2 = this.readCopy(token, string, false, replaceList);
        if (n2 != 0) {
            this.error.print(n2, 4, token2.getFLN(), token2.getOffset(), string, null, this.fileName);
        }
    }

    protected int readCopy(Token token, String string, boolean bl, ReplaceList replaceList) {
        Object object;
        Object object2;
        if (this.ol.getOption("-scnl") != null) {
            string = string.toLowerCase();
        } else if (this.ol.getOption("-scnu") != null) {
            string = string.toUpperCase();
        }
        Hashtable hashtable = this.includeCopyBooks;
        if (hashtable == null) {
            hashtable = this.getReaderProvider().getIncludeCopyBooks();
        }
        if (hashtable != null && (object2 = (CopyBookDesc)hashtable.get(object = new CopyBookDesc(new File(string).getName(), new File(this.getOrigFilename()).getName(), this.getLineCount()))) == null) {
            String string2 = this.ol.getOption("-ce=");
            if (string2 != null) {
                String string3 = ((CopyBookDesc)object).getName();
                for (String string4 : RtsUtil.getPathIterable(string2)) {
                    ((CopyBookDesc)object).setName(string3 + "." + string4);
                    object2 = (CopyBookDesc)hashtable.get(object);
                    if (object2 == null) continue;
                    string = string + "." + string4;
                    break;
                }
            }
            if (object2 == null) {
                return 0;
            }
        }
        if (this.copy != null) {
            return this.copy.readCopy(token, string, bl, replaceList);
        }
        if (this.getFileFinder() instanceof OptionedFileFinder) {
            ((OptionedFileFinder)this.getFileFinder()).setOptionList(this.ol);
        }
        if ((object = this.getFileFinder().findFile(string)) != null) {
            object2 = bl && !this.isDebugListing() && this.ol.getOption("-po") == null ? null : this.lst;
            this.copy = this.createCopyPreProcessor(this, (File)object, (Writer)object2, this.format, replaceList, this.error, this.ol, this.decimalPoint);
            this.copy.setInReplace(this.inReplace);
            if (this.lstSave != null) {
                this.copy.lst = this.lstSave;
            }
            this.copy.origFilename = string;
            this.copy.setFileFinder(this.getFileFinder());
            this.copy.setReaderProvider(this.getReaderProvider());
            if (!this.copy.open()) {
                return 3;
            }
            if (!this.children.contains(this.copy)) {
                this.children.add(this.copy);
            }
        } else {
            return 3;
        }
        return 0;
    }

    private boolean open() {
        return this.open(this.fileName);
    }

    protected boolean open(String string) {
        boolean bl = false;
        Reader reader = this.getReaderProvider().getReader(string);
        if (reader != null) {
            if (reader instanceof EmbeddedCopyReader) {
                this.writeListing("vvv-> the following lines have been generated without being read from a file", 0);
            }
            if (this.ppChain != null) {
                reader = this.ppChain.init(reader);
            }
            this.src = new LineNumberReader(reader);
            bl = true;
        }
        return bl;
    }

    void setReplaceList(TokenList tokenList, Token token) {
        Replace replace;
        ReplaceList replaceList = new ReplaceList();
        boolean bl = token.getToknum() != 682;
        Token token2 = this.getNextCrossLineToken(tokenList);
        if (token2 == null) {
            if (this.debugListing == 2) {
                throw new DebugListingException(7);
            }
            this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return;
        }
        if (token2.getToknum() == 554 || token2.getToknum() == 610) {
            boolean bl2 = token2.getToknum() == 554;
            token = token2;
            if (bl2 && (token2 = this.getNextCrossLineToken(tokenList)) == null) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(7);
                }
                this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return;
            }
            if (token2.getToknum() != 610) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(9);
                }
                this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                return;
            }
            token = token2;
            token2 = this.getNextCrossLineToken(tokenList);
            if (token2 == null) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(7);
                }
                this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                return;
            }
            if (token2.getToknum() != 10006) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(9);
                }
                this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                return;
            }
            if (bl2) {
                this.replaceLastOff();
            } else {
                this.replaceOff();
            }
            token2 = tokenList.getNext();
            if (token2 != null && token2.getToknum() != 10005) {
                this.fillLookAhead(tokenList, token2);
            }
            return;
        }
        boolean bl3 = token2.getToknum() == 271;
        token = token2;
        if (bl3 && (token2 = this.getNextCrossLineToken(tokenList)) == null) {
            if (this.debugListing == 2) {
                throw new DebugListingException(7);
            }
            this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
            return;
        }
        if (token2.getToknum() == 10006) {
            if (this.debugListing == 2) {
                throw new DebugListingException(9);
            }
            this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
            return;
        }
        block4: do {
            replace = new Replace(bl);
            if (token2.getToknum() == 379) {
                this.setInReplace(true);
                this.setReplaceList(replace, replaceList, bl3);
                this.ungetNextCrossLineToken(tokenList);
                return;
            }
            switch (token2.getToknum()) {
                case 10004: {
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() == 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    do {
                        replace.addToBefore(new Token(token2));
                        token = token2;
                        token2 = this.getNextCrossLineToken(tokenList, true, false, true);
                        if (token2 != null) continue;
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    } while (token2.getToknum() != 10004);
                    replace.endBefore();
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, false);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 312) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    while (token2.getToknum() != 10004) {
                        replace.addToAfter(new Token(token2));
                        token = token2;
                        token2 = this.getNextCrossLineToken(tokenList, true, false, true);
                        if (token2 != null) continue;
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    replace.endAfter();
                    replaceList.addItem(replace);
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 != null || this.inReplace) continue block4;
                    if (this.debugListing == 2) {
                        throw new DebugListingException(7);
                    }
                    this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                    return;
                }
                case 556: 
                case 776: {
                    if (token2.getToknum() == 556) {
                        replace.setMode(2);
                    } else {
                        replace.setMode(3);
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() == 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() == 10001 || token2.getToknum() == 10014) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    replace.addToBefore(new Token(token2));
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 312) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() == 10001 || token2.getToknum() == 10014) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (token2.getToknum() != 10004) {
                        replace.addToAfter(new Token(token2));
                        token = token2;
                        token2 = this.getNextCrossLineToken(tokenList);
                        if (token2 == null) {
                            if (this.debugListing == 2) {
                                throw new DebugListingException(7);
                            }
                            this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                            return;
                        }
                    }
                    if (token2.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                        return;
                    }
                    token = token2;
                    token2 = this.getNextCrossLineToken(tokenList, false, false, true);
                    if (token2 == null && !this.inReplace) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, token.getFLN(), token.getOffset(), null, null, this.fileName);
                        return;
                    }
                    replaceList.addItem(replace);
                    break;
                }
                default: {
                    if (this.debugListing == 2) {
                        throw new DebugListingException(9);
                    }
                    this.error.print(9, 4, token2.getFLN(), token2.getOffset(), null, null, this.fileName);
                    return;
                }
            }
        } while (token2 != null && token2.getToknum() != 10006);
        this.setReplaceList(replace, replaceList, bl3);
        if (token2 != null) {
            this.setInReplace(false);
        }
        if (token2 != null && (token2 = tokenList.getNext()) != null && token2.getToknum() != 10005) {
            this.fillLookAhead(tokenList, token2);
        }
    }

    private void addReplace(Replace replace) {
        this.replaceList.addItem(replace);
        if (this.parent != null) {
            this.parent.addReplace(replace);
        }
    }

    void setReplaceList(Replace replace, ReplaceList replaceList, boolean bl) {
        if (this.parent != null) {
            if (replace.isReplacing && !this.inReplace) {
                this.parent.addReplace(replace);
            } else {
                this.parent.setReplaceList(replace, new ReplaceList(replaceList), bl);
            }
        }
        if (!bl && !this.inReplace) {
            this.resetReplace();
        }
        int n2 = this.getNextReplProgr();
        Replace replace2 = replaceList.getFirst();
        while (replace2 != null) {
            replace2.setProgr(n2);
            this.replaceList.addItem(replace2);
            replace2 = replaceList.deleteCurrent();
        }
    }

    void replaceOff() {
        if (this.parent != null) {
            this.parent.replaceOff();
        } else {
            this.resetReplace();
        }
    }

    int getNextReplProgr() {
        Replace replace = this.replaceList.getLast();
        if (replace == null) {
            return 0;
        }
        return replace.getProgr() + 1;
    }

    void resetReplace() {
        Replace replace = this.replaceList.getFirst();
        while (replace != null) {
            replace = this.replaceList.deleteCurrent();
        }
    }

    void replaceLastOff() {
        if (this.parent != null) {
            this.parent.replaceLastOff();
            return;
        }
        Replace replace = this.replaceList.getLast();
        if (replace == null) {
            return;
        }
        int n2 = replace.getProgr();
        do {
            this.replaceList.deleteCurrent();
        } while ((replace = this.replaceList.getLast()) != null && replace.getProgr() == n2);
    }

    boolean match(Token token, Token token2, int n2) {
        String string;
        String string2;
        if (token instanceof ReplacedToken) {
            return false;
        }
        if (token.getToknum() == 10016 && token2.getToknum() == 10016) {
            return true;
        }
        if (token.getToknum() == 10001 && token2.getToknum() == 10001) {
            string2 = token.getWord().substring(1, token.getWord().length() - 1);
            string = token2.getWord().substring(1, token2.getWord().length() - 1);
        } else {
            string2 = token.getWord().toUpperCase().replace(Pcc.hyphenRepl, '-').trim();
            string = token2.getWord().toUpperCase().replace(Pcc.hyphenRepl, '-').trim();
        }
        if (string2.length() < string.length() || n2 == 1 && string2.length() > string.length()) {
            return false;
        }
        switch (n2) {
            case 2: {
                return string2.startsWith(string);
            }
            case 3: {
                return string2.endsWith(string);
            }
        }
        return string2.equalsIgnoreCase(string);
    }

    int getLineNumber() {
        if (this.src != null) {
            return this.lineCount;
        }
        return 0;
    }

    public String getOrigFilename() {
        return this.origFilename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public PreProcessor getParent() {
        return this.parent;
    }

    public void setDecimalPointIsComma(boolean bl) {
        this.decimalPoint = bl ? (char)44 : (char)46;
    }

    public String decimalPointIsComma() {
        if (this.ol.getOption("-sddp") != null) {
            return "$isDPC$";
        }
        return this.decimalPoint == ',' ? "true" : "false";
    }

    void setEnvValue(String string) {
        this.envValue = string;
    }

    void setEnvName(String string) {
        this.envName = string;
    }

    String getEnvValue() {
        return this.envValue;
    }

    String getEnvName() {
        return this.envName;
    }

    boolean getExecSql() {
        return this.execSql;
    }

    boolean getInExecSql() {
        return this.inExecSql;
    }

    boolean getInReplace() {
        return this.inReplace;
    }

    void setInReplace(boolean bl) {
        if (this.parent != null) {
            this.parent.setInReplace(bl);
        }
        this.inReplace = bl;
    }

    char getDecimalPoint() {
        return this.decimalPoint;
    }

    boolean isPropagate() {
        return this.propagate;
    }

    Object[] lastCondToken() {
        if (this.skipping.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = ((Branch)this.skipping.peek()).directive;
        if (this.skipping.size() > 1 || ((Branch)this.skipping.peek()).skip) {
            objectArray[1] = new Boolean(true);
        }
        return objectArray;
    }

    public static File findFile(String string, OptionList optionList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = optionList.getOption("-sp=");
        String string3 = optionList.getOption("-ce=");
        arrayList.add("");
        if (string2 != null) {
            for (String string4 : RtsUtil.getPathIterable(string2)) {
                if (string4.endsWith(File.separator)) {
                    arrayList.add(string4);
                    continue;
                }
                arrayList.add(string4 + File.separator);
            }
        }
        arrayList2.add("");
        if (string3 != null) {
            for (String string4 : RtsUtil.getPathIterable(string3)) {
                arrayList2.add("." + string4);
            }
        }
        int n2 = arrayList.size();
        int n3 = arrayList2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                File file = new File((String)arrayList.get(i2) + string + (String)arrayList2.get(i3));
                if (!file.canRead() || !file.isFile()) continue;
                return file;
            }
        }
        return null;
    }

    final void writeDataMap(String[] stringArray, DataDivision[] dataDivisionArray) {
        String string;
        String string2;
        if (dataDivisionArray.length == 0) {
            return;
        }
        if (this.ol.getOption("-la") != null) {
            string = string2 = "      *";
        } else {
            string2 = "*>     ";
            string = "*>-----";
        }
        try {
            this.lst.write(string + "--------------------------------------------------------------------------------------------------------------" + eol);
            this.lst.write(string2 + eol);
            this.lst.write(string2 + "LEGEND" + eol);
            this.lst.write(string2 + "          Loc(Location) FD = File Section                 Type Flags: column G/E  ---> G = Group" + eol);
            this.lst.write(string2 + "                        WS = Working-Storage Section                                   E = Elementary" + eol);
            this.lst.write(string2 + "                        LC = Local-Storage Section                    column O    ---> O = Occurs Item" + eol);
            this.lst.write(string2 + "                        TL = Thread-Local-Storage Section             column B/C  ---> B = Boolean  (88 level)" + eol);
            this.lst.write(string2 + "                        RD = Report Section                                            C = Constant (78 level)" + eol);
            this.lst.write(string2 + "                        LS = Linkage Section                          column R    ---> R = Redefines" + eol);
            this.lst.write(string2 + "                        SS = Screen Section                           column E    ---> E = External" + eol);
            this.lst.write(string2 + eol);
            this.lst.write(string2 + "                                               Reference Flags:       P = Parent item referenced" + eol);
            this.lst.write(string2 + "                                                                      C = Child item referenced" + eol);
            this.lst.write(string2 + "                                                                      R = Referenced" + eol);
            this.lst.write(string2 + "          Only for Loc=SS : " + eol);
            this.lst.write(string2 + "                       Offset in Location  LINES attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(string2 + "                                                                                  <Number>" + eol);
            this.lst.write(string2 + "                                                                                  'Express.' if Expression" + eol);
            this.lst.write(string2 + "                       Physical Length     SIZE  attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(string2 + "                                                                                  <Number>" + eol);
            this.lst.write(string2 + "                                                                                  'Express.' if Expression" + eol);
            this.lst.write(string2 + "                       Data Type           TITLE attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(string2 + "                                                                                  <String>" + eol);
            this.lst.write(string2 + "                                                                                  'No Title'" + eol);
            this.lst.write(string2 + eol);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] != null) {
                    this.lst.write(string + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                    this.lst.write(string2 + " " + stringArray[i2] + eol);
                }
                this.lst.write(string + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                this.lst.write(string2 + "Line      Name                                                    Offset    Physical Loc Type       Data Type Reference" + eol);
                this.lst.write(string2 + "Source                                                            in        Length       Flags                Flags" + eol);
                this.lst.write(string2 + "                                                                  Location               G O B R E" + eol);
                this.lst.write(string2 + "                                                                                         E   C" + eol);
                this.lst.write(string + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                if (dataDivisionArray[i2] == null) continue;
                this.lst.write(dataDivisionArray[i2].getDataMap(eol, string2).toString());
                this.lst.write(string + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                this.lst.write(dataDivisionArray[i2].getDataSize(eol, string2).toString());
                this.lst.write(string + "-----------------------------------------------------------------------------------------------------------------------" + eol);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static byte[] getDefFileContents(String string) {
        DefFile defFile = defFiles.get(string);
        if (defFile != null) {
            byte[] byArray = new byte[defFile.contents.length];
            System.arraycopy(defFile.contents, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    static /* synthetic */ OptionList access$300(PreProcessor preProcessor) {
        return preProcessor.ol;
    }

    static {
        String string;
        Serializable serializable;
        cvCobolReservedWords = new String[]{"CBL", "CURRENT-DATE", "TIME-OF-DAY", "EJECT", "ENTER", "EXAMINE", "EXHIBIT", "NOTE", "PROCESS", "READY", "RECORDING", "SERVICE", "SKIP1", "SKIP2", "SKIP3", "TRANSFORM", "WHEN-COMPILED"};
        cmCobolReservedWords = new String[]{"EQUALS", "EXCEEDS", "UNEQUAL"};
        cmsCobolReservedWords = new String[]{"COMP-0", "COMPUTATIONAL-0"};
        TASK_PATTERN = Pattern.compile("\\b(fixme|todo)\\b");
        defFiles = new HashMap<String, DefFile>();
        defFiles.put("fonts.def", new DefFile("fonts.def"));
        defFiles.put("iscoblib.def", new DefFile("iscoblib.def"));
        defFiles.put("iscobol.def", new DefFile("iscobol.def"));
        defFiles.put("iscontrols.def", new DefFile("iscontrols.def"));
        defFiles.put("iscrt.def", new DefFile("iscrt.def"));
        defFiles.put("isfilesys.def", new DefFile("isfilesys.def"));
        defFiles.put("isfonts.def", new DefFile("isfonts.def"));
        defFiles.put("isgui.def", new DefFile("isgui.def"));
        defFiles.put("iskeisen.def", new DefFile("iskeisen.def"));
        defFiles.put("isopensave.def", new DefFile("isopensave.def"));
        defFiles.put("ispalette.def", new DefFile("ispalette.def"));
        defFiles.put("isparseefd.def", new DefFile("isparseefd.def"));
        defFiles.put("isprint.def", new DefFile("isprint.def"));
        defFiles.put("isreg.def", new DefFile("isreg.def"));
        defFiles.put("isresize.def", new DefFile("isresize.def"));
        defFiles.put("issocket.def", new DefFile("issocket.def"));
        defFiles.put("iswinhelp.def", new DefFile("iswinhelp.def"));
        defFiles.put("iswinvers.def", new DefFile("iswinvers.def"));
        defFiles.put("sqlca", new DefFile("SQLCA"));
        defFiles.put("stdfonts.def", new DefFile("stdfonts.def"));
        try {
            serializable = new File(DefaultReaderProvider.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            string = ((File)serializable).getName().equals("iscobol.jar") ? ((File)serializable).getParentFile().getParentFile() + File.separator + "sample" + File.separator + "isdef" : null;
        }
        catch (Throwable throwable) {
            string = null;
        }
        copyLocation = string;
        serializable = new HashSet();
        serializable.add("doc");
        serializable.add("efd");
        serializable.add("elk");
        serializable.add("end-doc");
        serializable.add("sql");
        serializable.add("xfd");
        EXTRA_INFO_KEYWORDS = Collections.unmodifiableSet(serializable);
    }

    private class ReplaceAddToAfter
    extends ReplaceAddTo {
        private Token space;

        ReplaceAddToAfter(Replace replace) {
            super(replace);
        }

        @Override
        void add(Token token) {
            if (this.space != null) {
                this.replace.addToAfter(this.space);
            } else {
                this.space = new Token(token);
                this.space.setToknum(10016);
                this.space.setWord(" ");
            }
            this.replace.addToAfter(token);
        }
    }

    private class ReplaceAddToBefore
    extends ReplaceAddTo {
        ReplaceAddToBefore(Replace replace) {
            super(replace);
        }

        @Override
        void add(Token token) {
            this.replace.addToBefore(token);
        }
    }

    private abstract class ReplaceAddTo {
        final Replace replace;

        ReplaceAddTo(Replace replace) {
            this.replace = replace;
        }

        abstract void add(Token var1);
    }

    private static class Branch {
        Token directive;
        boolean skip;
        Token eval;

        Branch(Token token, boolean bl) {
            this.directive = token;
            this.skip = bl;
        }

        Branch(Token token, Token token2) {
            this.directive = token;
            this.eval = token2;
        }

        public String toString() {
            if (this.eval == null) {
                return ">>IF   line " + this.directive.getFLN();
            }
            return ">>WHEN line " + this.directive.getFLN() + ", cond=" + this.eval;
        }
    }

    private static class DefaultReaderProvider
    implements PreProcessorReaderProvider {
        private DefaultReaderProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader getReader(String string) {
            try {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(string), System.getProperty("file.encoding"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new FileReader(string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DefFile defFile = (DefFile)defFiles.get(string);
                if (defFile != null && copyLocation != null) {
                    if (defFile.contents == null) {
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(copyLocation + File.separator + defFile.name);
                            defFile.contents = new byte[fileInputStream.available()];
                            fileInputStream.read(defFile.contents);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (defFile.contents != null) {
                        return new EmbeddedCopyReader(defFile.contents);
                    }
                }
                return null;
            }
        }

        @Override
        public Hashtable getIncludeCopyBooks() {
            return null;
        }
    }

    private static class EmbeddedCopyReader
    extends InputStreamReader {
        EmbeddedCopyReader(byte[] byArray) {
            super(new ByteArrayInputStream(byArray));
        }
    }

    private class DefaultFileFinder
    implements OptionedFileFinder {
        Map cache = new HashMap();
        OptionList optL = PreProcessor.access$300(PreProcessor.this);

        private DefaultFileFinder() {
        }

        @Override
        public File findFile(String string) {
            if (this.cache.containsKey(string)) {
                return (File)this.cache.get(string);
            }
            File file = PreProcessor.findFile(string, this.optL);
            if (file == null) {
                File file2 = new File(string);
                if (defFiles.containsKey(file2.getName().toLowerCase()) && copyLocation != null) {
                    file = new File(file2.getName().toLowerCase());
                }
            }
            if (file != null) {
                this.cache.put(string, file);
            }
            return file;
        }

        @Override
        public void clearCache() {
            this.cache.clear();
        }

        @Override
        public void setOptionList(Object object) {
            this.optL = (OptionList)object;
        }
    }

    private static class DefFile {
        final String name;
        byte[] contents;

        DefFile(String string) {
            this.name = string;
        }
    }

    private class DebugListingException
    extends RuntimeException {
        final int errNo;

        DebugListingException(int n2) {
            this.errNo = n2;
        }
    }

    private static class LineBuffer {
        static final int LOOK_AHEAD = 0;
        static final int REPL_FIRST_LINE = 1;
        static final int REPL_NEXT_LINE = 2;
        final StringBuffer buf = new StringBuffer();
        int type;

        LineBuffer(int n2) {
            this.type = n2;
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    private static class LineLen {
        int length;
        int replDiff;
        int type = -1;

        private LineLen() {
        }

        LineLen init(int n2) {
            this.length = -1;
            this.replDiff = n2;
            this.type = -1;
            return this;
        }
    }
}

