/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.DuplicateParagraph;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MethodProcedure;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.ParagraphList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.SectionList;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.Stop;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IProcedureDivision;
import com.iscobol.rts.Config;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class ProcedureDivision
implements CobolToken,
ErrorsNumbers,
IProcedureDivision {
    TokenManager tm;
    Errors error;
    Pcc parent;
    private HashSet byValueVars = new HashSet();
    VariableNameList using = new VariableNameList();
    VariableDeclaration usingVarargs;
    VariableNameList chaining = new VariableNameList();
    ParagraphList pList = new ParagraphList();
    ParagraphList dList = new ParagraphList();
    SectionList sList = new SectionList();
    SectionList dsList = new SectionList();
    VariableName returning;
    VariableNameList raising;
    private Token firstToken;
    private int fileNumber;
    private Token startDeclaratives;
    private Token endDeclaratives;
    private Token elkToken;
    private String serviceBridgeOperation = null;

    public ProcedureDivision(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProcedureDivision(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        Paragraph paragraph;
        CobolToken cobolToken;
        VariableName variableName;
        int n2;
        boolean bl;
        pcc.inProcedure = true;
        this.error = errors;
        TokenList tokenList = tokenManager.delExtraInfo("ELK");
        if (tokenList != null) {
            this.elkToken = tokenList.getFirst();
            if ("OPERATION".equalsIgnoreCase(tokenList.getNext().getWord())) {
                if (tokenList.getNext().getToknum() == 61) {
                    this.serviceBridgeOperation = tokenList.getNext().getWord();
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        this.firstToken = token;
        this.parent = pcc;
        this.tm = tokenManager;
        token = this.tm.getToken();
        this.fileNumber = token.getFileIndex();
        boolean bl2 = bl = pcc.getRoot().isInterface() && !((CobolMethod)pcc).isDefault() && !((CobolMethod)pcc).isStatic();
        if (token.getToknum() != 410) {
            throw new ExpectedFoundException(token, this.error, "DIVISION");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 802 || token.getToknum() == 10009) {
            if (token.getToknum() == 10009) {
                this.error.print(31, 2, token, "expected . found " + token.getWord());
                this.tm.ungetToken();
            }
            n2 = 0;
            while ((token = this.tm.getToken()).getToknum() == 10009 || token.getToknum() == 312 || token.getToknum() == 803 || token.getToknum() == 676) {
                if (token.getToknum() == 312) {
                    this.isByValueAllowed(token);
                    token = this.tm.getToken();
                    if (token.getToknum() == 803) {
                        n2 = 1;
                    } else {
                        if (token.getToknum() != 676) throw new ExpectedFoundException(token, this.error, "VALUE|REFERENCE");
                        n2 = 0;
                    }
                } else if (token.getToknum() == 803) {
                    this.isByValueAllowed(token);
                    n2 = 1;
                } else if (token.getToknum() == 676) {
                    this.isByValueAllowed(token);
                    n2 = 0;
                } else {
                    this.tm.ungetToken();
                }
                token = this.tm.getToken();
                if (token.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                }
                this.tm.ungetToken();
                variableName = VariableName.getAnyUsing(this.tm, this.error, null, pcc);
                if (!this.isInLinkage(variableName.getVarDecl())) throw new GeneralErrorException(139, 4, variableName.getNameToken(), variableName.getName(), this.error);
                if (variableName.getDimension() > 0) {
                    throw new GeneralErrorException(55, 4, variableName.getNameToken(), variableName.getName(), this.error);
                }
                if (this instanceof MethodProcedure && variableName.getVarDecl().getRedefines() != null) {
                    throw new GeneralErrorException(19, 4, variableName.getNameToken(), "REDEFINES " + variableName.getName(), this.error);
                }
                this.using.addItem(variableName);
                if (n2 != 0) {
                    this.byValueVars.add(variableName);
                }
                if (variableName.getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, token, token.getWord(), this.error);
            }
        } else if (token.getToknum() == 322) {
            if (bl) {
                throw new GeneralErrorException(246, 4, token, token.getWord(), this.error);
            }
            while ((token = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                variableName = VariableName.getAnyUsing(this.tm, this.error, null, pcc);
                n2 = variableName.getDimension();
                cobolToken = variableName.getVarDecl();
                int n3 = ((VariableDeclaration)cobolToken).getDimension() + ((VariableDeclaration)cobolToken).getDyDimension();
                int n4 = n3 - n2;
                if (n4 < 0) {
                    throw new GeneralErrorException(41, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
                }
                if (n4 > 0 && !((VariableDeclaration)cobolToken).isObjectReference()) {
                    SubscriptList subscriptList = variableName.getIndexes();
                    if (subscriptList == null) {
                        subscriptList = new SubscriptList();
                    }
                    for (int i2 = 0; i2 < n4; ++i2) {
                        subscriptList.addItem(Subscript.get("1"));
                    }
                    variableName.setIndexes(subscriptList);
                }
                this.chaining.addItem(variableName);
                if (variableName.getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, token, token.getWord(), this.error);
            }
        }
        if (this.parent.data != null && this.parent.data.linkSec != null) {
            this.usingVarargs = this.parent.data.linkSec.checkUsingVarargs(this.using);
        }
        if (this.tm.getOptionList().getOption("-wlu") != null) {
            this.checkUsingWithLinkage();
        }
        if (token.getToknum() == 694) {
            token = this.tm.getToken();
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, null, pcc, GetVarOpts.DYN_GRP_ALLOW);
            token = this.tm.getToken();
        }
        if (this instanceof MethodProcedure && token.getToknum() == 663) {
            this.raising = new VariableNameList();
            while ((token = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                variableName = VariableName.getObject(this.tm, this.error, null, pcc);
                if (variableName == null) {
                    throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                }
                if (!variableName.getType().isAssignableTo(Throwable.class) || !variableName.getVarDecl().isFactory) {
                    throw new GeneralErrorException(75, 4, token, variableName.getType().getName(), this.error);
                }
                this.raising.addItem(variableName);
            }
            if (this.raising.getItemNum() == 0) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
        }
        if (token.getToknum() != 10006) {
            throw new ExpectedFoundException(token, this.error, "'.'");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 395) {
            pcc.inDeclaratives = true;
            this.startDeclaratives = token;
            token = this.tm.getToken();
            if (token.getToknum() != 10006) {
                throw new ExpectedFoundException(token, this.error, ".");
            }
        } else {
            this.tm.ungetToken();
        }
        int n5 = 1;
        block12: while (n5 != 0) {
            try {
                token = this.tm.getToken();
            }
            catch (EndOfProgramException endOfProgramException) {
                break;
            }
            switch (token.getToknum()) {
                case 395: {
                    if (bl) {
                        throw new GeneralErrorException(248, 4, token, token.getWord(), this.error);
                    }
                    pcc.inDeclaratives = false;
                    this.endDeclaratives = token;
                    token = this.tm.getToken();
                    if (token.getToknum() == 10006) continue block12;
                    throw new ExpectedFoundException(token, this.error, ".");
                }
                case 10002: 
                case 10009: {
                    if (bl) {
                        throw new GeneralErrorException(248, 4, token, token.getWord(), this.error);
                    }
                    if (pcc.inDeclaratives) {
                        paragraph = this.getParagraph(token.getWord(), true);
                        if (paragraph != null) {
                            paragraph.setIsDup();
                            Paragraph paragraph2 = new Paragraph(pcc, token, this.tm, this.error, true, this);
                            this.dList.addItem(paragraph2);
                            if (!paragraph.isSection && !paragraph2.isSection) continue block12;
                            this.error.print(67, 4, token, token.getWord());
                            continue block12;
                        }
                        this.dList.addItem(new Paragraph(pcc, token, this.tm, this.error, false, this));
                        continue block12;
                    }
                    paragraph = this.getParagraph(token.getWord(), false);
                    if (paragraph != null) {
                        paragraph.setIsDup();
                        this.pList.addItem(new Paragraph(pcc, token, this.tm, this.error, true, this));
                        continue block12;
                    }
                    this.pList.addItem(new Paragraph(pcc, token, this.tm, this.error, false, this));
                    continue block12;
                }
                case 422: {
                    Token token2 = this.tm.getToken();
                    if (token2.getToknum() == 395) {
                        if (bl) {
                            throw new GeneralErrorException(248, 4, token, token.getWord(), this.error);
                        }
                        if (!pcc.inDeclaratives) throw new UnexpectedTokenException(token, this.error);
                        pcc.inDeclaratives = false;
                        this.endDeclaratives = token;
                        token = this.tm.getToken();
                        if (token.getToknum() == 10006) continue block12;
                        throw new ExpectedFoundException(token, this.error, ".");
                    }
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                    n5 = 0;
                    continue block12;
                }
                case 521: 
                case 522: {
                    throw new GeneralErrorException(19, 4, token, "", this.error);
                }
            }
            this.tm.ungetToken();
            cobolToken = new Token(10009, "PROCEDURE", token.getFLN(), 0, token.getFileName());
            ((Token)cobolToken).setFileIndex(token.getFileIndex());
            Paragraph paragraph3 = new Paragraph(pcc, (Token)cobolToken, this.tm, this.error, this);
            if (bl && paragraph3.getBlock().getVerbs().getItemNum() > 0) {
                Verb verb = paragraph3.getBlock().getVerbs().getFirst();
                throw new GeneralErrorException(248, 4, verb.getKeyWord(), verb.getKeyWord().getWord(), this.error);
            }
            paragraph3.setParagraphCodeLimit();
            this.pList.addItem(paragraph3);
        }
        Section section = null;
        n5 = 1;
        paragraph = this.pList.getFirst();
        while (paragraph != null) {
            paragraph.setIdNumber(n5);
            if (paragraph.isSection) {
                if (section != null) {
                    section.check();
                }
                section = new Section(paragraph.getName());
                this.sList.addItem(section);
            }
            if (section != null) {
                section.addParagraph(paragraph);
                paragraph.setSection(section);
            }
            ++n5;
            paragraph = this.pList.getNext();
        }
        if (section != null) {
            section.check();
            section = null;
        }
        n5 = 1;
        paragraph = this.dList.getFirst();
        while (paragraph != null) {
            paragraph.setIdNumber(n5);
            if (paragraph.isSection) {
                if (section != null) {
                    section.check();
                }
                section = new Section(paragraph.getName());
                this.dsList.addItem(section);
            }
            if (section != null) {
                section.addParagraph(paragraph);
                paragraph.setSection(section);
            }
            ++n5;
            paragraph = this.dList.getNext();
        }
        if (section != null) {
            section.check();
        }
        if (!pcc.inDeclaratives) return;
        throw new GeneralErrorException(12, 4, token, "in DECLARATIVE", this.error);
    }

    protected void isByValueAllowed(Token token) throws GeneralErrorException {
    }

    private boolean isInLinkage(VariableDeclaration variableDeclaration) {
        return this.parent.data != null && this.parent.data.linkSec != null && this.parent.data.linkSec.vars != null && this.parent.data.linkSec.vars.exists(variableDeclaration);
    }

    private void checkUsingWithLinkage() {
        if (this.parent.data != null && this.parent.data.linkSec != null && this.parent.data.linkSec.vars != null) {
            VariableName variableName = null;
            String string = null;
            VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
            variableDeclarationList.addListObject(this.parent.data.linkSec.vars);
            VariableDeclaration variableDeclaration = this.parent.data.linkSec.vars.getFirst();
            while (variableDeclaration != null) {
                if (this.using != null) {
                    variableName = this.using.getFirst();
                    while (variableName != null) {
                        if (variableName.getVarDecl() == variableDeclaration) {
                            if (variableDeclaration.getRedefinesVar() != null) {
                                while ((variableDeclaration = variableDeclaration.getRedefinesVar()) != null) {
                                    variableDeclarationList.deleteObject(variableDeclaration);
                                }
                            } else {
                                variableDeclarationList.deleteObject(variableDeclaration);
                            }
                        }
                        variableName = this.using.getNext();
                    }
                }
                variableDeclaration = this.parent.data.linkSec.vars.getNext();
            }
            variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.getRedefinesVar() == null) {
                    string = string == null ? variableDeclaration.getName() : string + "," + variableDeclaration.getName();
                }
                variableDeclaration = variableDeclarationList.getNext();
            }
            if (string != null) {
                this.error.print(211, 2, this.firstToken, string);
            }
        }
    }

    public int getParCount() {
        return this.pList.getItemNum();
    }

    public void check() throws GeneralErrorException {
        Paragraph paragraph = this.pList.getFirst();
        while (paragraph != null) {
            paragraph.check();
            paragraph = this.pList.getNext();
        }
    }

    private void entryPointCode(StringBuffer stringBuffer) {
        if (this.parent.entryPoints.size() == 0) {
            return;
        }
        stringBuffer.append("   ");
        if (!this.parent.getSplitFlag()) {
            stringBuffer.append("private ");
        }
        stringBuffer.append("String $entryPoints[] = {");
        Object object = this.parent.entryPoints.iterator();
        while (true) {
            stringBuffer.append(object.next().getName());
            if (!object.hasNext()) break;
            stringBuffer.append("," + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("   };" + eol);
        stringBuffer.append("   public String[] getEntryPoints () {" + eol);
        stringBuffer.append("      return $entryPoints;" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append("   public Object call (int ep, Object[] argv) {" + eol);
        stringBuffer.append("      " + this.getSwitchesCode());
        stringBuffer.append(eol);
        stringBuffer.append("      int go;" + eol);
        stringBuffer.append("      com.iscobol.rts.Version.checkVersion (");
        if (this.parent.getSplitFlag()) {
            stringBuffer.append(this.parent.getClassName() + ".");
        }
        stringBuffer.append("this);" + eol);
        stringBuffer.append("      final int argl=(argv==null)?0:argv.length;");
        stringBuffer.append(eol);
        stringBuffer.append("      switch(ep) {" + eol);
        int n2 = this.getParCount();
        Object[] objectArray = this.parent.entryPoints.toArray();
        boolean bl = this.parent.getOption("-clk0") != null;
        for (int i2 = 0; i2 < this.parent.entryPoints.size(); ++i2) {
            object = (Entry)objectArray[i2];
            stringBuffer.append("      case " + i2 + ":" + eol);
            if (((Entry)object).using.getItemNum() > 0) {
                ProcedureDivision.usingCode(((Entry)object).using, null, ((Entry)object).usingVarargs, bl, stringBuffer);
            }
            this.prePutPerform(stringBuffer, "   ");
            Paragraph paragraph = ((Verb)object).getParent().parent;
            if (this.tm.getOptionList().getOption("-d") != null) {
                stringBuffer.append("         ");
                paragraph.getDebugEnterCode(stringBuffer, ((Entry)object).getName());
                stringBuffer.append(eol);
            }
            stringBuffer.append("            if ((go=");
            stringBuffer.append(((Entry)object).getMethodName());
            stringBuffer.append(") > 0) perform (go,");
            stringBuffer.append(n2);
            stringBuffer.append(");");
            int n3 = paragraph.getIdNumber() + 1;
            if (n3 <= n2) {
                stringBuffer.append(eol);
                stringBuffer.append("            else perform (");
                stringBuffer.append(n3);
                stringBuffer.append(",");
                stringBuffer.append(n2);
                stringBuffer.append(");");
            }
            stringBuffer.append(eol);
            stringBuffer.append("         } catch (GotoException ex$) { ");
            stringBuffer.append(eol);
            stringBuffer.append("           perform (ex$.parNum,");
            stringBuffer.append(n2);
            stringBuffer.append(");");
            stringBuffer.append(eol);
            this.postPutPerform(stringBuffer, "   ");
            stringBuffer.append("         break;" + eol);
        }
        stringBuffer.append("      }" + eol);
        stringBuffer.append("      return ");
        if (this.returning != null) {
            stringBuffer.append(this.returning.getCode());
        } else {
            stringBuffer.append(Verb.getReturnCode(this.parent.capitalizeNames));
        }
        stringBuffer.append(";" + eol);
        stringBuffer.append("   }" + eol);
    }

    private static void usingCode(VariableNameList variableNameList, HashSet hashSet, VariableDeclaration variableDeclaration, boolean bl, StringBuffer stringBuffer) {
        VariableDeclaration variableDeclaration2;
        VariableDeclaration variableDeclaration3;
        int n2;
        stringBuffer.append(eol);
        String string = null;
        if (variableDeclaration != null) {
            stringBuffer.append("      ");
            stringBuffer.append(variableDeclaration.getUnivoqueName());
            stringBuffer.append("= new ");
            string = variableDeclaration.getTypeName();
            string = string.substring(0, string.length() - 2);
            stringBuffer.append(string);
            stringBuffer.append("[0];");
            stringBuffer.append(eol);
        }
        stringBuffer.append("      switch (argl) {");
        stringBuffer.append(eol);
        stringBuffer.append("      default:" + eol);
        int n3 = variableNameList.getItemNum();
        if (variableDeclaration != null) {
            stringBuffer.append("      ");
            stringBuffer.append(variableDeclaration.getUnivoqueName());
            stringBuffer.append("= new ");
            stringBuffer.append(string);
            stringBuffer.append("[argv.length - ");
            stringBuffer.append(n3 - 1);
            stringBuffer.append("];");
            stringBuffer.append(eol);
            stringBuffer.append("      for(int i = ");
            stringBuffer.append(n3 - 1);
            stringBuffer.append(", j = 0; i < argv.length; i++, j++)");
            stringBuffer.append(eol);
            stringBuffer.append("         ");
            stringBuffer.append(variableDeclaration.getUnivoqueName());
            stringBuffer.append("[j] = (");
            stringBuffer.append(string);
            stringBuffer.append(") argv[i];");
            stringBuffer.append(eol);
            --n3;
        }
        for (n2 = n3; n2 > 0; --n2) {
            stringBuffer.append("      case ");
            stringBuffer.append(n2);
            stringBuffer.append(": ");
            VariableName variableName = variableNameList.getAt(n2 - 1);
            variableDeclaration3 = variableName.getVarDecl();
            while ((variableDeclaration2 = variableDeclaration3.getRedefinesVar()) != null) {
                variableDeclaration3 = variableDeclaration2;
            }
            stringBuffer.append(variableDeclaration3.getUnivoqueName());
            if (variableDeclaration3.isObjectReference()) {
                stringBuffer.append("=(");
                stringBuffer.append(variableDeclaration3.getTypeName());
                stringBuffer.append(")argv[");
                stringBuffer.append(n2 - 1);
                stringBuffer.append("];");
            } else {
                stringBuffer.append(".link((CobolVar)argv[");
                stringBuffer.append(n2 - 1);
                stringBuffer.append("]);");
            }
            stringBuffer.append(eol);
        }
        stringBuffer.append("      case 0: break;");
        stringBuffer.append(eol);
        stringBuffer.append("      }" + eol);
        if (bl) {
            stringBuffer.append("      switch (argl) {");
            stringBuffer.append(eol);
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append("      case ");
                stringBuffer.append(n2);
                stringBuffer.append(": ");
                variableDeclaration3 = variableNameList.getAt(n2).getVarDecl();
                while ((variableDeclaration2 = variableDeclaration3.getRedefinesVar()) != null) {
                    variableDeclaration3 = variableDeclaration2;
                }
                stringBuffer.append(variableDeclaration3.getUnivoqueName());
                if (variableDeclaration3.isObjectReference()) {
                    String string2 = variableDeclaration3.getClassName();
                    if ("boolean".equals(string2)) {
                        stringBuffer.append(" = false;");
                    } else if ("byte".equals(string2)) {
                        stringBuffer.append(" = (byte) 0;");
                    } else if ("char".equals(string2)) {
                        stringBuffer.append(" = (char) 0;");
                    } else if ("short".equals(string2) || "int".equals(string2) || "long".equals(string2) || "float".equals(string2) || "double".equals(string2)) {
                        stringBuffer.append(" = 0;");
                    } else {
                        stringBuffer.append(" = null;");
                    }
                } else {
                    stringBuffer.append(".link(");
                    stringBuffer.append(LinkageSection.lnkNull.getCode());
                    stringBuffer.append(");");
                }
                stringBuffer.append(eol);
            }
            stringBuffer.append("      }" + eol);
        }
    }

    private void prePutPerform(StringBuffer stringBuffer, String string) {
        boolean bl;
        stringBuffer.append(string + "      try {" + eol);
        boolean bl2 = bl = this.tm.getOptionList().getOption("-d") != null;
        if (bl) {
            stringBuffer.append(string);
            this.getDebugEnterCode(stringBuffer);
            stringBuffer.append(eol);
        }
    }

    private void putPerform(StringBuffer stringBuffer, int n2, int n3) {
        this.prePutPerform(stringBuffer, "");
        stringBuffer.append("         perform (" + n2 + "," + n3 + ");" + eol);
        this.postPutPerform(stringBuffer, "");
    }

    private void postPutPerform(StringBuffer stringBuffer, String string) {
        boolean bl = this.tm.getOptionList().getOption("-d") != null;
        stringBuffer.append(string + "      } catch (GobackException ex$) { " + eol);
        stringBuffer.append(string + "         if(ex$.getReturnValue()!=null) " + eol);
        stringBuffer.append(string + "            return ex$.getReturnValue();" + eol);
        stringBuffer.append(string + "      } finally { " + eol);
        if (bl) {
            stringBuffer.append(string + "      ");
            ProcedureDivision.getDebugExitCode(stringBuffer);
            stringBuffer.append(eol);
        }
        CobolProgram cobolProgram = (CobolProgram)this.parent;
        if (this.tm.getOptionList().getOption("-coe") != null || this.tm.getOptionList().getOption("-zi") != null || cobolProgram.getProgramIdentificationDivision().getProgramType() == 531) {
            stringBuffer.append(string + "         finalize();" + eol);
        }
        stringBuffer.append(string + "      }" + eol);
        if (this.parent.data != null && this.parent.data.screenSec != null || this.parent.useScreen) {
            stringBuffer.append(eol);
        }
    }

    private String getSwitchesCode() {
        EnvironmentDivision environmentDivision = this.parent.getEnvironmentDivision();
        if (environmentDivision != null) {
            ConfigurationSection configurationSection = environmentDivision.getConfigurationSection();
            if (configurationSection != null) {
                SpecialNames specialNames = configurationSection.getSpecialNames();
                if (specialNames != null) {
                    return specialNames.getSwitchesCode(new StringBuffer());
                }
                return "";
            }
            return "";
        }
        return "";
    }

    private void callCode(StringBuffer stringBuffer) {
        stringBuffer.append("   public Object call(Object argv[]) {" + eol);
        stringBuffer.append("      com.iscobol.rts.Version.checkVersion (");
        if (this.parent.getSplitFlag()) {
            stringBuffer.append(this.parent.getClassName() + ".");
        }
        stringBuffer.append("this);" + eol);
        stringBuffer.append("      " + this.getSwitchesCode());
        if (this.using.getItemNum() > 0) {
            stringBuffer.append("final int argl=(argv==null)?0:argv.length;");
            stringBuffer.append(eol);
            ProcedureDivision.usingCode(this.using, this.byValueVars, this.usingVarargs, this.parent.getOption("-clk0") != null, stringBuffer);
        } else if (this.chaining.getItemNum() > 0) {
            stringBuffer.append("      if (argv != null) {" + eol);
            stringBuffer.append("         switch (argv.length - 1) {" + eol);
            stringBuffer.append("         default:" + eol);
            VariableName variableName = this.chaining.getLast();
            int n2 = this.chaining.getItemNum() - 1;
            while (variableName != null) {
                stringBuffer.append("         case ");
                stringBuffer.append(n2);
                stringBuffer.append(": if (argv[");
                stringBuffer.append(n2);
                stringBuffer.append("] instanceof CobolVar)");
                stringBuffer.append(eol);
                stringBuffer.append("               ");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".set((CobolVar)argv[");
                stringBuffer.append(n2);
                stringBuffer.append("]);");
                stringBuffer.append(eol);
                stringBuffer.append("            else");
                stringBuffer.append(eol);
                stringBuffer.append("               ");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".set(argv[");
                stringBuffer.append(n2);
                stringBuffer.append("]);" + eol);
                variableName = this.chaining.getPrevious();
                --n2;
            }
            stringBuffer.append("         case -1:" + eol);
            stringBuffer.append("         }" + eol);
            stringBuffer.append("      }" + eol);
        } else {
            boolean bl;
            boolean bl2 = bl = !this.parent.optionMS || Config.b("iscobol.compiler.jjms.gen_cmdline_code", false);
            if (bl) {
                stringBuffer.append("if (gArgs == null && argv != null) {" + eol);
                stringBuffer.append("         gArgs = new String[argv.length];" + eol);
                stringBuffer.append("         for (int i = 0; i < argv.length; i++)" + eol);
                stringBuffer.append("            if (argv[i] != null)" + eol);
                stringBuffer.append("               gArgs[i] = argv[i].toString();" + eol);
                stringBuffer.append("         Factory.get().gArgs = gArgs;" + eol);
                stringBuffer.append("      }" + eol);
            }
        }
        this.putPerform(stringBuffer, 1, this.getParCount());
        stringBuffer.append("      return ");
        if (this.returning != null) {
            stringBuffer.append(this.returning.getCode());
        } else {
            stringBuffer.append(Verb.getReturnCode(this.parent.capitalizeNames));
        }
        stringBuffer.append(";" + eol);
        stringBuffer.append("   }" + eol);
    }

    private void performCode(StringBuffer stringBuffer, int n2, int n3) {
        boolean bl = n2 == 1;
        boolean bl2 = n3 == this.pList.getItemNum();
        int n4 = n2 / 1500 + 1;
        if (bl) {
            stringBuffer.append("   public void perform (int begin, int end) {" + eol);
        } else {
            stringBuffer.append("   private int perform$" + n4 + " (int begin, int end) throws GotoException, ExitSectionException {" + eol);
        }
        if (n3 > 0) {
            if (bl) {
                stringBuffer.append("      boolean goOn = true;" + eol);
                stringBuffer.append("      while (goOn) {" + eol);
                stringBuffer.append("         try {" + eol);
            }
            stringBuffer.append("            switch (begin) {" + eol);
            for (int i2 = n2; i2 <= n3; ++i2) {
                Paragraph paragraph = this.pList.getAt(i2 - 1);
                stringBuffer.append("            case " + i2 + ":" + eol);
                if (paragraph.hasGoto()) {
                    stringBuffer.append("               if ((begin = ");
                    stringBuffer.append(paragraph.getJavaName());
                    if (bl) {
                        stringBuffer.append("()) > 0) break;");
                    } else {
                        stringBuffer.append("()) > 0) return begin;");
                    }
                } else {
                    stringBuffer.append("               begin = ");
                    stringBuffer.append(paragraph.getJavaName());
                    stringBuffer.append("();");
                }
                stringBuffer.append(eol);
                stringBuffer.append("               if (end == " + i2 + ") {" + eol);
                if (bl) {
                    stringBuffer.append("                  goOn = false;" + eol);
                }
                stringBuffer.append("                  break;" + eol);
                stringBuffer.append("               }" + eol);
                if (bl2 || i2 != n3) continue;
                stringBuffer.append("               begin = " + (n3 + 1) + ";" + eol);
            }
            stringBuffer.append("            default:" + eol);
            if (!bl2) {
                stringBuffer.append("               if ((begin = perform$");
                stringBuffer.append(n4 + 1);
                if (bl) {
                    stringBuffer.append("(begin, end)) > 0) break;");
                } else {
                    stringBuffer.append("(begin, end)) > 0) return begin;");
                }
                stringBuffer.append(eol);
            }
            if (bl) {
                stringBuffer.append("               goOn = false;" + eol);
            }
            stringBuffer.append("               break;" + eol);
            stringBuffer.append("            }" + eol);
            if (bl) {
                stringBuffer.append("         } catch (GotoException e) {" + eol);
                stringBuffer.append("            begin = e.parNum;" + eol);
                stringBuffer.append("         } catch (ExitSectionException e) {" + eol);
                stringBuffer.append("            goOn = false;" + eol);
                stringBuffer.append("         }" + eol);
                stringBuffer.append("      }" + eol);
            } else {
                stringBuffer.append("         return 0;" + eol);
            }
        }
        stringBuffer.append("   }" + eol);
    }

    public int getCode(StringBuffer stringBuffer, int n2) {
        boolean bl;
        int n3;
        Paragraph paragraph;
        int n4 = 0;
        stringBuffer.append(this.tm.getCommentCode(this.firstToken, "   "));
        if (n2 > 0) {
            stringBuffer.append(eol + "      public class " + "inner_" + n2 + " extends " + "inner_" + (n2 - 1));
            stringBuffer.append(" {" + eol);
            stringBuffer.append("   public inner_" + n2 + "() {}" + eol);
            ++n2;
            paragraph = this.dList.getFirst();
            while (paragraph != null) {
                if (n4 > 0 && n4 % Pcc.MAX_PARAGRAPHS == 0) {
                    stringBuffer.append("      }");
                    stringBuffer.append(eol + "      public class " + "inner_" + n2 + " extends " + "inner_" + (n2 - 1));
                    stringBuffer.append(" {" + eol);
                    stringBuffer.append("   public inner_" + n2 + "() {}" + eol);
                    ++n2;
                }
                stringBuffer.append(paragraph.getCode());
                paragraph = this.dList.getNext();
                ++n4;
            }
            paragraph = this.pList.getFirst();
            while (paragraph != null) {
                if (n4 > 0 && n4 % Pcc.MAX_PARAGRAPHS == 0) {
                    stringBuffer.append("      }");
                    stringBuffer.append(eol + "      public class " + "inner_" + n2 + " extends " + "inner_" + (n2 - 1));
                    stringBuffer.append(" {" + eol);
                    stringBuffer.append("   public inner_" + n2 + "() {}" + eol);
                    ++n2;
                }
                stringBuffer.append(paragraph.getCode());
                paragraph = this.pList.getNext();
                ++n4;
            }
            n3 = 0;
            while (n3 < this.parent.sqlCursorMethodsCode.size()) {
                if (n4 > 0 && n4 % Pcc.MAX_PARAGRAPHS == 0) {
                    stringBuffer.append("      }");
                    stringBuffer.append(eol + "      public class " + "inner_" + n2 + " extends " + "inner_" + (n2 - 1));
                    stringBuffer.append(" {" + eol);
                    stringBuffer.append("   public inner_" + n2 + "() {}" + eol);
                    ++n2;
                }
                stringBuffer.append(this.parent.sqlCursorMethodsCode.get(n3));
                ++n3;
                ++n4;
            }
            this.parent.sqlCursorMethodsCode.clear();
            stringBuffer.append("      }");
            stringBuffer.append(eol + "      public class " + "inner_" + n2 + " extends " + "inner_" + (n2 - 1));
            stringBuffer.append(" {" + eol);
            stringBuffer.append("   public inner_" + n2 + "() {}" + eol);
            ++n2;
            Pcc.declareFinalize(stringBuffer, "      ");
            stringBuffer.append(this.parent.getFinalizeCode() + eol);
            stringBuffer.append("      }");
        }
        this.callCode(stringBuffer);
        this.entryPointCode(stringBuffer);
        n3 = this.pList.getItemNum();
        if (n3 > 0) {
            for (n4 = 1; n4 <= n3; n4 += 1500) {
                this.performCode(stringBuffer, n4, Math.min(n3, n4 + 1500 - 1));
            }
        } else {
            this.performCode(stringBuffer, 1, 0);
        }
        boolean bl2 = this.parent.getOption("-pt0") != null;
        boolean bl3 = bl = this.parent.getOption("-pt2") != null;
        if (bl2 || bl) {
            this.getPT0_2HandlingCode(stringBuffer, "perform", bl);
        }
        if (this.dList.getItemNum() > 0) {
            stringBuffer.append("   public void declaratives (int begin, int end)");
            stringBuffer.append(" throws GotoException {" + eol);
            stringBuffer.append("      boolean goOn = true;" + eol);
            stringBuffer.append("      while (goOn) {" + eol);
            stringBuffer.append("         try {" + eol);
            stringBuffer.append("            switch (begin) {" + eol);
            n4 = 1;
            paragraph = this.dList.getFirst();
            while (paragraph != null) {
                stringBuffer.append("            case " + n4 + ":" + eol);
                if (paragraph.hasGoto()) {
                    stringBuffer.append("               if ((begin = ");
                    stringBuffer.append(paragraph.getJavaName());
                    stringBuffer.append("()) > 0) break;");
                } else {
                    stringBuffer.append("               begin = ");
                    stringBuffer.append(paragraph.getJavaName());
                    stringBuffer.append("();");
                }
                stringBuffer.append(eol);
                stringBuffer.append("               if (end == " + n4 + ") {" + eol);
                stringBuffer.append("                  goOn = false;" + eol);
                stringBuffer.append("                  break;" + eol);
                stringBuffer.append("               }" + eol);
                paragraph = this.dList.getNext();
                ++n4;
            }
            stringBuffer.append("            default:" + eol);
            stringBuffer.append("               ");
            Stop.getStopRunCode(stringBuffer, this.parent.capitalizeNames, null, null);
            stringBuffer.append("               break;" + eol);
            stringBuffer.append("            }" + eol);
            stringBuffer.append("         } catch (ExitSectionException e) {" + eol);
            stringBuffer.append("            goOn = false;" + eol);
            stringBuffer.append("         }" + eol);
            stringBuffer.append("      }" + eol);
            stringBuffer.append("   }" + eol);
            if (bl2 || bl) {
                this.getPT0_2HandlingCode(stringBuffer, "declaratives", bl);
            }
        }
        if (n2 > 0) {
            stringBuffer.append("      }");
        } else {
            paragraph = this.dList.getFirst();
            while (paragraph != null) {
                stringBuffer.append(paragraph.getCode());
                paragraph = this.dList.getNext();
            }
            paragraph = this.pList.getFirst();
            while (paragraph != null) {
                stringBuffer.append(paragraph.getCode());
                paragraph = this.pList.getNext();
            }
            for (int i2 = 0; i2 < this.parent.sqlCursorMethodsCode.size(); ++i2) {
                stringBuffer.append(this.parent.sqlCursorMethodsCode.get(i2));
            }
            this.parent.sqlCursorMethodsCode.clear();
        }
        return n2;
    }

    private void getPT0_2HandlingCode(StringBuffer stringBuffer, String string, boolean bl) {
        int n2;
        String string2;
        String string3;
        String string4;
        boolean bl2 = "declaratives".equals(string);
        if (bl2) {
            string4 = "$dexitPoint$";
            string3 = "$depe$";
            string2 = "dexit";
            n2 = this.dList.getItemNum();
        } else {
            string4 = "$exitPoint$";
            string3 = "$epe$";
            string2 = "exit";
            n2 = this.pList.getItemNum();
        }
        stringBuffer.append("   ");
        boolean bl3 = this.parent.getSplitFlag();
        if (!bl3) {
            stringBuffer.append("private ");
        }
        stringBuffer.append("final ExitPointException ");
        stringBuffer.append(string3);
        stringBuffer.append(" = new ExitPointException();");
        stringBuffer.append(eol);
        stringBuffer.append("   ");
        if (!bl3) {
            stringBuffer.append("private ");
        }
        stringBuffer.append("final int ");
        stringBuffer.append(string4);
        stringBuffer.append("[] = new int[");
        stringBuffer.append(n2 + 1);
        stringBuffer.append("];");
        stringBuffer.append(eol);
        stringBuffer.append("   private void ");
        stringBuffer.append(string);
        stringBuffer.append(" (int begin,int end,int id) ");
        if (bl2) {
            stringBuffer.append("throws GotoException ");
        }
        stringBuffer.append("{");
        stringBuffer.append(eol);
        stringBuffer.append("      ");
        stringBuffer.append(string4);
        if (bl) {
            stringBuffer.append("[end]++;");
        } else {
            stringBuffer.append("[end] = id;");
        }
        stringBuffer.append(eol);
        stringBuffer.append("      try {");
        stringBuffer.append(eol);
        stringBuffer.append("         ");
        stringBuffer.append(string);
        stringBuffer.append(" (begin, 0);");
        stringBuffer.append(eol);
        stringBuffer.append("      } catch (ExitPointException _ex) {");
        stringBuffer.append(eol);
        stringBuffer.append("         ");
        stringBuffer.append(string4);
        if (bl) {
            stringBuffer.append("[end]--;");
        } else {
            stringBuffer.append("[end] = 0;");
        }
        stringBuffer.append(eol);
        if (bl) {
            stringBuffer.append("         if (end != _ex.num) {");
        } else {
            stringBuffer.append("         if (id != _ex.num) {");
        }
        stringBuffer.append(eol);
        stringBuffer.append("            throw _ex;");
        stringBuffer.append(eol);
        stringBuffer.append("         }");
        stringBuffer.append(eol);
        stringBuffer.append("      }");
        stringBuffer.append(eol);
        stringBuffer.append("   }");
        stringBuffer.append(eol);
        stringBuffer.append("   private void ");
        stringBuffer.append(string2);
        stringBuffer.append(" (int id) {");
        stringBuffer.append(eol);
        stringBuffer.append("      ");
        stringBuffer.append(string3);
        stringBuffer.append(".num = ");
        if (bl) {
            stringBuffer.append("id;");
        } else {
            stringBuffer.append(string4);
            stringBuffer.append("[id];");
        }
        stringBuffer.append(eol);
        if (!bl) {
            stringBuffer.append("      ");
            stringBuffer.append(string4);
            stringBuffer.append("[id] = 0;");
            stringBuffer.append(eol);
        }
        stringBuffer.append("      throw ");
        stringBuffer.append(string3);
        stringBuffer.append(";");
        stringBuffer.append(eol);
        stringBuffer.append("   }");
        stringBuffer.append(eol);
    }

    public Paragraph[] getParagraphs(boolean bl) {
        ParagraphList paragraphList = bl ? this.dList : this.pList;
        Object[] objectArray = new Paragraph[paragraphList.getItemNum()];
        paragraphList.toArray(objectArray);
        return objectArray;
    }

    public Paragraph[] getParagraphs() {
        Paragraph[] paragraphArray = this.getParagraphs(true);
        Paragraph[] paragraphArray2 = this.getParagraphs(false);
        Paragraph[] paragraphArray3 = new Paragraph[paragraphArray.length + paragraphArray2.length];
        System.arraycopy(paragraphArray, 0, paragraphArray3, 0, paragraphArray.length);
        System.arraycopy(paragraphArray2, 0, paragraphArray3, paragraphArray.length, paragraphArray2.length);
        return paragraphArray3;
    }

    public Section[] getSections(boolean bl) {
        SectionList sectionList = bl ? this.dsList : this.sList;
        Object[] objectArray = new Section[sectionList.getItemNum()];
        sectionList.toArray(objectArray);
        return objectArray;
    }

    public Section[] getSections() {
        Section[] sectionArray = this.getSections(true);
        Section[] sectionArray2 = this.getSections(false);
        Section[] sectionArray3 = new Section[sectionArray.length + sectionArray2.length];
        System.arraycopy(sectionArray, 0, sectionArray3, 0, sectionArray.length);
        System.arraycopy(sectionArray2, 0, sectionArray3, sectionArray.length, sectionArray2.length);
        return sectionArray3;
    }

    @Override
    public Token getDeclarativesStart() {
        return this.startDeclaratives;
    }

    @Override
    public Token getDeclarativesEnd() {
        return this.endDeclaratives;
    }

    public Paragraph getParagraphById(int n2, boolean bl) {
        if (bl) {
            return this.dList.elementAt(n2 - 1);
        }
        return this.pList.elementAt(n2 - 1);
    }

    public Paragraph getParagraph(String string, String string2, boolean bl) {
        Paragraph paragraph = null;
        Enumeration enumeration = bl ? this.dsList.elements() : this.sList.elements();
        while (enumeration.hasMoreElements()) {
            Paragraph paragraph2;
            Section section = (Section)enumeration.nextElement();
            if (!section.getName().equals(string2) || (paragraph2 = section.getParagraph(string)) == null) continue;
            if (paragraph == null) {
                paragraph = paragraph2;
                continue;
            }
            return new DuplicateParagraph();
        }
        return paragraph;
    }

    public Paragraph getParagraph(String string, boolean bl) {
        return this.getParagraph(string, (Paragraph)null, bl);
    }

    public Paragraph getParagraph(String string, Paragraph paragraph, boolean bl) {
        Paragraph paragraph2 = paragraph != null ? paragraph.getParagraphInSameSection(string) : null;
        if (paragraph2 == null && (paragraph2 = bl ? this.dList.getByName(string) : this.pList.getByName(string)) != null && paragraph2.isDuplicate()) {
            return new DuplicateParagraph();
        }
        return paragraph2;
    }

    public void getDebugEnterCode(StringBuffer stringBuffer) {
        stringBuffer.append(ProcedureDivision.getDebugEnterCode(this.parent, this.tm.getFileName()));
    }

    public static String getDebugEnterCode(Pcc pcc, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("         Debugger.enterProgram (\"");
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        stringBuffer.append(Pcc.escapeString(string2));
        stringBuffer.append("\", ");
        if (pcc.getSplitFlag()) {
            stringBuffer.append(pcc.getClassName() + ".");
        }
        stringBuffer.append("this );");
        return stringBuffer.toString();
    }

    public static void getDebugExitCode(StringBuffer stringBuffer) {
        stringBuffer.append(ProcedureDivision.getDebugExitCode());
    }

    public static String getDebugExitCode() {
        return "   Debugger.exitProgram ();";
    }

    void getThrows(StringBuffer stringBuffer) {
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public VariableName getReturning() {
        return this.returning;
    }

    @Override
    public VariableNameList getUsing() {
        return this.using;
    }

    @Override
    public String getServiceBridgeOperation() {
        return this.serviceBridgeOperation;
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public int getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public Set getByValueParameters() {
        return this.byValueVars;
    }

    @Override
    public VariableNameList getChaining() {
        return this.chaining;
    }
}

