/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Raise
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName exception;

    public Raise(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.exception = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.exception == null) {
            throw new GeneralErrorException(17, 4, this.keyWord, "", this.error);
        }
        if (!this.exception.getType().isAssignableTo(Throwable.class) || this.exception.getVarDecl().isFactory) {
            throw new GeneralErrorException(75, 4, this.keyWord, this.exception.getType().getName(), this.error);
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(this.parent.getIndent()).append("if (true) throw ").append(this.exception.getCode()).append(";").append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

