/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AtEnd;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Read
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static final int L_NO_LOCK = 0;
    private static final int L_IGNORE_LOCK = 1;
    private static final int L_LOCK = 2;
    private static final int L_KEPT_LOCK = 3;
    private static final int L_WAIT_LOCK = 4;
    private Select sel;
    private InvalidKey invKey;
    private AtEnd atEnd;
    private VariableName keyName;
    private VariableDeclaration[] key;
    private VariableName into;
    private VariableName size;
    private int type = 0;
    private int lock = 0;
    private final boolean optionCRLK = this.pc.getOption("-crlk") != null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Read(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(token2.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.sel.isXml()) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 595) {
                this.type = 595;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 670) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() != 551) {
                    throw new ExpectedFoundException(token2, this.error, "KEY");
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() == 545) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() != 10009) {
                    throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 643 || token2.getToknum() == 297) {
            this.type = 643;
            token2 = this.tm.getToken();
        } else if (token2.getToknum() == 595) {
            this.type = 595;
            token2 = this.tm.getToken();
        } else if (this.sel.accessMode == 717) {
            this.type = 595;
        }
        if (token2.getToknum() == 670 || token2.getToknum() == 672) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 542) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 813 || token2.getToknum() == 570 || token2.getToknum() == 596 || token2.getWord().equals("IGNORE") || token2.getToknum() == 550 || token2.getWord().equals("WAIT")) {
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 550) {
                this.lock = 3;
                token2 = this.tm.getToken();
            } else if (token2.getToknum() == 596) {
                this.lock = 0;
                token2 = this.tm.getToken();
            } else if (token2.getWord().equals("IGNORE")) {
                this.lock = 1;
                token2 = this.tm.getToken();
            } else if (token2.getWord().equals("WAIT")) {
                this.lock = 4;
                token2 = this.tm.getToken();
            } else {
                this.lock = 2;
            }
            if (token2.getToknum() != 570) {
                if (this.lock != 4) {
                    throw new ExpectedFoundException(token2, this.error, "LOCK");
                }
            } else {
                token2 = this.tm.getToken();
            }
        } else if (token2.getToknum() == 264) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 794) throw new ExpectedFoundException(token2, this.error, "UPDATERS");
            token2 = this.tm.getToken();
            this.lock = 0;
        } else if (this.sel.getLockMode(0) == 290) {
            this.lock = 2;
        }
        if (token2.getToknum() == 542) {
            if (this.into != null) {
                throw new GeneralErrorException(91, 4, token2, "INTO", this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 551) {
            if (this.type == 595 || this.type == 643) {
                throw new ClauseClashException(token2, this.error, token2.getWord());
            }
            if (this.sel.organization != 529) {
                throw new ClauseClashException(token2, this.error, token2.getWord());
            }
            this.type = 551;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 545) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            this.tm.ungetToken();
            this.keyName = VariableName.get(this.tm, this.error);
            this.key = this.sel.getKeyByName(this.keyName.getName());
            if (this.key == null) {
                this.keyName.check(this.pc);
                VariableDeclaration variableDeclaration = this.keyName.getVarDecl().getGrandPa();
                FileDescriptor fileDescriptor = this.pc.getFdByRecord(this.keyName.getVarDecl().getGrandPa());
                if (fileDescriptor != null) {
                    this.key = this.sel.getKeyByOffset(this.keyName.getVarDecl().getOffset());
                }
            }
            if (this.key == null) {
                throw new GeneralErrorException(56, 4, this.keyWord, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 542) {
            if (this.into != null) {
                throw new GeneralErrorException(91, 4, token2, "INTO", this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 728) {
            if (this.sel.organization != 717) {
                throw new ClauseClashException(this.keyWord, this.error, token2.getWord());
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.size = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
        } else {
            try {
                this.size = this.sel.getFD().getDepending();
            }
            catch (NullPointerException nullPointerException) {
                this.size = null;
            }
        }
        if (token2.getToknum() == 598) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 284 || token2.getToknum() == 422) {
                if (this.type == 551) {
                    throw new ClauseClashException(token2, this.error, token2.getWord());
                }
                if (this.type != 643) {
                    this.type = 595;
                }
                this.tm.ungetToken();
                this.tm.ungetToken();
                this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            } else {
                if (token2.getToknum() != 543) throw new UnexpectedTokenException(token2, this.error);
                if (this.type == 643 || this.type == 595) {
                    throw new ClauseClashException(token2, this.error, token2.getWord());
                }
                this.type = 551;
                this.tm.ungetToken();
                this.tm.ungetToken();
                this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            }
        } else if (token2.getToknum() == 284 || token2.getToknum() == 422) {
            this.tm.ungetToken();
            if (this.type == 551) {
                throw new ClauseClashException(token2, this.error, token2.getWord());
            }
            if (this.type != 643) {
                this.type = 595;
            }
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        } else if (token2.getToknum() == 543) {
            if (this.type == 643 || this.type == 595) {
                throw new ClauseClashException(token2, this.error, token2.getWord());
            }
            this.type = 551;
            this.tm.ungetToken();
            this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        if (this.type == 551 && this.sel.accessMode == 717 || (this.type == 595 || this.type == 643) && this.sel.accessMode == 664) {
            throw new ClauseClashException(this.keyWord, this.error, token2.getWord());
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 441) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
        if (this.type != 0) return;
        if (this.sel.accessMode == 717) {
            this.type = 595;
            return;
        } else {
            if (this.sel.accessMode != 664 && this.sel.accessMode != 414) return;
            this.type = 551;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getLock(boolean bl) {
        switch (this.lock) {
            case 0: {
                return "CobolFile.READ_NO_LOCK";
            }
            case 1: {
                return "CobolFile.READ_IGNORE";
            }
            case 2: {
                if (this.optionCRLK && !bl) {
                    return "CobolFile.READ_WAIT";
                }
                return "CobolFile.READ_LOCK";
            }
            case 3: {
                return "CobolFile.READ_KEPT";
            }
            case 4: {
                return "CobolFile.READ_WAIT";
            }
        }
        throw new InternalErrorException("Unknown lock mode:" + this.lock);
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (this.invKey != null) {
            stringBuffer.append(this.invKey.getCodeBefore());
        } else if (this.atEnd != null) {
            stringBuffer.append(this.atEnd.getCodeBefore());
        }
        if (this.size != null) {
            stringBuffer.append(this.size.getCode());
            stringBuffer.append(".set(");
        }
        stringBuffer.append(this.sel.getName());
        if (this.sel.isXml()) {
            stringBuffer.append(".readXml(");
            if (this.keyName != null) {
                stringBuffer.append(this.keyName.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(");");
            Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
            Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), bl);
        } else {
            if (this.type == 551) {
                stringBuffer.append(".readKey(");
                if (this.key == null && this.sel.organization == 529) {
                    this.key = this.sel.getPrimaryKey();
                }
                if (this.key != null) {
                    stringBuffer.append("new CobolVar[] {");
                    int n2 = 0;
                    while (true) {
                        stringBuffer.append(this.key[n2].getQualUnivoqueName());
                        if (++n2 >= this.key.length) break;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("},");
                } else {
                    stringBuffer.append("null,");
                }
            } else if (this.type == 643) {
                stringBuffer.append(".readPrev(");
            } else {
                stringBuffer.append(".readNext(");
            }
            stringBuffer.append(this.getLock(bl));
            stringBuffer.append(",");
            if (this.into != null) {
                stringBuffer.append(this.into.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(")");
            if (this.size != null) {
                stringBuffer.append(")");
            }
            stringBuffer.append(";");
            Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
            if (this.invKey != null) {
                stringBuffer.append(this.invKey.getCode());
            } else if (this.atEnd != null) {
                stringBuffer.append(this.atEnd.getCode());
            }
            Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), bl);
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public Select getSelect() {
        return this.sel;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }

    public AtEnd getAtEnd() {
        return this.atEnd;
    }

    public VariableName getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public VariableDeclaration[] getKey() {
        return this.key;
    }

    public int getLockRaw() {
        return this.lock;
    }

    public VariableName getInto() {
        return this.into;
    }
}

