/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Release
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final VariableName recName;
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Release(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.recName = VariableName.get(this.tm, this.error, this.pc);
        this.record = this.recName.getVarDecl();
        this.fd = this.pc.getFdByRecord(this.record);
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (!this.fd.isSort()) {
            throw new GeneralErrorException(104, 4, token2, this.fd.sel.fileName.getWord(), this.error);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 498) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                if (token2.getToknum() != 10001 && token2.getToknum() != 10002 && token2.getToknum() != 10017) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                this.fromToken = token2;
            }
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        if (this.fromVar != null || this.fromToken != null) {
            stringBuffer.append(this.parent.getIndent());
            if (this.fromVar != null) {
                stringBuffer.append(this.fromVar.getCode());
            } else {
                stringBuffer.append(this.getCodeLiteral(this.fromToken));
            }
            stringBuffer.append(".moveTo(");
            stringBuffer.append(this.record.getQualUnivoqueName());
            stringBuffer.append(");");
            stringBuffer.append(eol);
        }
        if (this.tm.getOptionList().getOption("-cv") != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if (" + this.getLocalVar("SORT-RETURN") + ".toint()==16) throw new SortAbort();");
            stringBuffer.append(eol);
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append(this.fd.sel.getName());
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            stringBuffer.append(".releaseRecord(" + this.recName.getCode() + ".length());");
        } else {
            stringBuffer.append(".releaseSort();");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }
}

