/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportDescriptor;
import java.util.List;
import java.util.Vector;

public class ReportDescriptor
implements CobolToken,
ErrorsNumbers,
IReportDescriptor {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    final Token reportName;
    final VariableName reportVar;
    final ReportSection repoSec;
    final VariableDeclaration vParent;
    final VariableDeclaration lineCnt;
    final VariableDeclaration pageCnt;
    final VariableDeclaration printSw;
    FileDescriptor fd;
    private boolean isGlobal;
    private boolean isControlsFinal;
    private Vector controls = new Vector();
    public final int pageLimit;
    private int lineLimit;
    private int maxLen;
    private int heading;
    private int firstDetail;
    private int lastDetail;
    final int footing;
    private Vector<ReportGroup> reportGroups = new Vector();

    public ReportDescriptor(ReportSection reportSection, Token token, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        int n2 = 0;
        int n3 = 0;
        this.repoSec = reportSection;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.reportName = token;
        this.tm.ungetToken();
        this.reportVar = VariableName.get(this.tm, this.error);
        this.vParent = VariableDeclaration.getGroup01(this.pc, this.tm, this.reportName);
        this.vParent.setUsed();
        token = new Token(10009, "LINE-COUNTER", 0, 0, this.tm.getFileName());
        this.lineCnt = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, token, false);
        this.lineCnt.setUsed();
        this.lineCnt.level = 2;
        this.lineCnt.parent = this.vParent;
        this.vParent.addChild(this.lineCnt);
        this.pc.loadVariable(this.lineCnt);
        token = new Token(10009, "PAGE-COUNTER", 0, 0, this.tm.getFileName());
        this.pageCnt = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, token, false);
        this.pageCnt.setUsed();
        this.pageCnt.level = 2;
        this.pageCnt.parent = this.vParent;
        this.vParent.addChild(this.pageCnt);
        this.pc.loadVariable(this.pageCnt);
        token = new Token(10009, "PRINT-SWITCH", 0, 0, this.tm.getFileName());
        this.printSw = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, token, false);
        this.printSw.setUsed();
        this.printSw.level = 2;
        this.printSw.parent = this.vParent;
        this.vParent.addChild(this.printSw);
        this.pc.loadVariable(this.printSw);
        block14: while ((token = this.tm.getToken()).getToknum() != 10006) {
            switch (token.getToknum()) {
                case 545: {
                    continue block14;
                }
                case 502: {
                    this.isGlobal = true;
                    continue block14;
                }
                case 373: 
                case 374: {
                    VariableName variableName;
                    Token token2 = this.tm.getToken();
                    if (token2.getToknum() == 545 || token2.getToknum() == 277) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() == 487) {
                        this.isControlsFinal = true;
                    } else {
                        this.tm.ungetToken();
                    }
                    while ((variableName = VariableName.get(this.tm, this.error)) != null) {
                        this.controls.add(variableName);
                    }
                    if (this.isControlsFinal || this.controls.size() != 0) continue block14;
                    throw new GeneralErrorException(29, 4, token, token.getWord(), this.error);
                }
                case 565: {
                    this.lineLimit();
                    continue block14;
                }
                case 629: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 562 || token.getToknum() == 563) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545 || token.getToknum() == 277) {
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    n2 = token.longValue();
                    if (n2 <= 0) {
                        throw new GeneralErrorException(30, 4, token, token.getWord(), this.error);
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() != 565 && token.getToknum() != 566) {
                        this.tm.ungetToken();
                    }
                    block16: while ((token = this.tm.getToken()).getToknum() != 10006) {
                        switch (token.getToknum()) {
                            case 511: {
                                token = this.tm.getToken();
                                if (token.getToknum() == 545) {
                                    token = this.tm.getToken();
                                }
                                if (!Token.isIntLit(token)) {
                                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                                }
                                this.heading = token.longValue();
                                if (this.heading >= 1) continue block16;
                                throw new GeneralErrorException(30, 4, token, token.getWord(), this.error);
                            }
                            case 489: {
                                token = this.tm.getToken();
                                if (token.getToknum() != 404) {
                                    throw new ExpectedFoundException(token, this.error, "DETAIL");
                                }
                                token = this.tm.getToken();
                                if (token.getToknum() == 545) {
                                    token = this.tm.getToken();
                                }
                                if (!Token.isIntLit(token)) {
                                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                                }
                                this.firstDetail = token.longValue();
                                continue block16;
                            }
                            case 554: {
                                token = this.tm.getToken();
                                if (token.getToknum() != 404) {
                                    throw new ExpectedFoundException(token, this.error, "DETAIL");
                                }
                                token = this.tm.getToken();
                                if (token.getToknum() == 545) {
                                    token = this.tm.getToken();
                                }
                                if (!Token.isIntLit(token)) {
                                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                                }
                                this.lastDetail = token.longValue();
                                continue block16;
                            }
                            case 493: {
                                token = this.tm.getToken();
                                if (token.getToknum() == 545) {
                                    token = this.tm.getToken();
                                }
                                if (!Token.isIntLit(token)) {
                                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                                }
                                n3 = token.longValue();
                                continue block16;
                            }
                            case 565: {
                                this.lineLimit();
                                continue block16;
                            }
                        }
                    }
                    this.tm.ungetToken();
                    continue block14;
                }
            }
            throw new UnexpectedTokenException(token, errors);
        }
        this.pageLimit = n2;
        this.footing = n3;
        while ((token = this.tm.getToken()).getToknum() == 10002 && token.longValue() == 1) {
            ReportGroup reportGroup = new ReportGroup(this, token, this.pc, this.tm, this.error);
            this.reportGroups.add(reportGroup);
        }
        this.tm.ungetToken();
    }

    void lineLimit() throws EndOfProgramException, GeneralErrorException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 562 || token.getToknum() == 563) {
            token = this.tm.getToken();
        }
        if (token.getToknum() == 545 || token.getToknum() == 277) {
            token = this.tm.getToken();
        }
        if (!Token.isIntLit(token)) {
            throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
        }
        this.lineLimit = token.longValue();
        if (this.lineLimit <= 0) {
            throw new GeneralErrorException(30, 4, token, token.getWord(), this.error);
        }
    }

    ReportGroup getDetail(Token token) throws GeneralErrorException {
        ReportGroup reportGroup = this.getReportGroup(token);
        if (reportGroup != null) {
            if (reportGroup.type == 4) {
                return reportGroup;
            }
            throw new GeneralErrorException(182, 4, token, token.getWord(), this.error);
        }
        return null;
    }

    ReportGroup getReportGroup(Token token) {
        String string = token.getWord();
        for (int i2 = this.reportGroups.size() - 1; i2 >= 0; --i2) {
            ReportGroup reportGroup = this.reportGroups.elementAt(i2);
            if (reportGroup.getName() == null || !string.equals(reportGroup.getName().getWord())) continue;
            return reportGroup;
        }
        return null;
    }

    public void check() throws GeneralErrorException {
        int n2;
        for (n2 = this.controls.size() - 1; n2 >= 0; --n2) {
            VariableName variableName = (VariableName)this.controls.elementAt(n2);
            variableName.check(this.pc);
            variableName.getVarDecl().setUsed();
        }
        for (n2 = this.reportGroups.size() - 1; n2 >= 0; --n2) {
            ReportGroup reportGroup = this.reportGroups.elementAt(n2);
            reportGroup.check();
        }
        this.fd = this.pc.getFdByReport(this.reportName.getWord());
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.reportName, this.reportName.getWord(), this.error);
        }
        this.fd.defineReportVar(this.reportName, this.maxLen);
        if (this.pageLimit > 0) {
            int n3;
            n2 = this.pageLimit;
            int n4 = this.footing > 0 ? this.footing : n2;
            int n5 = this.lastDetail > 0 ? this.lastDetail : n4;
            int n6 = this.firstDetail > 0 ? this.firstDetail : n5;
            int n7 = n3 = this.heading > 0 ? this.heading : n6;
            if (n4 > n2) {
                throw new GeneralErrorException(30, 4, this.reportName, "FOOTING " + n4, this.error);
            }
            if (n5 > n4) {
                throw new GeneralErrorException(30, 4, this.reportName, "LAST DETAIL " + n5, this.error);
            }
            if (n6 > n5) {
                throw new GeneralErrorException(30, 4, this.reportName, "FIRST DETAIL " + n6, this.error);
            }
            if (n3 > n6) {
                throw new GeneralErrorException(30, 4, this.reportName, "HEADING " + n3, this.error);
            }
        }
    }

    @Override
    public String getName() {
        return "rw$" + this.reportName.getCode();
    }

    @Override
    public Token getTokenName() {
        return this.reportName;
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* isGlobal = " + this.isGlobal + " */" + eol);
        stringBuffer2.append(this.tm.getCommentCode(this.reportName, "   "));
        stringBuffer2.append("   ReportWriter ");
        stringBuffer2.append(this.getName());
        stringBuffer2.append(";");
        stringBuffer2.append(eol);
        this.lineCnt.parent = null;
        stringBuffer2.append(this.lineCnt.getCode(stringBuffer));
        this.pageCnt.parent = null;
        stringBuffer2.append(this.pageCnt.getCode(stringBuffer));
        this.printSw.parent = null;
        stringBuffer2.append(this.printSw.getCode(stringBuffer));
        stringBuffer.append(this.getName());
        stringBuffer.append("=new ReportWriter (");
        stringBuffer.append(this.lineLimit > 0 && this.lineLimit < this.maxLen ? this.lineLimit : this.maxLen);
        stringBuffer.append(");");
        stringBuffer.append(eol);
        if (this.pageLimit > 0 || this.controls.size() > 0) {
            stringBuffer.append(this.getName());
            for (int i2 = 0; i2 < this.controls.size(); ++i2) {
                stringBuffer.append(".setControl(");
                stringBuffer.append(((VariableName)this.controls.elementAt(i2)).getCode());
                stringBuffer.append(")");
            }
            if (this.pageLimit > 0) {
                stringBuffer.append(".setPage(");
                stringBuffer.append(this.pageLimit);
                stringBuffer.append(")");
                if (this.heading > 0) {
                    stringBuffer.append(".setHeading(");
                    stringBuffer.append(this.heading);
                    stringBuffer.append(")");
                }
                if (this.firstDetail > 0) {
                    stringBuffer.append(".setFirstDetail(");
                    stringBuffer.append(this.firstDetail);
                    stringBuffer.append(")");
                }
                if (this.lastDetail > 0) {
                    stringBuffer.append(".setLastDetail(");
                    stringBuffer.append(this.lastDetail);
                    stringBuffer.append(")");
                }
                if (this.footing > 0) {
                    stringBuffer.append(".setFooting(");
                    stringBuffer.append(this.footing);
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append(";");
            stringBuffer.append(eol);
        }
        for (int i3 = 0; i3 < this.reportGroups.size(); ++i3) {
            ReportGroup reportGroup = this.reportGroups.elementAt(i3);
            stringBuffer2.append(reportGroup.getCode(stringBuffer));
        }
        return stringBuffer2.toString();
    }

    void setLen(int n2) {
        if (n2 > this.maxLen) {
            this.maxLen = n2;
        }
    }

    @Override
    public int getLen() {
        return this.maxLen;
    }

    boolean isControl(VariableName variableName) {
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        for (int i2 = this.controls.size() - 1; i2 >= 0; --i2) {
            if (((VariableName)this.controls.elementAt(i2)).getVarDecl() != variableDeclaration) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableDeclaration getLineCountVariable() {
        this.lineCnt.parent = null;
        return this.lineCnt;
    }

    @Override
    public VariableDeclaration getPageCountVariable() {
        this.pageCnt.parent = null;
        return this.pageCnt;
    }

    @Override
    public VariableDeclaration getPrintSwitchVariable() {
        this.printSw.parent = null;
        return this.printSw;
    }

    @Override
    public VariableDeclaration getVirtualParent() {
        return this.vParent;
    }

    @Override
    public List<ReportGroup> getReportGroups() {
        return this.reportGroups;
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    @Override
    public int getHeading() {
        return this.heading;
    }

    @Override
    public int getFirstDetail() {
        return this.firstDetail;
    }

    @Override
    public int getLastDetail() {
        return this.lastDetail;
    }

    @Override
    public int getFooting() {
        return this.footing;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fd;
    }
}

