/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportVariable;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportGroup;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportGroup
implements CobolToken,
ErrorsNumbers,
IReportGroup {
    public static final int TYPE_REPORT_HEADING = 1;
    public static final int TYPE_PAGE_HEADING = 2;
    public static final int TYPE_CONTROL_HEADING = 3;
    public static final int TYPE_DETAIL = 4;
    public static final int TYPE_CONTROL_FOOTING = 5;
    public static final int TYPE_PAGE_FOOTING = 6;
    public static final int TYPE_REPORT_FOOTING = 7;
    public static final int LINE_MASK = 0xFFFFFFF;
    public static final int LINE_PLUS = 0x10000000;
    public static final int LINE_PAGE = 0x20000000;
    public final ReportDescriptor rd;
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private int currColumn = 1;
    private int currLine = 1;
    private Token name;
    final int prog;
    final int type;
    private VariableName control;
    private int line;
    private int nextGroup;
    private Vector<ReportVariable> children = new Vector();
    Use use;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportGroup(ReportDescriptor reportDescriptor, Token token, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        int n2 = 0;
        this.rd = reportDescriptor;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        token = this.tm.getToken();
        if (token.getToknum() == 10009) {
            this.name = token;
            this.prog = this.rd.repoSec.checkGroupName(this.name.getWord());
        } else {
            this.name = null;
            this.prog = 0;
            this.tm.ungetToken();
        }
        block11: while ((token = this.tm.getToken()).getToknum() != 10006) {
            switch (token.getToknum()) {
                case 565: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 602) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 595) {
                        token = this.tm.getToken();
                        if (token.getToknum() != 629) throw new ExpectedFoundException(token, this.error, "PAGE");
                        this.line = 0x20000001;
                        continue block11;
                    }
                    boolean bl = false;
                    if (token.getToknum() == 637) {
                        bl = true;
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    this.line = token.longValue();
                    if (bl) {
                        this.line |= 0x10000000;
                        continue block11;
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 613 || token.getToknum() == 595) {
                        if (token.getToknum() == 613 && (token = this.tm.getToken()).getToknum() != 595) {
                            throw new ExpectedFoundException(token, this.error, "NEXT");
                        }
                        token = this.tm.getToken();
                        if (token.getToknum() != 629) {
                            throw new ExpectedFoundException(token, this.error, "PAGE");
                        }
                        this.line |= 0x20000000;
                        continue block11;
                    }
                    this.tm.ungetToken();
                    continue block11;
                }
                case 595: {
                    token = this.tm.getToken();
                    if (!token.getWord().equals("GROUP")) {
                        throw new ExpectedFoundException(token, this.error, "GROUP");
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 595) {
                        token = this.tm.getToken();
                        if (token.getToknum() != 629) throw new ExpectedFoundException(token, this.error, "PAGE");
                        if ((this.line & 0x10000000) != 0) {
                            this.nextGroup = this.line | 0x20000000;
                            continue block11;
                        }
                        this.nextGroup = 0x20000001;
                        continue block11;
                    }
                    boolean bl = false;
                    if (token.getToknum() == 637) {
                        bl = true;
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    this.nextGroup = token.longValue();
                    if (bl) {
                        this.nextGroup |= 0x10000000;
                        continue block11;
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 613 || token.getToknum() == 595) {
                        if (token.getToknum() == 613 && (token = this.tm.getToken()).getToknum() != 595) {
                            throw new ExpectedFoundException(token, this.error, "NEXT");
                        }
                        token = this.tm.getToken();
                        if (token.getToknum() != 629) {
                            throw new ExpectedFoundException(token, this.error, "PAGE");
                        }
                        this.nextGroup |= 0x20000000;
                        continue block11;
                    }
                    this.tm.ungetToken();
                    continue block11;
                }
                case 781: {
                    String string;
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if ((string = token.getWord()).length() == 2) {
                        if (string.equals("RH")) {
                            n2 = 1;
                        } else if (string.equals("RF")) {
                            n2 = 7;
                        } else if (string.equals("PH")) {
                            n2 = 2;
                        } else if (string.equals("PF")) {
                            n2 = 6;
                        } else if (string.equals("CH")) {
                            n2 = 3;
                        } else if (string.equals("CF")) {
                            n2 = 5;
                        } else {
                            if (!string.equals("DE")) throw new UnexpectedTokenException(token, errors);
                            n2 = 4;
                        }
                    } else {
                        switch (token.getToknum()) {
                            case 684: {
                                token = this.tm.getToken();
                                if (token.getToknum() == 511) {
                                    n2 = 1;
                                    break;
                                }
                                if (token.getToknum() != 493) throw new UnexpectedTokenException(token, errors);
                                n2 = 7;
                                break;
                            }
                            case 629: {
                                token = this.tm.getToken();
                                if (token.getToknum() == 511) {
                                    n2 = 2;
                                    break;
                                }
                                if (token.getToknum() != 493) throw new UnexpectedTokenException(token, errors);
                                n2 = 6;
                                break;
                            }
                            case 373: {
                                token = this.tm.getToken();
                                if (token.getToknum() == 511) {
                                    n2 = 3;
                                    break;
                                }
                                if (token.getToknum() != 493) throw new UnexpectedTokenException(token, errors);
                                n2 = 5;
                                break;
                            }
                            case 404: {
                                n2 = 4;
                                break;
                            }
                            default: {
                                throw new UnexpectedTokenException(token, errors);
                            }
                        }
                    }
                    if (this.rd.pageLimit == 0 && (n2 == 2 || n2 == 6)) {
                        throw new GeneralErrorException(187, 4, token, token.getWord(), this.error);
                    }
                    if (this.rd.footing == 0 && n2 == 6) {
                        throw new GeneralErrorException(187, 4, token, token.getWord(), this.error);
                    }
                    if (n2 != 3 && n2 != 5 || (token = this.tm.getToken()).getToknum() == 487) continue block11;
                    if (token.getToknum() != 10009) throw new UnexpectedTokenException(token, errors);
                    this.tm.ungetToken();
                    this.control = VariableName.get(this.tm, this.error);
                    if (this.control != null) continue block11;
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
            }
            throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
        }
        this.type = n2;
        while ((token = this.tm.getToken()).getToknum() == 10002 && token.longValue() > 1) {
            this.tm.ungetToken();
            this.children.add(new ReportVariable(this.rd, this, this.pc, this.tm, this.error));
        }
        this.tm.ungetToken();
    }

    int getDataMapSize() {
        int n2 = 0;
        for (ReportVariable reportVariable : this.children) {
            VariableDeclaration variableDeclaration = reportVariable.getCobVar();
            if (variableDeclaration == null) continue;
            n2 += variableDeclaration.getPhisicLen();
        }
        return n2;
    }

    StringBuffer getLineDatamap(String string) {
        VariableDeclaration variableDeclaration;
        String string2 = " ";
        StringBuffer stringBuffer = new StringBuffer("*>");
        String string3 = "" + this.name.getFLN();
        VariableDeclaration.fillNum(stringBuffer, 9 - string3.length());
        stringBuffer.append(string3 + " " + this.name.getWord());
        if (stringBuffer.length() > 72) {
            stringBuffer.delete(72, stringBuffer.length());
        }
        VariableDeclaration.fillSpace(stringBuffer, 73 - stringBuffer.length());
        string3 = "";
        VariableDeclaration.fillNum(stringBuffer, 9 - string3.length());
        stringBuffer.append(string3 + " ");
        int n2 = 0;
        String string4 = "E";
        for (ReportVariable reportVariable : this.children) {
            variableDeclaration = reportVariable.getCobVar();
            if (variableDeclaration == null) continue;
            n2 += variableDeclaration.getPhisicLen();
            string4 = "G";
        }
        string3 = "" + n2;
        VariableDeclaration.fillNum(stringBuffer, 9 - string3.length());
        stringBuffer.append(string3 + " RD " + string4 + "   ");
        VariableDeclaration.fillSpace(stringBuffer, 119 - stringBuffer.length());
        stringBuffer.append("      ");
        stringBuffer.append(eol);
        for (ReportVariable reportVariable : this.children) {
            variableDeclaration = reportVariable.getCobVar();
            if (variableDeclaration == null) continue;
            variableDeclaration.getLineDatamap(stringBuffer, "RD", "  ", string);
        }
        return stringBuffer;
    }

    void writeExtDatamap(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = VariableDeclaration.appendFieldElement(document, element);
        VariableDeclaration.appendElement(document, element2, "name", this.name.getWord());
        int n2 = 0;
        boolean bl = true;
        for (ReportVariable object : this.children) {
            VariableDeclaration variableDeclaration = object.getCobVar();
            if (variableDeclaration == null) continue;
            n2 += variableDeclaration.getPhisicLen();
            bl = false;
        }
        VariableDeclaration.appendElement(document, element2, "physicalLength", String.valueOf(n2));
        VariableDeclaration.appendElement(document, element2, "location", "RD");
        if (!bl) {
            VariableDeclaration.appendElement(document, element2, "group", "yes");
        } else {
            VariableDeclaration.appendElement(document, element2, "elementary", "yes");
        }
        if (this.name.getFileIndex() > 0) {
            VariableDeclaration.appendElement(document, element2, "copyFile", this.name.getFileName());
            String string = ((PreProcessor)this.tm.getAllPreProcessors().elementAt(this.name.getFileIndex())).getReplacingString();
            if (string != null) {
                VariableDeclaration.appendElement(document, element2, "copyReplacing", string);
            }
        }
        boolean bl2 = this.pc.getOption("-m1") != null;
        for (ReportVariable reportVariable : this.children) {
            VariableDeclaration variableDeclaration = reportVariable.getCobVar();
            if (variableDeclaration == null) continue;
            variableDeclaration.writeExtDatamap(element, "RD", bl2);
        }
    }

    public void check() throws GeneralErrorException {
        if (this.control != null) {
            this.control.check(this.pc);
            if (!this.rd.isControl(this.control)) {
                throw new GeneralErrorException(185, 4, this.control.name, this.control.name.getWord(), this.error);
            }
        }
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            this.children.elementAt(i2).check();
        }
    }

    private void newCode(StringBuffer stringBuffer) {
        stringBuffer.append("new ReportGroup (");
        if (this.use != null) {
            stringBuffer.append("this,");
            stringBuffer.append(this.use.parag.getIdNumber());
            stringBuffer.append(",");
            stringBuffer.append(this.use.parag.getLastParagraphInSameSection().getIdNumber());
        }
        stringBuffer.append(")");
    }

    private void stdargs(StringBuffer stringBuffer) {
        if (this.name != null) {
            stringBuffer.append(this.getUnivoqueName());
        } else {
            this.newCode(stringBuffer);
        }
        stringBuffer.append(",");
        stringBuffer.append(this.line);
        stringBuffer.append(",0x");
        stringBuffer.append(Integer.toHexString(this.nextGroup));
    }

    @Override
    public Token getName() {
        return this.name;
    }

    public String getUnivoqueName() {
        String string;
        if (this.name == null) {
            string = null;
        } else {
            string = this.name.getCode();
            if (this.prog != 0) {
                string = string + (Pcc.identifierSep + this.prog);
            }
        }
        return string;
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.name != null) {
            stringBuffer2.append("   ReportGroup ");
            stringBuffer2.append(this.getUnivoqueName());
            stringBuffer2.append(" = ");
            this.newCode(stringBuffer2);
            stringBuffer2.append(";");
            stringBuffer2.append(eol);
        }
        stringBuffer.append(this.rd.getName());
        switch (this.type) {
            case 1: {
                stringBuffer.append(".setReportHeading(");
                this.stdargs(stringBuffer);
                break;
            }
            case 7: {
                stringBuffer.append(".setReportFooting(");
                this.stdargs(stringBuffer);
                break;
            }
            case 2: {
                stringBuffer.append(".setPageHeading(");
                this.stdargs(stringBuffer);
                break;
            }
            case 6: {
                stringBuffer.append(".setPageFooting(");
                this.stdargs(stringBuffer);
                break;
            }
            case 3: {
                stringBuffer.append(".setControlHeading(");
                this.stdargs(stringBuffer);
                stringBuffer.append(",");
                if (this.control != null) {
                    stringBuffer.append(this.control.getCode());
                    break;
                }
                stringBuffer.append("null");
                break;
            }
            case 5: {
                stringBuffer.append(".setControlFooting(");
                this.stdargs(stringBuffer);
                stringBuffer.append(",");
                if (this.control != null) {
                    stringBuffer.append(this.control.getCode());
                    break;
                }
                stringBuffer.append("null");
                break;
            }
            case 4: {
                stringBuffer.append(".setDetail(");
                this.stdargs(stringBuffer);
                break;
            }
            default: {
                throw new InternalErrorException("REPORT VAR TYPE UNKNOWN " + this.type);
            }
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            stringBuffer2.append(this.children.elementAt(i2).getCode(stringBuffer));
        }
        return stringBuffer2.toString();
    }

    boolean setColumn(int n2) {
        if (n2 > 0) {
            if (n2 > this.currColumn) {
                this.currColumn = n2;
            }
            this.rd.setLen(this.currColumn - 1);
            return false;
        }
        return true;
    }

    @Override
    public int getColumn() {
        return this.currColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean setLine(int n2) {
        if (n2 < 0) {
            return true;
        }
        if ((n2 & 0x10000000) > 0) {
            if ((n2 & 0xFFFFFFF) <= 0) return false;
            this.currLine += n2 & 0xFFFFFFF;
            this.currColumn = 1;
            return false;
        } else if ((n2 & 0x20000000) > 0) {
            this.currColumn = 1;
            if ((n2 & 0xFFFFFFF) <= 0) return true;
            this.currLine = n2 & 0xFFFFFFF;
            return false;
        } else {
            if (n2 <= 0) return true;
            if (n2 <= this.currLine) return false;
            this.currLine = n2;
            this.currColumn = 1;
        }
        return false;
    }

    @Override
    public List<ReportVariable> getChildren() {
        return this.children;
    }

    @Override
    public ReportDescriptor getReportDescriptor() {
        return this.rd;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getNextGroup() {
        return this.nextGroup;
    }

    public Use getUse() {
        return this.use;
    }

    @Override
    public VariableName getControl() {
        return this.control;
    }
}

