/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IReportSection;
import com.iscobol.interfaces.compiler.IToken;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class ReportSection
implements CobolToken,
ErrorsNumbers,
IReportSection {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private Vector rdList = new Vector();
    private Hashtable allGroups = new Hashtable();
    private Token firstToken;
    private Token lastToken;

    public ReportSection(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        Token token = null;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        this.firstToken = token = this.tm.getToken();
        if (token.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token, "'.'");
                this.tm.ungetToken();
            }
            while ((token = this.tm.getToken()).getToknum() == 665) {
                this.rdList.add(new ReportDescriptor(this, token, pcc, tokenManager, errors));
            }
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        this.tm.ungetToken();
        this.lastToken = token;
        this.pc.addImport("import com.iscobol.report.*;");
    }

    void check() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = this.rdList.size() - 1; i2 >= 0; --i2) {
            ReportDescriptor reportDescriptor = (ReportDescriptor)this.rdList.elementAt(i2);
            try {
                reportDescriptor.check();
                if (hashSet.add(reportDescriptor.getName())) continue;
                throw new GeneralErrorException(91, 4, reportDescriptor.getTokenName(), "RD", this.error);
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
        }
    }

    @Override
    public ReportDescriptor getReport(IToken iToken) throws GeneralErrorException {
        if (!(iToken instanceof Token)) {
            throw new IllegalArgumentException("" + iToken);
        }
        return this.getReport((Token)iToken);
    }

    public ReportDescriptor getReport(Token token) throws GeneralErrorException {
        ReportDescriptor reportDescriptor = null;
        String string = token.getWord();
        for (int i2 = this.rdList.size() - 1; i2 >= 0; --i2) {
            ReportDescriptor reportDescriptor2 = (ReportDescriptor)this.rdList.elementAt(i2);
            if (!string.equals(reportDescriptor2.reportName.getWord())) continue;
            if (reportDescriptor == null) {
                reportDescriptor = reportDescriptor2;
                continue;
            }
            throw new GeneralErrorException(36, 4, token, token.getWord(), this.error);
        }
        return reportDescriptor;
    }

    @Override
    public ReportGroup getReportGroup(IToken iToken) throws GeneralErrorException {
        if (!(iToken instanceof Token)) {
            throw new IllegalArgumentException("" + iToken);
        }
        return this.getReportGroup((Token)iToken);
    }

    public ReportGroup getReportGroup(Token token) throws GeneralErrorException {
        ReportGroup reportGroup = null;
        for (int i2 = this.rdList.size() - 1; i2 >= 0; --i2) {
            ReportDescriptor reportDescriptor = (ReportDescriptor)this.rdList.elementAt(i2);
            ReportGroup reportGroup2 = reportDescriptor.getReportGroup(token);
            if (reportGroup2 == null) continue;
            if (reportGroup == null) {
                reportGroup = reportGroup2;
                continue;
            }
            throw new GeneralErrorException(36, 4, token, token.getWord(), this.error);
        }
        return reportGroup;
    }

    @Override
    public ReportGroup getDetail(IToken iToken) throws GeneralErrorException {
        if (!(iToken instanceof Token)) {
            throw new IllegalArgumentException("" + iToken);
        }
        return this.getDetail((Token)iToken);
    }

    public ReportGroup getDetail(Token token) throws GeneralErrorException {
        ReportGroup reportGroup = null;
        for (int i2 = this.rdList.size() - 1; i2 >= 0; --i2) {
            ReportDescriptor reportDescriptor = (ReportDescriptor)this.rdList.elementAt(i2);
            ReportGroup reportGroup2 = reportDescriptor.getDetail(token);
            if (reportGroup2 == null) continue;
            if (reportGroup == null) {
                reportGroup = reportGroup2;
                continue;
            }
            throw new GeneralErrorException(36, 4, token, token.getWord(), this.error);
        }
        return reportGroup;
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.tm.getCommentCode(this.firstToken, ""));
        for (int i2 = this.rdList.size() - 1; i2 >= 0; --i2) {
            stringBuffer2.append(((ReportDescriptor)this.rdList.elementAt(i2)).getCode(stringBuffer));
        }
        return stringBuffer2.toString();
    }

    int checkGroupName(String string) {
        int n2;
        int[] nArray = (int[])this.allGroups.get(string);
        if (nArray == null) {
            n2 = 0;
            nArray = new int[]{0};
            this.allGroups.put(string, nArray);
        } else {
            n2 = nArray[0] = nArray[0] + 1;
        }
        return n2;
    }

    @Override
    public Vector getRdList() {
        return this.rdList;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

