/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportVariable;
import java.util.List;
import java.util.Vector;

public class ReportVariable
implements CobolToken,
ErrorsNumbers,
IReportVariable {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private final ReportDescriptor rd;
    private final ReportGroup group;
    private final ReportVariable parent;
    private Token name;
    private int level;
    private int line;
    private int column;
    private int offset;
    private boolean groupIndicate;
    private VariableName source;
    private boolean sumReset;
    private VariableName reset;
    private VariableDeclaration cobvar;
    private Vector sum = new Vector();
    private Vector upon = new Vector();
    private Vector children = new Vector();
    private VariableDeclaration memory;
    private static int cnt;

    public ReportVariable(ReportDescriptor reportDescriptor, ReportGroup reportGroup, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(reportDescriptor, reportGroup, pcc, tokenManager, errors, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportVariable(ReportDescriptor reportDescriptor, ReportGroup reportGroup, Pcc pcc, TokenManager tokenManager, Errors errors, ReportVariable reportVariable) throws GeneralErrorException, EndOfProgramException {
        TokenManager.Marker marker = tokenManager.getMarker();
        TokenManager.Marker marker2 = tokenManager.getMarker();
        boolean bl = false;
        this.rd = reportDescriptor;
        this.group = reportGroup;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        this.parent = reportVariable;
        this.tm.setMarker(marker);
        Token token = this.tm.getToken();
        if (token.getToknum() != 10002) {
            throw new GeneralErrorException(27, 4, token, token.getWord(), this.error);
        }
        this.level = token.longValue();
        token.setWord("77");
        token = this.tm.getToken();
        if (token.getToknum() == 10009) {
            this.name = token;
        } else {
            this.tm.ungetToken();
        }
        block6: while ((token = this.tm.getToken()).getToknum() != 10006) {
            switch (token.getToknum()) {
                case 304: 
                case 323: 
                case 545: 
                case 547: 
                case 548: 
                case 556: 
                case 633: 
                case 634: 
                case 700: 
                case 715: 
                case 724: 
                case 776: 
                case 803: 
                case 810: 
                case 10001: 
                case 10002: 
                case 10017: 
                case 10023: {
                    bl = true;
                    continue block6;
                }
                case 408: 
                case 509: 
                case 797: {
                    continue block6;
                }
                case 565: {
                    this.tm.setMarker(marker2);
                    token = this.tm.getToken();
                    if (token.getToknum() == 602) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 595) {
                        token = this.tm.getToken();
                        if (token.getToknum() != 629) throw new ExpectedFoundException(token, this.error, "PAGE");
                        this.line = 0x20000001;
                    } else {
                        boolean bl2 = false;
                        if (token.getToknum() == 637) {
                            bl2 = true;
                            token = this.tm.getToken();
                        }
                        if (!Token.isIntLit(token)) {
                            throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                        }
                        this.line = token.longValue();
                        if (this.line < 0 || this.line == 0 && !bl2) {
                            throw new GeneralErrorException(183, 4, token, token.getWord(), this.error);
                        }
                        if (bl2) {
                            this.line += 0x10000000;
                        } else {
                            token = this.tm.getToken();
                            if (token.getToknum() == 613 || token.getToknum() == 595) {
                                if (token.getToknum() == 613 && (token = this.tm.getToken()).getToknum() != 595) {
                                    throw new ExpectedFoundException(token, this.error, "NEXT");
                                }
                                token = this.tm.getToken();
                                if (token.getToknum() != 629) {
                                    throw new ExpectedFoundException(token, this.error, "PAGE");
                                }
                                this.line += 0x20000000;
                            } else {
                                this.tm.ungetToken();
                            }
                        }
                    }
                    marker2.removeUntilHere();
                    continue block6;
                }
                case 338: {
                    this.tm.setMarker(marker2);
                    token = this.tm.getToken();
                    if (token.getToknum() == 602) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    this.column = token.longValue();
                    marker2.removeUntilHere();
                    continue block6;
                }
            }
            if ("SOURCE".equals(token.getWord())) {
                this.tm.setMarker(marker2);
                token = this.tm.getToken();
                if (token.getToknum() == 545) {
                    token = this.tm.getToken();
                }
                if ("LINE-COUNTER".equals(token.getWord()) || "PAGE-COUNTER".equals(token.getWord())) {
                    this.tm.ungetToken();
                    this.source = VariableName.get(this.tm, this.error);
                    this.source.setOf(this.rd.reportVar);
                    this.source.check(this.pc);
                } else {
                    this.tm.ungetToken();
                    int[] nArray = new int[]{0};
                    Expression expression = new Expression(nArray, token, null, this.pc, this.tm, this.error, false, false);
                    Token token2 = expression.keyWord;
                    if (expression.isVoid()) {
                        throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                    }
                    if (nArray[0] != 0) {
                        throw new GeneralErrorException(44, 4, token2, token2.getWord(), this.error);
                    }
                    if (expression.hasOperator || expression.firstVar == null) {
                        throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                    }
                    this.source = expression.firstVar;
                }
                marker2.removeUntilHere();
                continue;
            }
            if ("GROUP".equals(token.getWord())) {
                this.tm.setMarker(marker2);
                token = this.tm.getToken();
                if (!"INDICATE".equals(token.getWord())) {
                    this.tm.ungetToken();
                }
                this.groupIndicate = true;
                marker2.removeUntilHere();
                continue;
            }
            if (!"SUM".equals(token.getWord())) throw new UnexpectedTokenException(token, this.error);
            if (reportGroup.type != 5) {
                throw new GeneralErrorException(186, 4, token, token.getWord(), this.error);
            }
            this.tm.setMarker(marker2);
            while ((token = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                VariableName variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName == null) throw new SyntaxErrorException(token, token.getWord(), this.error);
                this.sum.add(variableName);
            }
            if (this.sum.size() == 0) {
                throw new SyntaxErrorException(token, token.getWord(), this.error);
            }
            if (token.getToknum() == 795) {
                while ((token = this.tm.getToken()).getToknum() == 10009) {
                    reportGroup = this.rd.getReportGroup(token);
                    if (reportGroup == null) {
                        throw new GeneralErrorException(181, 4, token, token.getWord(), this.error);
                    }
                    if (reportGroup.type != 4) {
                        throw new GeneralErrorException(182, 4, token, token.getWord(), this.error);
                    }
                    this.upon.add(reportGroup);
                }
            }
            if (token.getToknum() == 689) {
                this.sumReset = true;
                token = this.tm.getToken();
                if (token.getToknum() == 613) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.reset = VariableName.get(this.tm, this.error, this.pc);
                    if (this.reset == null) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                } else if (token.getToknum() != 487) {
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
            } else {
                this.tm.ungetToken();
            }
            marker2.removeUntilHere();
        }
        if (this.line != 0 && reportGroup.setLine(this.line)) {
            throw new GeneralErrorException(183, 4, this.name != null ? this.name : this.rd.reportName, "" + this.line, this.error);
        }
        if (this.column != 0 && reportGroup.setColumn(this.column)) {
            throw new GeneralErrorException(184, 4, this.name != null ? this.name : this.rd.reportName, "" + this.column, this.error);
        }
        if (bl) {
            this.tm.rewindToMarker(marker);
            this.cobvar = new VariableDeclaration(this.pc, this.tm, this.error, null);
            this.cobvar.setUsed();
            this.pc.loadVariable(this.cobvar);
            this.offset = this.column != 0 ? this.column - 1 : reportGroup.getColumn() - 1;
            reportGroup.setColumn(this.offset + 1 + this.cobvar.globalLen());
        } else {
            marker.removeUntilHere();
            if (this.column > 0) {
                reportGroup.setColumn(this.column);
            }
        }
        while ((token = this.tm.getToken()).getToknum() == 10002 && token.longValue() > this.level) {
            this.tm.ungetToken();
            this.children.add(new ReportVariable(this.rd, reportGroup, this.pc, this.tm, this.error, this));
        }
        this.tm.ungetToken();
    }

    public static void resetCounters() {
        cnt = 0;
    }

    public void check() throws GeneralErrorException {
        int n2;
        if (this.source != null) {
            this.source.check(this.pc);
        }
        for (n2 = this.sum.size() - 1; n2 >= 0; --n2) {
            ((VariableName)this.sum.elementAt(n2)).check(this.pc);
        }
        for (n2 = this.upon.size() - 1; n2 >= 0; --n2) {
            ((ReportGroup)this.upon.elementAt(n2)).check();
        }
        if (this.reset != null) {
            this.reset.check(this.pc);
            if (!this.rd.isControl(this.reset)) {
                throw new GeneralErrorException(185, 4, this.reset.name, this.reset.name.getWord(), this.error);
            }
        }
        if (this.line != 0) {
            Token token = new Token(this.name != null ? this.name : this.rd.reportName);
            token.setWord("mem$line$" + cnt++);
            this.memory = VariableDeclaration.getPicX(this.pc, this.tm, token, this.rd.getLen(), null);
            this.memory.setAccessedByAddress();
            this.memory.setUsed();
        }
        if (this.cobvar != null) {
            this.cobvar.parent = this.getMemoryVar();
            this.cobvar.level = this.cobvar.parent.level + 1;
        }
        for (n2 = this.children.size() - 1; n2 >= 0; --n2) {
            ((ReportVariable)this.children.elementAt(n2)).check();
        }
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.name != null) {
            stringBuffer2.append(this.tm.getCommentCode(this.name, "   "));
        }
        if (this.memory != null) {
            stringBuffer2.append(this.memory.getCode(stringBuffer));
        }
        if (this.name != null && this.cobvar != null) {
            this.cobvar.setOffset(this.offset);
            stringBuffer2.append(this.cobvar.getCode(stringBuffer));
            stringBuffer.append(this.rd.getName());
            stringBuffer.append(".addVar ((new ReportVariable (");
            stringBuffer.append(this.level);
            stringBuffer.append(",");
            stringBuffer.append(this.cobvar.getUnivoqueName());
        } else {
            stringBuffer.append(this.rd.getName());
            stringBuffer.append(".addVar ((new ReportVariable (");
            stringBuffer.append(this.level);
            if (this.cobvar != null) {
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer.append(",");
                stringBuffer3.append(this.getMemoryVar().getUnivoqueName());
                stringBuffer3.append(",");
                stringBuffer3.append(this.offset);
                stringBuffer3.append(",");
                stringBuffer3.append(this.cobvar.globalLen());
                this.cobvar.fillArguments(stringBuffer3, false);
                this.cobvar.getFactoryInvoke(stringBuffer3, stringBuffer);
            }
        }
        stringBuffer.append("))");
        if (this.source != null) {
            stringBuffer.append(".setSource (");
            this.printVariableName(stringBuffer, this.source);
            stringBuffer.append(")");
        }
        if (this.line != 0) {
            stringBuffer.append(".setLine (0x");
            stringBuffer.append(Integer.toHexString(this.line));
            if (this.memory != null) {
                stringBuffer.append(",");
                stringBuffer.append(this.memory.getUnivoqueName());
            }
            stringBuffer.append(")");
        }
        if (this.column != 0) {
            stringBuffer.append(".setColumn (0x");
            stringBuffer.append(Integer.toHexString(this.column));
            stringBuffer.append(")");
        }
        if (this.groupIndicate) {
            stringBuffer.append(".setGroupIndicate ()");
        }
        if (this.sum.size() > 0) {
            stringBuffer.append(".setSum(new CobValue[] {");
            int n2 = 0;
            while (true) {
                stringBuffer.append(((VariableName)this.sum.elementAt(n2)).getCode());
                if (++n2 == this.sum.size()) break;
                stringBuffer.append(",");
            }
            if (this.upon.size() > 0) {
                stringBuffer.append("}, new ReportGroup[] {");
                n2 = 0;
                while (true) {
                    stringBuffer.append(((ReportGroup)this.upon.elementAt(n2)).getUnivoqueName());
                    if (++n2 == this.sum.size()) break;
                    stringBuffer.append(",");
                }
                stringBuffer.append("})");
            } else {
                stringBuffer.append("}, null)");
            }
        }
        if (this.sumReset) {
            stringBuffer.append(".setReset (");
            if (this.reset == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.reset.getCode());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            stringBuffer2.append(((ReportVariable)this.children.elementAt(i2)).getCode(stringBuffer));
        }
        return stringBuffer2.toString();
    }

    @Override
    public VariableDeclaration getMemoryVar() {
        if (this.memory != null) {
            return this.memory;
        }
        if (this.parent != null) {
            return this.parent.getMemoryVar();
        }
        return this.rd.vParent;
    }

    private void printVariableName(StringBuffer stringBuffer, VariableName variableName) {
        if (variableName.hasSubValue() || variableName.hasVariableIndex() || variableName.isFunction() || variableName.isMethod()) {
            stringBuffer.append("new ECV() { public ICobolVar ieval() { return ");
            stringBuffer.append(variableName.getCode());
            stringBuffer.append("; } }");
        } else {
            stringBuffer.append(variableName.getCode());
        }
    }

    @Override
    public VariableDeclaration getCobVar() {
        return this.cobvar;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public List getUpon() {
        return this.upon;
    }

    @Override
    public Token getName() {
        return this.name;
    }

    @Override
    public VariableName getSource() {
        return this.source;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public VariableDeclaration getMemory() {
        return this.memory;
    }

    @Override
    public boolean getGroupIndicate() {
        return this.groupIndicate;
    }

    @Override
    public boolean getSumReset() {
        return this.sumReset;
    }

    @Override
    public VariableName getReset() {
        return this.reset;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public List getSum() {
        return this.sum;
    }
}

