/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.Verb;

public class Resume
extends Verb
implements CobolToken,
ErrorsNumbers {
    Token label;
    int toNums;

    public Resume(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
        }
        this.label = token2;
    }

    @Override
    public void check() throws GeneralErrorException {
        Paragraph paragraph = this.pc.getParagraph(this.label.getWord(), this.parent.parent);
        if (paragraph == null) {
            throw new UndefinedException(this.keyWord, this.error, this.label.getWord());
        }
        if (paragraph.isDeclaratives()) {
            throw new GeneralErrorException(47, 4, this.keyWord, this.label.getWord(), this.error);
        }
        this.toNums = paragraph.getIdNumber();
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        boolean bl = this.tm.getOptionList().getOption("-d") != null;
        this.getCodeDebug(stringBuffer);
        if (bl) {
            Paragraph.getDebugExitCode(stringBuffer);
            stringBuffer.append(" ");
        }
        stringBuffer.append("if (true) throw new GotoException (");
        stringBuffer.append(this.toNums);
        stringBuffer.append(");");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

