/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AtEnd;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Return
extends Verb
implements CobolToken,
ErrorsNumbers {
    Select sel;
    AtEnd atEnd;
    VariableName into;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Return(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(token2.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (!this.sel.isSort()) {
            throw new GeneralErrorException(104, 4, token2, this.sel.fileName.getWord(), this.error);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 670) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 542) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 598) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 284 && token2.getToknum() != 422) throw new UnexpectedTokenException(token2, this.error);
            this.tm.ungetToken();
            this.tm.ungetToken();
            this.atEnd();
        } else if (token2.getToknum() == 284 || token2.getToknum() == 422) {
            this.tm.ungetToken();
            this.atEnd();
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 443) return;
        this.tm.ungetToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void atEnd() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 598) {
            token = this.tm.getToken();
            if (token.getToknum() != 284 && token.getToknum() != 422) throw new UnexpectedTokenException(token, this.error);
            this.tm.ungetToken();
            this.tm.ungetToken();
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else if (token.getToknum() == 284 || token.getToknum() == 422) {
            this.tm.ungetToken();
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.atEnd != null) {
            stringBuffer.append(this.atEnd.getCodeBefore());
        }
        if (this.tm.getOptionList().getOption("-cv") != null) {
            stringBuffer.append("if (" + this.getLocalVar("SORT-RETURN") + ".toint()==16) throw new SortAbort();");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        stringBuffer.append(this.sel.getName());
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            stringBuffer.append(".returnRecord(");
        } else {
            stringBuffer.append(".returnSort(");
        }
        if (this.into != null) {
            stringBuffer.append(this.into.getCode());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(");");
        if (this.atEnd != null) {
            stringBuffer.append(this.atEnd.getCode());
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public VariableName getInto() {
        return this.into;
    }

    public AtEnd getAtEnd() {
        return this.atEnd;
    }

    public Select getSelect() {
        return this.sel;
    }
}

