/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Rewrite
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;
    private InvalidKey invKey;
    private boolean lock;
    private VariableName keyName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rewrite(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.record = VariableName.get(this.tm, this.error, this.pc).getVarDecl();
            this.fd = this.pc.getFdByRecord(this.record);
        } else {
            if (token2.getToknum() != 482) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            this.fd = this.pc.data.fileSec.getFD(token2.getWord());
            if (this.fd != null) {
                this.record = this.fd.recordDesc.getFirst();
            }
        }
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.fd.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, this.fd.sel.fileName.getWord(), this.error);
        }
        if (!this.fd.sel.allowsOpenIO()) {
            this.error.print(142, 2, this.keyWord, this.fd.sel.fileName.getWord());
        }
        if (this.fd.isXml()) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 551) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 545) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 670) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 498) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (token2.getToknum() != 10001) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                this.fromToken = token2;
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 813 || token2.getToknum() == 570 || token2.getToknum() == 596) {
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 596) {
                token2 = this.tm.getToken();
            } else {
                this.lock = true;
            }
            if (token2.getToknum() != 570) {
                throw new ExpectedFoundException(token2, this.error, "LOCK");
            }
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
        token2 = this.tm.getToken();
        if (token2.getToknum() != 444) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.pc.getDeclarative(this.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.fromVar != null || this.fromToken != null) {
            stringBuffer.append(this.parent.getIndent());
            if (this.fromVar != null) {
                stringBuffer.append(this.fromVar.getCode());
            } else {
                stringBuffer.append(this.getCodeLiteral(this.fromToken));
            }
            stringBuffer.append(".moveTo(");
            stringBuffer.append(this.record.getQualUnivoqueName());
            stringBuffer.append(");");
            stringBuffer.append(eol);
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (this.fd.sel.isXml()) {
            stringBuffer.append(this.fd.sel.getName());
            stringBuffer.append(".rewriteXml(");
            stringBuffer.append(this.record.getUnivoqueName());
            stringBuffer.append(",");
            if (this.keyName != null) {
                stringBuffer.append(this.keyName.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(");");
            Use.putFileStatus(stringBuffer, this.fd.sel, this.parent.getIndent());
        } else {
            stringBuffer.append(this.invKey.getCodeBefore());
            stringBuffer.append(this.fd.sel.getName());
            stringBuffer.append(".rewrite(");
            stringBuffer.append(this.lock);
            stringBuffer.append(",");
            if (this.fd.getDepending() != null && this.fd.sel.organization != 677) {
                if (this.fd.getDependingOffs() > 0) {
                    stringBuffer.append(this.fd.getDependingOffs() + " + ");
                }
                stringBuffer.append(this.fd.getDepending().getCode());
                stringBuffer.append(".toint()");
            } else {
                stringBuffer.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
            }
            stringBuffer.append(");");
            Use.putFileStatus(stringBuffer, this.fd.sel, this.parent.getIndent());
            stringBuffer.append(this.invKey.getCode());
        }
        Use.putDeclaratives(stringBuffer, this.pc, this.fd.sel, this.parent.getIndent(), bl);
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public boolean isLock() {
        return this.lock;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }
}

