/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class SMAPGenerator {
    static final String nameSDE = "isCOBOLSourceDebugExtension6";
    private static byte[] scramble = new byte[]{75, -88, 62, 51, 44, 81, 46, -123, 114, 0, -56, -117, -16, -81, 106, 47, 64, 40, -86, -43, 16, 91, -18, 14, 27, 50, 19, 84, 37, -99, -119, 56, -23, -60, -31, -5, 1, 8, -58, -85, 105, 66, 94, -108, 90, -97, 82, 13, 59, -92, 87, -59, 55, 35, -80, 18, -17, 60, -67, 93, -30, 95, -89, 86, 96, 69, 11, -76, -28, -116, -126, -24, 101, 4, 72, -26, -57, -113, -125, 125, -103, 42, 38, 80, 111, -74, 112, 71, -35, 41, 63, -14, 2, 26, -8, 54, -42, 39, -83, -53, 123, -96, -109, 61, -107, 52, 3, 36, -124, 121, -115, 70, 89, 118, 24, -98, 32, -51, -79, 113, 21, -41, 73, -50, -4, 102, 117, 49, -91, 68, 124, 57, -114, -111, -40, -13, 31, -54, -34, -49, 65, -62, 108, -21, 34, -69, 76, -1, -110, -47, -66, -78, -120, -2, -46, -48, 83, 126, -25, -65, -36, 110, 22, 58, 9, -73, -100, -45, -55, 67, -15, 20, -72, -9, -102, -22, 122, -112, 115, -75, 5, -90, -37, 17, -87, -82, -128, -44, -104, 30, -84, -11, 15, -121, 12, -118, -94, 109, -10, -101, -19, 33, 77, 7, -32, 116, -64, 79, -71, 98, -95, -70, 48, 119, 97, 88, -106, 10, 92, 107, 100, -27, -20, 23, 74, 78, -63, 53, -38, 29, 43, 45, -3, -52, -122, 104, 6, 25, -39, -68, -61, -77, -12, -6, -29, 127, 85, 28, -127, 120, -33, -7, 103, -105, -93, 99};
    private String name;
    private Vector lines;
    private byte[] origClass;
    private int origPos;
    private byte[] newClass;
    private int newPos;
    private int sdeIndex;
    private CopyBookDesc[] copyFiles;
    private String encoding;
    private String[] sourceFileNames;
    private String sourceFileName;
    private String[] copyResources;
    private boolean debugReplSrc;
    private boolean ok;
    private static final String tmpdir = System.getProperty("java.io.tmpdir");

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length >= 1) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                new SMAPGenerator(stringArray[i2]);
            }
        } else {
            System.err.println("Usage: <command> <input java file> ");
        }
    }

    public SMAPGenerator(String string) throws IOException {
        this.name = string;
        this.lines = new Vector();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.name + ".java"), System.getProperty("file.encoding")));
        int n2 = lineNumberReader.read();
        while (n2 >= 0) {
            if (n2 == 47 && (n2 = lineNumberReader.read()) == 42 && (n2 = lineNumberReader.read()) == 33 && (n2 = lineNumberReader.read()) == 35) {
                n2 = lineNumberReader.read();
                switch (n2) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        String string2 = "";
                        String string3 = "";
                        while (n2 >= 48 && n2 <= 57) {
                            string2 = string2 + (char)n2;
                            n2 = lineNumberReader.read();
                        }
                        if (n2 == 44) {
                            while ((n2 = lineNumberReader.read()) >= 48 && n2 <= 57) {
                                string3 = string3 + (char)n2;
                            }
                        }
                        if (n2 < 0) break;
                        this.findCommand(lineNumberReader);
                        Object object = new SmapLine(lineNumberReader.getLineNumber(), string2, Integer.parseInt(string3));
                        if (!((SmapLine)object).isOk()) break;
                        this.lines.addElement(object);
                        this.ok = true;
                        break;
                    }
                    case 78: {
                        n2 = lineNumberReader.read();
                        this.debugReplSrc = n2 == 49;
                        this.ok = true;
                        break;
                    }
                    case 70: {
                        String string4 = "";
                        while ((n2 = lineNumberReader.read()) >= 0 && n2 != 42) {
                            string4 = string4 + (char)n2;
                        }
                        this.encoding = string4;
                        this.ok = true;
                        break;
                    }
                    case 83: {
                        String string4;
                        Object object = new ArrayList<String>();
                        block19: while ((n2 = lineNumberReader.read()) >= 0 && n2 != 42) {
                            string4 = "";
                            while (n2 != 59) {
                                string4 = string4 + (char)n2;
                                n2 = lineNumberReader.read();
                                if (n2 >= 0) continue;
                                break block19;
                            }
                            object.add(string4);
                        }
                        this.sourceFileNames = object.toArray(new String[object.size()]);
                        this.ok = true;
                        break;
                    }
                    case 67: {
                        String string4;
                        ArrayList<CopyBookDesc> arrayList = new ArrayList<CopyBookDesc>();
                        String string5 = null;
                        int n3 = 0;
                        String string6 = null;
                        short s2 = 0;
                        short s3 = 0;
                        block21: while ((n2 = lineNumberReader.read()) >= 0 && n2 != 42) {
                            string4 = "";
                            while (n2 != 44) {
                                string4 = string4 + (char)n2;
                                n2 = lineNumberReader.read();
                                if (n2 >= 0) continue;
                                break block21;
                            }
                            string5 = string4;
                            string4 = "";
                            while ((n2 = lineNumberReader.read()) != 44) {
                                if (n2 < 0) break block21;
                                string4 = string4 + (char)n2;
                            }
                            try {
                                n3 = Integer.parseInt(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            string4 = "";
                            while ((n2 = lineNumberReader.read()) != 44) {
                                if (n2 < 0) break block21;
                                string4 = string4 + (char)n2;
                            }
                            string6 = string4;
                            string4 = "";
                            while ((n2 = lineNumberReader.read()) != 44) {
                                if (n2 < 0) break block21;
                                string4 = string4 + (char)n2;
                            }
                            try {
                                s2 = Short.parseShort(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            string4 = "";
                            while ((n2 = lineNumberReader.read()) != 59) {
                                if (n2 < 0) break block21;
                                string4 = string4 + (char)n2;
                            }
                            try {
                                s3 = Short.parseShort(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            arrayList.add(new CopyBookDesc(string6, string5, n3, s2, s3));
                        }
                        this.copyFiles = arrayList.toArray(new CopyBookDesc[arrayList.size()]);
                        this.ok = true;
                        break;
                    }
                    case 69: {
                        String string4;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        block27: while ((n2 = lineNumberReader.read()) >= 0 && n2 != 42) {
                            string4 = "";
                            while (n2 != 59) {
                                string4 = string4 + (char)n2;
                                n2 = lineNumberReader.read();
                                if (n2 >= 0) continue;
                                break block27;
                            }
                            arrayList.add(string4);
                        }
                        this.copyResources = arrayList.toArray(new String[arrayList.size()]);
                        this.ok = true;
                        break;
                    }
                    case 77: {
                        String string4 = "";
                        while ((n2 = lineNumberReader.read()) >= 0 && n2 != 42) {
                            string4 = string4 + (char)n2;
                        }
                        this.sourceFileName = string4;
                    }
                }
            }
            if (n2 < 0) continue;
            n2 = lineNumberReader.read();
        }
        lineNumberReader.close();
        this.install(this.makeSmap());
    }

    private void findCommand(LineNumberReader lineNumberReader) throws IOException {
        int n2;
        while ((!Character.isJavaIdentifierStart((char)(n2 = lineNumberReader.read())) || n2 == 116 && (n2 = lineNumberReader.read()) == 114 && (n2 = lineNumberReader.read()) == 121 && !Character.isJavaIdentifierPart((char)(n2 = lineNumberReader.read()))) && n2 != 59 && n2 != 61 && n2 >= 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private byte[] makeSmap() throws IOException {
        Object object2;
        Iterator iterator;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(new DeflaterOutputStream(byteArrayOutputStream2));
        int n2 = this.lines.size() - 1;
        int n3 = -1;
        int n4 = -1;
        short s2 = 1;
        int n5 = -1;
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream3);
        int n6 = 0;
        for (int i2 = 0; i2 <= n2; ++i2) {
            SmapLine smapLine = (SmapLine)this.lines.elementAt(i2);
            if (smapLine.cobolLine == n3 + s2 && smapLine.javaLine == n4 + s2 && smapLine.fileIndex == n5) {
                s2 = (short)(s2 + 1);
            } else {
                if (n3 > 0) {
                    this.makeLine(dataOutputStream3, n3, (short)n5, s2, n4);
                    ++n6;
                }
                n5 = smapLine.fileIndex;
                n3 = smapLine.cobolLine;
                n4 = smapLine.javaLine;
                s2 = 1;
            }
            if (i2 != n2) continue;
            this.makeLine(dataOutputStream3, n3, (short)smapLine.fileIndex, s2, n4);
            ++n6;
        }
        dataOutputStream3.close();
        dataOutputStream2.writeInt(n6);
        dataOutputStream2.write(byteArrayOutputStream3.toByteArray());
        if (this.copyFiles != null) {
            dataOutputStream2.writeInt(this.copyFiles.length);
            for (CopyBookDesc copyBookDesc : this.copyFiles) {
                dataOutputStream2.writeUTF(copyBookDesc.getParentName());
                dataOutputStream2.writeInt(copyBookDesc.getParentLineNumber());
                dataOutputStream2.writeUTF(copyBookDesc.getName());
                dataOutputStream2.writeShort(copyBookDesc.getParentIndex());
                dataOutputStream2.writeShort(copyBookDesc.getIndex());
            }
        } else {
            dataOutputStream2.writeInt(0);
        }
        if (this.sourceFileNames != null) {
            dataOutputStream2.writeInt(this.sourceFileNames.length);
            for (String string : this.sourceFileNames) {
                dataOutputStream2.writeUTF(string);
            }
        } else {
            dataOutputStream2.writeInt(0);
        }
        if (this.copyResources != null) {
            dataOutputStream2.writeInt(this.copyResources.length);
            for (String string : this.copyResources) {
                iterator = null;
                try {
                    iterator = new FileInputStream(string);
                    object2 = new byte[((FileInputStream)((Object)iterator)).available()];
                    ((FileInputStream)((Object)iterator)).read((byte[])object2);
                    dataOutputStream2.writeUTF(new File(string).getName().toLowerCase());
                    dataOutputStream2.writeInt(((Object)object2).length);
                    dataOutputStream2.write((byte[])object2);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (iterator != null) {
                        ((FileInputStream)((Object)iterator)).close();
                    }
                }
            }
        } else {
            dataOutputStream2.writeInt(0);
        }
        dataOutputStream2.writeLong(System.currentTimeMillis());
        if (this.ok) {
            dataOutputStream2.writeBoolean(true);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Properties properties = Config.e();
            int n7 = 0;
            Object var18_32 = null;
            iterator = properties.propertyNames();
            while (iterator.hasMoreElements()) {
                object2 = (String)iterator.nextElement();
                if (((String)object2).startsWith("iscobol.compiler.const.")) {
                    arrayList.add((String)object2 + "=" + properties.getProperty((String)object2));
                    continue;
                }
                if (((String)object2).equals("iscobol.compiler.debug.replaced_source")) {
                    String string = (String)object2 + "=" + properties.getProperty((String)object2);
                    continue;
                }
                if (!((String)object2).equals("iscobol.compiler.regexp") && !((String)object2).equals("iscobol.compiler.custompreproc")) continue;
                n7 = 1;
            }
            if (n7 != 0) {
                void var18_33;
                if (var18_33 != null) {
                    arrayList.add(var18_33);
                }
            } else {
                arrayList.add("iscobol.compiler.debug.replaced_source=0");
            }
            dataOutputStream2.writeInt(arrayList.size());
            for (Object object2 : arrayList) {
                dataOutputStream2.writeUTF((String)object2);
            }
        } else {
            dataOutputStream2.writeBoolean(false);
        }
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        if (this.sourceFileNames != null) {
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            dataOutputStream2 = new DataOutputStream(new DeflaterOutputStream(byteArrayOutputStream2));
            this.buildDebugResourceFile(dataOutputStream2);
            dataOutputStream2.close();
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            dataOutputStream.write(byArray2);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private File getReplFileList() throws IOException {
        File file;
        if (this.sourceFileName != null && (file = new File(tmpdir + File.separator + new File(this.sourceFileName).getName() + ".filelist")).exists()) {
            return file;
        }
        return null;
    }

    private void buildDebugResourceFile(DataOutputStream dataOutputStream) throws IOException {
        File file;
        String string = this.encoding != null ? this.encoding : System.getProperty("file.encoding");
        dataOutputStream.writeUTF(string);
        if (this.debugReplSrc && (file = this.getReplFileList()) != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            class MyFile {
                ByteArrayOutputStream baos;
                PrintStream ps;
                String name;

                MyFile() {
                }
            }
            Stack<MyFile> stack = new Stack<MyFile>();
            MyFile myFile = null;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("      *>>((file: ")) {
                    myFile = new MyFile();
                    myFile.baos = new ByteArrayOutputStream();
                    myFile.ps = new PrintStream((OutputStream)myFile.baos, false, string);
                    myFile.name = string2.substring("      *>>((file: ".length(), string2.length() - 2);
                    stack.push(myFile);
                } else if (string2.startsWith("      *<<((file: ")) {
                    myFile.ps.close();
                    stack.pop();
                    byte[] byArray = myFile.baos.toByteArray();
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        byArray[i2] = scramble[byArray[i2] & 0xFF];
                    }
                    dataOutputStream.writeUTF(myFile.name);
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                    myFile = stack.isEmpty() ? null : (MyFile)stack.peek();
                } else {
                    myFile.ps.println(string2);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            file.delete();
        } else {
            TreeMap<File, String> treeMap = new TreeMap<File, String>();
            for (String string3 : this.sourceFileNames) {
                treeMap.put(new File(string3), string3);
            }
            for (File file2 : treeMap.keySet()) {
                dataOutputStream.writeUTF((String)treeMap.get(file2));
                this.writeFile(file2, true, dataOutputStream);
            }
        }
        dataOutputStream.writeUTF("");
    }

    private void writeFile(File file, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray;
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        } else if (!bl || (byArray = PreProcessor.getDefFileContents(file.getPath())) == null) {
            byArray = new byte[]{};
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = scramble[byArray[i2] & 0xFF];
        }
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    private void makeLine(DataOutputStream dataOutputStream, int n2, short s2, short s3, int n3) throws IOException {
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeShort(s2);
        dataOutputStream.writeShort(s3);
        dataOutputStream.writeInt(n3);
    }

    private void install(byte[] byArray) throws IOException {
        File file = new File(this.name + ".class");
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.origClass = new byte[(int)file.length()];
        if (fileInputStream.read(this.origClass, 0, this.origClass.length) != this.origClass.length) {
            fileInputStream.close();
            throw new IOException("Wrong length: " + this.origClass.length);
        }
        fileInputStream.close();
        this.newClass = new byte[this.origClass.length + byArray.length + 100];
        this.newPos = 0;
        this.origPos = 0;
        this.copy(8);
        int n2 = this.newPos;
        int n3 = this.read2();
        this.write2(n3);
        this.sdeIndex = this.copyConstantPool(n3);
        if (this.sdeIndex < 0) {
            this.writeSDE();
            this.sdeIndex = n3++;
            this.randomAccessWrite2(n2, n3);
        }
        this.copy(6);
        int n4 = this.read2();
        this.write2(n4);
        this.copy(n4 * 2);
        this.copyMembers();
        this.copyMembers();
        int n5 = this.newPos;
        int n6 = this.read2();
        this.write2(n6);
        if (!this.copyAttrs(n6)) {
            this.randomAccessWrite2(n5, ++n6);
        }
        this.writeAttrForSDE(this.sdeIndex, byArray);
        File file2 = new File(this.name + ".class.tmp");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(this.newClass, 0, this.newPos);
        fileOutputStream.close();
        if (!file.delete()) {
            throw new IOException("Delete failed: " + file.getPath());
        }
        if (!file2.renameTo(file)) {
            throw new IOException("RenameTo failed: " + file.getPath());
        }
    }

    int copyConstantPool(int n2) throws IOException {
        int n3 = -1;
        block7: for (int i2 = 1; i2 < n2; ++i2) {
            int n4 = this.read1();
            this.write1(n4);
            switch (n4) {
                case 1: {
                    int n5 = this.read2();
                    this.write2(n5);
                    if (nameSDE.equals(this.readUTF8String(n5))) {
                        n3 = i2;
                    }
                    this.copy(n5);
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.copy(2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.copy(4);
                    continue block7;
                }
                case 15: {
                    this.copy(3);
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i2;
                    continue block7;
                }
                default: {
                    throw new IOException("Unexpected tag: " + n4);
                }
            }
        }
        return n3;
    }

    private void copy(int n2) {
        while (n2 > 0) {
            this.newClass[this.newPos++] = this.origClass[this.origPos++];
            --n2;
        }
    }

    private int read1() {
        return this.origClass[this.origPos++] & 0xFF;
    }

    private int read2() {
        return (this.read1() << 8) + this.read1();
    }

    private int read4() {
        return (this.read2() << 16) + this.read2();
    }

    private void write1(int n2) {
        this.newClass[this.newPos++] = (byte)n2;
    }

    private void write2(int n2) {
        this.write1(n2 >> 8);
        this.write1(n2 & 0xFF);
    }

    private void write4(int n2) {
        this.write2(n2 >> 16);
        this.write2(n2 & 0xFFFF);
    }

    private String readUTF8String(int n2) throws UnsupportedEncodingException {
        return new String(this.origClass, this.origPos, n2, "UTF-8");
    }

    private void writeSDE() {
        this.write1(1);
        this.write2(nameSDE.length());
        for (int i2 = 0; i2 < nameSDE.length(); ++i2) {
            this.write1(nameSDE.charAt(i2));
        }
    }

    private void randomAccessWrite2(int n2, int n3) {
        int n4 = this.newPos;
        this.newPos = n2;
        this.write2(n3);
        this.newPos = n4;
    }

    private void copyMembers() {
        int n2 = this.read2();
        this.write2(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.copy(6);
            int n3 = this.read2();
            this.write2(n3);
            this.copyAttrs(n3);
        }
    }

    private boolean copyAttrs(int n2) {
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.read2();
            if (n3 == this.sdeIndex) {
                bl = true;
                continue;
            }
            this.write2(n3);
            int n4 = this.read4();
            this.write4(n4);
            this.copy(n4);
        }
        return bl;
    }

    void writeAttrForSDE(int n2, byte[] byArray) {
        this.write2(n2);
        this.write4(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.write1(byArray[i2]);
        }
    }

    static class SmapLine {
        final int javaLine;
        final int cobolLine;
        final int fileIndex;

        SmapLine(int n2, String string, int n3) {
            int n4;
            this.fileIndex = n3;
            this.javaLine = n2 + 1;
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            this.cobolLine = n4;
        }

        boolean isOk() {
            return this.cobolLine > 0;
        }

        public String toString() {
            return "java=" + this.javaLine + ",cobol=" + this.cobolLine + ",file=\"" + this.fileIndex + "\"";
        }
    }

    static class SmapCopy {
        int lineStart;
        int lineEnd;
        short fileIndex;
        byte copyDeep;
        String fileName;

        SmapCopy() {
        }
    }
}

