/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IDataSection;
import java.util.Hashtable;

public class ScreenSection
implements CobolToken,
ErrorsNumbers,
IDataSection {
    public static final String screenManagerVarName = "ScrFactory.getGUIEnviroment()";
    Pcc pc;
    TokenManager tm;
    Errors error;
    VariableDeclarationList vars = new VariableDeclarationList();
    private int progScreenI = 0;
    private int progScreenJ = 0;
    private Token firstToken;
    private Token lastToken;
    private Hashtable allVariables = new Hashtable();

    public ScreenSection(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, null);
    }

    public ScreenSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) {
        this.firstToken = token;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
    }

    public void loadSS() throws GeneralErrorException, EndOfProgramException {
        Token token = null;
        token = this.tm.getToken();
        if (token.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token, "'.'");
                this.tm.ungetToken();
            }
            boolean bl = this.pc.isInterfaceChild();
            while ((token = this.tm.getToken()).getToknum() == 10002) {
                this.tm.ungetToken();
                try {
                    VariableDeclarationScreen variableDeclarationScreen = new VariableDeclarationScreen(this.pc, this.tm, this.error, null, false, false, this);
                    variableDeclarationScreen.setParentSection(this);
                    if (bl) {
                        throw new GeneralErrorException(249, 4, variableDeclarationScreen.getNameToken(), variableDeclarationScreen.getName(), this.error);
                    }
                    if (variableDeclarationScreen.getHasCharacterAttribute()) continue;
                    this.vars.addItem(variableDeclarationScreen);
                }
                catch (GeneralErrorException generalErrorException) {
                    while ((token = this.tm.getToken()).getToknum() != 10006 && token.getWord().length() > 1) {
                    }
                }
            }
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        this.lastToken = token;
        this.pc.useScreen = this.vars.getItemNum() > 0;
        this.loadVars(this.allVariables);
    }

    public String getCode(Pcc pcc, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.tm.getCommentCode(this.firstToken, ""));
        VariableDeclarationScreen variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getFirst();
        while (variableDeclarationScreen != null) {
            stringBuffer2.append(variableDeclarationScreen.getCode(stringBuffer));
            variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getNext();
        }
        this.progScreenI = 0;
        this.progScreenJ = 0;
        variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getFirst();
        while (variableDeclarationScreen != null) {
            variableDeclarationScreen.resetProgScreen();
            variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getNext();
        }
        return stringBuffer2.toString();
    }

    public void check() throws GeneralErrorException {
        VariableDeclarationScreen variableDeclarationScreen = null;
        variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getFirst();
        while (variableDeclarationScreen != null) {
            variableDeclarationScreen.check(null);
            variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getNext();
        }
    }

    private void loadVars(Hashtable hashtable) {
        VariableDeclarationScreen variableDeclarationScreen = null;
        variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getFirst();
        while (variableDeclarationScreen != null) {
            variableDeclarationScreen.loadVars(hashtable);
            variableDeclarationScreen = (VariableDeclarationScreen)this.vars.getNext();
        }
    }

    public VariableDeclaration getAny(VariableName variableName) {
        return (VariableDeclaration)this.allVariables.get(variableName.getName());
    }

    public void addvar(VariableDeclarationScreen variableDeclarationScreen) {
        this.vars.addItem(variableDeclarationScreen);
    }

    public int getProgScreenI() {
        return this.progScreenI;
    }

    public int getProgScreenJ() {
        return this.progScreenJ;
    }

    public void setProgScreenI(int n2) {
        this.progScreenI = n2;
    }

    public void setProgScreenJ(int n2) {
        this.progScreenJ = n2;
    }

    @Override
    public VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

