/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;

public class Search
extends Verb
implements CobolToken,
ErrorsNumbers {
    VariableName table;
    VariableName indexItem;
    VariableName indexItem2;
    Block atEndBlock;
    VerbList whenConds = new VerbList();
    VerbList allConds = new VerbList();
    VariableDeclaration tableVd;
    boolean binary;
    Block allBlock;
    private Token nextSentence;
    private NextSentence ns;

    public Search(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.table = VariableName.get(this.tm, this.error);
        this.tableVd = this.pc.getVar(this.table, false);
        if (this.tableVd == null) {
            throw new UndefinedException(this.table.getNameToken(), this.error, this.table.getName());
        }
        this.tableVd.setUsed();
        VariableNameList variableNameList = this.tableVd.getIndexes();
        if (!this.tableVd.occursClause || variableNameList == null) {
            throw new GeneralErrorException(11, 4, token2, token2.getWord(), this.error);
        }
        if (this.table.getDimension() > 0) {
            throw new GeneralErrorException(11, 4, token2, token2.getWord(), this.error);
        }
        if (token2.isAll()) {
            if (this.tableVd.ascOccursKey == null && this.tableVd.descOccursKey == null) {
                throw new GeneralErrorException(11, 4, token2, token2.getWord(), this.error);
            }
            this.indexItem = variableNameList.getFirst();
            this.binarySearch(this.tm.getToken());
        } else {
            this.search(this.tm.getToken());
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 445) {
            this.tm.ungetToken();
        } else if (this.nextSentence != null) {
            this.ns = new NextSentence(this.nextSentence, block, this.pc, this.tm, this.error);
        }
    }

    private void search(Token token) throws GeneralErrorException, EndOfProgramException {
        if (token.getToknum() == 807) {
            token = this.tm.getToken();
            if (token.getToknum() == 10009) {
                this.tm.ungetToken();
                this.indexItem = VariableName.get(this.tm, this.error, this.pc);
                if (!this.indexItem.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(46, 4, token, token.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            token = this.tm.getToken();
        }
        boolean bl = false;
        VariableNameList variableNameList = this.tableVd.getIndexes();
        if (this.indexItem != null) {
            VariableName variableName = variableNameList.getFirst();
            while (variableName != null) {
                if (variableName.getName().equalsIgnoreCase(this.indexItem.getName())) {
                    bl = true;
                    break;
                }
                variableName = variableNameList.getNext();
            }
            if (!bl) {
                this.indexItem2 = this.indexItem;
                this.indexItem = variableNameList.getFirst();
            }
        } else {
            this.indexItem = variableNameList.getFirst();
            this.indexItem.getVarDecl().setUsed();
        }
        if (token.getToknum() == 284 && (token = this.tm.getToken()).getToknum() != 422) {
            throw new ExpectedFoundException(token, this.error, "'END'");
        }
        if (token.getToknum() == 422) {
            this.atEndBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 5);
            token = this.tm.getToken();
        }
        if (token.getToknum() != 810) {
            throw new ExpectedFoundException(token, this.error, "'WHEN'");
        }
        while (token.getToknum() == 810) {
            this.whenConds.addItem(new SearchWhenPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error));
            token = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private void binarySearch(Token token) throws GeneralErrorException, EndOfProgramException {
        this.binary = true;
        if (token.getToknum() == 284 && (token = this.tm.getToken()).getToknum() != 422) {
            throw new ExpectedFoundException(token, this.error, "'END'");
        }
        if (token.getToknum() == 422) {
            this.atEndBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 5);
            token = this.tm.getToken();
        }
        if (token.getToknum() != 810) {
            throw new ExpectedFoundException(token, this.error, "'WHEN'");
        }
        this.allConds.addItem(new SearchAllCond(this.keyWord, this.parent, this.pc, this.tm, this.error));
        token = this.tm.getToken();
        while (token.getToknum() == 274) {
            this.allConds.addItem(new SearchAllCond(this.keyWord, this.parent, this.pc, this.tm, this.error));
            token = this.tm.getToken();
        }
        if (token.getToknum() == 595) {
            this.nextSentence = token;
            token = this.tm.getToken();
            if (token.getToknum() != 714) {
                throw new ExpectedFoundException(token, this.error, "SENTENCE");
            }
            token = this.tm.getToken();
            if (token.getToknum() != 10006 && token.getToknum() != 445) {
                throw new ExpectedFoundException(token, this.error, "END-SEARCH|.");
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
            this.allBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.binary) {
            Verb verb = this.allConds.getFirst();
            while (verb != null) {
                verb.check();
                verb = this.allConds.getNext();
            }
        } else {
            Verb verb = this.whenConds.getFirst();
            while (verb != null) {
                verb.check();
                verb = this.whenConds.getNext();
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.binary) {
            stringBuffer.append(this.getCodeBinary());
        } else {
            stringBuffer.append(this.getCodeSequential());
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private String getCodeBinary() {
        int n2;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = Search.getUniqueId();
        String string = "search$comp" + n3;
        stringBuffer.append("CobolVar.SearchComparator " + string + " = ");
        boolean bl2 = bl = this.pc.getOption("-sqlj") != null;
        if (bl) {
            stringBuffer.append("new CobolVar.SearchComparator() { public int compareTo() {");
        } else {
            stringBuffer.append("() -> {");
        }
        stringBuffer.append(eol);
        int n4 = 1;
        Verb verb = this.allConds.getFirst();
        while (verb != null) {
            for (n2 = 0; n2 <= n4; ++n2) {
                stringBuffer.append("   ");
            }
            stringBuffer.append(verb.getCode());
            verb = this.allConds.getNext();
            ++n4;
        }
        stringBuffer.append(this.parent.getIndent() + "   ");
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("return 0;" + eol);
        n4 = this.allConds.getItemNum();
        SearchAllCond searchAllCond = (SearchAllCond)this.allConds.getLast();
        while (searchAllCond != null) {
            stringBuffer.append(this.parent.getIndent() + "   ");
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuffer.append("   ");
            }
            stringBuffer.append("else " + searchAllCond.getCodeAfter());
            if (searchAllCond.isAscKey) {
                stringBuffer.append("return 1;" + eol);
            } else {
                stringBuffer.append("return -1;" + eol);
            }
            stringBuffer.append(this.parent.getIndent() + "   ");
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuffer.append("   ");
            }
            stringBuffer.append("else ");
            if (searchAllCond.isAscKey) {
                stringBuffer.append("return -1;" + eol);
            } else {
                stringBuffer.append("return 1;" + eol);
            }
            searchAllCond = (SearchAllCond)this.allConds.getPrevious();
            --n4;
        }
        stringBuffer.append(this.parent.getIndent());
        if (bl) {
            stringBuffer.append("}");
        }
        stringBuffer.append("};" + eol);
        stringBuffer.append(this.parent.getIndent() + "if(CobolVar.searchAll(");
        if (this.tableVd.isDepending()) {
            stringBuffer.append(this.tableVd.getDepending().getCode() + ".toint() , " + this.indexItem.getCode());
        } else {
            int n5 = 0;
            VariableDeclaration variableDeclaration = this.tableVd.parent;
            while (variableDeclaration != null) {
                if (variableDeclaration.occursMin > 0) {
                    ++n5;
                }
                variableDeclaration = variableDeclaration.parent;
            }
            stringBuffer.append(this.tableVd.getQualUnivoqueName()).append(".getDimensions()[" + n5 + "] , ");
            stringBuffer.append(this.indexItem.getCode());
        }
        stringBuffer.append(" , " + string + "))");
        if (this.allBlock != null) {
            stringBuffer.append(this.allBlock.getCode());
        } else if (this.ns != null) {
            stringBuffer.append("{");
            stringBuffer.append(this.ns.getCode());
            stringBuffer.append("}");
        } else {
            stringBuffer.append(" ;");
        }
        if (this.atEndBlock != null) {
            stringBuffer.append(" else ");
            stringBuffer.append(this.atEndBlock.getCode() + eol);
        }
        return stringBuffer.toString();
    }

    private String getCodeSequential() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Search.getUniqueId();
        String string = "search$comp" + n2;
        stringBuffer.append("CobolVar.SearchEvaluator " + string + " = ");
        boolean bl2 = bl = this.pc.getOption("-sqlj") != null;
        if (bl) {
            stringBuffer.append("new CobolVar.SearchEvaluator() { public int evaluate() {");
        } else {
            stringBuffer.append("() -> {");
        }
        stringBuffer.append(eol);
        int n3 = 1;
        Object object = (SearchWhenPhrase)this.whenConds.getFirst();
        while (object != null) {
            stringBuffer.append(this.parent.getIndent() + "      if(");
            stringBuffer.append(((SearchWhenPhrase)object).cond.getCode() + ") return " + n3 + ";" + eol);
            object = (SearchWhenPhrase)this.whenConds.getNext();
            ++n3;
        }
        stringBuffer.append(this.parent.getIndent() + "      return -1;" + eol);
        stringBuffer.append(this.parent.getIndent());
        if (bl) {
            stringBuffer.append("}");
        }
        stringBuffer.append("};" + eol);
        object = "search$retval" + n2;
        stringBuffer.append(this.parent.getIndent() + "int " + (String)object + " = ");
        if (this.tableVd.isDepending()) {
            stringBuffer.append("CobolVar.search(" + this.tableVd.getDepending().getCode() + ".toint() , ");
        } else {
            int n4 = 0;
            VariableDeclaration variableDeclaration = this.tableVd.parent;
            while (variableDeclaration != null) {
                if (variableDeclaration.occursMin > 0) {
                    ++n4;
                }
                variableDeclaration = variableDeclaration.parent;
            }
            stringBuffer.append("CobolVar.search(");
            stringBuffer.append(this.tableVd.getQualUnivoqueName());
            stringBuffer.append(".getDimensions()[" + n4 + "] , ");
        }
        stringBuffer.append(this.indexItem.getCode() + " , ");
        if (this.indexItem2 != null) {
            stringBuffer.append(this.indexItem2.getCode());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" , " + string + ");" + eol);
        n3 = 1;
        SearchWhenPhrase searchWhenPhrase = (SearchWhenPhrase)this.whenConds.getFirst();
        while (searchWhenPhrase != null) {
            if (n3 == 1) {
                stringBuffer.append(this.parent.getIndent());
            } else {
                stringBuffer.append(" else ");
            }
            stringBuffer.append("if(" + (String)object + " == " + n3 + ")");
            if (searchWhenPhrase.whenBlock != null) {
                stringBuffer.append(searchWhenPhrase.whenBlock.getCode());
            } else if (this.ns != null) {
                stringBuffer.append("{");
                stringBuffer.append(this.ns.getCode());
                stringBuffer.append("}");
            } else {
                stringBuffer.append(" ; ");
            }
            searchWhenPhrase = (SearchWhenPhrase)this.whenConds.getNext();
            ++n3;
        }
        if (this.atEndBlock != null) {
            stringBuffer.append(" else ");
            stringBuffer.append(this.atEndBlock.getCode());
        }
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public boolean isBinary() {
        return this.binary;
    }

    public VariableName getTable() {
        return this.table;
    }

    public VariableDeclaration getTableDeclaration() {
        return this.tableVd;
    }

    public VerbList getAllConds() {
        return this.allConds;
    }

    public VerbList getWhenConds() {
        return this.whenConds;
    }

    public VariableName getIndexItem1() {
        return this.indexItem;
    }

    public VariableName getIndexItem2() {
        return this.indexItem2;
    }

    public Block getAtEndBlock() {
        return this.atEndBlock;
    }

    public Block getAllBlock() {
        return this.allBlock;
    }

    public NextSentence getNextSentence() {
        return this.ns;
    }

    public class SearchAllCond
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VariableName tblItem;
        boolean isCond;
        boolean isAscKey;
        Expression value;

        public SearchAllCond(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.tblItem = null;
            this.isCond = false;
            this.isAscKey = true;
            Token token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            TokenManager.Marker marker = this.tm.getMarker();
            this.tm.setMarker(marker);
            VariableName variableName = null;
            this.tblItem = VariableName.get(this.tm, this.error, this.pc);
            if (this.tblItem.getVarDecl().level == 88) {
                this.check(this.tblItem.getVarDecl().parent, true);
                this.isCond = true;
            } else {
                if (!this.check(this.tblItem.getVarDecl(), false)) {
                    variableName = this.tblItem;
                    this.tblItem = null;
                    this.tm.rewindToMarker(marker);
                    this.value = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                }
                if ((token2 = this.tm.getToken()).getToknum() == 545) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 462) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 773) {
                        token2 = this.tm.getToken();
                    }
                } else if (token2.getToknum() == 61 || token2.getToknum() == 463) {
                    token2 = this.tm.getToken();
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.tm.ungetToken();
                if (this.tblItem == null) {
                    if (token2.getToknum() != 10009) {
                        throw new GeneralErrorException(11, 4, variableName.getNameToken(), variableName.getName() + " not a KEY for " + Search.this.table.getName(), this.error);
                    }
                    this.tblItem = VariableName.get(this.tm, this.error, this.pc);
                    this.check(this.tblItem.getVarDecl(), true);
                } else {
                    this.value = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                }
            }
        }

        @Override
        public void check() throws GeneralErrorException {
            if (this.value != null) {
                this.value.check();
            }
        }

        private boolean check(VariableDeclaration variableDeclaration, boolean bl) throws GeneralErrorException {
            VariableName variableName;
            VariableNameList variableNameList = Search.this.tableVd.ascOccursKey;
            VariableNameList variableNameList2 = Search.this.tableVd.descOccursKey;
            boolean bl2 = false;
            if (variableNameList != null) {
                variableName = variableNameList.getFirst();
                while (variableName != null) {
                    if (variableName.getName().equalsIgnoreCase(variableDeclaration.getName())) {
                        bl2 = true;
                        break;
                    }
                    variableName = variableNameList.getNext();
                }
            }
            if (!bl2 && variableNameList2 != null) {
                variableName = variableNameList2.getFirst();
                while (variableName != null) {
                    if (variableName.getName().equalsIgnoreCase(variableDeclaration.getName())) {
                        bl2 = true;
                        this.isAscKey = false;
                        break;
                    }
                    variableName = variableNameList2.getNext();
                }
            }
            if (!bl2 && bl) {
                throw new GeneralErrorException(11, 4, variableDeclaration.name, variableDeclaration.getName() + " not a KEY for " + Search.this.table.getName(), this.error);
            }
            return bl2;
        }

        @Override
        public String getCode() {
            return this.getCode(false);
        }

        private String getCode(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            Alphabet alphabet = this.pc.getProgramCollatingSeq();
            if (!bl) {
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append("if(");
            if (this.isCond) {
                VariableDeclaration variableDeclaration = this.tblItem.getVarDecl().parent;
                stringBuffer.append(variableDeclaration.getQualUnivoqueName());
                stringBuffer.append(this.tblItem.getSubscriptCode());
                stringBuffer.append(".compareTo(");
                stringBuffer.append(this.getCodeLiteral(this.tblItem.getVarDecl().getLowValue(0)));
                if (alphabet != null) {
                    stringBuffer.append("," + alphabet.getDeclUnivoqueName());
                }
            } else {
                stringBuffer.append(this.tblItem.getCode());
                stringBuffer.append(".compareTo(");
                stringBuffer.append(this.value.getCode());
                if (alphabet != null && !this.value.isNumeric()) {
                    stringBuffer.append("," + alphabet.getDeclUnivoqueName());
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(bl ? ">" : "==");
            stringBuffer.append("0) ");
            if (!bl) {
                stringBuffer.append(eol);
            }
            return stringBuffer.toString();
        }

        public String getCodeAfter() {
            return this.getCode(true);
        }

        public Expression getValue() {
            return this.value;
        }

        public boolean isCond() {
            return this.isCond;
        }

        public boolean isAscendingKey() {
            return this.isAscKey;
        }

        public VariableName getTableItem() {
            return this.tblItem;
        }
    }

    public class SearchWhenPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        Condition cond;
        Block whenBlock;

        public SearchWhenPhrase(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
            if (!this.cond.isFullCondition()) {
                throw new IllegalConditionException(this.keyWord, this.error);
            }
            Token token2 = this.tm.getToken();
            if (token2.getToknum() == 595) {
                Search.this.nextSentence = token2;
                token2 = this.tm.getToken();
                if (token2.getToknum() != 714) {
                    throw new ExpectedFoundException(token2, this.error, "SENTENCE");
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10006 && token2.getToknum() != 810 && token2.getToknum() != 445) {
                    throw new ExpectedFoundException(token2, this.error, "WHEN|END-SEARCH|.");
                }
                this.tm.ungetToken();
            } else {
                this.tm.ungetToken();
                this.whenBlock = new Block(this.parent, this.parent.parent, Search.this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            }
        }

        @Override
        public void check() throws GeneralErrorException {
            this.cond.check();
        }

        @Override
        public String getCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if(");
            stringBuffer.append(this.cond.getCode());
            stringBuffer.append(")");
            stringBuffer.append(eol);
            return stringBuffer.toString();
        }

        public Condition getCondition() {
            return this.cond;
        }

        public Block getWhenBlock() {
            return this.whenBlock;
        }
    }
}

