/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.EfdHint;
import com.iscobol.compiler.EfdParser;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Key;
import com.iscobol.compiler.KeyList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.ISelectExtension;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.rts.Config;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class Select
implements CobolToken,
ErrorsNumbers,
ISelectExtension {
    private Pcc pc;
    private TokenManager tm;
    private Token device;
    private Token opSysName;
    private VariableName opSysNameVar;
    private Token memLengthTk;
    private VariableName memLengthVar;
    private EfdParser efdExtraInfo;
    private StringList efdKeysParts;
    private String efdName;
    private Token paddingChar;
    private VariableName paddingCharVar;
    private Errors error;
    private int lockMode = 290;
    private boolean isLockSet;
    private boolean recordDelimiterStd1;
    private int reserveArea = 0;
    private boolean optional;
    private boolean line;
    private boolean flsu;
    private boolean massUpdate;
    private boolean rollback;
    private boolean multipleRecords;
    private boolean explicitBinary;
    private boolean trailingSpaces = false;
    private FileDescriptor fd;
    private VariableName fileStatus;
    private VariableName fileStatus2;
    private Token collating;
    private Alphabet alphabet;
    private Key recordKey;
    private KeyList altKeys;
    private boolean isExternal;
    private Token classToken;
    private VariableName classVar;
    private VariableName addressVar;
    private Select sameRecordAreaOf;
    private Vector masterRecordAreaFor;
    private final Token keyWord;
    private boolean compression;
    private boolean encryption;
    private int comprCntrlValue = 1;
    final Token fileName;
    VariableName relativeKey;
    int organization = 717;
    int accessMode = 717;
    VariableName useGiving;
    boolean isPrinter;
    Token isPrinterTok = null;
    boolean writeSimple = false;
    private boolean sort;
    private boolean assignExt;
    boolean hasBefore;
    private boolean xmlLineFeed = true;
    private boolean xml;
    private Token xmlDocTypeTk;
    private VariableName xmlDocTypeVn;
    private boolean xmlCheckValidityI;
    private boolean xmlCheckValidityO;

    void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    @Override
    public boolean isSort() {
        return this.sort;
    }

    public boolean isXml() {
        return this.xml;
    }

    @Override
    public boolean isLine() {
        return this.line;
    }

    boolean allowsOpenIO() {
        return !(this.isPrinter && this.pc.options.getOption("-cm") == null || this.line && this.flsu);
    }

    boolean allowsDelete() {
        return !this.isPrinter && !this.line;
    }

    void check(Pcc pcc) throws GeneralErrorException {
        CobolToken cobolToken;
        if (pcc.data != null && pcc.data.fileSec != null && (this.fd = pcc.data.fileSec.getFD(this.fileName.getWord())) != null) {
            if (!(this.isExternal || pcc instanceof CobolMethod || this.fd.threadLocal)) {
                pcc.addFinalizeCode("   " + this.getName() + ".finalize();" + eol);
            }
        } else {
            throw new GeneralErrorException(51, 4, this.fileName, this.fileName.getWord(), this.error);
        }
        this.sort = this.fd.isSort();
        if (this.addressVar != null) {
            this.addressVar.check(pcc);
        }
        if (this.xmlDocTypeVn != null) {
            this.xmlDocTypeVn.check(pcc);
        }
        if (this.classVar != null) {
            this.classVar.check(pcc);
        }
        if (this.opSysNameVar != null) {
            if (pcc.getAny(this.opSysNameVar, true, true) == null) {
                cobolToken = VariableDeclaration.getPicX(pcc, this.tm, this.opSysName, 256, null);
                pcc.fixedVars.addItem((VariableDeclaration)cobolToken);
                pcc.loadVariable((VariableDeclaration)cobolToken);
                ((VariableDeclaration)cobolToken).setUsed();
            }
            this.opSysNameVar.check(pcc);
            if (!(this.memLengthTk == null || this.xml && (this.opSysNameVar.getVarDecl().isPointer() || this.opSysNameVar.getVarDecl().isHandle()))) {
                throw new GeneralErrorException(29, 4, this.memLengthTk, this.memLengthTk.getWord(), this.error);
            }
            if (this.memLengthVar != null) {
                this.memLengthVar.check(pcc);
            }
        }
        if (this.organization == 677) {
            if (this.relativeKey == null) {
                if (this.accessMode != 717) {
                    throw new GeneralErrorException(57, 4, this.fileName, this.fileName.getWord(), this.error);
                }
            } else {
                this.relativeKey.check(pcc);
                if (!this.relativeKey.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(56, 4, this.fileName, this.relativeKey.getName(), this.error);
                }
            }
        }
        if (this.paddingCharVar != null) {
            this.paddingCharVar.check(pcc);
        }
        if (this.fileStatus != null) {
            this.fileStatus.check(pcc);
            cobolToken = this.fileStatus.getVarDecl();
            if (this.xml) {
                if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited() || !((VariableDeclaration)cobolToken).isSigned()) {
                    throw new GeneralErrorException(284, 4, this.fileStatus.name, this.fileStatus.name.getWord(), this.error);
                }
            } else if (((VariableDeclaration)cobolToken).isNumeric() && this.tm.getOptionList().getOption("-cv") == null || ((VariableDeclaration)cobolToken).isEdited || ((VariableDeclaration)cobolToken).phisicLen != 2) {
                throw new GeneralErrorException(52, 4, this.fileStatus.name, this.fileStatus.name.getWord(), this.error);
            }
        }
        if (this.fileStatus2 != null) {
            this.fileStatus2.check(pcc);
        }
        if (this.recordKey != null) {
            this.recordKey.check(pcc, this.fd.getVirtualParent());
            if (this.altKeys != null) {
                cobolToken = this.altKeys.getFirst();
                while (cobolToken != null) {
                    ((Key)cobolToken).check(pcc, this.fd.getVirtualParent());
                    cobolToken = this.altKeys.getNext();
                }
            }
        }
        if (this.fd.hasLinage()) {
            this.isPrinter = true;
        }
        if (this.collating != null) {
            SpecialNames specialNames;
            ConfigurationSection configurationSection;
            cobolToken = pcc.getEnvironmentDivision();
            if (cobolToken != null && (configurationSection = ((EnvironmentDivision)cobolToken).getConfigurationSection()) != null && (specialNames = configurationSection.getSpecialNames()) != null) {
                this.alphabet = specialNames.getAlphabet(this.collating);
            }
            if (this.alphabet == null) {
                throw new GeneralErrorException(25, 4, this.fileName, "ALPHABET " + this.collating.getWord(), this.error);
            }
        }
        if ((cobolToken = this.checkAltKeys()) != null) {
            throw new GeneralErrorException(210, 2, this.fileName, ((Key)cobolToken).keyName.getName(), this.error);
        }
    }

    public VariableDeclaration[] getPrimaryKey() {
        if (this.recordKey != null) {
            return this.recordKey.getVars();
        }
        return null;
    }

    VariableDeclaration[] getKeyByOffset(int n2) {
        VariableDeclaration[] variableDeclarationArray;
        if (this.recordKey != null && (variableDeclarationArray = this.recordKey.getVars()) != null && variableDeclarationArray[0] != null && variableDeclarationArray[0].getOffset() == n2) {
            return variableDeclarationArray;
        }
        if (this.altKeys != null) {
            Key key = this.altKeys.getFirst();
            while (key != null) {
                variableDeclarationArray = key.getVars();
                if (variableDeclarationArray != null && variableDeclarationArray[0] != null && variableDeclarationArray[0].getOffset() == n2) {
                    return variableDeclarationArray;
                }
                key = this.altKeys.getNext();
            }
        }
        return null;
    }

    VariableDeclaration[] getKeyByName(String string) {
        if (this.recordKey != null && string.equals(this.recordKey.keyName.name.getWord())) {
            return this.recordKey.getVars();
        }
        if (this.altKeys != null) {
            Key key = this.altKeys.getFirst();
            while (key != null) {
                if (string.equals(key.keyName.name.getWord())) {
                    return key.getVars();
                }
                key = this.altKeys.getNext();
            }
        }
        return null;
    }

    String getKeysPartsByName(String string) {
        String string2 = null;
        string2 = this.efdKeysParts.getFirst();
        while (string2 != null) {
            if (string.equalsIgnoreCase(string2)) {
                return string2;
            }
            string2 = this.efdKeysParts.getNext();
        }
        return null;
    }

    public String getEfdCobTrigger() {
        String string = this.efdExtraInfo != null ? this.efdExtraInfo.getCobtrigger() : null;
        return string;
    }

    public String getEfdName() {
        if (this.efdName == null) {
            this.efdName = this.fd.getEfdName();
            if (this.opSysNameVar != null && this.efdName == null) {
                this.error.print(119, 2, this.fd.fileName, "SELECT");
            }
            if (this.efdName == null) {
                this.efdName = this.opSysNameVar != null ? this.opSysNameVar.getName().replace('-', '_').replace('.', '_').toLowerCase(Locale.US) : (this.opSysName != null ? this.opSysName.getCode().replace('-', '_').replace('.', '_').toLowerCase(Locale.US) : this.fd.fileName.getCode().replace('-', '_').replace('.', '_').toLowerCase(Locale.US));
            }
            File file = new File(this.efdName);
            this.efdName = file.getName();
        }
        return this.efdName;
    }

    @Override
    public String getName() {
        String string = "";
        if (this.fd != null && this.fd.threadLocal) {
            string = string + "$my_thloc_stg$.";
        }
        string = string + this.getBaseName();
        return string;
    }

    String getBaseName() {
        return "file$" + this.fileName.getWord().replace('-', Pcc.hyphenRepl);
    }

    @Override
    public String getMemBufName() {
        return this.getBaseName() + "$0";
    }

    private void addKey(StringBuffer stringBuffer, Key key) {
        VariableDeclaration[] variableDeclarationArray = key.getVars();
        int n2 = 0;
        while (true) {
            stringBuffer.append(variableDeclarationArray[n2].getUnivoqueName());
            if (++n2 >= variableDeclarationArray.length) break;
            stringBuffer.append(",");
        }
    }

    private static void addToVec(Vector vector, VariableDeclaration variableDeclaration) {
        boolean bl = false;
        if (variableDeclaration != null && variableDeclaration.children.getItemNum() > 0) {
            bl = true;
            int n2 = 0;
            VariableDeclaration variableDeclaration2 = variableDeclaration.children.getFirst();
            while (variableDeclaration2 != null) {
                if (variableDeclaration2.level == 88 || variableDeclaration2.level == 78) {
                    ++n2;
                }
                variableDeclaration2 = variableDeclaration.children.getNext();
            }
            if (variableDeclaration.children.getItemNum() == n2) {
                bl = false;
            }
        }
        if (variableDeclaration != null) {
            if (!bl) {
                vector.addElement(variableDeclaration);
            } else {
                VariableDeclaration variableDeclaration3 = variableDeclaration.children.getFirst();
                while (variableDeclaration3 != null) {
                    Select.addToVec(vector, variableDeclaration3);
                    variableDeclaration3 = variableDeclaration.children.getNext();
                }
            }
        }
    }

    VariableDeclaration[] getAllKeyFields() {
        VariableDeclaration[] variableDeclarationArray = new VariableDeclaration[]{};
        if (this.organization == 529) {
            int n2;
            Vector vector = new Vector();
            VariableDeclaration[] variableDeclarationArray2 = this.recordKey.getVars();
            for (n2 = 0; n2 < variableDeclarationArray2.length; ++n2) {
                Select.addToVec(vector, variableDeclarationArray2[n2]);
            }
            if (this.altKeys != null) {
                Key key = this.altKeys.getFirst();
                while (key != null) {
                    variableDeclarationArray2 = key.getVars();
                    for (n2 = 0; n2 < variableDeclarationArray2.length; ++n2) {
                        Select.addToVec(vector, variableDeclarationArray2[n2]);
                    }
                    key = this.altKeys.getNext();
                }
            }
            variableDeclarationArray = new VariableDeclaration[vector.size()];
            for (n2 = 0; n2 < variableDeclarationArray.length; ++n2) {
                variableDeclarationArray[n2] = (VariableDeclaration)vector.elementAt(n2);
            }
        }
        return variableDeclarationArray;
    }

    private void addEfdKey(StringBuffer stringBuffer, Key key, int n2, String string) throws GeneralErrorException {
        VariableDeclaration[] variableDeclarationArray = key.getVars();
        boolean bl = true;
        int n3 = 0;
        Vector vector = this.fd.getHints();
        stringBuffer.append(" <key segCount='");
        stringBuffer.append(variableDeclarationArray.length);
        stringBuffer.append("' duplicate='");
        stringBuffer.append(key.duplicates);
        stringBuffer.append("'>");
        stringBuffer.append(string);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EfdHint efdHint = (EfdHint)enumeration.nextElement();
                if (n2 != efdHint.getIdx()) continue;
                stringBuffer.append(" <hint ");
                if (efdHint.getString() != null) {
                    stringBuffer.append("string='");
                    stringBuffer.append(efdHint.getString());
                } else {
                    stringBuffer.append("idx='");
                    stringBuffer.append(efdHint.getNumber());
                }
                stringBuffer.append("'/>");
                stringBuffer.append(string);
            }
        }
        for (n3 = 0; n3 < variableDeclarationArray.length; ++n3) {
            stringBuffer.append("  <segment offset='");
            stringBuffer.append(variableDeclarationArray[n3].getOffset());
            stringBuffer.append("' size='");
            stringBuffer.append(variableDeclarationArray[n3].getPhisicLen());
            stringBuffer.append("'/>");
            stringBuffer.append(string);
        }
        for (n3 = 0; n3 < variableDeclarationArray.length; ++n3) {
            if (variableDeclarationArray[n3].getEfdKeyCode(stringBuffer, string, variableDeclarationArray, this.efdKeysParts)) continue;
            bl = false;
        }
        if (!bl) {
            if (this.pc.isEasyDBActivated()) {
                throw new GeneralErrorException(245, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            stringBuffer.append("<part name='!!!!Error in FD'/>" + string);
        }
        stringBuffer.append(" </key>");
        stringBuffer.append(string);
    }

    private void addEfcKey(StringBuffer stringBuffer, Key key, String string) {
        VariableDeclaration[] variableDeclarationArray = key.getVars();
        boolean bl = true;
        int n2 = 0;
        stringBuffer.append(" <key segCount='");
        stringBuffer.append(variableDeclarationArray.length);
        stringBuffer.append("' duplicate='");
        stringBuffer.append(key.duplicates);
        stringBuffer.append("'>");
        stringBuffer.append(string);
        for (n2 = 0; n2 < variableDeclarationArray.length; ++n2) {
            stringBuffer.append("  <segment offset='");
            stringBuffer.append(variableDeclarationArray[n2].getOffset());
            stringBuffer.append("' size='");
            stringBuffer.append(variableDeclarationArray[n2].getPhisicLen());
            stringBuffer.append("'/>");
            stringBuffer.append(string);
        }
        for (n2 = 0; n2 < variableDeclarationArray.length; ++n2) {
            if (variableDeclarationArray[n2].getEfcKeyCode(stringBuffer, string, true)) continue;
            bl = false;
        }
        if (!bl) {
            stringBuffer.append("<part name='!!!!Error in FD'/>" + string);
        }
        stringBuffer.append(" </key>");
        stringBuffer.append(string);
    }

    @Override
    public boolean hasLinage() {
        return this.fd != null && this.fd.hasLinage();
    }

    public String getCode(StringBuffer stringBuffer) {
        String string = this.fd.isSort() ? this.getCodeSort(stringBuffer) : (this.xml ? this.getCodeXml(stringBuffer) : this.getCodeFile(stringBuffer));
        if (this.keyWord != null) {
            string = this.tm.getCommentCode(this.keyWord, "   ") + string;
        }
        return string;
    }

    public String getCodeSort(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* [SELECT] */" + eol);
        stringBuffer2.append("   CobolSort ");
        String string = this.getBaseName();
        stringBuffer2.append(string);
        stringBuffer2.append(";");
        stringBuffer2.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("=Factory.getSort (");
        stringBuffer.append("\"");
        stringBuffer.append(this.fileName.getWord());
        stringBuffer.append("\",");
        if (this.opSysNameVar != null) {
            stringBuffer.append(this.opSysNameVar.getCode());
        } else {
            stringBuffer.append(this.tm.getCodeLiteral(this.opSysName));
        }
        stringBuffer.append(",");
        if (this.pc.optionMS) {
            stringBuffer.append(this.fd.getVirtualParent().getUnivoqueName());
        } else {
            stringBuffer.append(this.fd.getVirtualParent().getDeclUnivoqueName());
        }
        stringBuffer.append(",");
        stringBuffer.append(this.fd.recordMin);
        if (this.sort) {
            stringBuffer.append(",");
            if (this.fileStatus != null) {
                stringBuffer.append(this.fileStatus.getCode());
            } else {
                stringBuffer.append("null");
            }
        }
        stringBuffer.append(")");
        if (this.alphabet != null) {
            stringBuffer.append(".collatingSequence (");
            stringBuffer.append(this.alphabet.getDeclUnivoqueNameBytes());
            stringBuffer.append(")");
        }
        stringBuffer.append(";");
        stringBuffer.append(eol);
        return stringBuffer2.toString();
    }

    public String getEfdCode() throws GeneralErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.efdExtraInfo != null && this.efdExtraInfo.getComment() != null) {
            stringBuffer.append(this.efdExtraInfo.getXmlComment() + eol);
        }
        stringBuffer.append("<table name='");
        stringBuffer.append(this.getEfdName());
        stringBuffer.append("' type='");
        switch (this.organization) {
            case 529: {
                stringBuffer.append("idx");
                break;
            }
            case 677: {
                stringBuffer.append("rel");
                break;
            }
            default: {
                stringBuffer.append("seq");
            }
        }
        int n2 = this.fd.getMaxRecLen();
        stringBuffer.append("' maxRecLen='");
        stringBuffer.append(n2);
        stringBuffer.append("' minRecLen='");
        if (this.tm.getOptionList().getOption("-crv") != null) {
            stringBuffer.append(this.fd.getMinRecLen(n2));
        } else if (this.fd.recordMin == 0) {
            stringBuffer.append(n2);
        } else {
            stringBuffer.append(this.fd.recordMin);
        }
        if (this.efdExtraInfo != null && this.efdExtraInfo.isTemporary()) {
            stringBuffer.append("' temporary='" + this.efdExtraInfo.getTemporaryType());
        } else if (this.fd != null && this.fd.getEfdTemporaryType() != null) {
            stringBuffer.append("' temporary='" + this.fd.getEfdTemporaryType());
        }
        if (this.organization == 529) {
            stringBuffer.append("' keyCount='");
            if (this.altKeys != null) {
                stringBuffer.append("" + (this.altKeys.getItemNum() + 1));
            } else {
                stringBuffer.append("1");
            }
            stringBuffer.append("'>");
            stringBuffer.append(eol);
            int n3 = 1;
            this.efdKeysParts = new StringList();
            this.addEfdKey(stringBuffer, this.recordKey, n3, eol);
            if (this.altKeys != null) {
                Key key = this.altKeys.getFirst();
                while (key != null) {
                    this.addEfdKey(stringBuffer, key, ++n3, eol);
                    key = this.altKeys.getNext();
                }
            }
        } else {
            stringBuffer.append("'>");
        }
        this.fd.getEfdCode(stringBuffer, eol, "");
        stringBuffer.append("</table>");
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public String getEfcCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.efdExtraInfo != null && this.efdExtraInfo.getComment() != null) {
            stringBuffer.append(this.efdExtraInfo.getXmlComment() + eol);
        }
        stringBuffer.append("<table name='");
        stringBuffer.append(this.getEfdName());
        int n2 = this.fd.getMaxRecLen();
        stringBuffer.append("' maxRecLen='");
        stringBuffer.append(n2);
        stringBuffer.append("' minRecLen='");
        if (this.tm.getOptionList().getOption("-crv") != null) {
            stringBuffer.append(this.fd.getMinRecLen(n2));
        } else if (this.fd.recordMin == 0) {
            stringBuffer.append(n2);
        } else {
            stringBuffer.append(this.fd.recordMin);
        }
        stringBuffer.append("'");
        if (this.pc.options.getOption("-dca") != null) {
            stringBuffer.append(" dataConvention=\"-dca\"");
        } else if (this.pc.options.getOption("-dcd") != null) {
            stringBuffer.append(" dataConvention=\"-dcd\"");
        } else if (this.pc.options.getOption("-dcm") != null) {
            stringBuffer.append(" dataConvention=\"-dcm\"");
        } else if (this.pc.options.getOption("-dcmi") != null) {
            stringBuffer.append(" dataConvention=\"-dcmi\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(eol);
        if (this.organization == 529) {
            this.addEfcKey(stringBuffer, this.recordKey, eol);
            if (this.altKeys != null) {
                Key key = this.altKeys.getFirst();
                while (key != null) {
                    this.addEfcKey(stringBuffer, key, eol);
                    key = this.altKeys.getNext();
                }
            }
        }
        this.fd.getEfcCode(stringBuffer, eol, "");
        stringBuffer.append("</table>");
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public String getCodeXml(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* [SELECT] */" + eol);
        stringBuffer2.append("   ");
        if (this.pc.isFactory()) {
            stringBuffer2.append("static ");
        }
        stringBuffer2.append("XmlFile ");
        String string = this.getBaseName();
        stringBuffer2.append(string);
        stringBuffer2.append(";");
        stringBuffer2.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append("Factory.getFileXml");
        stringBuffer.append(" (");
        stringBuffer.append("\"");
        stringBuffer.append(this.fileName.getWord());
        stringBuffer.append("\",");
        if (this.pc.optionMS) {
            stringBuffer.append(this.fd.getFirstRecord().getUnivoqueName());
        } else {
            stringBuffer.append(this.fd.getFirstRecord().getDeclUnivoqueName());
        }
        stringBuffer.append(",");
        if (this.addressVar != null) {
            stringBuffer.append(this.addressVar.getCode());
        } else if (this.memLengthVar != null) {
            if (this.pc.getOption("-cp") != null) {
                stringBuffer.append("new PicX(");
                stringBuffer.append(this.opSysNameVar.getCode());
                stringBuffer.append(".getAddress(), ");
                stringBuffer.append(this.memLengthVar.getCode());
                stringBuffer.append(".toint())");
            } else {
                stringBuffer.append("((CobolVar) ");
                stringBuffer.append(this.opSysNameVar.getCode());
                stringBuffer.append(".getId()).sub(1, ");
                stringBuffer.append(this.memLengthVar.getCode());
                stringBuffer.append(".toint())");
            }
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(",");
        stringBuffer.append(this.xmlLineFeed);
        stringBuffer.append(",");
        if (this.xmlDocTypeTk != null) {
            stringBuffer.append(this.tm.getCodeLiteral(this.xmlDocTypeTk));
        } else if (this.xmlDocTypeVn != null) {
            stringBuffer.append(this.xmlDocTypeVn.getCode());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        return stringBuffer2.toString();
    }

    public String getCodeFile(StringBuffer stringBuffer) {
        ErrorsNumbers errorsNumbers;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* [SELECT] */" + eol);
        if (this.pc.isFactory()) {
            stringBuffer2.append("   static CobolFile ");
        } else {
            stringBuffer2.append("   CobolFile ");
        }
        String string = this.getBaseName();
        stringBuffer2.append(string);
        stringBuffer2.append(";");
        stringBuffer2.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("=");
        if (this.classToken != null || this.classVar != null) {
            stringBuffer.append("Factory.getFileGeneric");
        } else if (this.organization == 677) {
            stringBuffer.append("Factory.getFileRelative");
        } else if (this.organization == 529) {
            stringBuffer.append("Factory.getFileIndexed");
        } else if (this.isPrinter) {
            if (this.tm.getOptionList().getOption("-cm") != null) {
                stringBuffer.append("Factory.getFilePrinterMF");
            } else {
                stringBuffer.append("Factory.getFilePrinter");
            }
        } else if (this.addressVar != null) {
            stringBuffer.append("Factory.getFileString");
        } else if (this.line) {
            if (this.flsu) {
                stringBuffer.append("Factory.getFileLineSeq");
            } else {
                stringBuffer.append("Factory.getFileLineSeq8bit");
            }
        } else {
            stringBuffer.append("Factory.getFileSequential");
        }
        if (this.isExternal) {
            stringBuffer.append("Ext");
        }
        stringBuffer.append(" (");
        stringBuffer.append("\"");
        stringBuffer.append(this.fileName.getWord());
        stringBuffer.append("\",");
        stringBuffer.append(this.fd.getMaxRecLen());
        stringBuffer.append(",");
        if (this.pc.optionMS) {
            stringBuffer.append(this.fd.getFirstRecord().getUnivoqueName());
        } else {
            stringBuffer.append(this.fd.getFirstRecord().getDeclUnivoqueName());
        }
        stringBuffer.append(",");
        stringBuffer.append(this.fd.recordMin);
        if (this.sort) {
            stringBuffer.append(",");
            if (this.fileStatus != null) {
                stringBuffer.append(this.fileStatus.getCode());
            } else {
                stringBuffer.append("null");
            }
        }
        stringBuffer.append(",");
        stringBuffer.append(this.optional);
        if (this.addressVar != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.addressVar.getCode());
            stringBuffer.append(",");
            if (this.line) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append("false");
            }
        }
        if (this.organization == 677 || this.organization == 529) {
            if (this.accessMode == 414) {
                stringBuffer.append(",CobolFile.ACCESS_DYNAMIC");
            } else if (this.accessMode == 664) {
                stringBuffer.append(",CobolFile.ACCESS_RANDOM");
            } else {
                stringBuffer.append(",CobolFile.ACCESS_SEQUENTIAL");
            }
        } else if (this.classToken != null || this.classVar != null) {
            stringBuffer.append(",CobolFile.ACCESS_SEQUENTIAL");
        }
        if (this.classToken != null || this.classVar != null) {
            if (this.organization == 677) {
                stringBuffer.append("|CobolFile.ORG_RELATIVE");
            } else if (this.organization == 529) {
                stringBuffer.append("|CobolFile.ORG_INDEXED");
            } else if (this.line) {
                stringBuffer.append("|CobolFile.ORG_LINE_SEQUENTIAL");
            } else {
                stringBuffer.append("|CobolFile.ORG_SEQUENTIAL");
            }
            stringBuffer.append(",");
            if (this.classVar != null) {
                stringBuffer.append(this.classVar.getCode());
            } else {
                stringBuffer.append(this.tm.getCodeLiteral(this.classToken));
            }
        }
        stringBuffer.append(")");
        if (this.organization == 529) {
            stringBuffer.append(".key(new CobolVar[] {");
            this.addKey(stringBuffer, this.recordKey);
            stringBuffer.append("},");
            stringBuffer.append(this.recordKey.duplicates);
            stringBuffer.append(")");
            if (this.altKeys != null) {
                errorsNumbers = this.altKeys.getFirst();
                while (errorsNumbers != null) {
                    stringBuffer.append(".key(new CobolVar[] {");
                    this.addKey(stringBuffer, (Key)errorsNumbers);
                    stringBuffer.append("},");
                    stringBuffer.append(((Key)errorsNumbers).duplicates);
                    stringBuffer.append(")");
                    errorsNumbers = this.altKeys.getNext();
                }
            }
            if (this.alphabet != null) {
                stringBuffer.append(".collatingSequence (");
                stringBuffer.append(this.alphabet.getDeclUnivoqueNameBytes());
                stringBuffer.append(")");
            }
        } else if (this.organization == 677 && this.relativeKey != null) {
            stringBuffer.append(".relativeKey (");
            if (this.fd.threadLocal) {
                this.relativeKey.getVarDecl().noCobolClassPfx = true;
                stringBuffer.append(this.relativeKey.getCode());
                this.relativeKey.getVarDecl().noCobolClassPfx = false;
            } else {
                stringBuffer.append(this.relativeKey.getCode());
            }
            stringBuffer.append(")");
        }
        if (this.fd.hasLinage()) {
            stringBuffer.append(".");
            this.fd.getLinageCode(stringBuffer);
        }
        if (this.assignExt) {
            stringBuffer.append(".setAssignExt(true)");
        }
        if ((errorsNumbers = this.fd.getCodeSet()) != null) {
            stringBuffer.append(".setCodeSet(");
            stringBuffer.append(errorsNumbers.getDeclUnivoqueNameBytes());
            stringBuffer.append(")");
        }
        stringBuffer.append(";");
        stringBuffer.append(eol);
        if (this.isCompressed()) {
            stringBuffer.append(string);
            stringBuffer.append(".setCompressionFactor(" + this.getCompressionFactor() + ");");
            stringBuffer.append(eol);
        }
        if (this.trailingSpaces && !this.isPrinter) {
            if (this.flsu) {
                stringBuffer.append("((LineSeqFile)");
            } else {
                stringBuffer.append("((LineSequentialDFile)");
            }
            stringBuffer.append(string);
            stringBuffer.append(").setTrailingSpaces();");
            stringBuffer.append(eol);
        }
        return stringBuffer2.toString();
    }

    public String getCodeDebug() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/* [SELECT] */" + eol);
        stringBuffer.append("/* fileName = [" + this.fileName.getWord() + "] */" + eol);
        stringBuffer.append("/* optional = " + this.optional + " */" + eol);
        if (this.device != null) {
            stringBuffer.append("/* device = [" + this.device.getWord() + "] */" + eol);
        }
        if (this.opSysName != null) {
            if (this.opSysNameVar == null) {
                stringBuffer.append("/* opSysNam = [" + this.opSysName.getWord() + "] */" + eol);
            } else {
                stringBuffer.append("/* opSysNam */" + eol + this.opSysNameVar.getCode());
            }
        }
        stringBuffer.append("/* organization = " + (this.organization == 677 ? "RELATIVE */" : (this.organization == 529 ? "INDEXED */" : "SEQUENTIAL */")) + eol);
        stringBuffer.append("/* access mode = " + (this.accessMode == 664 ? "RANDOM */" : (this.accessMode == 414 ? "DYNAMIC */" : "SEQUENTIAL */")) + eol);
        if (this.relativeKey != null) {
            stringBuffer.append("/* relativeKey */" + eol + this.relativeKey.getCode());
        }
        if (this.recordKey != null) {
            stringBuffer.append("/* recordKey */" + eol + this.recordKey.getCode());
        }
        if (this.altKeys != null) {
            Key key = this.altKeys.getFirst();
            while (key != null) {
                stringBuffer.append("/* altKey */" + eol + key.getCode());
                key = this.altKeys.getNext();
            }
        }
        if (this.paddingChar != null) {
            if (this.paddingCharVar == null) {
                stringBuffer.append("/* paddingChar = [" + this.paddingChar.getWord() + "] */" + eol);
            } else {
                stringBuffer.append("/* paddingCharVar */" + eol + this.paddingCharVar.getCode());
            }
        }
        if (this.reserveArea > 0) {
            stringBuffer.append("/* reserveArea = " + this.reserveArea + " */" + eol);
        }
        if (this.fileStatus != null) {
            stringBuffer.append("/* fileStatus */" + eol + this.fileStatus.getCode());
        }
        if (this.collating != null) {
            stringBuffer.append("/* collating = " + this.collating.getWord() + " */" + eol);
        }
        stringBuffer.append("/* lock mode = " + (this.lockMode == 578 ? "MANUAL */" : (this.lockMode == 473 ? "EXCLUSIVE */" : (this.lockMode == 290 ? "AUTOMATIC */" : "NULL */"))) + eol);
        stringBuffer.append("/* multipleRecords = " + this.multipleRecords + " */" + eol);
        stringBuffer.append("/* mass-update = " + this.massUpdate + " */" + eol);
        stringBuffer.append("/* rollback = " + this.rollback + " */" + eol);
        return stringBuffer.toString();
    }

    @Override
    public VariableDeclaration getFirstRecord() {
        return this.fd.getFirstRecord();
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    Select() {
        this.keyWord = new Token(712, "SELECT", 0, 0, "");
        this.fileName = new Token(10009, "dummy", 0, 0, "");
    }

    public Select(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        boolean bl;
        this.tm = tokenManager;
        this.error = errors;
        this.pc = pcc;
        boolean bl2 = bl = this.tm.getOptionList().getOption("-fl") == null;
        if (this.tm.getOptionList().getOption("-fm") != null) {
            this.lockMode = 578;
        } else if (this.tm.getOptionList().getOption("-cm") != null) {
            this.lockMode = 0;
        } else if (this.tm.getOptionList().getOption("-ci") != null) {
            this.lockMode = 578;
            this.multipleRecords = true;
        }
        this.tm.ungetToken();
        this.keyWord = this.tm.getToken();
        Token token = this.tm.getToken();
        if (token.getToknum() == 598) {
            token = this.tm.getToken();
            if (token.getToknum() != 616) {
                throw new ExpectedFoundException(token, this.error, "OPTIONAL");
            }
            token = this.tm.getToken();
        } else if (token.getToknum() == 616) {
            this.optional = true;
            token = this.tm.getToken();
        }
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.fileName = token;
        boolean bl3 = false;
        token = this.tm.getToken();
        while (token.getToknum() != 10006) {
            block1 : switch (token.getToknum()) {
                case 283: {
                    bl3 = true;
                    this.assign();
                    break;
                }
                case 257: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 587) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    switch (token.getToknum()) {
                        case 414: 
                        case 664: 
                        case 717: {
                            this.accessMode = token.getToknum();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
                case 335: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 716) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                }
                case 716: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if ((this.collating = token).getToknum() == 10009) break;
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
                case 732: {
                    if (!this.sort) {
                        this.error.print(11, 4, token, token.getWord());
                    }
                }
                case 482: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 742) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                }
                case 742: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 545) {
                        this.tm.ungetToken();
                    }
                    this.fileStatus = VariableName.get(this.tm, this.error);
                    if (this.fileStatus == null) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                    if (this.tm.getOptionList().getOption("-cv") == null) break;
                    token = this.tm.getToken();
                    if (token.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.fileStatus2 = VariableName.get(this.tm, this.error);
                        if (this.fileStatus2 != null) break;
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                    this.tm.ungetToken();
                    break;
                }
                case 570: {
                    this.isLockSet = true;
                    this.multipleRecords = false;
                    token = this.tm.getToken();
                    if (token.getToknum() == 587) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    switch (token.getToknum()) {
                        case 473: {
                            this.lockMode = token.getToknum();
                            token = this.tm.getToken();
                            if (token.getToknum() == 813) {
                                token = this.tm.getToken();
                            }
                            if (token.getToknum() == 579) {
                                this.massUpdate = true;
                                break block1;
                            }
                            this.tm.ungetToken();
                            break block1;
                        }
                        case 290: 
                        case 578: {
                            this.lockMode = token.getToknum();
                            token = this.tm.getToken();
                            if (token.getToknum() == 813) {
                                token = this.tm.getToken();
                            }
                            if (token.getToknum() == 701) {
                                this.rollback = true;
                                this.multipleRecords = bl;
                                break block1;
                            }
                            if (token.getToknum() == 570) {
                                token = this.tm.getToken();
                            }
                            if (token.getToknum() == 613) {
                                token = this.tm.getToken();
                                if (token.getToknum() == 591) {
                                    this.multipleRecords = true;
                                    bl = true;
                                    token = this.tm.getToken();
                                }
                                if (token.getToknum() == 670 || token.getToknum() == 672) {
                                    token = this.tm.getToken();
                                    if (token.getToknum() == 813) {
                                        token = this.tm.getToken();
                                        if (token.getToknum() != 701) {
                                            throw new UnexpectedTokenException(token, this.error);
                                        }
                                        this.rollback = true;
                                        this.multipleRecords = bl;
                                        break block1;
                                    }
                                    if (token.getToknum() == 701) {
                                        this.rollback = true;
                                        this.multipleRecords = bl;
                                        break block1;
                                    }
                                    this.tm.ungetToken();
                                    break block1;
                                }
                                if (this.multipleRecords) {
                                    this.tm.ungetToken();
                                    break block1;
                                }
                                throw new UnexpectedTokenException(token, this.error);
                            }
                            this.tm.ungetToken();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
                case 619: {
                    this.line = false;
                    token = this.tm.getToken();
                    if (token.getToknum() != 545) {
                        this.tm.ungetToken();
                    }
                    if ((token = this.tm.getToken()).getToknum() == 670) break;
                    this.tm.ungetToken();
                    break;
                }
                case 565: {
                    this.line = true;
                    break;
                }
                case 818: {
                    this.xml = true;
                    token = this.tm.getToken();
                    boolean bl4 = false;
                    if (token.getToknum() != 10009 || !(bl4 = "DOCUMENT-TYPE".equals(token.getWord())) && !"CHECK".equals(token.getWord())) {
                        this.tm.ungetToken();
                        break;
                    }
                    if (bl4) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 545) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() != 612) {
                            if (token.getToknum() == 478) {
                                token = this.tm.getToken();
                            }
                            if (token.getToknum() == 10009) {
                                this.tm.ungetToken();
                                this.xmlDocTypeVn = VariableName.get(this.tm, this.error);
                                if (this.xmlDocTypeVn == null) {
                                    token = this.tm.getToken();
                                    throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
                                }
                            } else if (token.getToknum() == 10001) {
                                this.xmlDocTypeTk = token;
                            } else {
                                throw new GeneralErrorException(21, 4, token, token.getWord(), this.error);
                            }
                        }
                        this.xmlCheckValidity(this.tm.getToken());
                        break;
                    }
                    this.xmlCheckValidity(token);
                    break;
                }
                case 301: {
                    this.explicitBinary = true;
                    token = this.tm.getToken();
                    break;
                }
                case 677: {
                    if (token.getToknum() == 677) {
                        Token token2 = this.tm.getToken();
                        if (token2.getToknum() == 551 || token2.getToknum() == 545 || token2.getToknum() == 10009) {
                            token = token2;
                            if (token.getToknum() == 551) {
                                token = this.tm.getToken();
                            }
                            if (token.getToknum() == 545) {
                                token = this.tm.getToken();
                            }
                            this.tm.ungetToken();
                            this.relativeKey = VariableName.get(this.tm, this.error);
                            if (this.relativeKey != null) break;
                            throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
                        }
                        this.tm.ungetToken();
                    }
                }
                case 529: 
                case 717: {
                    switch (token.getToknum()) {
                        case 529: 
                        case 677: 
                        case 717: {
                            this.organization = token.getToknum();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(token, token.getWord(), this.error);
                }
                case 813: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 354) {
                        this.compression = true;
                        token = this.tm.getToken();
                        if (token.getToknum() == 421) {
                            this.encryption = true;
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    if (token.getToknum() == 421) {
                        this.encryption = true;
                        token = this.tm.getToken();
                        if (token.getToknum() == 354) {
                            this.compression = true;
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    throw new UnexpectedTokenException(token, errors);
                }
                case 354: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 373) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 803) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.comprCntrlValue = Integer.parseInt(token.getWord());
                        if (this.comprCntrlValue < 0 || this.comprCntrlValue > 100) {
                            throw new NumberFormatException();
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new GeneralErrorException(30, 4, token, token.getWord(), this.error);
                    }
                }
                case 628: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 323) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    this.paddingChar = token;
                    if (token.getToknum() == 10001) break;
                    if (token.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.paddingCharVar = VariableName.get(this.tm, this.error);
                        break;
                    }
                    throw new GeneralErrorException(21, 4, token, token.getWord(), this.error);
                }
                case 670: 
                case 672: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 399) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 545) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() != 740) {
                            throw new UnexpectedTokenException(token, errors);
                        }
                        this.recordDelimiterStd1 = true;
                        break;
                    }
                    if (token.getToknum() == 551) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    if (this.recordKey != null) {
                        throw new GeneralErrorException(175, 4, token, token.getWord(), this.error);
                    }
                    this.recordKey = new Key(this.tm, this.error, true);
                    break;
                }
                case 273: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 670) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 551) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    if (this.altKeys == null) {
                        this.altKeys = new KeyList();
                    }
                    this.altKeys.addItem(new Key(this.tm, this.error, false));
                    break;
                }
                case 688: {
                    token = this.tm.getToken();
                    if (Token.isIntLit(token)) {
                        this.reserveArea = Integer.parseInt(token.getWord());
                        token = this.tm.getToken();
                        if (token.getToknum() == 278 || token.getToknum() == 279) break;
                        this.tm.ungetToken();
                        break;
                    }
                    throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                }
                case 325: {
                    if (this.classToken != null || this.classVar != null) {
                        throw new GeneralErrorException(92, 4, token, token.getWord(), this.error);
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10001) {
                        this.classToken = token;
                        break;
                    }
                    if (token.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.classVar = VariableName.get(this.tm, this.error);
                        break;
                    }
                    throw new GeneralErrorException(21, 4, token, token.getWord(), this.error);
                }
                default: {
                    throw new UnexpectedTokenException(token, errors);
                }
            }
            token = this.tm.getToken();
        }
        if (!bl3) {
            throw new GeneralErrorException(18, 4, this.keyWord, "ASSIGN", this.error);
        }
        if (this.organization == 717 && !this.sort && !this.explicitBinary && this.tm.getOptionList().getOption("-cfl") != null) {
            this.line = true;
        }
        if (this.line && this.device != null && (this.device.getToknum() == 534 || this.device.getToknum() == 535 || this.device.getToknum() == 623)) {
            this.trailingSpaces = true;
        } else if (this.line && this.opSysName != null && (this.opSysName.getWord().equals("CARD-PUNCH") || this.opSysName.getWord().equals("CARD-READER") || this.opSysName.getWord().equals("CASSETTE") || this.opSysName.getWord().equals("MAGNETIC-TAPE"))) {
            this.trailingSpaces = true;
        }
        this.checks();
    }

    private void xmlCheckValidity(Token token) throws GeneralErrorException, EndOfProgramException {
        while (token.getToknum() == 10009 && "CHECK".equals(token.getWord())) {
            if (this.xmlCheckValidityI && this.xmlCheckValidityO) {
                throw new UnexpectedTokenException(token, this.error);
            }
            token = this.tm.getToken();
            if (token.getToknum() == 10009 && "VALIDITY".equals(token.getWord())) {
                token = this.tm.getToken();
            }
            if (token.getToknum() == 534) {
                if (this.xmlCheckValidityI) {
                    throw new UnexpectedTokenException(token, this.error);
                }
                this.xmlCheckValidityI = true;
            } else if (token.getToknum() == 623) {
                if (this.xmlCheckValidityO) {
                    throw new UnexpectedTokenException(token, this.error);
                }
                this.xmlCheckValidityO = true;
            }
            token = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private void assign() throws GeneralErrorException, EndOfProgramException {
        int n2;
        Object object;
        boolean bl;
        Token token = this.tm.getToken();
        if (token.getToknum() == 773) {
            token = this.tm.getToken();
        }
        boolean bl2 = bl = this.tm.getOptionList().getOption("-cax") != null;
        if (token.getToknum() == 478) {
            this.assignExt = true;
            token = this.tm.getToken();
        } else if (token.getToknum() == 414) {
            bl = false;
            token = this.tm.getToken();
        } else if (token.getToknum() == 598) {
            this.xmlLineFeed = false;
            token = this.tm.getToken();
            if (token.getToknum() != 565) {
                throw new ExpectedFoundException(token, this.error, "LINE");
            }
            token = this.tm.getToken();
            if (token.getToknum() == 260) {
                token = this.tm.getToken();
            }
        }
        switch (token.getToknum()) {
            case 408: 
            case 552: {
                this.organization = 717;
                this.line = true;
            }
            case 406: 
            case 407: 
            case 534: 
            case 535: 
            case 623: 
            case 664: {
                this.device = token;
                token = this.tm.getToken();
                break;
            }
            case 644: 
            case 645: 
            case 646: {
                this.device = token;
                token = this.tm.getToken();
                this.isPrinter = true;
                break;
            }
            case 565: {
                token = this.tm.getToken();
                if (token.getToknum() == 260) {
                    this.device = token;
                    token = this.tm.getToken();
                    this.isPrinter = true;
                    break;
                }
                throw new ExpectedFoundException(token, this.error, "ADVANCING");
            }
            case 259: {
                this.device = token;
                token = this.tm.getToken();
                if (token.getToknum() != 609) {
                    this.tm.ungetToken();
                }
                this.addressVar = VariableName.get(this.tm, this.error);
                if (this.addressVar == null) {
                    token = this.tm.getToken();
                    throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
                }
                token = this.tm.getToken();
                break;
            }
            case 368: {
                throw new GeneralErrorException(19, 4, token, token.getWord(), this.error);
            }
            case 581: 
            case 732: 
            case 733: 
            case 734: {
                token = this.tm.getToken();
                this.sort = true;
                break;
            }
            case 10009: {
                if (!"ADDRESS OF".equals(token.getWord())) break;
                token = this.tm.getToken();
                if (token.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.addressVar = VariableName.get(this.tm, this.error);
                    if (this.addressVar == null) {
                        throw new GeneralErrorException(24, 4, token, "", this.error);
                    }
                    token = this.tm.getToken();
                    break;
                }
                throw new GeneralErrorException(24, 4, token, "", this.error);
            }
        }
        if (token.getToknum() == 10001) {
            this.opSysName = token;
            token = this.tm.getToken();
        } else if (token.getToknum() == 10009) {
            if (bl) {
                this.assignExt = true;
            }
            if (this.tm.getOptionList().getOption("-csl") != null) {
                this.opSysName = new Token(token);
                this.opSysName.setWord("'" + token.getWord().replace('-', '_') + "'");
                this.opSysName.setToknum(10001);
            } else if (this.assignExt) {
                if (this.tm.getOptionList().getOption("-cv") != null) {
                    object = token.getWord().replace('_', '-');
                    n2 = ((String)object).lastIndexOf(45);
                    if (n2 >= 0) {
                        if (++n2 < ((String)object).length()) {
                            object = ((String)object).substring(n2, ((String)object).length());
                        } else {
                            throw new GeneralErrorException(144, 4, token, token.getWord(), this.error);
                        }
                    }
                    this.opSysName = new Token(token);
                    this.opSysName.setWord("'" + (String)object + "'");
                    this.opSysName.setToknum(10001);
                } else {
                    this.opSysName = new Token(token);
                    this.opSysName.setWord("'" + token.getWord().replace('-', '_') + "'");
                    this.opSysName.setToknum(10001);
                }
            } else {
                this.opSysName = token;
                this.tm.ungetToken();
                this.opSysNameVar = VariableName.get(this.tm, this.error);
            }
            token = this.tm.getToken();
            if (token.isLength() && this.opSysNameVar != null) {
                this.memLengthTk = token;
                token = this.tm.getToken();
                if (token.getToknum() == 545) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() != 10009) {
                    throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.memLengthVar = VariableName.get(this.tm, this.error);
                token = this.tm.getToken();
                this.opSysName = new Token(this.fileName);
                this.opSysName.setWord("'" + this.fileName.getWord() + "'");
                this.opSysName.setToknum(10001);
            }
        } else {
            if (this.assignExt) {
                throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
            }
            this.opSysName = new Token(this.fileName);
            this.opSysName.setWord("'" + this.fileName.getWord() + "'");
            this.opSysName.setToknum(10001);
        }
        if (this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.b(".compiler.easydb", false)) {
            n2 = 0;
            if (this.tm.getOptionList().getOption("-efc") != null) {
                n2 = 1;
            }
            if ((object = this.tm.delExtraInfo("XFD")) != null || (object = this.tm.delExtraInfo("EFC")) != null || (object = this.tm.delExtraInfo("EFD")) != null) {
                this.efdExtraInfo = new EfdParser((TokenList)object, n2 != 0, this.error);
            }
        }
        this.tm.ungetToken();
    }

    private void checks() throws GeneralErrorException {
        switch (this.organization) {
            case 717: {
                if (this.recordKey != null || this.relativeKey != null || this.altKeys != null || this.accessMode != 717 || this.massUpdate || this.rollback || this.collating != null && !this.isSort()) {
                    throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
                }
                this.flsu = this.tm.getOptionList().getOption("-flsu") != null;
                break;
            }
            case 677: {
                if (this.relativeKey == null && this.accessMode != 717) {
                    throw new GeneralErrorException(25, 4, this.fileName, "RELATIVE KEY", this.error);
                }
                if (this.recordKey == null && this.altKeys == null && this.paddingChar == null && this.addressVar == null && !this.massUpdate && !this.rollback && !this.line && this.collating == null) break;
                throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
            }
            case 529: {
                if (this.recordKey == null) {
                    throw new GeneralErrorException(25, 4, this.fileName, "RECORD KEY", this.error);
                }
                if (this.relativeKey == null && !this.line && this.addressVar == null && this.paddingChar == null) break;
                throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
            }
        }
    }

    private Key checkAltKeys() {
        if (this.altKeys != null) {
            int n2;
            Key key;
            Object object;
            int n3;
            KeyList keyList;
            int n4 = this.altKeys.getItemNum();
            VariableDeclaration[][] variableDeclarationArrayArray = new VariableDeclaration[n4 + 1][];
            if (this.tm.getOptionList().getOption("-cko") != null) {
                keyList = new KeyList();
                n3 = 0;
                while (!this.altKeys.isEmpty()) {
                    object = this.altKeys.getFirst();
                    n3 = 0;
                    key = this.altKeys.getFirst();
                    while (key != null) {
                        if (key.getVars()[0].getOffset() < ((Key)object).getVars()[0].getOffset()) {
                            object = key;
                            n3 = this.altKeys.getCurrentIndex();
                        }
                        key = this.altKeys.getNext();
                    }
                    keyList.addItem((Key)object);
                    this.altKeys.getAt(n3);
                    this.altKeys.deleteCurrent();
                }
                this.altKeys = keyList;
            }
            if (this.tm.getOptionList().getOption("-crko") != null) {
                keyList = new KeyList();
                n3 = 0;
                int n5 = 0;
                while (!this.altKeys.isEmpty()) {
                    object = this.altKeys.getFirst();
                    key = object;
                    n3 = this.altKeys.getCurrentIndex();
                    while (key != null) {
                        if (key.getVars()[0].getOffset() < ((Key)object).getVars()[0].getOffset()) {
                            object = key;
                            n3 = this.altKeys.getCurrentIndex();
                        } else if (key.getVars()[0].getOffset() == ((Key)object).getVars()[0].getOffset()) {
                            for (n5 = 1; n5 < key.getVars().length; ++n5) {
                                if (((Key)object).getVars().length <= n5 || key.getVars()[n5].getOffset() == ((Key)object).getVars()[n5].getOffset()) continue;
                                if (key.getVars()[n5].getOffset() >= ((Key)object).getVars()[n5].getOffset()) break;
                                object = key;
                                n3 = this.altKeys.getCurrentIndex();
                                break;
                            }
                        }
                        key = this.altKeys.getNext();
                    }
                    keyList.addItem((Key)object);
                    this.altKeys.getAt(n3);
                    this.altKeys.deleteCurrent();
                }
                this.altKeys = keyList;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                variableDeclarationArrayArray[n2] = this.altKeys.getAt(n2).getVars();
            }
            variableDeclarationArrayArray[n4] = this.recordKey.getVars();
            for (n2 = n4; n2 > 0; --n2) {
                object = variableDeclarationArrayArray[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (((VariableDeclaration[])object).length != variableDeclarationArrayArray[i2].length) continue;
                    n3 = 0;
                    for (n3 = 0; n3 < ((Object)object).length && ((VariableDeclaration)object[n3]).getOffset() == variableDeclarationArrayArray[i2][n3].getOffset() && ((VariableDeclaration)object[n3]).getPhisicLen() == variableDeclarationArrayArray[i2][n3].getPhisicLen(); ++n3) {
                    }
                    if (n3 != ((Object)object).length) continue;
                    return this.altKeys.getAt(i2);
                }
            }
        }
        return null;
    }

    public void setOpSysName(Token token) {
        this.opSysName = token;
        this.opSysNameVar = null;
    }

    public void setOpSysNameVar(VariableName variableName) {
        this.opSysNameVar = variableName;
        this.opSysName = variableName.name;
    }

    public String getPathCode() {
        if (this.opSysNameVar != null && this.memLengthTk == null) {
            return this.opSysNameVar.getCode();
        }
        return this.tm.getCodeLiteral(this.opSysName);
    }

    @Override
    public int getLockMode() {
        return this.lockMode;
    }

    @Override
    public int getLockMode(int n2) {
        if (this.lockMode == 0) {
            if (n2 == 534) {
                return 578;
            }
            return 473;
        }
        return this.lockMode;
    }

    @Override
    public boolean getMassUpdate() {
        return this.massUpdate;
    }

    @Override
    public boolean getMultipleRecords() {
        return this.multipleRecords;
    }

    public void setMultipleRecords(boolean bl) {
        this.multipleRecords = bl;
    }

    @Override
    public boolean isWithRollback() {
        return this.rollback;
    }

    @Override
    public boolean isEncrypted() {
        return this.encryption;
    }

    @Override
    public boolean isCompressed() {
        return this.compression;
    }

    @Override
    public VariableName getFileStatus() {
        return this.fileStatus;
    }

    @Override
    public boolean hasLockSupport() {
        if (this.classToken != null || this.classVar != null) {
            return true;
        }
        if (this.organization == 677) {
            return true;
        }
        if (this.organization == 529) {
            return true;
        }
        if (this.isPrinter) {
            return false;
        }
        if (this.addressVar != null) {
            return false;
        }
        if (this.line) {
            return !this.flsu;
        }
        return true;
    }

    void setSameRecordArea(Select select) {
        this.sameRecordAreaOf = select;
        if (select.masterRecordAreaFor == null) {
            select.masterRecordAreaFor = new Vector();
        }
        select.masterRecordAreaFor.addElement(this);
    }

    @Override
    public Select getSameRecordArea() {
        return this.sameRecordAreaOf;
    }

    @Override
    public Vector getMasterRecordAreaFor() {
        return this.masterRecordAreaFor;
    }

    @Override
    public boolean hasSameRecordArea() {
        return this.masterRecordAreaFor != null || this.sameRecordAreaOf != null;
    }

    @Override
    public VariableName getOpSysNameVar() {
        return this.opSysNameVar;
    }

    @Override
    public Token getOpSysName() {
        return this.opSysName;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isFlsu() {
        return this.flsu;
    }

    @Override
    public boolean isMassUpdate() {
        return this.massUpdate;
    }

    @Override
    public boolean isLockSet() {
        return this.isLockSet;
    }

    @Override
    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public boolean isMultipleRecords() {
        return this.multipleRecords;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public Key getRecordKey() {
        return this.recordKey;
    }

    @Override
    public KeyList getAltKeys() {
        return this.altKeys;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public Token getClassToken() {
        return this.classToken;
    }

    @Override
    public VariableName getClassVar() {
        return this.classVar;
    }

    @Override
    public VariableName getAddressVar() {
        return this.addressVar;
    }

    @Override
    public Token getFileName() {
        return this.fileName;
    }

    @Override
    public VariableName getRelativeKey() {
        return this.relativeKey;
    }

    @Override
    public int getOrganization() {
        return this.organization;
    }

    @Override
    public int getAccessMode() {
        return this.accessMode;
    }

    @Override
    public boolean isPrinter() {
        return this.isPrinter;
    }

    @Override
    public boolean isAssignExt() {
        return this.assignExt;
    }

    @Override
    public VariableName getUseGiving() {
        return this.useGiving;
    }

    @Override
    public Token getKeyWord() {
        return this.keyWord;
    }

    @Override
    public Token getDevice() {
        return this.device;
    }

    @Override
    public Token getCollating() {
        return this.collating;
    }

    @Override
    public int getCompressionFactor() {
        return this.comprCntrlValue;
    }

    @Override
    public IToken getPaddingChar() {
        return this.paddingChar;
    }

    @Override
    public IVariableName getPaddingCharVar() {
        return this.paddingCharVar;
    }

    @Override
    public boolean isRecordDelimiterStd1() {
        return this.recordDelimiterStd1;
    }

    @Override
    public int getReserveArea() {
        return this.reserveArea;
    }
}

