/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Send
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName threadHandle;
    private VariableName msgVar;
    private Token msgToken;
    private boolean last;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Send(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.msgVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            if (token2.getToknum() != 10001 && token2.getToknum() != 10002 && token2.getToknum() != 10017) throw new UnexpectedTokenException(token2, this.error);
            this.msgToken = token2;
            this.msgToken.setWord(token2.getWord());
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 773) throw new ExpectedFoundException(token2, this.error, "'TO'");
        token2 = this.tm.getToken();
        if (token2.getToknum() == 763 || token2.getToknum() == 10009) {
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
            }
            this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
            if (this.threadHandle == null) {
                token2 = this.tm.getToken();
                throw new UnexpectedTokenException(token2, this.error);
            }
            if (this.threadHandle.getVarDecl().isValidThreadHandle()) return;
            throw new ClauseClashException(token2, this.error, this.threadHandle.getName());
        }
        if (token2.getToknum() == 554) {
            this.last = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 763) return;
            throw new ExpectedFoundException(token2, this.error, "'THREAD'");
        }
        if (token2.getToknum() != 262) throw new UnexpectedTokenException(token2, this.error);
        token2 = this.tm.getToken();
        if (token2.getToknum() == 766 || token2.getToknum() == 763) return;
        throw new UnexpectedTokenException(token2, this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("Factory.send (");
        if (this.threadHandle == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.threadHandle.getCode());
        }
        stringBuffer.append(", ");
        if (this.msgVar != null) {
            stringBuffer.append(this.msgVar.getCode());
        } else {
            stringBuffer.append(this.getCodeLiteral(this.msgToken));
        }
        stringBuffer.append(", ");
        stringBuffer.append(this.last);
        stringBuffer.append(");");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

