/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStreamConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ServiceBridgeUtility {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final String SOAP_ENVELOPE_START = "       01  soap-";
    private static final String SOAP_NS_PFX = "soapenv";
    private static final String ARRAY_OF = "ArrayOf";
    private static final String[] SOAP_ENVELOPE_NS = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"};
    public static final int V1_1 = 0;
    public static final int V1_2 = 1;
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_SOAPHTTP = "http://schemas.xmlsoap.org/soap/http";
    private static final Map<String, String> soapTypes = new HashMap<String, String>();
    private final List<Type> types = new ArrayList<Type>();
    private final List<Message> messages = new ArrayList<Message>();
    private final List<PortType> portTypes = new ArrayList<PortType>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private List<DeferredTypeGetCode> deferredMessageTypes;
    private Set<String> varnames;
    private String targetNamespace;
    private Map<String, String> currPref2ns;
    private Map<String, String> currNs2Pref;
    private Map<String, Integer> arraySizes = new HashMap<String, Integer>();
    private final Map<String, String> globPref2ns = new HashMap<String, String>();
    private final Map<String, String> globNs2Pref = new HashMap<String, String>();
    private final Map<String, String> restrictions = new HashMap<String, String>();
    private boolean schemaElemFormQual;
    private final int version;
    private final String uri;
    private int idProg;
    private int nsProg;
    private Set<String> wsdlImports = new HashSet<String>();

    private static void putSpace(StringBuilder stringBuilder, int n2) {
        stringBuilder.append("         ");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
    }

    private static void putLevel(StringBuilder stringBuilder, int n2) {
        ServiceBridgeUtility.putSpace(stringBuilder, n2);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }

    public ServiceBridgeUtility(String string, int n2) {
        this.uri = string;
        this.version = n2;
    }

    public Map<String, StringBuilder> generateCopyfiles() throws ParserConfigurationException, IOException, SAXException {
        return this.generateCopyfiles(ServiceBridgeUtility.openXml(this.uri));
    }

    private static Element openXml(String string) throws IOException, SAXException, ParserConfigurationException {
        InputStream inputStream;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            object = new URL(string);
            inputStream = ((URL)object).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        object = documentBuilder.parse(inputStream);
        inputStream.close();
        object.getDocumentElement().normalize();
        return object.getDocumentElement();
    }

    public int getVersion() {
        return this.version;
    }

    public String getURI() {
        return this.uri;
    }

    private String getURI(String string) {
        String string2 = null;
        if (this.currPref2ns != null) {
            string2 = this.currPref2ns.get(string);
        }
        if (string2 == null) {
            string2 = this.globPref2ns.get(string);
        }
        return string2;
    }

    private FullName getUriAndNameFromAttr(Element element, String string) throws SAXException {
        return this.getUriAndNameFromAttr(element, string, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FullName getUriAndNameFromAttr(Element element, String string, String string2) throws SAXException {
        String string3;
        String string4;
        String string5 = string2 == null ? element.getAttribute(string) : element.getAttributeNS(string2, string);
        if (string5 == null) return null;
        if (string5.length() <= 0) return null;
        int n2 = string5.indexOf(58);
        if (n2 > 0) {
            string4 = this.getURI(string5.substring(0, n2));
            if (string4 == null) {
                throw new SAXException("Invalid namespace in element:" + string5.substring(0, n2));
            }
            if (++n2 >= string5.length()) throw new SAXException("Void name in element:" + string5);
            string3 = string5.substring(n2);
            return new FullName(string4, string3);
        } else {
            string4 = this.targetNamespace;
            string3 = string5;
        }
        return new FullName(string4, string3);
    }

    private Type getType(Element element, boolean bl) throws SAXException {
        String string;
        Object object;
        Object object2;
        ElementIterator elementIterator = new ElementIterator(element);
        String string2 = element.getAttribute("name");
        FullName fullName = this.getUriAndNameFromAttr(element, "type");
        if (fullName == null) {
            fullName = this.getUriAndNameFromAttr(element, "element");
            if (fullName == null) {
                object2 = this.getUriAndNameFromAttr(element, "ref");
                fullName = object2;
            }
            if (fullName != null) {
                string2 = fullName.name;
            }
        }
        if (fullName != null) {
            if ("http://www.w3.org/2001/XMLSchema".equals(fullName.uri)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(fullName.name)) {
                    ServiceBridgeUtility.warning("Invalid type '" + fullName.name + "'");
                }
                object2 = new Type(string2, "simple", fullName, bl, this.currNs2Pref);
            } else {
                object = XMLStreamConstants.xsdSimpleTypes.containsKey(fullName.name) ? "simple" : "reference";
                object2 = new Type(string2, (String)object, fullName, bl, this.currNs2Pref);
            }
        } else {
            object2 = element.hasChildNodes() ? ((object = elementIterator.next()) != null ? ((string = object.getLocalName()).equalsIgnoreCase("complexType") ? this.scanComplexTypes((Element)object, string2, bl) : (string.equalsIgnoreCase("simpleType") ? this.scanSimpleTypes((Node)object, string2, bl) : null)) : null) : null;
        }
        if (object2 != null) {
            object = element.getAttribute("maxOccurs");
            if (object != null && ((String)object).length() > 0) {
                int n2 = -1;
                if (((String)object).equals("unbounded")) {
                    n2 = 0;
                } else {
                    try {
                        n2 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n2 == 0 || n2 > 1) {
                    ((Type)object2).dimensions++;
                    if (((Type)object2).dimensionSize == null) {
                        Type.access$3302((Type)object2, new int[]{n2});
                    } else {
                        int[] nArray = ((Type)object2).dimensionSize;
                        Type.access$3302((Type)object2, new int[nArray.length + 1]);
                        System.arraycopy(nArray, 0, ((Type)object2).dimensionSize, 0, nArray.length);
                        ((Type)object2).dimensionSize[nArray.length] = n2;
                    }
                }
            }
            string = element.getAttribute("minOccurs");
            ((Type)object2).optional = "0".equals(string);
        }
        return object2;
    }

    private static void warning(String string) {
        System.err.println("Warning: " + string);
    }

    private void scanComplexTypes(Element element, Type type) throws SAXException {
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string = element2.getLocalName();
                if (string.equalsIgnoreCase("element")) {
                    Type type2 = this.getType(element2, this.getElementFormQualified(element2));
                    if (type2 != null) {
                        type.add(type2, element2);
                        continue;
                    }
                    ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(element2) + "'");
                    continue;
                }
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(element2) + "'");
            }
        }
    }

    private Type scanSimpleTypes(Node node, boolean bl) throws SAXException {
        return this.scanSimpleTypes(node, null, bl);
    }

    private Type scanSimpleTypes(Node node, String string, boolean bl) throws SAXException {
        String string2;
        ElementIterator elementIterator;
        Element element;
        Type type = null;
        Element element2 = (Element)node;
        String string3 = element2.getAttribute("name");
        if ((string3 == null || string3.length() == 0) && string != null) {
            string3 = string;
        }
        if (node.hasChildNodes() && (element = (elementIterator = new ElementIterator(node)).next()) != null && (string2 = element.getLocalName()).equals("restriction")) {
            FullName fullName = this.getUriAndNameFromAttr(element, "base");
            if (fullName == null) {
                throw new SAXException("Missing \"base\" attribute in <restriction>");
            }
            type = new Type(string3, "restriction", fullName, bl, this.currNs2Pref);
            this.restrictions.put(string3, fullName.name);
        }
        if (type == null) {
            type = new Type(string3, "simple", null, bl, this.currNs2Pref);
        }
        return type;
    }

    private Type scanAttribute(String string, Element element, boolean bl) throws SAXException {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(element);
        FullName fullName = null;
        while ((element2 = elementIterator.next()) != null) {
            FullName fullName2;
            if (!"attribute".equals(element2.getLocalName()) || (fullName2 = this.getUriAndNameFromAttr(element2, "ref")) == null || !"arrayType".equals(fullName2.name) || !NS_SOAPENC.equals(fullName2.uri)) continue;
            fullName = this.getUriAndNameFromAttr(element2, "arrayType", NS_WSDL);
        }
        if (fullName != null) {
            Object object;
            int n2 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n3 = 0;
            boolean bl2 = true;
            String string2 = fullName.name;
            while ((n3 = string2.indexOf(91, n3)) > 0) {
                int n4;
                if (bl2) {
                    fullName.name = string2.substring(0, n3);
                    bl2 = false;
                }
                ++n2;
                if ((n4 = string2.indexOf(93, ++n3)) > n3) {
                    try {
                        arrayList.add(new Integer(string2.substring(n3, n4)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(0);
                    }
                    n3 = n4 + 1;
                    continue;
                }
                object = this.arraySizes.get(string);
                if (object == null) {
                    object = 0;
                }
                arrayList.add(object);
            }
            if (bl2) {
                n2 = 1;
                arrayList.add(new Integer(0));
            }
            object = new int[arrayList.size()];
            for (int i2 = 0; i2 < ((int[])object).length; ++i2) {
                object[i2] = (Integer)arrayList.get(i2);
            }
            if (this.targetNamespace.equals(fullName.uri)) {
                return new Type(string, "reference", fullName, n2, (int[])object, bl, this.currNs2Pref);
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(fullName.uri)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(fullName.name)) {
                    throw new SAXException("Invalid type " + fullName.name);
                }
                return new Type(string, "simple", fullName, n2, (int[])object, bl, this.currNs2Pref);
            }
            throw new SAXException("Unhandled type " + fullName.uri + ":" + fullName.name);
        }
        throw new SAXException("arrayType not found on " + string);
    }

    private boolean getElementFormQualified(Element element) {
        String string = element.getAttribute("form");
        if (string != null && string.length() > 0) {
            return "qualified".equals(string);
        }
        return this.schemaElemFormQual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type scanRestriction(String string, Element element, boolean bl) throws SAXException {
        FullName fullName = this.getUriAndNameFromAttr(element, "base");
        if (fullName == null) {
            throw new SAXException("Missing \"base\" attribute in <restriction>");
        }
        Type type = null;
        if (NS_SOAPENC.equals(fullName.uri)) {
            if (soapTypes.get(fullName.name) == null) {
                throw new SAXException("Invalid type " + fullName.name);
            }
            if ("Array".equals(fullName.name)) {
                if (!element.hasChildNodes()) throw new SAXException("void array:" + string);
                return this.scanAttribute(string, element, bl);
            }
            type = new Type(string, "restriction", fullName, bl, this.currNs2Pref);
            type.add(this.scanComplexTypes(element, bl), element);
            return type;
        } else {
            type = new Type(string, "restriction", fullName, bl, this.currNs2Pref);
            type.add(this.scanComplexTypes(element, bl), element);
        }
        return type;
    }

    private Type scanComplexContent(String string, Element element, boolean bl) throws SAXException {
        if (element.hasChildNodes()) {
            ElementIterator elementIterator = new ElementIterator(element);
            Element element2 = elementIterator.next();
            if (element2 != null) {
                String string2 = element2.getLocalName();
                if ("extension".equalsIgnoreCase(string2)) {
                    FullName fullName = this.getUriAndNameFromAttr(element2, "base");
                    Type type = new Type(string, "extension", fullName, bl, this.currNs2Pref);
                    type.add(this.scanComplexTypes(element2, bl), element2);
                    return type;
                }
                if ("restriction".equalsIgnoreCase(string2)) {
                    return this.scanRestriction(string, element2, bl);
                }
                throw new SAXException("Unexpected node <" + string2 + ">");
            }
            throw new SAXException("Void node <" + string + ">");
        }
        throw new SAXException("Void node <" + string + ">");
    }

    private Type scanComplexTypes(Element element, boolean bl) throws SAXException {
        return this.scanComplexTypes(element, null, bl);
    }

    private Type scanComplexTypes(Element element, String string, boolean bl) throws SAXException {
        Type type = null;
        Element element2 = element;
        String string2 = element2.getAttribute("name");
        if ((string2 == null || string2.length() == 0) && string != null) {
            string2 = string;
        }
        if (element.hasChildNodes()) {
            Element element3;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element3 = elementIterator.next()) != null) {
                String string3 = element3.getLocalName();
                if ("complexContent".equalsIgnoreCase(string3)) {
                    type = this.scanComplexContent(string2, element3, bl);
                    continue;
                }
                Object object = "all".equalsIgnoreCase(string3) ? "all" : ("choice".equalsIgnoreCase(string3) ? "choice" : ("sequence".equalsIgnoreCase(string3) ? "sequence" : ("anyAttribute".equalsIgnoreCase(string3) ? null : "simple")));
                if (object == null) continue;
                type = new Type(string2, (String)object, null, bl, this.currNs2Pref);
                this.scanComplexTypes(element3, type);
            }
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private void scanTypesSchema(Element element) throws SAXException {
        if (element.hasChildNodes()) {
            Element element2;
            this.globNs2Pref.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.globPref2ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.currNs2Pref = new HashMap<String, String>();
            this.currPref2ns = new HashMap<String, String>();
            this.schemaElemFormQual = "qualified".equals(element.getAttribute("elementFormDefault"));
            ElementIterator elementIterator = new ElementIterator(element);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while ((element2 = elementIterator.next()) != null) {
                Type type;
                boolean bl = "import".equalsIgnoreCase(element2.getLocalName());
                if (bl) {
                    String string = element2.getAttribute("schemaLocation");
                    if (string.length() > 0 && !this.wsdlImports.contains(string)) {
                        this.wsdlImports.add(string);
                        arrayList.add(string);
                    }
                    type = null;
                } else {
                    type = "complexType".equalsIgnoreCase(element2.getLocalName()) ? this.scanComplexTypes(element2, this.getElementFormQualified(element2)) : ("simpleType".equalsIgnoreCase(element2.getLocalName()) ? this.scanSimpleTypes(element2, this.getElementFormQualified(element2)) : ("element".equalsIgnoreCase(element2.getLocalName()) ? this.getType(element2, this.getElementFormQualified(element2)) : null));
                }
                if (type != null) {
                    if (this.types.contains(type)) {
                        ServiceBridgeUtility.warning("duplicate type: '" + ServiceBridgeUtility.nodeToString(element2) + "'");
                    }
                    this.types.add(type);
                    type.setTypeIndex(this.types.size());
                    continue;
                }
                if (bl) continue;
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(element2) + "'");
            }
            this.currNs2Pref = null;
            this.currPref2ns = null;
            for (String string : arrayList) {
                try {
                    void string2;
                    Object object;
                    File iOException = new File(string);
                    if (!iOException.isAbsolute() && ((File)(object = new File(this.uri))).isFile() && ((File)object).getParent() != null) {
                        String string3 = ((File)object).getParent() + File.separator + string;
                    }
                    if (!"schema".equalsIgnoreCase((object = ServiceBridgeUtility.openXml((String)string2)).getLocalName())) continue;
                    this.scanTypesSchema((Element)object);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    ServiceBridgeUtility.warning(parserConfigurationException.getMessage());
                }
                catch (IOException iOException) {
                    ServiceBridgeUtility.warning(iOException.getMessage());
                }
            }
        }
    }

    private void scanTypes(Node node) throws SAXException {
        if (node.hasChildNodes()) {
            Element element;
            ElementIterator elementIterator = new ElementIterator(node);
            while ((element = elementIterator.next()) != null) {
                String string = element.getLocalName();
                if (!"schema".equalsIgnoreCase(string)) continue;
                this.scanTypesSchema(element);
            }
        }
    }

    private void scanMessage(Element element) throws SAXException {
        String string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            ServiceBridgeUtility.warning("<message> without name: " + ServiceBridgeUtility.nodeToString(element));
        } else if (!element.hasChildNodes()) {
            ServiceBridgeUtility.warning("<message> without part(s): " + ServiceBridgeUtility.nodeToString(element));
        } else {
            Element element2;
            Message message = new Message(string);
            this.messages.add(message);
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                if (!"part".equalsIgnoreCase(element2.getLocalName())) continue;
                Type type = this.getType(element2, this.schemaElemFormQual);
                if (type != null) {
                    message.addPart(type);
                    continue;
                }
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(element2) + "'");
            }
        }
    }

    private Operation scanOperation(Element element) throws SAXException {
        FullName fullName = this.getUriAndNameFromAttr(element, "name");
        if (fullName == null) {
            throw new SAXException("<operation> without name");
        }
        String string = null;
        if (fullName.uri != null) {
            string = this.globNs2Pref.get(fullName.uri);
        }
        Operation operation = new Operation(fullName.uri, string, fullName.name);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string2 = element2.getLocalName();
                FullName fullName2 = this.getUriAndNameFromAttr(element2, "message");
                if (fullName2 == null) continue;
                Message message = ServiceBridgeUtility.findMessage(this.messages, fullName2.name);
                operation.addParams(string2, message);
            }
        }
        return operation;
    }

    private void scanPortType(Element element) throws SAXException {
        String string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            throw new SAXException("<portType> without name");
        }
        PortType portType = new PortType(string);
        this.portTypes.add(portType);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string2 = element2.getLocalName();
                if (!"operation".equalsIgnoreCase(string2)) continue;
                portType.addOperation(this.scanOperation(element2));
            }
        }
    }

    private void scanBinding2(Element element, Binding binding) throws SAXException {
        String string = element.getAttribute("style");
        String string2 = element.getAttribute("transport");
        if (string2 == null || string2.length() == 0) {
            ServiceBridgeUtility.warning("Missing 'transport' attribute");
        } else if (!NS_SOAPHTTP.equals(string2)) {
            ServiceBridgeUtility.warning("Invalid 'transport' value: " + string2);
        }
        binding.setStyle(string);
        binding.setTransport(string2);
    }

    private void scanBinding(Element element) throws SAXException {
        String string = element.getAttribute("name");
        FullName fullName = this.getUriAndNameFromAttr(element, "type");
        Binding binding = new Binding(string, fullName, this.portTypes);
        this.bindings.add(binding);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string2 = element2.getLocalName();
                if ("binding".equalsIgnoreCase(string2)) {
                    this.scanBinding2(element2, binding);
                    continue;
                }
                if (!"operation".equalsIgnoreCase(string2)) continue;
                this.scanOperation2(element2, binding.portType, "rpc".equalsIgnoreCase(binding.style));
            }
        }
    }

    private void scanOperation2(Element element, PortType portType, boolean bl) throws SAXException {
        if (portType != null && element.hasChildNodes()) {
            String string = element.getAttribute("name");
            for (Operation operation : portType.operations) {
                Element element2;
                if (!operation.name.equals(string)) continue;
                ElementIterator elementIterator = new ElementIterator(element);
                block1: while ((element2 = elementIterator.next()) != null) {
                    String string2 = element2.getLocalName();
                    for (Operation.Param param : operation.params) {
                        Element element3;
                        if (!param.key.equals(string2)) continue;
                        if (!element2.hasChildNodes()) continue block1;
                        ElementIterator elementIterator2 = new ElementIterator(element2);
                        while ((element3 = elementIterator2.next()) != null) {
                            FullName fullName;
                            String string3 = element3.getLocalName();
                            if ("body".equals(string3)) {
                                if (NS_SOAPENC.equals(element3.getAttribute("encodingStyle")) && "encoded".equals(element3.getAttribute("use"))) {
                                    param.msg.encoded = true;
                                }
                                if (!bl) continue;
                                this.setRpcURI(param, element3);
                                continue;
                            }
                            if (!"header".equals(string3) || (fullName = this.getUriAndNameFromAttr(element3, "message")) == null) continue;
                            param.hdr = ServiceBridgeUtility.findMessage(this.messages, fullName.name);
                            if (param.hdr == null) continue;
                            if (NS_SOAPENC.equals(element3.getAttribute("encodingStyle")) && "encoded".equals(element3.getAttribute("use"))) {
                                param.hdr.encoded = true;
                            }
                            param.uri = element3.getAttribute("namespace");
                            if (!bl) continue;
                            this.setRpcURI(param, element3);
                        }
                        continue block1;
                    }
                }
                break block0;
            }
        }
    }

    private void setRpcURI(Operation.Param param, Element element) {
        param.uri = element.getAttribute("namespace");
        if (param.uri != null && param.uri.length() > 0) {
            String string;
            if ("output".equals(param.key)) {
                string = "ns" + this.nsProg++;
                if (!this.globNs2Pref.containsKey(param.uri)) {
                    this.globNs2Pref.put(param.uri, string);
                }
                this.globPref2ns.put(string, param.uri);
            } else {
                string = this.globNs2Pref.get(param.uri);
                if (string == null) {
                    string = "ns" + this.nsProg++;
                    this.globNs2Pref.put(param.uri, string);
                    this.globPref2ns.put(string, param.uri);
                }
            }
            param.uriPfx = string;
        }
    }

    public void setArraySizes(Map<String, Integer> map) {
        this.arraySizes.putAll(map);
    }

    private Map<String, StringBuilder> generateCopyfiles(Node node) throws SAXException, IOException, ParserConfigurationException {
        this.scanRoot(node);
        ServiceBridgeUtility.doReference(this.types, this.types);
        for (Message object : this.messages) {
            ServiceBridgeUtility.doReference(this.types, object.parts);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Binding binding : this.bindings) {
            boolean bl;
            PortType portType = binding.portType;
            boolean bl2 = bl = binding.style != null && binding.style.equals("rpc");
            if (portType == null || !NS_SOAPHTTP.equals(binding.transport)) continue;
            for (Operation operation : portType.operations) {
                StringBuilder stringBuilder = new StringBuilder();
                operation.getCode(stringBuilder, portType.name, bl);
                if (stringBuilder.length() <= 0) continue;
                linkedHashMap.put(operation.name, stringBuilder);
            }
        }
        return linkedHashMap;
    }

    private void scanRoot(Node node) throws SAXException, IOException, ParserConfigurationException {
        if (node.getNodeType() != 1 || !"definitions".equalsIgnoreCase(node.getLocalName())) {
            throw new SAXException("Invalid root element: expected <definitions> found <" + node.getLocalName() + ">");
        }
        Element element = (Element)node;
        this.targetNamespace = element.getAttribute("targetNamespace");
        if (node.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(node);
            while ((element2 = elementIterator.next()) != null) {
                String string;
                String string2 = element2.getLocalName();
                if ("types".equalsIgnoreCase(string2)) {
                    this.scanTypes(element2);
                    continue;
                }
                if ("message".equalsIgnoreCase(string2)) {
                    this.scanMessage(element2);
                    continue;
                }
                if ("portType".equalsIgnoreCase(string2)) {
                    this.scanPortType(element2);
                    continue;
                }
                if ("binding".equalsIgnoreCase(string2)) {
                    this.scanBinding(element2);
                    continue;
                }
                if (!"import".equalsIgnoreCase(string2) || (string = element2.getAttribute("location")).length() <= 0 || this.wsdlImports.contains(string)) continue;
                this.wsdlImports.add(string);
                this.scanRoot(ServiceBridgeUtility.openXml(string));
            }
        }
    }

    public void debug() {
        for (Binding object : this.bindings) {
            System.out.println(object);
        }
        for (PortType portType : this.portTypes) {
            System.out.println(portType);
        }
        for (Message message : this.messages) {
            System.out.println(message);
        }
        for (Type type : this.types) {
            System.out.println(type);
        }
    }

    private static void doReference(List<Type> list, List<Type> list2) {
        for (Type type : list2) {
            if (type.reference == null && (type.type == "reference" || type.type == "extension")) {
                type.reference = ServiceBridgeUtility.lookFor(list, type);
                if (type.reference != null) {
                    type.reference.parent = type;
                    if (type.ns2Pref == null) {
                        type.ns2Pref = type.reference.ns2Pref;
                    }
                }
                if (type.type != "extension" || type.components == null) continue;
                ServiceBridgeUtility.doReference(list, type.components);
                continue;
            }
            if (type.components == null) continue;
            ServiceBridgeUtility.doReference(list, type.components);
        }
    }

    private static boolean isSameOrAncestor(Type type, Type type2) {
        while (type2 != null) {
            if (type == type2) {
                return true;
            }
            type2 = type2.parent;
        }
        return false;
    }

    private static Type lookFor(List<Type> list, Type type) {
        FullName fullName = type.typeName;
        Type type2 = null;
        for (Type type3 : list) {
            if (ServiceBridgeUtility.isSameOrAncestor(type3, type) || !type3.name.equals(fullName.name) || type3.typeName == null || type.typeName == null || !((Type)type3).typeName.uri.equals(((Type)type).typeName.uri)) continue;
            type2 = type3;
            if (type.typeIndex >= type3.typeIndex) continue;
            return type2;
        }
        if (type2 != null) {
            return type2;
        }
        for (Type type3 : list) {
            if (ServiceBridgeUtility.isSameOrAncestor(type3, type) || !type3.name.equals(fullName.name)) continue;
            type2 = type3;
            if (type.typeIndex >= type3.typeIndex) continue;
            return type2;
        }
        return type2;
    }

    private static Message findMessage(List<Message> list, String string) {
        for (Message message : list) {
            if (!string.equals(message.name)) continue;
            return message;
        }
        return null;
    }

    private static boolean isOccursDynamic(String string) {
        return string != null && string.startsWith("dynamic");
    }

    private static String nodeToString(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        if (node instanceof Element) {
            Element element = (Element)node;
            stringBuilder.append(element.getTagName());
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                stringBuilder.append(" ");
                stringBuilder.append(attr.getName());
                stringBuilder.append("=\"");
                stringBuilder.append(attr.getValue());
                stringBuilder.append("\"");
            }
        } else {
            stringBuilder.append(node.getNodeName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    static {
        soapTypes.put("string", "S");
        soapTypes.put("Array", "S");
    }

    private class ElementIterator {
        private final NodeList nodeList;
        private final int count;
        private int idx;

        ElementIterator(Node node) {
            this.nodeList = node.getChildNodes();
            this.count = this.nodeList.getLength();
            if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                Map map = ServiceBridgeUtility.this.currPref2ns != null ? ServiceBridgeUtility.this.currPref2ns : ServiceBridgeUtility.this.globPref2ns;
                Map map2 = ServiceBridgeUtility.this.currNs2Pref != null ? ServiceBridgeUtility.this.currNs2Pref : ServiceBridgeUtility.this.globNs2Pref;
                for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                    Node node2 = namedNodeMap.item(i2);
                    String string = node2.getNodeName();
                    if (!string.startsWith("xmlns:") || string.length() <= 6) continue;
                    map.put(node2.getLocalName(), node2.getNodeValue());
                    map2.put(node2.getNodeValue(), node2.getLocalName());
                }
            }
        }

        Element next() {
            while (this.idx < this.count) {
                Node node;
                if ((node = this.nodeList.item(this.idx++)).getNodeType() != 1) continue;
                return (Element)node;
            }
            return null;
        }
    }

    private static class DeferredTypeGetCode {
        Type t;
        Type par;
        String uri;
        boolean output;
        String typeUri;
        boolean encoded;
        String occurs;
        int id;

        DeferredTypeGetCode(Type type, Type type2, String string, boolean bl, String string2, boolean bl2, String string3, int n2) {
            this.t = type;
            this.par = type2;
            this.uri = string;
            this.output = bl;
            this.typeUri = string2;
            this.encoded = bl2;
            this.occurs = string3;
            this.id = n2;
        }

        void getCode(StringBuilder stringBuilder, int n2) {
            this.t.getCode(stringBuilder, this.par, n2, this.uri, this.output, this.typeUri, this.encoded, this.occurs, this.id);
        }
    }

    private class Binding {
        private final String name;
        private final FullName type;
        private final PortType portType;
        private String style;
        private String transport;

        Binding(String string, FullName fullName, List<PortType> list) throws SAXException {
            this.name = string;
            this.type = fullName;
            int n2 = list.size();
            PortType portType = null;
            for (int i2 = 0; i2 < n2 && !(portType = list.get(i2)).name.equals(this.type.name); ++i2) {
                portType = null;
            }
            this.portType = portType;
            if (this.portType == null) {
                throw new SAXException("<binding>:portType " + this.type.name + " not found");
            }
        }

        void setStyle(String string) {
            this.style = string;
        }

        void setTransport(String string) {
            this.transport = string;
        }

        public String toString() {
            return "binding=" + this.name + ",style=" + this.style + ",transport=" + this.transport + ":" + this.portType;
        }
    }

    private class PortType {
        private final String name;
        private final List<Operation> operations = new ArrayList<Operation>();

        PortType(String string) {
            this.name = string;
        }

        void addOperation(Operation operation) {
            this.operations.add(operation);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("PortType:");
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
            for (Operation operation : this.operations) {
                stringBuilder.append(operation);
            }
            return stringBuilder.toString();
        }
    }

    private class Operation {
        private final String uri;
        private final String uriPfx;
        private final String name;
        private final List<Param> params = new ArrayList<Param>();

        Operation(String string, String string2, String string3) {
            this.uri = string;
            this.uriPfx = string2;
            this.name = string3;
        }

        void addParams(String string, Message message) {
            this.params.add(new Param(string, message));
        }

        private void getNamespaces(Message message, Map<String, String> map) {
            for (Type type : message.parts) {
                this.getNamespaces(type, map);
            }
        }

        private void getNamespaces(Type type, Map<String, String> map) {
            if (type.typeName != null && ((Type)type).typeName.uri != null && ((Type)type).typeName.uri != "http://www.w3.org/2001/XMLSchema") {
                ((Type)type).typeName.pfx = type.getPrefix(((Type)type).typeName.uri);
                if (((Type)type).typeName.pfx != null) {
                    map.put(((Type)type).typeName.pfx, ((Type)type).typeName.uri);
                } else {
                    ServiceBridgeUtility.warning("unknown namespace: '" + ((Type)type).typeName.uri + "'");
                }
            }
            if (type.reference != null) {
                if (ServiceBridgeUtility.isSameOrAncestor(type.reference, type)) {
                    ServiceBridgeUtility.warning("removed recursive dependence: '" + type.reference.name + "'");
                    type.reference = null;
                } else {
                    this.getNamespaces(type.reference, map);
                }
            }
            if (type.components != null) {
                int n2 = 0;
                while (n2 < type.components.size()) {
                    Type type2 = (Type)type.components.get(n2);
                    if (ServiceBridgeUtility.isSameOrAncestor(type2, type)) {
                        ServiceBridgeUtility.warning("removed recursive dependence: '" + type2.name + "'");
                        type.components.remove(n2);
                        continue;
                    }
                    this.getNamespaces(type2, map);
                    ++n2;
                }
            }
        }

        public void getCode(StringBuilder stringBuilder, String string, boolean bl) {
            stringBuilder.append("       >>SOURCE FORMAT FREE");
            stringBuilder.append(eol);
            stringBuilder.append("      *> binding name=");
            stringBuilder.append(this.name);
            stringBuilder.append(", style=");
            stringBuilder.append(bl ? "rpc" : "document");
            stringBuilder.append(eol);
            for (Param param : this.params) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                int n2 = 5;
                boolean bl2 = param.key.equals("output");
                stringBuilder.append(ServiceBridgeUtility.SOAP_ENVELOPE_START);
                if (bl2) {
                    stringBuilder.append("out-");
                } else {
                    stringBuilder.append("in-");
                }
                if (this.uri != null && this.uriPfx != null) {
                    linkedHashMap.put(this.uriPfx, this.uri);
                }
                if (bl && param.uriPfx != null) {
                    linkedHashMap.put(param.uriPfx, param.uri);
                }
                if (param.hdr != null) {
                    this.getNamespaces(param.hdr, linkedHashMap);
                }
                if (param.msg != null) {
                    this.getNamespaces(param.msg, linkedHashMap);
                }
                stringBuilder.append(this.name);
                stringBuilder.append(" identified by 'soapenv:Envelope'." + eol);
                ServiceBridgeUtility.putLevel(stringBuilder, 3);
                stringBuilder.append(" identified by 'xmlns:soapenv' is attribute." + eol);
                ServiceBridgeUtility.putLevel(stringBuilder, 5);
                stringBuilder.append(" filler pic x(" + SOAP_ENVELOPE_NS[ServiceBridgeUtility.this.version].length() + ") value '" + SOAP_ENVELOPE_NS[ServiceBridgeUtility.this.version] + "'." + eol);
                if (param.msg.encoded) {
                    ServiceBridgeUtility.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:xsd' is attribute.");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema".length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append("http://www.w3.org/2001/XMLSchema");
                    stringBuilder.append("\".");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:xsi' is attribute.");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema-instance".length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append("http://www.w3.org/2001/XMLSchema-instance");
                    stringBuilder.append("\".");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:soapenc' is attribute.");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + ServiceBridgeUtility.NS_SOAPENC.length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append(ServiceBridgeUtility.NS_SOAPENC);
                    stringBuilder.append("\".");
                    stringBuilder.append(eol);
                }
                for (String string2 : linkedHashMap.keySet()) {
                    String string3 = (String)linkedHashMap.get(string2);
                    ServiceBridgeUtility.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:" + string2 + "' is attribute." + eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + string3.length() + ") value '" + string3 + "'." + eol);
                }
                if (param.hdr != null) {
                    ServiceBridgeUtility.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'soapenv:Header'." + eol);
                    param.hdr.getCode(stringBuilder, n2, this.uri, bl2);
                }
                ServiceBridgeUtility.putLevel(stringBuilder, 3);
                stringBuilder.append(" identified by 'soapenv:Body'." + eol);
                if (bl) {
                    ++n2;
                    if (param.msg.encoded) {
                        this.putEncodingStyle(stringBuilder, n2);
                    }
                    ServiceBridgeUtility.putLevel(stringBuilder, n2);
                    stringBuilder.append(" identified by '");
                    if (param.uriPfx != null) {
                        stringBuilder.append(param.uriPfx);
                        stringBuilder.append(":");
                    }
                    stringBuilder.append(this.name);
                    if (bl2) {
                        stringBuilder.append("Response");
                    }
                    stringBuilder.append("'.");
                    stringBuilder.append(eol);
                }
                param.msg.getCode(stringBuilder, n2, this.uri, bl2);
                stringBuilder.append(eol);
            }
            stringBuilder.append("       >>SOURCE FORMAT PREVIOUS" + eol);
        }

        private void putEncodingStyle(StringBuilder stringBuilder, int n2) {
            ServiceBridgeUtility.putLevel(stringBuilder, n2);
            stringBuilder.append(" identified by 'soapenv:encodingStyle' is attribute.");
            stringBuilder.append(eol);
            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
            stringBuilder.append(" filler pic x(" + ServiceBridgeUtility.NS_SOAPENC.length() + ") value '" + ServiceBridgeUtility.NS_SOAPENC + "'.");
            stringBuilder.append(eol);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Operation:");
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
            if (this.params != null) {
                for (Param param : this.params) {
                    stringBuilder.append("<");
                    stringBuilder.append(param.key);
                    stringBuilder.append(">\n");
                    stringBuilder.append(param.msg);
                }
            }
            return stringBuilder.toString();
        }

        class Param {
            private final String key;
            private final Message msg;
            private Message hdr;
            private String uri;
            private String uriPfx;

            private Param(String string, Message message) {
                this.key = string;
                this.msg = message;
            }
        }
    }

    private class Message {
        private final String name;
        private boolean encoded;
        private final List<Type> parts = new ArrayList<Type>();

        Message(String string) {
            this.name = string;
        }

        void addPart(Type type) {
            this.parts.add(type);
        }

        public void getCode(StringBuilder stringBuilder, int n2, String string, boolean bl) {
            ServiceBridgeUtility.this.deferredMessageTypes = new ArrayList();
            ServiceBridgeUtility.this.varnames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
            for (Type object : this.parts) {
                int n3 = n2;
                int n4 = -1;
                if (bl && this.encoded) {
                    ServiceBridgeUtility.putLevel(stringBuilder, ++n3);
                    stringBuilder.append(" identified by '");
                    stringBuilder.append(object.name);
                    stringBuilder.append("'");
                    stringBuilder.append(".");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, n3 + 1);
                    stringBuilder.append(" identified by 'href' is attribute.");
                    stringBuilder.append(eol);
                    ServiceBridgeUtility.putLevel(stringBuilder, n3 + 2);
                    n4 = ServiceBridgeUtility.this.idProg++;
                    Object object2 = object;
                    ((Type)object2).name = ((Type)object2).name + "Type";
                    object2 = Integer.toString(n4);
                    stringBuilder.append(" filler pic x(");
                    stringBuilder.append(((String)object2).length() + 3);
                    stringBuilder.append(") value \"#id");
                    stringBuilder.append(n4);
                    stringBuilder.append("\".");
                    stringBuilder.append(eol);
                    n3 = n2 - 1;
                }
                object.getCode(stringBuilder, null, n3, string, bl, null, this.encoded, null, n4);
            }
            for (DeferredTypeGetCode deferredTypeGetCode : ServiceBridgeUtility.this.deferredMessageTypes) {
                deferredTypeGetCode.getCode(stringBuilder, n2 - 1);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("msg:");
            stringBuilder.append(this.name);
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.parts.get(i2));
            }
            return stringBuilder.toString();
        }
    }

    private class Type {
        static final String SIMPLE = "simple";
        static final String ALL = "all";
        static final String CHOICE = "choice";
        static final String SEQUENCE = "sequence";
        static final String REFERENCE = "reference";
        static final String EXTENSION = "extension";
        static final String RESTRICTION = "restriction";
        private String name;
        private final String type;
        private FullName typeName;
        private final List<Type> components;
        private int dimensions;
        private int[] dimensionSize;
        private Type reference;
        private Type parent;
        private boolean optional;
        private Map<String, String> ns2Pref;
        private int typeIndex;
        private final boolean elemFromQual;

        Type(String string, String string2, FullName fullName, boolean bl, Map<String, String> map) {
            this(string, string2, fullName, 0, null, bl, map);
        }

        Type(String string, String string2, FullName fullName, int n2, int[] nArray, boolean bl, Map<String, String> map) {
            this.ns2Pref = map;
            this.elemFromQual = bl;
            this.name = string;
            this.dimensions = n2;
            this.dimensionSize = nArray;
            if (string2 == ALL || string2 == CHOICE || string2 == SEQUENCE) {
                this.type = string2;
                this.typeName = null;
                this.components = new ArrayList<Type>();
            } else if (string2 == REFERENCE) {
                this.type = string2;
                this.typeName = fullName;
                this.components = null;
            } else if (string2 == EXTENSION) {
                this.type = string2;
                this.typeName = fullName;
                this.components = new ArrayList<Type>();
            } else if (string2 == RESTRICTION) {
                this.type = string2;
                this.typeName = fullName;
                this.components = new ArrayList<Type>();
            } else {
                this.type = null;
                this.typeName = fullName;
                this.components = null;
            }
        }

        private void setTypeIndex(int n2) {
            this.typeIndex = n2;
            if (this.components != null) {
                for (Type type : this.components) {
                    type.setTypeIndex(n2);
                }
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Type)) {
                return false;
            }
            Type type = (Type)object;
            if (this.name.equals(type.name)) {
                if (this.typeName != null) {
                    if (type.typeName != null) {
                        return this.typeName.uri.equals(type.typeName.uri);
                    }
                    return false;
                }
                return type.typeName == null;
            }
            return false;
        }

        void add(Type type, Element element) {
            if (type != null) {
                this.components.add(type);
                type.parent = this;
            } else {
                ServiceBridgeUtility.warning("type undefined: '" + ServiceBridgeUtility.nodeToString(element) + "'");
            }
        }

        private String getPrefix(String string) {
            String string2;
            String string3 = string2 = this.ns2Pref != null ? this.ns2Pref.get(string) : null;
            if (string2 == null) {
                string2 = (String)ServiceBridgeUtility.this.globNs2Pref.get(string);
            }
            return string2;
        }

        private String getNameCode(String string) {
            FullName fullName = this.reference != null && this.reference.typeName != null && "http://www.w3.org/2001/XMLSchema".equals(this.reference.typeName.uri) ? this.reference.typeName : this.typeName;
            if (fullName != null && fullName.pfx != null) {
                return fullName.pfx + ":" + this.name;
            }
            if (string != null) {
                String string2 = this.getPrefix(string);
                if (string2 != null) {
                    return string2 + ":" + this.name;
                }
                return this.name;
            }
            return this.name;
        }

        public void getCode(StringBuilder stringBuilder, Type type, int n2, String string, boolean bl, String string2, boolean bl2, String string3, int n3) {
            String string4;
            FullName fullName = null;
            String string5 = string4 = this.typeName != null ? this.typeName.uri : string2;
            if (this.type == REFERENCE) {
                String string6;
                String string7;
                if (bl2 && bl) {
                    if (this.dimensions == 1) {
                        boolean bl3;
                        ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                        stringBuilder.append(" identified by 'soapenc:Array'.");
                        stringBuilder.append(eol);
                        if (n3 >= 0) {
                            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
                            stringBuilder.append(" identified by 'id' is attribute.");
                            stringBuilder.append(eol);
                            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
                            string7 = Integer.toString(n3);
                            stringBuilder.append(" filler pic x(");
                            stringBuilder.append(string7.length() + 2);
                            stringBuilder.append(") value \"id");
                            stringBuilder.append(n3);
                            stringBuilder.append("\".");
                            stringBuilder.append(eol);
                        }
                        ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
                        stringBuilder.append(" identified by 'soapenc:arrayType' is attribute.");
                        stringBuilder.append(eol);
                        ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
                        string7 = this.name;
                        if (string7.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.typeName != null) {
                            string7 = this.typeName.name;
                            if (this.dimensions == 1 && string7.endsWith(string6 = "" + this.dimensionSize[0])) {
                                string7 = string7.substring(0, string7.length() - string6.length());
                            }
                        }
                        string6 = (bl3 = XMLStreamConstants.xsdSimpleTypes.containsKey(string7)) ? "xsd:" + string7 : this.getPrefix(ServiceBridgeUtility.this.targetNamespace) + ":" + string7;
                        string6 = this.dimensionSize[0] > 0 ? string6 + "[" + this.dimensionSize[0] + "]" : string6 + "[]";
                        stringBuilder.append(" filler pic x(");
                        stringBuilder.append(string6.length());
                        stringBuilder.append(") value \"");
                        stringBuilder.append(string6);
                        stringBuilder.append("\".");
                        stringBuilder.append(eol);
                        this.putOptional(++n2, stringBuilder);
                        ServiceBridgeUtility.putLevel(stringBuilder, n2);
                        stringBuilder.append(" identified by '");
                        if (bl3 && type != null) {
                            stringBuilder.append(type.name);
                        } else {
                            stringBuilder.append(string7);
                        }
                        stringBuilder.append('\'');
                        if ("base64Binary".equals(string7) || "hexBinary".equals(string7)) {
                            stringBuilder.append(" " + string7);
                        }
                        stringBuilder.append(" occurs ");
                        string3 = this.getOccurs(0, type);
                        stringBuilder.append(string3);
                        stringBuilder.append(".");
                        stringBuilder.append(eol);
                        this.putType(stringBuilder, n2, string3, type);
                    } else {
                        this.putOptional(++n2, stringBuilder);
                        ServiceBridgeUtility.putLevel(stringBuilder, n2);
                        stringBuilder.append(" identified by '");
                        stringBuilder.append(this.name);
                        stringBuilder.append('\'');
                        if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                            stringBuilder.append(" " + this.typeName.name);
                        }
                        stringBuilder.append(".");
                        stringBuilder.append(eol);
                        if (n3 >= 0) {
                            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
                            stringBuilder.append(" identified by 'id' is attribute.");
                            stringBuilder.append(eol);
                            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
                            string7 = Integer.toString(n3);
                            stringBuilder.append(" filler pic x(");
                            stringBuilder.append(string7.length() + 2);
                            stringBuilder.append(") value \"id");
                            stringBuilder.append(n3);
                            stringBuilder.append("\".");
                            stringBuilder.append(eol);
                        }
                        if (this.typeName != null && !this.typeName.name.startsWith(ServiceBridgeUtility.ARRAY_OF)) {
                            this.putType(stringBuilder, n2, string3, type);
                        }
                    }
                } else if (type == null || type.type != REFERENCE || this.reference == null || !this.reference.name.equals(this.name) || this.reference.type != REFERENCE) {
                    if (bl2 && !bl && this.reference != null && this.reference.dimensions == 1) {
                        string7 = this.name;
                        this.name = this.reference.name;
                        this.reference.name = string7;
                        fullName = this.typeName;
                        this.typeName = new FullName(null, "Array");
                        this.typeName.pfx = "soapenc";
                    }
                    string3 = this.addLevel(++n2, bl2, bl, type, string3, string, stringBuilder);
                    if (fullName != null) {
                        this.typeName = fullName;
                    }
                    this.putArrayType(stringBuilder, n2, string3, type);
                }
                if (this.reference != null) {
                    if (bl2 && bl && n3 < 0 && this.reference.type == REFERENCE && !XMLStreamConstants.xsdSimpleTypes.containsKey(this.reference.name) && string3 == null) {
                        ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
                        stringBuilder.append(" identified by 'href' is attribute.");
                        stringBuilder.append(eol);
                        ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
                        int n4 = ServiceBridgeUtility.this.idProg++;
                        string6 = Integer.toString(n4);
                        stringBuilder.append(" filler pic x(");
                        stringBuilder.append(string6.length() + 3);
                        stringBuilder.append(") value \"#id");
                        stringBuilder.append(n4);
                        stringBuilder.append("\".");
                        stringBuilder.append(eol);
                        ServiceBridgeUtility.this.deferredMessageTypes.add(new DeferredTypeGetCode(this.reference, this, string, bl, string4, bl2, string3, n4));
                        return;
                    }
                    if (this.reference.typeName != null && "http://www.w3.org/2001/XMLSchema".equals(this.reference.typeName.uri)) {
                        ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                        stringBuilder.append(" ");
                        stringBuilder.append(this.getVarName("a-", type));
                        stringBuilder.append(" pic " + this.reference.getPicture() + ".");
                        stringBuilder.append(eol);
                    } else {
                        this.reference.getCode(stringBuilder, this, n2, string, bl, string4, bl2, string3, -1);
                    }
                } else if (this.typeName != null) {
                    ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.getVarName("a-", type));
                    stringBuilder.append(" pic " + this.getPicture() + ".");
                    stringBuilder.append(eol);
                }
            } else {
                boolean bl4;
                if (this.type == EXTENSION && this.reference != null) {
                    this.reference.getCode(stringBuilder, type, n2, string4, bl, string2, bl2, string3, n3);
                }
                if (bl4 = this.isSimpleType()) {
                    this.putOptional(++n2, stringBuilder);
                    ServiceBridgeUtility.putLevel(stringBuilder, n2);
                    stringBuilder.append(" identified by '");
                    if (bl2) {
                        stringBuilder.append(this.name);
                    } else if (this.elemFromQual || type == null) {
                        stringBuilder.append(this.getNameCode(string));
                    } else {
                        stringBuilder.append(this.name);
                    }
                    stringBuilder.append('\'');
                    if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                        stringBuilder.append(" " + this.typeName.name);
                    }
                    if (this.dimensions > 0) {
                        stringBuilder.append(" occurs ");
                        stringBuilder.append(this.getOccurs(0, type));
                    }
                    stringBuilder.append(".");
                    stringBuilder.append(eol);
                    if (bl2 && this.typeName != null) {
                        this.putType(stringBuilder, n2, string3, type);
                    }
                }
                if (this.components == null) {
                    if (this.dimensions > 0) {
                        int n5 = 0;
                        if (bl4) {
                            ++n5;
                        }
                        while (n5 < this.dimensions) {
                            ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                            string3 = this.getOccurs(n5, type);
                            stringBuilder.append(" filler occurs " + string3 + ".");
                            stringBuilder.append(eol);
                            ++n5;
                        }
                    }
                    if (bl4) {
                        ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                        stringBuilder.append(" ");
                        stringBuilder.append(this.getVarName("a-", type));
                        stringBuilder.append(" pic " + this.getPicture() + ".");
                        stringBuilder.append(eol);
                    } else if (this.reference != null) {
                        this.reference.getCode(stringBuilder, this, n2, string, bl, string4, bl2, string3, -1);
                    }
                } else if (!this.components.isEmpty()) {
                    for (Type type2 : this.components) {
                        if (type2.type == SEQUENCE && this.type != EXTENSION) {
                            string3 = type2.addLevel(++n2, bl2, bl, this, string3, string, stringBuilder);
                        }
                        type2.getCode(stringBuilder, this, n2, string, bl, string4, bl2, string3, -1);
                    }
                } else if (this.type != EXTENSION) {
                    ServiceBridgeUtility.putLevel(stringBuilder, ++n2);
                    if (this.name != null) {
                        stringBuilder.append(" ");
                        stringBuilder.append(this.getVarName("a-", type));
                    } else {
                        stringBuilder.append("filler");
                    }
                    stringBuilder.append(" pic " + this.getPicture() + ".");
                    stringBuilder.append(eol);
                }
            }
            if (fullName != null) {
                String string8 = this.name;
                this.name = this.reference.name;
                this.reference.name = string8;
            }
        }

        private String addLevel(int n2, boolean bl, boolean bl2, Type type, String string, String string2, StringBuilder stringBuilder) {
            this.putOptional(n2, stringBuilder);
            ServiceBridgeUtility.putLevel(stringBuilder, n2);
            stringBuilder.append(" identified by '");
            if (bl) {
                String string3;
                if (!bl2 && this.dimensions == 1 && this.typeName != null && XMLStreamConstants.xsdSimpleTypes.containsKey(this.typeName.name)) {
                    stringBuilder.append("item");
                } else if (this.name.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.reference != null && this.reference.dimensions == 1 && this.name.endsWith(string3 = "" + this.reference.dimensionSize[0])) {
                    stringBuilder.append(this.name.substring(0, this.name.length() - string3.length()));
                } else {
                    stringBuilder.append(this.name);
                }
            } else if (this.elemFromQual || type == null) {
                stringBuilder.append(this.getNameCode(string2));
            } else {
                stringBuilder.append(this.name);
            }
            stringBuilder.append('\'');
            if (this.typeName != null && ("base64Binary".equals(this.typeName.name) || "hexBinary".equals(this.typeName.name))) {
                stringBuilder.append(" " + this.typeName.name);
            }
            if (this.dimensions == 1) {
                stringBuilder.append(" occurs ");
                string = this.getOccurs(0, type);
                stringBuilder.append(string);
            }
            stringBuilder.append(".");
            stringBuilder.append(eol);
            if (bl && this.typeName != null) {
                this.putType(stringBuilder, n2, string, type);
            }
            return string;
        }

        private void putOptional(int n2, StringBuilder stringBuilder) {
            if (this.optional) {
                ServiceBridgeUtility.putSpace(stringBuilder, n2);
                stringBuilder.append("*> optional");
                stringBuilder.append(eol);
            }
        }

        private void putType(StringBuilder stringBuilder, int n2, String string, Type type) {
            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
            stringBuilder.append(" identified by 'xsi:type' is attribute.");
            stringBuilder.append(eol);
            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
            String string2 = XMLStreamConstants.xsdSimpleTypes.containsKey(this.typeName.name) ? "xsd:" + this.typeName.name : (this.typeName.pfx != null ? this.typeName.pfx + ":" + this.typeName.name : this.typeName.name);
            boolean bl = ServiceBridgeUtility.isOccursDynamic(string);
            if (bl) {
                stringBuilder.append(" " + this.getVarName("t-", type));
            } else {
                stringBuilder.append(" filler");
            }
            stringBuilder.append(" pic x(" + string2.length() + ")");
            stringBuilder.append(" value '" + string2 + "'");
            stringBuilder.append(".");
            stringBuilder.append(eol);
        }

        private String getVarName(String string, Type type) {
            String string2 = this.name.startsWith(ServiceBridgeUtility.ARRAY_OF) && this.type == REFERENCE && this.dimensions == 1 && type != null ? string + type.name : string + this.name;
            String string3 = string2;
            int n2 = 0;
            while (ServiceBridgeUtility.this.varnames.contains(string3)) {
                string3 = string2 + "--" + n2;
                ++n2;
            }
            ServiceBridgeUtility.this.varnames.add(string3);
            return string3;
        }

        private void putArrayType(StringBuilder stringBuilder, int n2, String string, Type type) {
            if (!this.typeName.name.startsWith(ServiceBridgeUtility.ARRAY_OF) || this.reference == null || this.reference.dimensions != 1) {
                return;
            }
            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 1);
            stringBuilder.append(" identified by 'soapenc:arrayType' is attribute.");
            stringBuilder.append(eol);
            ServiceBridgeUtility.putLevel(stringBuilder, n2 + 2);
            String string2 = this.typeName.name.substring(7);
            String string3 = "" + this.reference.dimensionSize[0];
            if (string2.endsWith(string3)) {
                string2 = string2.substring(0, string2.length() - string3.length());
            }
            String string4 = XMLStreamConstants.xsdSimpleTypes.containsKey(string2) ? "xsd:" + string2 : (this.typeName.pfx != null ? this.typeName.pfx + ":" + string2 : string2);
            string4 = string4 + "[]";
            boolean bl = ServiceBridgeUtility.isOccursDynamic(string);
            if (bl) {
                stringBuilder.append(" " + this.getVarName("at-", type));
            } else {
                stringBuilder.append(" filler");
            }
            stringBuilder.append(" pic x(" + string4.length() + ")");
            stringBuilder.append(" value '" + string4 + "'");
            stringBuilder.append(".");
            stringBuilder.append(eol);
        }

        private boolean isSimpleType() {
            return this.type == null || this.type == SIMPLE || this.type == RESTRICTION;
        }

        private String getSimpleType() {
            if (this.typeName != null) {
                String string = this.typeName.name;
                while (string != null) {
                    String string2 = XMLStreamConstants.xsdSimpleTypes.get(string);
                    if (string2 != null) {
                        return string2;
                    }
                    string = (String)ServiceBridgeUtility.this.restrictions.get(string);
                }
            }
            return null;
        }

        private String getPicture() {
            String string = this.getSimpleType();
            String string2 = string != null ? (string == "I8" ? "x(1)" : (string == "I16" ? "s9(5)" : (string == "I32" ? "s9(10)" : (string == "I64" ? "s9(18)" : (string == "F" ? "s9(12)v9(6)" : (string == "D" ? "s9(12)v9(6)" : "x any length")))))) : "x any length";
            return string2;
        }

        private String getOccurs(int n2, Type type) {
            if (this.dimensionSize != null && n2 < this.dimensionSize.length && this.dimensionSize[n2] > 0) {
                return "" + this.dimensionSize[n2] + " times";
            }
            return "dynamic capacity " + this.getVarName("a-c-", type) + " initialized";
        }

        private String toString(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.components == null) {
                stringBuilder.append(string);
                stringBuilder.append(this.name);
                if (this.dimensions > 0) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.dimensions);
                    stringBuilder.append(']');
                }
                stringBuilder.append(':');
                if (this.type == null) {
                    stringBuilder.append(this.typeName);
                } else if (this.reference == null) {
                    stringBuilder.append("->");
                    stringBuilder.append(this.typeName);
                } else {
                    stringBuilder.append("->");
                    stringBuilder.append(this.reference.toString(string + ' '));
                }
            } else {
                stringBuilder.append(string + this.name);
                if (this.reference != null) {
                    stringBuilder.append(":->" + this.reference.toString(string + ' '));
                } else {
                    stringBuilder.append(":" + this.type);
                }
                string = string + ' ';
                int n2 = this.components.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder.append("\n");
                    stringBuilder.append(this.components.get(i2).toString(string));
                }
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.toString("");
        }

        static /* synthetic */ int[] access$3302(Type type, int[] nArray) {
            type.dimensionSize = nArray;
            return nArray;
        }
    }

    private class FullName {
        final String uri;
        String name;
        String pfx;

        public FullName(String string, String string2) {
            this.uri = string;
            this.name = string2;
        }

        public boolean equals(Object object) {
            return object instanceof FullName && this.uri.equals(((FullName)object).uri) && this.name.equals(((FullName)object).name);
        }

        public String toString() {
            return "uri=" + this.uri + ", name=" + this.name;
        }
    }
}

