/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LikeFlags;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class SimpleCondition
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_EQ = 1;
    public static final int OP_NE = 2;
    public static final int OP_GE = 3;
    public static final int OP_LE = 4;
    public static final int OP_GT = 5;
    public static final int OP_LT = 6;
    public static final int OP_C_POSITIVE = 7;
    public static final int OP_C_NEGATIVE = 8;
    public static final int OP_C_ZERO = 9;
    public static final int OP_C_NUMERIC = 10;
    public static final int OP_C_ALPHABETIC = 11;
    public static final int OP_C_ALPHABETIC_UPPER = 12;
    public static final int OP_C_ALPHABETIC_LOWER = 13;
    public static final int OP_C_UNSET = 14;
    public static final int OP_C_CLASS = 15;
    public static final int OP_LIKE = 16;
    public static final int OP_HANDLE = 17;
    public static final int OP_NOT = 128;
    Expression left;
    Expression right;
    int op;
    private boolean isUnaryOp;
    private SpecialNamesClass snc;
    private LikeFlags like;

    public SimpleCondition(Expression expression, boolean bl, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.left = expression;
        this.init(new int[]{0}, null, 14, bl);
    }

    public SimpleCondition(int[] nArray, Expression expression, int n2, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.left = new Expression(nArray, this.keyWord, this.parent, this.pc, this.tm, this.error, true, true);
        this.init(nArray, expression, n2, false);
    }

    static boolean isBinaryOperator(Token token) {
        switch (token.getToknum()) {
            case 60: 
            case 61: 
            case 62: 
            case 462: 
            case 463: 
            case 471: 
            case 507: 
            case 510: 
            case 560: 
            case 561: 
            case 784: {
                return true;
            }
        }
        return false;
    }

    private void init(int[] nArray, Expression expression, int n2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        Token token;
        Token token2;
        if (this.left.getType() == 1 && !this.left.isObjectReference()) {
            return;
        }
        if (this.left.getType() == 0) {
            if (expression != null && n2 != 0) {
                this.left = expression;
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
        if ((token2 = this.tm.getToken()).getToknum() == 545) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 598) {
            bl = true;
            token2 = this.tm.getToken();
        }
        switch (token2.getToknum()) {
            case 61: 
            case 462: 
            case 463: {
                this.op = 1;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 784: {
                this.op = 2;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 60: 
            case 62: 
            case 471: 
            case 507: 
            case 560: {
                if (token2.getToknum() == 60) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 62) {
                        this.op = 2;
                        break;
                    }
                    this.tm.ungetToken();
                }
                this.op = token2.getToknum() == 560 || token2.getToknum() == 60 ? 6 : 5;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 761) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 617 || token2.getToknum() == 61) {
                    if (token2.getToknum() == 617) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != 462 && token2.getToknum() != 61) break;
                    switch (this.op) {
                        case 3: {
                            this.op = 5;
                            break;
                        }
                        case 6: {
                            this.op = 4;
                            break;
                        }
                        case 4: {
                            this.op = 6;
                            break;
                        }
                        case 5: {
                            this.op = 3;
                        }
                    }
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 773) break;
                    this.tm.ungetToken();
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            case 642: {
                this.op = 7;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 594: {
                this.op = 8;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 603: {
                this.op = 10;
                if (this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 266: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.op = 11;
                this.isUnaryOp = true;
                break;
            }
            case 267: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.op = 13;
                this.isUnaryOp = true;
                break;
            }
            case 268: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.op = 12;
                this.isUnaryOp = true;
                break;
            }
            case 561: {
                if (this.left.isNumeric() || this.left.hasOperator) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.like = new LikeFlags(this.tm, this.error, this.pc);
                this.op = 16;
                this.isUnaryOp = false;
                break;
            }
            case 510: {
                if (this.left.getAsVar() == null || !this.left.getAsVar().getVarDecl().isHandle()) {
                    throw new IllegalConditionException(token2, this.error);
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() != 609) {
                    this.tm.ungetToken();
                }
                this.op = 17;
                break;
            }
            case 822: {
                this.op = 9;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(token2, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 10002: {
                if (token2.isFigurativeZero()) {
                    this.op = 9;
                    if (!this.left.isNumeric()) {
                        throw new IllegalConditionException(token2, this.error);
                    }
                    this.isUnaryOp = true;
                    break;
                }
            }
            case 10009: {
                this.snc = this.pc.getSpecialNamesClass(token2.getCode());
                if (this.snc != null) {
                    if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                        throw new IllegalConditionException(token2, this.error);
                    }
                    this.op = 15;
                    this.isUnaryOp = true;
                    break;
                }
            }
            default: {
                if (bl) {
                    this.op = 1;
                    this.error.print(18, 3, token2, "EQUAL assumed");
                } else {
                    this.op = 14;
                }
                this.tm.ungetToken();
            }
        }
        if (!(this.left.getType() != 4 || this.left.isJavaString() || this.op == 1 || this.op == 2 || (token = this.left.getAsToken()) != null && token.isNull())) {
            throw new IllegalConditionException(token2, this.error);
        }
        if (this.op != 14 && !this.isUnaryOp) {
            while ((token2 = this.tm.getToken()).getToknum() == 40) {
                nArray[0] = nArray[0] + 1;
            }
            this.tm.ungetToken();
            this.right = new Expression(nArray, this.keyWord, this.parent, this.pc, this.tm, this.error, true, true);
        } else if (this.op == 14 && expression != null && this.left != expression) {
            this.right = this.left;
            this.left = expression;
            this.op = n2;
        }
        if (bl) {
            this.op |= 0x80;
        }
    }

    boolean isBoolean() {
        return this.left.getType() == 1 && (!this.left.isObjectReference() || this.right == null);
    }

    boolean isFullCondition() {
        return this.isBoolean() || this.op != 14 && this.left != null && (this.isUnaryOp || this.right != null);
    }

    private String getCodeBoolean() {
        return this.left.getCode();
    }

    private String getCodeObject() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("(");
        switch (this.op) {
            case 1: 
            case 130: {
                bl = true;
                break;
            }
            case 2: 
            case 129: {
                bl = false;
                break;
            }
            default: {
                throw new InternalErrorException("op=" + this.op);
            }
        }
        int n2 = this.left.getType();
        int n3 = this.right.getType();
        boolean bl2 = this.left.isJavaString() || n2 == 2;
        boolean bl3 = this.right.isJavaString() || n3 == 2;
        boolean bl4 = this.left.isJavaNumericWrapper();
        boolean bl5 = this.right.isJavaNumericWrapper();
        if (bl2 && bl3 || bl4 && n3 == 3 || n2 == 3 && bl5 || bl4 && bl5) {
            if (!bl) {
                stringBuffer.append("!");
            }
            stringBuffer.append("ExprUtil.eq(");
            stringBuffer.append(this.left.getCode());
            stringBuffer.append(", ");
            stringBuffer.append(this.right.getCode());
            stringBuffer.append("))");
        } else {
            if ((this.left.isPrimitiveWrapper() || this.left.isNull()) && (this.right.isPrimitiveWrapper() || this.right.isNull())) {
                this.left.setObject();
                this.right.setObject();
            }
            stringBuffer.append(this.left.getCode());
            if (bl) {
                stringBuffer.append("==");
            } else {
                stringBuffer.append("!=");
            }
            stringBuffer.append(this.right.getCode());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static void uDisplayGetCode(int n2, StringBuffer stringBuffer) {
        switch (n2 & 0xFFFFFF7F) {
            case 1: {
                stringBuffer.append(")==0");
                break;
            }
            case 2: {
                stringBuffer.append(")!=0");
                break;
            }
            case 3: {
                stringBuffer.append(")>=0");
                break;
            }
            case 4: {
                stringBuffer.append(")<=0");
                break;
            }
            case 5: {
                stringBuffer.append(")>0");
                break;
            }
            case 6: {
                stringBuffer.append(")<0");
                break;
            }
            default: {
                throw new InternalErrorException("isUDisplayCond op=" + n2);
            }
        }
    }

    private static NameAndLen isUDisplayExpr(TokenManager tokenManager, Expression expression) {
        VariableName variableName = expression.getAsVar();
        if (variableName != null) {
            return NameAndLen.get(variableName);
        }
        Token token = expression.getAsToken();
        if (token != null) {
            return NameAndLen.get(tokenManager, token);
        }
        return null;
    }

    static boolean getUDisplayCond(NameAndLen nameAndLen, NameAndLen nameAndLen2, int n2, StringBuffer stringBuffer, Alphabet alphabet) {
        if (nameAndLen != null && nameAndLen2 != null && (nameAndLen.isNum || nameAndLen2.isNum) && (nameAndLen.decimals == nameAndLen2.decimals || nameAndLen.name == null || nameAndLen2.name == null)) {
            if (nameAndLen.name == null) {
                if (nameAndLen2.name == null) {
                    if (nameAndLen.isNum) {
                        if (nameAndLen2.isNum) {
                            stringBuffer.append("(0");
                        } else {
                            stringBuffer.append("(1");
                        }
                    } else if (nameAndLen2.isNum) {
                        stringBuffer.append("(-1");
                    } else {
                        stringBuffer.append("(0");
                    }
                    SimpleCondition.uDisplayGetCode(n2, stringBuffer);
                    return true;
                }
                if (nameAndLen.isNum) {
                    stringBuffer.append("Factory.cmp((byte) " + Token.getEncByte('0') + ",");
                } else {
                    stringBuffer.append("Factory.cmp((byte) " + Token.getEncByte(' ') + ",");
                }
                stringBuffer.append(nameAndLen2.name);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(nameAndLen2.name);
                stringBuffer.append(".getOffset(),");
                stringBuffer.append(nameAndLen2.len);
                if (alphabet != null) {
                    stringBuffer.append(',');
                    stringBuffer.append(alphabet.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(n2, stringBuffer);
                return true;
            }
            if (nameAndLen2.name == null) {
                stringBuffer.append("Factory.cmp(");
                stringBuffer.append(nameAndLen.name);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(nameAndLen.name);
                if (nameAndLen2.isNum) {
                    stringBuffer.append(".getOffset(), (byte) " + Token.getEncByte('0') + ",");
                } else {
                    stringBuffer.append(".getOffset(), (byte) " + Token.getEncByte(' ') + ",");
                }
                stringBuffer.append(nameAndLen.len);
                if (alphabet != null) {
                    stringBuffer.append(',');
                    stringBuffer.append(alphabet.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(n2, stringBuffer);
                return true;
            }
            if (nameAndLen.len == nameAndLen2.len) {
                stringBuffer.append("Factory.cmp(");
                stringBuffer.append(nameAndLen.name);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(nameAndLen.name);
                stringBuffer.append(".getOffset(),");
                stringBuffer.append(nameAndLen2.name);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(nameAndLen2.name);
                stringBuffer.append(".getOffset(),");
                stringBuffer.append(nameAndLen2.len);
                if (alphabet != null) {
                    stringBuffer.append(',');
                    stringBuffer.append(alphabet.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(n2, stringBuffer);
                return true;
            }
        }
        return false;
    }

    static boolean isUDisplayCond(Expression expression, int n2, Expression expression2, StringBuffer stringBuffer, Alphabet alphabet, TokenManager tokenManager) {
        if (expression != null && expression2 != null && !expression.hasOperator && !expression2.hasOperator) {
            return SimpleCondition.getUDisplayCond(SimpleCondition.isUDisplayExpr(tokenManager, expression), SimpleCondition.isUDisplayExpr(tokenManager, expression2), n2, stringBuffer, alphabet);
        }
        return false;
    }

    private boolean isUDisplayCond(StringBuffer stringBuffer, Alphabet alphabet) {
        if (this.left != null && this.right != null && !this.left.hasOperator && !this.right.hasOperator) {
            return SimpleCondition.getUDisplayCond(SimpleCondition.isUDisplayExpr(this.tm, this.left), SimpleCondition.isUDisplayExpr(this.tm, this.right), this.op, stringBuffer, alphabet);
        }
        return false;
    }

    private void compareStd(StringBuffer stringBuffer, String string, Alphabet alphabet) {
        if (this.left.isJavaNumericWrapper() || this.right.isJavaNumericWrapper()) {
            stringBuffer.append("ExprUtil.cmp(");
            stringBuffer.append(this.left.getCode());
            stringBuffer.append(", ");
            stringBuffer.append(this.right.getCode());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.left.getCode());
            stringBuffer.append(".compareTo(");
            stringBuffer.append(this.right.getCode());
            if (!this.left.isNumeric() && !this.right.isNumeric() && alphabet != null) {
                stringBuffer.append("," + alphabet.getDeclUnivoqueName());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("0");
    }

    private boolean isXOptimizable(VariableName variableName) {
        if (this.pc.optionMS) {
            return false;
        }
        if (variableName.getVarDecl().isPic1()) {
            return false;
        }
        SubValueList subValueList = variableName.getSubValueList();
        if (subValueList != null && subValueList.isVarLen()) {
            return false;
        }
        return !variableName.isNotXOptimizable(true);
    }

    private boolean compare(StringBuffer stringBuffer, String string, Alphabet alphabet) {
        boolean bl;
        boolean bl2 = bl = string.equals("==") || string.equals("!=");
        if (this.left.couldBeNative() && this.right.couldBeNative()) {
            stringBuffer.append(this.left.getCode(true));
            stringBuffer.append(string);
            stringBuffer.append(this.right.getCode(true));
            return true;
        }
        if (alphabet == null && this.left.isString() && this.right.isString()) {
            Token token = this.left.getAsToken();
            Token token2 = this.right.getAsToken();
            if (token != null && (token.isAll() || token.isNational() || token.isResource()) || token2 != null && (token2.isAll() || token2.isNational() || token2.isResource())) {
                this.compareStd(stringBuffer, string, alphabet);
                return true;
            }
            VariableName variableName = this.left.getAsVar();
            VariableName variableName2 = this.right.getAsVar();
            if ((variableName == null || this.isXOptimizable(variableName)) && (variableName2 == null || this.isXOptimizable(variableName2))) {
                String string2;
                String string3;
                String string4;
                String string5;
                Object object;
                int n2;
                int n3 = variableName != null ? variableName.getVariableLength() : -1;
                int n4 = n2 = variableName2 != null ? variableName2.getVariableLength() : -1;
                if (variableName != null) {
                    object = new StringBuffer();
                    string5 = variableName.getCode(false, false, false);
                    variableName.getCodeOffset((StringBuffer)object, 0);
                    string4 = ((StringBuffer)object).toString();
                } else {
                    string5 = this.left.getCode();
                    string4 = "0";
                }
                if (variableName2 != null) {
                    object = new StringBuffer();
                    string3 = variableName2.getCode(false, false, false);
                    variableName2.getCodeOffset((StringBuffer)object, 0);
                    string2 = ((StringBuffer)object).toString();
                } else {
                    string3 = this.right.getCode();
                    string2 = "0";
                }
                if (n3 == n2 && n3 != -1) {
                    if (n3 == 1) {
                        String string6;
                        if (this.pc.getOption("-xms") != null) {
                            object = ".get(";
                            string6 = ")";
                        } else {
                            object = "[";
                            string6 = "]";
                        }
                        if (!bl) {
                            stringBuffer.append("(");
                        }
                        stringBuffer.append(string5);
                        stringBuffer.append(".getMemory()");
                        stringBuffer.append((String)object);
                        stringBuffer.append(string4);
                        stringBuffer.append(string6);
                        if (!bl) {
                            stringBuffer.append("&0xff)");
                        }
                        stringBuffer.append(string);
                        if (!bl) {
                            stringBuffer.append("(");
                        }
                        stringBuffer.append(string3);
                        stringBuffer.append(".getMemory()");
                        stringBuffer.append((String)object);
                        stringBuffer.append(string2);
                        stringBuffer.append(string6);
                        if (!bl) {
                            stringBuffer.append("&0xff)");
                        }
                        return true;
                    }
                    stringBuffer.append("Factory.cmp(");
                    stringBuffer.append(string5);
                    stringBuffer.append(".getMemory(),");
                    stringBuffer.append(string4);
                    stringBuffer.append(",");
                    stringBuffer.append(string3);
                    stringBuffer.append(".getMemory(),");
                    stringBuffer.append(string2);
                    stringBuffer.append(",");
                    stringBuffer.append(n3);
                    stringBuffer.append(")");
                    stringBuffer.append(string);
                    stringBuffer.append("0");
                    return true;
                }
                stringBuffer.append("Factory.cmp(");
                stringBuffer.append(string5);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(string4);
                stringBuffer.append(",");
                if (n3 == -1) {
                    if (variableName != null) {
                        if (!variableName.getSubstringLen(stringBuffer, 0)) {
                            object = variableName.getSubValueList();
                            stringBuffer.append(string5);
                            stringBuffer.append(".length()+1-");
                            stringBuffer.append(((SubValueList)object).getOffset());
                        }
                    } else {
                        stringBuffer.append(string5);
                        stringBuffer.append(".length()");
                    }
                } else {
                    stringBuffer.append(n3);
                }
                stringBuffer.append(",");
                stringBuffer.append(string3);
                stringBuffer.append(".getMemory(),");
                stringBuffer.append(string2);
                stringBuffer.append(",");
                if (n2 == -1) {
                    if (variableName2 != null) {
                        if (!variableName2.getSubstringLen(stringBuffer, 0)) {
                            object = variableName2.getSubValueList();
                            stringBuffer.append(string3);
                            stringBuffer.append(".length()+1-");
                            stringBuffer.append(((SubValueList)object).getOffset());
                        }
                    } else {
                        stringBuffer.append(string3);
                        stringBuffer.append(".length()");
                    }
                } else {
                    stringBuffer.append(n2);
                }
                stringBuffer.append(")");
                stringBuffer.append(string);
                stringBuffer.append("0");
                return true;
            }
            this.compareStd(stringBuffer, string, alphabet);
            return true;
        }
        this.compareStd(stringBuffer, string, alphabet);
        return true;
    }

    @Override
    public String getCode() {
        if (this.isBoolean()) {
            return this.getCodeBoolean();
        }
        if (this.left.getType() == 4) {
            return this.getCodeObject();
        }
        if (this.right != null) {
            switch (this.op) {
                case 1: 
                case 2: 
                case 129: 
                case 130: {
                    if (this.left.isObjectReference() && this.right.isObjectReference()) {
                        return this.getCodeObject();
                    }
                    if ((!this.left.isJavaNumericWrapper() || this.right.getType() != 3) && (this.left.getType() != 3 || !this.right.isJavaNumericWrapper())) break;
                    return this.getCodeObject();
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        boolean bl = (this.op & 0x80) == 128;
        Alphabet alphabet = null;
        if (this.pc != null) {
            alphabet = this.pc.getProgramCollatingSeq();
        }
        if (bl) {
            stringBuffer.append("!(");
        }
        if (this.pc.getOption("-cudc") != null) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            try {
                if (this.isUDisplayCond(stringBuffer, alphabet)) {
                    stringBuffer.append(")");
                    if (bl) {
                        stringBuffer.append(")");
                    }
                    return stringBuffer.toString();
                }
            }
            catch (InternalErrorException internalErrorException) {
                stringBuffer = stringBuffer2;
            }
        }
        switch (this.op & 0xFFFFFF7F) {
            case 1: {
                this.compare(stringBuffer, "==", alphabet);
                break;
            }
            case 2: {
                this.compare(stringBuffer, "!=", alphabet);
                break;
            }
            case 3: {
                this.compare(stringBuffer, ">=", alphabet);
                break;
            }
            case 4: {
                this.compare(stringBuffer, "<=", alphabet);
                break;
            }
            case 5: {
                this.compare(stringBuffer, ">", alphabet);
                break;
            }
            case 6: {
                this.compare(stringBuffer, "<", alphabet);
                break;
            }
            case 7: {
                if (this.left.firstVar == null || this.left.hasOperator) {
                    stringBuffer.append(this.left.getCode());
                } else {
                    stringBuffer.append(this.left.firstVar.getCode());
                }
                stringBuffer.append(".isPositive()");
                break;
            }
            case 8: {
                if (this.left.firstVar == null || this.left.hasOperator) {
                    stringBuffer.append(this.left.getCode());
                } else {
                    stringBuffer.append(this.left.firstVar.getCode());
                }
                stringBuffer.append(".isNegative()");
                break;
            }
            case 9: {
                stringBuffer.append(this.left.getCode());
                stringBuffer.append(".signum()==0");
                break;
            }
            case 10: {
                stringBuffer.append(this.left.firstVar.getCode());
                stringBuffer.append(".isNumeric()");
                break;
            }
            case 11: {
                stringBuffer.append(this.left.firstVar.getCode());
                stringBuffer.append(".isAlphabetic()");
                break;
            }
            case 12: {
                stringBuffer.append(this.left.firstVar.getCode());
                stringBuffer.append(".isAlphabeticUpper()");
                break;
            }
            case 13: {
                stringBuffer.append(this.left.firstVar.getCode());
                stringBuffer.append(".isAlphabeticLower()");
                break;
            }
            case 15: {
                stringBuffer.append(this.snc.getCode(this.left.firstVar));
                break;
            }
            case 16: {
                stringBuffer.append(this.left.getCode());
                stringBuffer.append(".isLike(");
                stringBuffer.append(this.right.getCode());
                stringBuffer.append(",");
                stringBuffer.append(this.like.getCode());
                stringBuffer.append(")");
                break;
            }
            case 17: {
                stringBuffer.append(this.left.firstVar.getCode());
                stringBuffer.append(".getId()==");
                stringBuffer.append(this.right.firstVar.getCode());
                break;
            }
            default: {
                throw new InternalErrorException("op=" + this.op);
            }
        }
        if (bl) {
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.left != null) {
            if (this.right != null) {
                return this.left.toString() + " & " + this.right.toString();
            }
            return this.left.toString();
        }
        if (this.right != null) {
            return this.right.toString();
        }
        return this.keyWord.getWord();
    }

    public static void check(Verb verb, Expression expression, int n2, Expression expression2) throws GeneralErrorException {
        Errors errors = verb.error;
        if (expression2 != null) {
            int n3;
            if (expression2.isVoid()) {
                throw new IllegalConditionException(verb.keyWord, errors);
            }
            if (expression2.getType() == 1 && !expression2.isObjectReference()) {
                throw new IllegalConditionException(verb.keyWord, errors);
            }
            if (expression.isObjectReference() ^ expression2.isObjectReference()) {
                Token token;
                Token token2 = expression.getAsToken();
                if (token2 != null && token2.isNull()) {
                    if (expression2.getType() == 3) {
                        expression.setNumericType();
                    } else if (expression2.isObjectReference()) {
                        expression.setNull();
                    } else if (expression2.isString()) {
                        expression.setStringType();
                    }
                }
                if ((token = expression2.getAsToken()) != null && token.isNull()) {
                    if (expression.getType() == 3) {
                        expression2.setNumericType();
                    } else if (expression.isObjectReference()) {
                        expression2.setNull();
                    } else if (expression.isString()) {
                        expression2.setStringType();
                    }
                }
                if (expression.getType() != expression2.getType()) {
                    n3 = 1;
                    switch (expression.getType()) {
                        case 3: 
                        case 5: {
                            switch (expression2.getType()) {
                                case 3: 
                                case 5: {
                                    n3 = 0;
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (!expression.isJavaString() || expression2.getType() != 2) break;
                            n3 = 0;
                            break;
                        }
                        case 2: {
                            if (!expression2.isJavaString()) break;
                            n3 = 0;
                        }
                    }
                    if (n3 != 0) {
                        throw new IllegalConditionException(verb.keyWord, errors);
                    }
                }
            }
            if (expression.getType() != expression2.getType()) {
                if (expression.getType() == 3) {
                    if (expression2.getType() == 2 && (n3 = expression.setStringType()) != 0) {
                        errors.print(n3 == 4 ? 43 : 297, n3, verb.keyWord, verb.toString());
                    }
                } else if (expression.getType() == 2) {
                    if (expression2.getType() == 3) {
                        if (n2 == 16) {
                            throw new IllegalConditionException(verb.keyWord, errors);
                        }
                        n3 = expression2.setStringType();
                        if (n3 != 0) {
                            errors.print(n3 == 4 ? 43 : 297, n3, verb.keyWord, verb.toString());
                        }
                    }
                } else {
                    MyClass myClass = expression.getCType();
                    MyClass myClass2 = expression2.getCType();
                    if (!(n2 != 1 && n2 != 2 || myClass == null || myClass2 == null || expression.isJavaNumericWrapper() && expression2.isJavaNumericWrapper() || myClass.isAssignableFrom(myClass2) || myClass2.isAssignableFrom(myClass))) {
                        throw new IllegalConditionException(verb.keyWord, errors);
                    }
                }
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.left.check();
        if (this.right != null) {
            this.right.check();
            SimpleCondition.check(this, this.left, this.op, this.right);
            if (this.op == 16) {
                this.like.check(this.right.getFirstToken());
            }
        }
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public int getOperator() {
        return this.op;
    }

    public boolean isUnary() {
        return this.isUnaryOp;
    }

    public SpecialNamesClass getSpecialNamesClass() {
        return this.snc;
    }

    static class NameAndLen {
        final String name;
        final int len;
        final boolean isNum;
        final int decimals;

        NameAndLen(String string, int n2, boolean bl, int n3) {
            this.name = string;
            this.len = n2;
            this.isNum = bl;
            this.decimals = n3;
        }

        static NameAndLen get(VariableName variableName) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            if (!variableName.hasSubValue()) {
                String string;
                if (variableDeclaration.level == 88) {
                    string = variableName.getCode88();
                    variableDeclaration = variableDeclaration.parent;
                } else {
                    string = variableName.getCode();
                }
                int n2 = variableDeclaration.getPhisicLen();
                if (variableDeclaration.isX()) {
                    return new NameAndLen(string, n2, false, 0);
                }
                if (variableDeclaration.is9Display() && !variableDeclaration.isSigned()) {
                    return new NameAndLen(string, n2, true, variableDeclaration.getDecimals());
                }
                return null;
            }
            return null;
        }

        static NameAndLen get(TokenManager tokenManager, Token token) {
            if (token.getToknum() == 10002) {
                if ("0".equals(token.getCode())) {
                    return new NameAndLen(null, 0, true, 0);
                }
                return new NameAndLen(tokenManager.getCodeLiteral(token), token.getCode().length(), true, 0);
            }
            if (token.getToknum() == 10001) {
                if (" ".equals(token.getCode())) {
                    return new NameAndLen(null, 0, false, 0);
                }
                return new NameAndLen(tokenManager.getCodeLiteral(token), token.getCode().length(), false, 0);
            }
            return null;
        }
    }
}

