/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Sort
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token fileName;
    private Select sel;
    private VariableName table;
    private boolean duplicates;
    private boolean isInDeclaratives;
    private String performMethodName;
    private VariableName keyTable;
    private VariableNameList keys = new VariableNameList();
    private LabelName startNameInp;
    private LabelName endNameInp;
    private LabelName startNameOut;
    private LabelName endNameOut;
    private int startNumInp;
    private int endNumInp;
    private int startNumOut;
    private int endNumOut;
    private SelectList selUsing;
    private Select selGiving;
    private Alphabet collSeq;

    public Sort(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        CobolToken cobolToken;
        Token token2 = this.tm.getToken();
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.fileName = token2;
        if (this.fileName.getToknum() == 10009) {
            this.sel = this.pc.getSelect(this.fileName.getWord());
            if (this.sel == null) {
                this.tm.ungetToken();
                this.table = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                if (this.table == null) {
                    throw new SyntaxErrorException(token2, token2.getWord(), this.error);
                }
                cobolToken = this.table.getVarDecl();
                if (!((VariableDeclaration)cobolToken).checkDimension(1)) {
                    throw new GeneralErrorException(163, 4, this.table.name, this.table.name.getWord(), this.error);
                }
            } else if (!this.sel.isSort()) {
                throw new GeneralErrorException(104, 4, token2, this.fileName.getWord(), this.error);
            }
        } else {
            throw new GeneralErrorException(24, 4, token2, token2.getWord(), this.error);
        }
        if ((token2 = this.tm.getToken()).getToknum() == 551) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 278) {
                throw new ExpectedFoundException(token2, this.error, "AREA");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 545) {
                token2 = this.tm.getToken();
            }
            this.tm.ungetToken();
            this.keyTable = VariableName.get(this.tm, this.error, this.pc);
            if (this.keyTable == null) {
                throw new GeneralErrorException(24, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        } else {
            block0: while (true) {
                int n2;
                int n3;
                VariableDeclaration variableDeclaration;
                VariableDeclaration variableDeclaration2;
                VariableName variableName;
                boolean bl = false;
                if (token2.getToknum() == 613) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 401) {
                    bl = true;
                } else if (token2.getToknum() != 281) break;
                token2 = this.tm.getToken();
                if (token2.getToknum() != 551) {
                    this.tm.ungetToken();
                }
                if (this.table != null) {
                    variableName = VariableName.get(this.tm, this.error, this.pc, false);
                    if (variableName != null) {
                        variableDeclaration2 = this.table.getVarDecl();
                        variableDeclaration = variableName.getVarDecl();
                        n3 = variableDeclaration2.getDimension() + variableDeclaration2.getDyDimension();
                        n2 = variableDeclaration.getDimension() + variableDeclaration.getDyDimension();
                        if (!variableDeclaration.isIn(variableDeclaration2) || n3 - variableName.getDimension() != 1 || n3 != n2) {
                            throw new GeneralErrorException(56, 4, variableName.name, variableName.name.getWord(), this.error);
                        }
                    }
                } else {
                    variableName = VariableName.get(this.tm, this.error, this.pc);
                }
                if (variableName == null) {
                    if (this.table == null) {
                        throw new GeneralErrorException(24, 4, token2, token2.getWord(), this.error);
                    }
                    variableName = this.table;
                }
                variableName.rounded = bl;
                this.keys.addItem(variableName);
                while (true) {
                    if ((token2 = this.tm.getToken()).getToknum() != 10009) continue block0;
                    this.tm.ungetToken();
                    if (this.table != null) {
                        variableName = VariableName.get(this.tm, this.error, this.pc, false);
                        if (variableName != null) {
                            variableDeclaration2 = this.table.getVarDecl();
                            variableDeclaration = variableName.getVarDecl();
                            n3 = variableDeclaration2.getDimension() + variableDeclaration2.getDyDimension();
                            n2 = variableDeclaration.getDimension() + variableDeclaration.getDyDimension();
                            if (!variableDeclaration.isIn(variableDeclaration2) || n3 - variableName.getDimension() != 1 || n3 != n2) {
                                throw new GeneralErrorException(56, 4, variableName.name, variableName.name.getWord(), this.error);
                            }
                        }
                    } else {
                        variableName = VariableName.get(this.tm, this.error, this.pc);
                    }
                    if (variableName == null) {
                        throw new GeneralErrorException(24, 4, token2, token2.getWord(), this.error);
                    }
                    variableName.rounded = bl;
                    this.keys.addItem(variableName);
                }
                break;
            }
            if (this.keys.getItemNum() == 0 && this.table == null) {
                throw new ExpectedFoundException(token2, this.error, "ASCENDING|DESCENDING");
            }
        }
        if (token2.getToknum() == 813 || token2.getToknum() == 413) {
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 413) {
                throw new ExpectedFoundException(token2, this.error, "DUPLICATES");
            }
            this.duplicates = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 526) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 618) {
                token2 = this.tm.getToken();
            }
        }
        if (token2.getToknum() == 335 || token2.getToknum() == 716) {
            if (token2.getToknum() == 335) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 716) {
                throw new ExpectedFoundException(token2, this.error, "SEQUENCE");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 545) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.collSeq = this.pc.getAlphabet(token2);
            if (this.collSeq == null) {
                throw new GeneralErrorException(25, 4, token2, "ALPHABET " + token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        }
        if (this.sel == null) {
            this.tm.ungetToken();
        } else {
            if (token2.getToknum() == 534 || token2.getToknum() == 623) {
                this.inputOutput(token2);
            } else if (token2.getToknum() == 802 || token2.getToknum() == 505) {
                this.usingGiving(token2);
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 534 || token2.getToknum() == 623) {
                this.inputOutput(token2);
            } else if (token2.getToknum() == 802 || token2.getToknum() == 505) {
                this.usingGiving(token2);
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
        }
        if (this.keys.getItemNum() == 0 && this.table != null) {
            if (this.table.getVarDecl().ascOccursKey != null) {
                cobolToken = this.table.getVarDecl().ascOccursKey.getFirst();
                while (cobolToken != null) {
                    if (((VariableName)cobolToken).getVarDecl() == null) {
                        ((VariableName)cobolToken).associateToVarDeclAny(this.pc, false);
                    }
                    cobolToken = this.table.getVarDecl().ascOccursKey.getNext();
                }
            }
            if (this.table.getVarDecl().descOccursKey != null) {
                cobolToken = this.table.getVarDecl().descOccursKey.getFirst();
                while (cobolToken != null) {
                    if (((VariableName)cobolToken).getVarDecl() == null) {
                        ((VariableName)cobolToken).associateToVarDeclAny(this.pc, false);
                    }
                    cobolToken = this.table.getVarDecl().descOccursKey.getNext();
                }
            }
        }
    }

    void inputOutput(Token token) throws GeneralErrorException, EndOfProgramException {
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 651) {
            throw new ExpectedFoundException(token2, this.error, "PROCEDURE");
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 545) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 10009 || token2.getToknum() == 10002) {
            LabelName labelName;
            this.tm.ungetToken();
            LabelName labelName2 = LabelName.get(this.parent, this.tm, this.error, this.pc);
            token2 = this.tm.getToken();
            if (token2.getToknum() == 768 || token2.getToknum() == 767) {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10009 && token2.getToknum() != 10002) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                this.tm.ungetToken();
                labelName = LabelName.get(this.parent, this.tm, this.error, this.pc);
            } else {
                this.tm.ungetToken();
                labelName = null;
            }
            if (token.getToknum() == 534) {
                if (this.startNameInp != null || this.selUsing != null) {
                    throw new GeneralErrorException(91, 4, token2, "INPUT PROCEDURE", this.error);
                }
                this.startNameInp = labelName2;
                this.endNameInp = labelName;
            } else {
                if (this.startNameOut != null || this.selGiving != null) {
                    throw new GeneralErrorException(91, 4, token2, "OUTPUT PROCEDURE", this.error);
                }
                this.startNameOut = labelName2;
                this.endNameOut = labelName;
            }
        } else {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
    }

    void usingGiving(Token token) throws GeneralErrorException, EndOfProgramException {
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            Select select = this.pc.getSelect(token2.getWord());
            if (select == null) {
                throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (select.isSort()) {
                throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (token.getToknum() == 802) {
                if (this.startNameInp != null || this.selUsing != null) {
                    throw new GeneralErrorException(91, 4, token2, "USING", this.error);
                }
                this.selUsing = new SelectList();
                this.selUsing.addItem(select);
                while ((token2 = this.tm.getToken()).getToknum() == 10009) {
                    select = this.pc.getSelect(token2.getWord());
                    if (select == null) {
                        throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
                    }
                    if (select.isSort()) {
                        throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
                    }
                    this.selUsing.addItem(select);
                }
                this.tm.ungetToken();
            } else {
                if (this.startNameOut != null || this.selGiving != null) {
                    throw new GeneralErrorException(91, 4, token2, "GIVING", this.error);
                }
                this.selGiving = select;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.sel != null) {
            int[] nArray;
            if (this.selUsing == null) {
                nArray = new int[]{this.startNumInp, this.endNumInp};
                this.performMethodName = Perform.check(this.startNameInp, this.endNameInp, nArray, this.isInDeclaratives, this.pc);
                this.startNumInp = nArray[0];
                this.endNumInp = nArray[1];
            }
            if (this.selGiving == null) {
                nArray = new int[]{this.startNumOut, this.endNumOut};
                this.performMethodName = Perform.check(this.startNameOut, this.endNameOut, nArray, this.isInDeclaratives, this.pc);
                this.startNumOut = nArray[0];
                this.endNumOut = nArray[1];
            }
        }
    }

    public String getTableCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("new CobolSort (");
        stringBuffer.append(this.table.getCode());
        stringBuffer.append(")");
        if (this.keys.getItemNum() > 0) {
            VariableName variableName = this.keys.getFirst();
            while (variableName != null) {
                stringBuffer.append(".keyAdd (");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(", ");
                stringBuffer.append(variableName.rounded);
                stringBuffer.append(")");
                variableName = this.keys.getNext();
            }
        } else if (this.table.getVarDecl().ascOccursKey != null) {
            VariableName variableName = this.table.getVarDecl().ascOccursKey.getFirst();
            while (variableName != null) {
                stringBuffer.append(".keyAdd (");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(", false)");
                variableName = this.table.getVarDecl().ascOccursKey.getNext();
            }
        } else if (this.table.getVarDecl().descOccursKey != null) {
            VariableName variableName = this.table.getVarDecl().descOccursKey.getFirst();
            while (variableName != null) {
                stringBuffer.append(".keyAdd (");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(", true)");
                variableName = this.table.getVarDecl().descOccursKey.getNext();
            }
        }
        if (this.table.isVariableLengthGroup()) {
            String string2 = this.table.getVarDecl().getCodeSort();
            stringBuffer.append(".tableSort (() -> {");
            stringBuffer.append(eol);
            stringBuffer.append(string2);
            stringBuffer.append(" });");
            stringBuffer.append(eol);
        } else {
            stringBuffer.append(".tableSort ();");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public String getCode() {
        ErrorsNumbers errorsNumbers;
        if (this.sel == null) {
            return this.getTableCode();
        }
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        boolean bl2 = this.pc.getDeclarative(this.sel) != null || bl;
        stringBuffer.append(string);
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        if (this.keys.getItemNum() > 0) {
            VariableName variableName = this.keys.getFirst();
            do {
                stringBuffer.append(".keyAdd (");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(", ");
                stringBuffer.append(variableName.rounded);
                stringBuffer.append(")");
            } while ((variableName = this.keys.getNext()) != null);
            stringBuffer.append(";");
        } else {
            stringBuffer.append(".keyTable (");
            stringBuffer.append(this.keyTable.getCode());
            stringBuffer.append(");");
        }
        stringBuffer.append(eol);
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            return this.getCodeNew(stringBuffer, bl2, string, eol);
        }
        if (this.selUsing == null) {
            Perform.getPerformCode(this.pc, this.startNumInp, this.endNumInp, string, stringBuffer, this.performMethodName, this.startNameInp, true);
            stringBuffer.append(eol);
        } else {
            errorsNumbers = this.selUsing.getFirst();
            while (errorsNumbers != null) {
                stringBuffer.append(string);
                stringBuffer.append("try {");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append(((Select)errorsNumbers).getName());
                stringBuffer.append(".open(");
                stringBuffer.append(((Select)errorsNumbers).getPathCode());
                stringBuffer.append(", CobolFile.OPEN_INPUT, CobolFile.LOCK_NONE);");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append("for ( ; ; ) {");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append(((Select)errorsNumbers).getName());
                stringBuffer.append(".readNext(false, ");
                stringBuffer.append(this.sel.getFirstRecord().getQualUnivoqueName());
                stringBuffer.append(");");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append(this.sel.getName());
                stringBuffer.append(".releaseSort();");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append("}");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append("} catch (AtEndException ");
                stringBuffer.append(this.parent.getExceptName());
                stringBuffer.append(") {}");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append(((Select)errorsNumbers).getName());
                stringBuffer.append(".close();");
                stringBuffer.append(eol);
                errorsNumbers = this.selUsing.getNext();
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        stringBuffer.append(".sort(");
        if (this.collSeq != null) {
            stringBuffer.append(this.collSeq.getDeclUnivoqueNameBytes());
        } else {
            errorsNumbers = this.pc.getProgramCollatingSeq();
            if (errorsNumbers != null) {
                stringBuffer.append(((Alphabet)errorsNumbers).getDeclUnivoqueNameBytes());
            }
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        if (this.selGiving == null) {
            Perform.getPerformCode(this.pc, this.startNumOut, this.endNumOut, string, stringBuffer, this.performMethodName, this.startNameOut, true);
            stringBuffer.append(eol);
        } else {
            stringBuffer.append(string);
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(this.selGiving.getName());
            stringBuffer.append(".open(");
            stringBuffer.append(this.selGiving.getPathCode());
            stringBuffer.append(", CobolFile.OPEN_OUTPUT, CobolFile.LOCK_NONE);");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("for ( ; ; ) {");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".returnSort(");
            stringBuffer.append(this.selGiving.getFirstRecord().getQualUnivoqueName());
            stringBuffer.append(");");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(this.selGiving.getName());
            stringBuffer.append(".write(false,");
            stringBuffer.append(this.selGiving.getFirstRecord().globalLen());
            stringBuffer.append(");");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("}");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("} catch (AtEndException ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(") {}");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(this.selGiving.getName());
            stringBuffer.append(".close();");
            stringBuffer.append(eol);
        }
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        stringBuffer.append(".finalize ();");
        stringBuffer.append(eol);
        Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
        Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), "CobolFile.OPEN_IO", bl2);
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private String getCodeNew(StringBuffer stringBuffer, boolean bl, String string, String string2) {
        ErrorsNumbers errorsNumbers;
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        stringBuffer.append(".setUsing(");
        if (this.selUsing != null) {
            stringBuffer.append("new CobolFile[] {");
            errorsNumbers = this.selUsing.getFirst();
            while (true) {
                stringBuffer.append(((Select)errorsNumbers).getName());
                errorsNumbers = this.selUsing.getNext();
                if (errorsNumbers == null) break;
                stringBuffer.append(",");
            }
            stringBuffer.append("}, new ICobolVar[] {");
            errorsNumbers = this.selUsing.getFirst();
            while (true) {
                stringBuffer.append(((Select)errorsNumbers).getPathCode());
                errorsNumbers = this.selUsing.getNext();
                if (errorsNumbers == null) break;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null, null");
        }
        stringBuffer.append(");");
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        stringBuffer.append(".setGiving(");
        if (this.selGiving != null) {
            stringBuffer.append("new CobolFile[] {");
            stringBuffer.append(this.selGiving.getName());
            stringBuffer.append("}, new ICobolVar[] {");
            stringBuffer.append(this.selGiving.getPathCode());
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null, null");
        }
        stringBuffer.append(");");
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(this.sel.getName());
        stringBuffer.append(".initSort(");
        if (this.collSeq != null) {
            stringBuffer.append(this.collSeq.getDeclUnivoqueNameBytes());
        } else {
            errorsNumbers = this.pc.getProgramCollatingSeq();
            if (errorsNumbers != null) {
                stringBuffer.append(((Alphabet)errorsNumbers).getDeclUnivoqueNameBytes());
            } else {
                stringBuffer.append("null");
            }
        }
        stringBuffer.append(");");
        stringBuffer.append(string2);
        if (this.selUsing == null) {
            Perform.getPerformCode(this.pc, this.startNumInp, this.endNumInp, string, stringBuffer, this.performMethodName, this.startNameInp, true);
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".endInput();");
            stringBuffer.append(string2);
        }
        if (this.selGiving == null) {
            Perform.getPerformCode(this.pc, this.startNumOut, this.endNumOut, string, stringBuffer, this.performMethodName, this.startNameOut, true);
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".endOutput();");
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
        if (this.tm.getOptionList().getOption("-cv") != null) {
            stringBuffer.append("} catch (SortAbort _sa) {");
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), "CobolFile.OPEN_IO", bl);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public Select getSelect() {
        return this.sel;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public VariableNameList getKeys() {
        return this.keys;
    }

    public VariableName getKeyTable() {
        return this.keyTable;
    }

    public Alphabet getCollatingSequence() {
        return this.collSeq;
    }

    public SelectList getSelUsing() {
        return this.selUsing;
    }

    public Select getSelGiving() {
        return this.selGiving;
    }

    public String getPerformMethodName() {
        return this.performMethodName;
    }

    public LabelName getStartNameInp() {
        return this.startNameInp;
    }

    public LabelName getEndNameInp() {
        return this.endNameInp;
    }

    public LabelName getStartNameOut() {
        return this.startNameOut;
    }

    public LabelName getEndNameOut() {
        return this.endNameOut;
    }

    public int getStartNumInp() {
        return this.startNumInp;
    }

    public int getEndNumInp() {
        return this.endNumInp;
    }

    public int getStartNumOut() {
        return this.startNumOut;
    }

    public int getEndNumOut() {
        return this.endNumOut;
    }

    public VariableName getTable() {
        return this.table;
    }

    public boolean isDuplicatesInOrder() {
        return this.duplicates;
    }
}

