/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.Switch;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.ISpecialNames;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SpecialNames
implements CobolToken,
ErrorsNumbers,
ISpecialNames {
    TokenManager tm;
    Errors error;
    static final char DEFAULT_CURRENCY = '$';
    static final char[] invalidCurrencyChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'P', 'R', 'S', 'V', 'X', 'Z', ' ', '*', '+', '-', ',', '.', ':', ';', '/', '\'', '\"', '='};
    boolean decimalPointIsComma = false;
    boolean numericSignTrailSep = false;
    char currency = (char)36;
    static final int FIRST_SWITCH = 0;
    static final int MAX_SWITCH = 26;
    Switch[] switches;
    VariableDeclarationList symChars;
    VariableName screenControl;
    VariableName eventStatus;
    VariableName crtStatus;
    VariableName cursor;
    VariableName eventObject;
    VariableName eventSource;
    String consName = "";
    private Vector alphabets;
    private final Pcc pcc;
    private Token firstToken;

    public SpecialNames(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, token, null);
    }

    public SpecialNames(Pcc pcc, TokenManager tokenManager, Errors errors, Token token, Token token2) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = token2;
        this.pcc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        boolean bl = pcc.getOption("-cv") != null;
        boolean bl2 = pcc.isInterfaceChild();
        Token token3 = this.tm.getToken();
        if (token3.getToknum() != 10006) {
            this.error.print(188, 3, token3, "'.'");
            this.tm.ungetToken();
        }
        block73: while ((token3 = this.tm.getToken()).getToknum() != 10006) {
            String string;
            switch (token3.getToknum()) {
                case 368: {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 383) {
                        pcc.consoleIsCrt = true;
                    }
                    this.consName = token3.getWord();
                    continue block73;
                }
                case 383: {
                    if (bl2) {
                        throw new GeneralErrorException(246, 4, token3, token3.getWord(), this.error);
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 742) {
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.crtStatus = VariableName.get(this.tm, this.error);
                            continue block73;
                        }
                        new UnexpectedTokenException(token3, this.error);
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case 386: {
                    if (bl2) {
                        throw new GeneralErrorException(246, 4, token3, token3.getWord(), this.error);
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.cursor = VariableName.get(this.tm, this.error);
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case 705: {
                    if (bl2) {
                        throw new GeneralErrorException(246, 4, token3, token3.getWord(), this.error);
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 373) {
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.screenControl = VariableName.get(this.tm, this.error);
                            continue block73;
                        }
                        new UnexpectedTokenException(token3, this.error);
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case 468: {
                    if (bl2) {
                        throw new GeneralErrorException(246, 4, token3, token3.getWord(), this.error);
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 742) {
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventStatus = VariableName.get(this.tm, this.error);
                            continue block73;
                        }
                        new UnexpectedTokenException(token3, this.error);
                        continue block73;
                    }
                    if (token3.getToknum() == 606) {
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventObject = VariableName.getObject(this.tm, this.error, null, null);
                            if (this.eventObject != null) continue block73;
                            new GeneralErrorException(75, 4, token3, token3.getWord(), this.error);
                            continue block73;
                        }
                        new UnexpectedTokenException(token3, this.error);
                        continue block73;
                    }
                    if (token3.getToknum() == 10009 && token3.getWord().equalsIgnoreCase("SOURCE")) {
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.eventSource = VariableName.getObject(this.tm, this.error, null, null);
                            if (this.eventSource != null) continue block73;
                            new GeneralErrorException(75, 4, token3, token3.getWord(), this.error);
                            continue block73;
                        }
                        new UnexpectedTokenException(token3, this.error);
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case 394: {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 339) {
                        this.decimalPointIsComma = true;
                        this.tm.setDecimalPointIsComma();
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, errors);
                    continue block73;
                }
                case 603: {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() != 724) {
                        throw new ExpectedFoundException(token3, this.error, "SIGN");
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() != 776) {
                        throw new ExpectedFoundException(token3, this.error, "TRAILING");
                    }
                    token3 = this.tm.getToken();
                    if (token3.getToknum() != 715) {
                        throw new ExpectedFoundException(token3, this.error, "SEPARATE");
                    }
                    this.numericSignTrailSep = true;
                    pcc.setNumericSignTrailingSeparate(true);
                    continue block73;
                }
                case 385: {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 724) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 10001 && token3.getWord().length() == 3 && this.isValidCurrencyChar(token3.getWord().charAt(1))) {
                        this.currency = token3.getWord().charAt(1);
                        continue block73;
                    }
                    new GeneralErrorException(16, 4, token3, "<" + token3.getWord() + ">", errors);
                    continue block73;
                }
                case 325: {
                    Object object;
                    while ((token3 = this.tm.getToken()).getToknum() == 10009) {
                        object = new SpecialNamesClass(pcc, tokenManager, errors, token3);
                        if (pcc.putSpecialNamesClass((SpecialNamesClass)object)) continue;
                        new GeneralErrorException(63, 4, token3, token3.getWord(), errors);
                    }
                    this.tm.ungetToken();
                    continue block73;
                }
                case 749: {
                    this.parseSwitch(token3, bl2, -1);
                    continue block73;
                }
                case 750: {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 324) {
                        token3 = this.tm.getToken();
                    }
                    Object object = new Vector();
                    Vector<Token> vector = new Vector<Token>();
                    while (true) {
                        if (token3.getToknum() == 10009) {
                            ((Vector)object).addElement(token3.getWord());
                            token3 = this.tm.getToken();
                            continue;
                        }
                        if (((Vector)object).size() == 0) {
                            throw new GeneralErrorException(17, 4, token3, token3.getWord(), this.error);
                        }
                        if (token3.getToknum() == 545 || token3.getToknum() == 277) {
                            token3 = this.tm.getToken();
                        }
                        while (token3.getToknum() == 10002) {
                            vector.addElement(token3);
                            token3 = this.tm.getToken();
                        }
                        if (((Vector)object).size() != vector.size()) {
                            throw new GeneralErrorException(129, 4, token3, "", this.error);
                        }
                        if (token3.getToknum() != 10009) break;
                    }
                    this.tm.ungetToken();
                    if (this.symChars == null) {
                        this.symChars = new VariableDeclarationList();
                    }
                    for (int i2 = ((Vector)object).size() - 1; i2 >= 0; --i2) {
                        VariableDeclaration variableDeclaration = VariableDeclaration.getConstant(pcc, this.tm, (String)((Vector)object).elementAt(i2), this.getSymChar((Token)vector.elementAt(i2)));
                        variableDeclaration.getValueToken().setHexdecimal(true);
                        this.symChars.addItem(variableDeclaration);
                        pcc.loadVariable(variableDeclaration);
                        this.tm.addConstVar(variableDeclaration);
                    }
                    continue block73;
                }
                case 265: {
                    if (bl2) {
                        throw new GeneralErrorException(246, 4, token3, token3.getWord(), this.error);
                    }
                    if (this.alphabets == null) {
                        this.alphabets = new Vector();
                    }
                    Alphabet alphabet = new Alphabet(pcc, this.tm, this.error);
                    this.alphabets.addElement(alphabet);
                    if (token == null || !token.getCode().equals(alphabet.getName().getCode())) continue block73;
                    this.tm.setLowHighValues(alphabet.getLowValue(), alphabet.getHighValue());
                    continue block73;
                }
            }
            switch (string = token3.getWord()) {
                case "ENVIRONMENT-VALUE": {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 10009) {
                        this.tm.setEnvValue(token3.getWord());
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case "ENVIRONMENT-NAME": {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    if (token3.getToknum() == 10009) {
                        this.tm.setEnvName(token3.getWord());
                        continue block73;
                    }
                    new UnexpectedTokenException(token3, this.error);
                    continue block73;
                }
                case "CSP": 
                case "C01": 
                case "C02": 
                case "C03": 
                case "C04": 
                case "C05": 
                case "C06": 
                case "C07": 
                case "C08": 
                case "C09": 
                case "C10": 
                case "C11": 
                case "C12": 
                case "AFP-5A": {
                    if (bl) {
                        String string2 = token3.getWord();
                        token3 = this.tm.getToken();
                        if (token3.getToknum() == 545) {
                            token3 = this.tm.getToken();
                        }
                        if (token3.getToknum() == 10009) {
                            pcc.putSNFunc(token3.getWord(), string2);
                            continue block73;
                        }
                        throw new UnexpectedTokenException(token3, errors);
                    }
                    this.tm.ungetToken();
                    break;
                }
                case "SYSIN": 
                case "SYSOUT": 
                case "SYSERR": 
                case "SYSOUT-FLUSH": 
                case "CONSOLE": 
                case "SYSLST": 
                case "SYSLIST": {
                    token3 = this.tm.getToken();
                    if (token3.getToknum() == 545) {
                        token3 = this.tm.getToken();
                    }
                    pcc.putMnemonicSystem(token3.getWord(), string);
                    continue block73;
                }
                case "SWITCH-0": 
                case "SWITCH-1": 
                case "SWITCH-2": 
                case "SWITCH-3": 
                case "SWITCH-4": 
                case "SWITCH-5": 
                case "SWITCH-6": 
                case "SWITCH-7": 
                case "SWITCH-8": 
                case "SWITCH-9": 
                case "SWITCH-10": 
                case "SWITCH-11": 
                case "SWITCH-12": 
                case "SWITCH-13": 
                case "SWITCH-14": 
                case "SWITCH-15": 
                case "SWITCH-16": 
                case "SWITCH-17": 
                case "SWITCH-18": 
                case "SWITCH-19": 
                case "SWITCH-20": 
                case "SWITCH-21": 
                case "SWITCH-22": 
                case "SWITCH-23": 
                case "SWITCH-24": 
                case "SWITCH-25": 
                case "SWITCH-26": {
                    this.parseSwitch(token3, bl2, Integer.parseInt(string.substring(string.indexOf(45) + 1)));
                    continue block73;
                }
                default: {
                    this.tm.ungetToken();
                    break;
                }
            }
            break;
        }
        if (this.hasSwitches()) {
            for (int i3 = 0; i3 <= 26; ++i3) {
                Switch switch_ = this.switches[i3];
                if (switch_ == null) continue;
                switch_.var = VariableDeclaration.getSwitchVar(pcc, switch_.mnemonic, switch_.condNameOn, switch_.condNameOff, false, this.tm, this.error);
                pcc.loadVariable(switch_.var);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSwitch(Token token, boolean bl, int n2) throws GeneralErrorException, EndOfProgramException {
        Object object;
        if (bl) {
            throw new GeneralErrorException(246, 4, token, token.getWord(), this.error);
        }
        if (this.pcc.getRoot().getIdentificationDivision().getClassId() != null) {
            throw new GeneralErrorException(19, 4, token, ": switch in cobol class", this.error);
        }
        if (n2 < 0) {
            token = this.tm.getToken();
            if (token.getToknum() == 10001 && ((String)(object = token.getPlain())).length() == 1) {
                char c2 = ((String)object).charAt(0);
                if (c2 < 'A' || c2 > 'Z') throw new UnexpectedTokenException(token, this.error);
                n2 = '\u0001' + c2 - 65;
            } else {
                if (token.getToknum() != 10002) throw new UnexpectedTokenException(token, this.error);
                n2 = Integer.parseInt(token.getWord());
                if (n2 < 0 || n2 > 26) {
                    throw new GeneralErrorException(30, 4, token, "" + n2, this.error);
                }
            }
        }
        if (this.switches == null) {
            this.switches = new Switch[27];
        }
        if ((object = this.switches[n2]) == null) {
            this.switches[n2] = new Switch(n2);
            object = this.switches[n2];
        }
        if ((token = this.tm.getToken()).getToknum() == 545) {
            token = this.tm.getToken();
        }
        if (token.getToknum() == 10009) {
            ((Switch)object).mnemonic = token.getWord();
            token = this.tm.getToken();
        }
        while (token.getToknum() == 613 || token.getToknum() == 610) {
            Token token2 = token;
            token = this.tm.getToken();
            if (token.getToknum() == 742) {
                token = this.tm.getToken();
            }
            if (token.getToknum() == 545) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 10009) throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            if (token2.getToknum() == 613) {
                ((Switch)object).condNameOn = token.getWord();
            } else {
                ((Switch)object).condNameOff = token.getWord();
            }
            token = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private String getSymChar(Token token) throws GeneralErrorException {
        String string = "";
        try {
            int n2 = Integer.parseInt(token.getCode());
            if (n2 < 1 || n2 > 256) {
                throw new GeneralErrorException(235, 4, token, "", this.error);
            }
            string = "" + (char)(n2 - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string;
    }

    public void check(Pcc pcc) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        if (this.screenControl != null) {
            this.screenControl.check(pcc);
            variableDeclaration = this.screenControl.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNScreenControl(variableDeclaration);
        }
        if (this.crtStatus != null) {
            this.crtStatus.check(pcc);
            variableDeclaration = this.crtStatus.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNCrtStatus(variableDeclaration);
        }
        if (this.cursor != null) {
            this.cursor.check(pcc);
            variableDeclaration = this.cursor.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNCursor(variableDeclaration);
        }
        if (this.eventStatus != null) {
            this.eventStatus.check(pcc);
            variableDeclaration = this.eventStatus.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNEventStatus(variableDeclaration);
        }
        if (this.eventObject != null) {
            this.eventObject.checkObject(pcc);
            if (!this.eventObject.getType().getName().equals("java.util.EventObject")) {
                new GeneralErrorException(75, 4, this.eventObject.getNameToken(), this.eventObject.getName(), this.error);
            }
            variableDeclaration = this.eventObject.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNEventObject(variableDeclaration);
        }
        if (this.eventSource != null) {
            this.eventSource.checkObject(pcc);
            if (!this.eventSource.getType().getName().equals("com.iscobol.gui.server.CobolGUIJavaBean")) {
                new GeneralErrorException(75, 4, this.eventSource.getNameToken(), this.eventSource.getName(), this.error);
            }
            variableDeclaration = this.eventSource.getVarDecl();
            variableDeclaration.setUsed();
            pcc.setSNEventSource(variableDeclaration);
        }
    }

    private boolean isValidCurrencyChar(char c2) {
        c2 = Character.toUpperCase(c2);
        for (int i2 = 0; i2 < invalidCurrencyChars.length; ++i2) {
            if (c2 != invalidCurrencyChars[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSwitches() {
        return this.switches != null;
    }

    public String getCode(StringBuffer stringBuffer) {
        Hashtable hashtable;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* currency = [" + this.currency + "] */" + eol);
        stringBuffer2.append("/* decimalPointIsComma = [" + this.decimalPointIsComma + "] */" + eol);
        if (!this.pcc.optionMS && this.hasSwitches()) {
            for (int i2 = 0; i2 <= 26; ++i2) {
                if (this.switches[i2] == null) continue;
                stringBuffer2.append(this.switches[i2].var.getCode(stringBuffer));
            }
        }
        if (this.symChars != null) {
            VariableDeclaration variableDeclaration = this.symChars.getFirst();
            while (variableDeclaration != null) {
                stringBuffer2.append(variableDeclaration.getCode(stringBuffer));
                variableDeclaration = this.symChars.getNext();
            }
        }
        if ((hashtable = this.pcc.getSpecialNamesClasses()) != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                SpecialNamesClass.Values values;
                int n2;
                SpecialNamesClass specialNamesClass = (SpecialNamesClass)enumeration.nextElement();
                Vector vector = specialNamesClass.getValues();
                int n3 = 0;
                for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                    values = (SpecialNamesClass.Values)vector.elementAt(n2);
                    if (values.thruValue == null) {
                        n3 += values.fromValue.getWord().length() - 2;
                        continue;
                    }
                    ++n3;
                }
                stringBuffer2.append("SNClass " + specialNamesClass.uniqueName + "= new SNClass (" + n3 + ")");
                for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                    values = (SpecialNamesClass.Values)vector.elementAt(n2);
                    if (specialNamesClass.isNational()) {
                        stringBuffer2.append(".add ( ");
                    } else {
                        stringBuffer2.append(".addB ( ");
                    }
                    stringBuffer2.append(this.tm.getCodeLiteral(values.fromValue));
                    if (values.thruValue != null) {
                        stringBuffer2.append(",");
                        stringBuffer2.append(this.tm.getCodeLiteral(values.thruValue));
                    }
                    stringBuffer2.append(")");
                    stringBuffer2.append(eol);
                }
                stringBuffer2.append(";");
                stringBuffer2.append(eol);
            }
        }
        return stringBuffer2.toString();
    }

    public String getSwitchesCode(StringBuffer stringBuffer) {
        if (this.hasSwitches()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("Factory.setSwitches (new NumericVar[] {");
            stringBuffer2.append(eol);
            int n2 = 0;
            while (true) {
                stringBuffer2.append("            ");
                if (this.switches[n2] != null) {
                    stringBuffer2.append(this.switches[n2].var.getUnivoqueName());
                } else {
                    stringBuffer2.append("null");
                }
                if (n2 == 26) break;
                stringBuffer2.append(",");
                stringBuffer2.append(eol);
                ++n2;
            }
            stringBuffer2.append("});");
            stringBuffer2.append(eol);
            return stringBuffer2.toString();
        }
        return "";
    }

    public Alphabet[] getAlphabets() {
        if (this.alphabets != null && this.alphabets.size() > 0) {
            Alphabet[] alphabetArray = new Alphabet[this.alphabets.size()];
            this.alphabets.toArray(alphabetArray);
            return alphabetArray;
        }
        return null;
    }

    public Alphabet getAlphabet(Token token) {
        String string = token.getCode();
        if (this.alphabets != null) {
            for (int i2 = this.alphabets.size() - 1; i2 >= 0; --i2) {
                Alphabet alphabet = (Alphabet)this.alphabets.elementAt(i2);
                if (!alphabet.getName().getCode().equals(string)) continue;
                return alphabet;
            }
        }
        return null;
    }

    public Switch[] getSwitches() {
        return this.switches;
    }

    @Override
    public char getCurrency() {
        return this.currency;
    }

    @Override
    public boolean isDecimalPointIsComma() {
        return this.decimalPointIsComma;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }
}

