/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlClose
extends SqlStatement {
    private String name;

    public SqlClose(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors);
        Token token2 = this.getSqlToken();
        if (token2.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
        } else {
            this.name = token2.getWord();
            if (!this.pc.checkCursor(this.name)) {
                throw new GeneralErrorException(93, 4, token2, this.name, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.name != null) {
            SqlDeclareCursor sqlDeclareCursor = this.pc.getCursor(this.name);
            this.isSqljStat = sqlDeclareCursor.isSqljStat;
            if (sqlDeclareCursor.getPrepStat() != null) {
                this.isSqljStat = false;
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.sqlj && this.isSqljStat) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("try {" + eol);
            stringBuffer.append(this.parent.getIndent());
            if (this.name != null) {
                stringBuffer.append("if (" + this.name + " != null)" + eol);
                stringBuffer.append(this.parent.getIndent() + "   ");
                stringBuffer.append(this.name + ".close();");
            } else {
                stringBuffer.append("if (" + this.cursHndl.getCode() + " != null)" + eol);
                stringBuffer.append(this.parent.getIndent() + "   ");
                stringBuffer.append(this.cursHndl.getCode() + ".close();");
            }
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("else" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("   throw new SQLException(\"IsCOBOLNotFound\");");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("catch (SQLException e) {" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}" + eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat: CLOSE " + this.name + " SQLCODE=\" + " + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        } else {
            stringBuffer.append(this.getReturnCode());
            if (this.name != null) {
                stringBuffer.append(".set(Esql.CLOSE(new Object[] {");
                stringBuffer.append(this.pc.sqlca.SQLCA + ", \"");
                stringBuffer.append(this.name);
                stringBuffer.append("\", null, " + this.getInstanceName());
                stringBuffer.append("}));");
            } else {
                stringBuffer.append(".set(Esql.CLOSE_HNDL(new Object[] {");
                stringBuffer.append(this.pc.sqlca.SQLCA + ", ");
                stringBuffer.append(this.cursHndl.getCode());
                if (this.pc.getOption("-xcsqc") != null) {
                    stringBuffer.append(", " + this.getInstanceName());
                }
                stringBuffer.append("}));");
            }
        }
        stringBuffer.append(eol);
        this.addWhenever(stringBuffer);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public VariableName getCursorHandle() {
        if (this.cursHndl == null) {
            return this.pc.getCursor(this.name).getCursorHandle();
        }
        return this.cursHndl;
    }

    public String getName() {
        return this.name;
    }
}

