/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlDeclareVar
extends SqlStatement {
    static final int SQL_TYPE_NOBIN = 0;
    static final int SQL_TYPE_BINARY = 1;
    VariableName var;
    int sqlType = 0;
    String ccsid = "";
    VariableName ccsidVar = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlDeclareVar(ExecSql execSql, Token token, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, null, pcc, tokenManager, errors, false);
        Token token2 = this.tm.getToken();
        if (token2 == null || token2.getToknum() != 10009) return;
        this.ungetSqlToken();
        this.var = VariableName.get(this.tm, this.error, this.pc);
        token2 = this.getSqlToken();
        if (token2 == null || !token2.getWord().equalsIgnoreCase("VARIABLE")) throw new GeneralErrorException(31, 4, token2, "VARIABLE/" + token2.getWord(), this.error);
        token2 = this.getSqlToken();
        if (token2 != null && token2.getWord().equalsIgnoreCase("FOR")) {
            token2 = this.getSqlToken();
            if (token2 == null || !token2.getWord().equalsIgnoreCase("BIT")) throw new GeneralErrorException(31, 4, token2, "BIT/" + token2.getWord(), this.error);
            token2 = this.getSqlToken();
            if (token2 == null || !token2.getWord().equalsIgnoreCase("DATA")) throw new GeneralErrorException(31, 4, token2, "DATA/" + token2.getWord(), this.error);
            this.sqlType = 1;
            return;
        } else {
            if (!token2.getWord().equalsIgnoreCase("CCSID")) throw new GeneralErrorException(31, 4, token2, "FOR or CCSID/" + token2.getWord(), this.error);
            token2 = this.getSqlToken();
            if (token2.getToknum() == 58) {
                this.ccsidVar = this.getHostVariable(false, true);
                return;
            } else {
                this.ccsid = token2.getWord();
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sqlType == 1) {
            stringBuffer.append(this.var.getName().replace('-', Pcc.hyphenRepl) + ".setSqlBinary();" + eol);
        }
        return stringBuffer.toString();
    }
}

