/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatPlsql;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlExecute
extends SqlStatPlsql {
    private boolean immediate;
    private VariableName selVar;
    private Token selToken;
    private boolean plsql;
    private VariableName prepHndl;
    private VariableName descriptorUsing;
    private VariableName descriptorInto;
    private Pcc ppcc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlExecute(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, VariableName variableName, int n2, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, variableName, n2, errors);
        this.isSqljStat = false;
        Token token2 = this.getSqlToken();
        this.ppcc = pcc;
        if (token2.getWord().equals("DECLARE") || token2.getWord().equals("BEGIN")) {
            this.plsql = true;
            this.plsql(token2);
            this.fillParameters(token2);
            return;
        }
        if (token2.getWord().equals("IMMEDIATE")) {
            this.immediate = true;
            token2 = this.getSqlToken(true);
            if (token2.getToknum() == 10001) {
                this.selToken = token2;
            } else if (token2.getToknum() == 58) {
                this.selVar = this.getHostVariable();
            } else if (token2.getToknum() == 10009) {
                throw new GeneralErrorException(97, 4, token2, token2.getWord(), this.error);
            }
            this.prepStat = "***";
        } else if (token2.getToknum() == 58) {
            this.prepHndl = this.getHostVariable();
            if (!this.prepHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.prepHndl.getNameToken(), this.prepHndl.getName(), this.error);
            }
        } else {
            this.prepStat = token2.getWord();
        }
        token2 = this.getSqlToken();
        if (token2.getToknum() == 802) {
            token2 = this.getSqlToken();
            if (token2.getWord().equals("DESCRIPTOR")) {
                if (!this.db2Esql) {
                    this.descriptorUsing = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    token2 = this.getSqlToken(true);
                    if (token2.getToknum() != 58) throw new ExpectedFoundException(token2, this.error, " Variable-Name ");
                    this.descriptorUsing = this.getHostVariable();
                }
            } else {
                this.ungetAllSqlToken();
                this.parmVars = new Vector();
                this.parmInds = new Vector();
                this.into(this.parmVars, this.parmInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        token2 = this.getSqlToken();
        if (token2.getToknum() == 542) {
            token2 = this.getSqlToken();
            if (token2.getWord().equals("DESCRIPTOR")) {
                if (!this.db2Esql) {
                    this.descriptorInto = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    token2 = this.getSqlToken(true);
                    if (token2.getToknum() != 58) throw new ExpectedFoundException(token2, this.error, " Variable-Name ");
                    this.descriptorInto = this.getHostVariable();
                }
            } else {
                this.ungetAllSqlToken();
                this.bindVars = new Vector();
                this.bindInds = new Vector();
                this.into(this.bindVars, this.bindInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        if (this.parmInds == null || !this.optionXLVNULL) return;
        this.fillParmInds(this.parmInds, this.parmVars);
    }

    void plsql(Token token) throws GeneralErrorException, EndOfProgramException {
        Token token2 = token;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.resetQuery();
        this.addToken(token);
        this.parmVars = new Vector();
        this.parmInds = new Vector();
        this.parmType = new Vector();
        this.parmIOUD = new Vector();
        this.parmOtherType = new Vector();
        this.parmNameType = new Vector();
        while ((token = this.getSqlToken()).getToknum() != 432) {
            if (token.getToknum() == 40 && n4 == 0) {
                ++n4;
                ++n2;
                n3 = this.parmVars.size();
                if (token2.getToknum() != 40) {
                    this.saveProcNames();
                } else {
                    this.procNames.add("__$$void$$__");
                }
            } else if (token.getToknum() == 41 && n4 == 1) {
                --n4;
                this.saveProcParms(n3, token);
                this.procNames.remove(--n2);
                n3 = this.parmVars.size();
            } else if (token.getToknum() == 40) {
                ++n4;
            } else if (token.getToknum() == 41) {
                --n4;
            }
            if (token.getToknum() == 58) {
                Token token3 = this.getSqlToken();
                if (token3.isWord()) {
                    this.ungetSqlToken();
                    this.value(this.parmVars, this.parmInds, true);
                    if (n2 == 0) {
                        token = this.getSqlToken();
                        if (token.getWord() == ":=") {
                            this.addToQuery(":=");
                            this.parmType.add(null);
                            this.parmIOUD.add("O");
                            this.parmOtherType.add(null);
                            this.parmNameType.add(null);
                        } else {
                            this.parmType.add(null);
                            this.parmIOUD.add("I");
                            this.parmOtherType.add(null);
                            this.parmNameType.add(null);
                            this.ungetAllSqlToken();
                        }
                    }
                } else {
                    this.addToken(token);
                    this.addToken(token3);
                }
            } else {
                this.addToken(token);
            }
            token2 = token;
        }
        for (int i2 = this.parmType.size(); i2 < this.parmVars.size() + 1; ++i2) {
            this.parmType.add(null);
            this.parmIOUD.add("D");
            this.parmOtherType.add(null);
            this.parmNameType.add(null);
        }
        this.ungetSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
        VariableName variableName;
        Object e2;
        int n2;
        if (this.parmVars != null) {
            for (n2 = 0; n2 < this.parmVars.size(); ++n2) {
                e2 = this.parmVars.elementAt(n2);
                if (!(e2 instanceof VariableName)) continue;
                ((VariableName)e2).check(this.pc);
            }
        }
        if (this.parmInds != null) {
            for (n2 = 0; n2 < this.parmInds.size(); ++n2) {
                variableName = (VariableName)this.parmInds.elementAt(n2);
                if (variableName == null) continue;
                variableName.check();
                variableName.getVarDecl().setEsqlIndicator();
            }
        }
        if (this.bindVars != null) {
            for (n2 = 0; n2 < this.bindVars.size(); ++n2) {
                e2 = this.bindVars.elementAt(n2);
                if (!(e2 instanceof VariableName)) continue;
                ((VariableName)e2).check(this.pc);
            }
        }
        if (this.bindInds != null) {
            for (n2 = 0; n2 < this.bindInds.size(); ++n2) {
                variableName = (VariableName)this.bindInds.elementAt(n2);
                if (variableName == null) continue;
                variableName.check();
                variableName.getVarDecl().setEsqlIndicator();
            }
        }
    }

    @Override
    public Vector getParmVars() {
        return this.parmVars;
    }

    @Override
    public Vector getParmInds() {
        return this.parmInds;
    }

    public Vector getBindVars() {
        return this.bindVars;
    }

    public Vector getBindInds() {
        return this.bindInds;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.plsql) {
            stringBuffer.append(this.getPlsqlCode());
        }
        if (this.descriptorInto != null || this.descriptorUsing != null) {
            stringBuffer.append(this.getReturnCode());
            stringBuffer.append(".set(Esql.EXECUTE_DESCRIPTOR_DB2(new Object[]{" + this.pc.sqlca.SQLCA + ", \"");
            stringBuffer.append(this.prepStat);
            if (this.descriptorInto != null) {
                stringBuffer.append("\", " + this.descriptorInto.getCode());
            } else {
                stringBuffer.append("\", null");
            }
            if (this.descriptorUsing != null) {
                stringBuffer.append(", " + this.descriptorUsing.getCode());
            } else {
                stringBuffer.append(", null");
            }
            stringBuffer.append(", ");
            stringBuffer.append(this.getInstanceName(this.ppcc));
            if (this.optionCP) {
                stringBuffer.append(", ");
                stringBuffer.append("" + this.optionD64);
            }
            stringBuffer.append("}));");
            stringBuffer.append(eol);
        } else {
            this.startForClause(stringBuffer);
            if (this.immediate && (this.selVar != null || this.selToken != null) && this.bindVars == null && this.parmVars == null) {
                stringBuffer.append(this.getReturnCode());
                stringBuffer.append(".set(Esql.EXECUTE_IMMEDIATE(new Object[]{" + this.pc.sqlca.SQLCA + ",");
                if (this.selVar != null) {
                    if (this.selVar.getVarDecl().isVarying() || this.selVar.getVarDecl().isVarChar() || this.selVar.getVarDecl().isLob()) {
                        stringBuffer.append(this.selVar.getVarDecl().getChildren().getLast().getUnivoqueName());
                    } else {
                        stringBuffer.append(this.selVar.getVarDecl().getUnivoqueName());
                    }
                    if (this.selVar.hasIndexes()) {
                        stringBuffer.append(this.selVar.getIndexes().getCode(this.selVar.getVarDecl().isObjectReference(), this.selVar.getVarDecl().getOccurs() > 0, this.selVar.isEdited() && this.selVar.isNumeric()));
                    }
                    stringBuffer.append(", true}));");
                } else {
                    stringBuffer.append(this.getCodeLiteral(this.selToken));
                    stringBuffer.append(", false}));");
                }
                stringBuffer.append(eol);
            } else {
                if (this.immediate) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(this.getReturnCode());
                    stringBuffer.append(".set(Esql.PREPARE(new Object[] {" + this.pc.sqlca.SQLCA + ",\"***\",null,");
                    if (this.selVar != null) {
                        stringBuffer.append(this.selVar.getVarDecl().getUnivoqueName());
                        stringBuffer.append(", true}));");
                    } else {
                        stringBuffer.append(this.getCodeLiteral(this.selToken));
                        stringBuffer.append(", false}));");
                    }
                    stringBuffer.append(eol);
                    this.addWhenever(stringBuffer);
                }
                this.getCodeGeneric(this.pc, stringBuffer, null, this.prepStat, this.prepHndl, true, this.bindVars, this.bindInds, this.parmVars, this.parmInds);
                if (this.immediate) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(this.getReturnCode());
                    stringBuffer.append(".set(Esql.FREE(new Object[] {");
                    stringBuffer.append(this.cursHndl.getCode());
                    stringBuffer.append(", " + this.getInstanceName());
                    stringBuffer.append("}));");
                    stringBuffer.append(eol);
                }
            }
            this.endForClause(stringBuffer);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean isPlsql() {
        return this.plsql;
    }

    public String getPrepStat() {
        return this.prepStat;
    }

    public VariableName getPrepHndl() {
        return this.prepHndl;
    }

    public VariableName getSelVar() {
        return this.selVar;
    }

    public Token getSelToken() {
        return this.selToken;
    }

    @Override
    void saveProcNames() throws GeneralErrorException, EndOfProgramException {
        Token token = null;
        String string = "";
        int n2 = 0;
        boolean bl = false;
        this.ungetSqlToken();
        while (!bl) {
            this.ungetSqlToken();
            token = this.tm.getToken();
            if (token.getToknum() != 10021) {
                bl = true;
            }
            this.ungetSqlToken();
        }
        bl = false;
        while (!bl) {
            this.ungetSqlToken();
            token = this.tm.getToken();
            if (token.getToknum() != 10021) {
                bl = true;
            }
            this.ungetSqlToken();
            ++n2;
        }
        if (token.getToknum() == 10006) {
            bl = false;
            while (!bl) {
                this.ungetSqlToken();
                token = this.tm.getToken();
                if (token.getToknum() != 10021) {
                    bl = true;
                }
                this.ungetSqlToken();
            }
        } else {
            while (n2 > 0) {
                this.tm.getToken();
                --n2;
            }
        }
        while ((token = this.tm.getToken()).getToknum() != 40) {
            if (token.getToknum() == 10021) continue;
            string = string + token.getWord();
        }
        if (this.procNames == null) {
            this.procNames = new Vector();
        }
        this.procNames.add(string);
    }
}

