/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlFetch
extends SqlStatement {
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    private int fetchType = 1;
    private Vector bindVars;
    private Vector bindInds;
    private VariableName descriptorVar = null;
    private boolean rowset = false;
    private boolean rowsetStartingType = false;
    private VariableName rowsetHostVar = null;
    private int rowsetVal = 0;
    private VariableName rowsetStartingHostVar = null;
    private int rowsetStartingVal = -1;
    private SqlDeclareCursor c;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlFetch(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, VariableName variableName, int n2, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, variableName, n2, errors);
        Token token2 = this.getSqlToken();
        switch (token2.getToknum()) {
            case 595: {
                this.fetchType = 1;
                break;
            }
            case 489: {
                this.fetchType = 2;
                break;
            }
            case 554: {
                this.fetchType = 3;
                break;
            }
            case 643: {
                this.fetchType = 4;
                break;
            }
            case 677: {
                throw new GeneralErrorException(95, 4, token2, token2.getWord(), this.error);
            }
            default: {
                if (token2.getWord().equals("PRIOR")) {
                    this.fetchType = 4;
                    break;
                }
                if (token2.getWord().equals("ABSOLUTE")) {
                    throw new GeneralErrorException(95, 4, token2, token2.getWord(), this.error);
                }
                if (token2.getWord().equals("ROWSET")) {
                    this.rowset = true;
                    token2 = this.getSqlToken();
                    if (!token2.getWord().equals("STARTING")) throw new ExpectedFoundException(token2, this.error, "'STARTING'");
                    token2 = this.getSqlToken();
                    if (token2.getToknum() != 284) {
                        throw new ExpectedFoundException(token2, this.error, "'AT'");
                    }
                    token2 = this.getSqlToken();
                    if (token2.getWord().equals("ABSOLUTE")) {
                        this.rowsetStartingType = true;
                    }
                    if (!token2.getWord().equals("ABSOLUTE") && !token2.getWord().equals("RELATIVE")) throw new ExpectedFoundException(token2, this.error, "'ABSOLUTE/RELATIVE'");
                    token2 = this.getSqlToken();
                    if (token2.getToknum() == 58) {
                        this.rowsetStartingHostVar = this.getHostVariable();
                        break;
                    }
                    if (token2.getToknum() != 10002) throw new ExpectedFoundException(token2, this.error, "SQL HOST VARIABLE or Int literal");
                    this.rowsetStartingVal = new Integer(token2.getWord());
                    break;
                }
                this.ungetAllSqlToken();
            }
        }
        token2 = this.getSqlToken();
        if (token2.getWord().equals("ROWSET")) {
            if (this.rowset) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.rowset = true;
            token2 = this.getSqlToken();
        }
        if (token2.getToknum() == 498) {
            token2 = this.getSqlToken();
        }
        if (token2.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
        } else {
            this.curName = token2.getWord();
            this.c = this.pc.getCursor(this.curName);
            if (this.c == null) {
                throw new GeneralErrorException(93, 4, token2, this.curName, this.error);
            }
            this.cursHndl = this.c.cursHndl;
        }
        token2 = this.getSqlToken();
        if (this.rowset && token2.getToknum() == 494) {
            token2 = this.getSqlToken();
            if (token2.getToknum() == 58) {
                this.rowsetHostVar = this.getHostVariable();
            } else {
                if (token2.getToknum() != 10002) throw new ExpectedFoundException(token2, this.error, "SQL HOST VARIABLE or Int literal");
                this.rowsetVal = new Integer(token2.getWord());
            }
            this.forVar = this.rowsetHostVar;
            this.forVal = this.rowsetVal;
            token2 = this.getSqlToken();
            if (token2.getWord().equals("ROWS")) {
                token2 = this.getSqlToken();
            }
        }
        if (token2.getToknum() == 542) {
            this.bindVars = new Vector();
            this.bindInds = new Vector();
            this.into(this.bindVars, this.bindInds);
        } else if (token2.getToknum() == 802) {
            token2 = this.getSqlToken();
            if (!token2.getWord().equals("DESCRIPTOR")) throw new ExpectedFoundException(token2, this.error, " Variable-Name ");
            if (this.db2Esql && (token2 = this.getSqlToken()).getToknum() != 58) {
                throw new GeneralErrorException(196, 4, token2, token2.getWord(), this.error);
            }
            this.descriptorVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            this.ungetAllSqlToken();
        }
        if (this.forVar != null || this.forVal != 0) {
            this.c.changeBind = false;
        }
        if (this.bindVars == null || this.c == null || !this.c.changeBind) return;
        if (this.c.bindVars == null) {
            for (int i2 = 0; i2 < this.bindVars.size(); ++i2) {
                Object e2 = this.bindVars.elementAt(i2);
                if (!(e2 instanceof VariableName) || !((VariableName)e2).hasIndexes() && !((VariableName)e2).hasSubValue()) continue;
                this.c.changeBind = false;
            }
            if (!this.c.changeBind) return;
            this.c.bindVars = this.bindVars;
            this.c.bindInds = this.bindInds;
            return;
        } else if (!this.c.bindVars.toString().equals(this.bindVars.toString())) {
            this.c.changeBind = false;
            return;
        } else {
            if (!this.c.bindVars.toString().equals(this.bindVars.toString())) return;
            if (this.c.bindInds != null && !this.c.bindInds.toString().equals(this.bindInds.toString())) {
                this.c.changeBind = false;
                return;
            } else {
                if (this.c.bindInds != null || this.bindInds == null || this.bindInds.size() <= 0) return;
                this.c.changeBind = false;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int n2;
        if (this.bindVars != null) {
            for (n2 = 0; n2 < this.bindVars.size(); ++n2) {
                ((VariableName)this.bindVars.elementAt(n2)).check(this.pc);
            }
        }
        if (this.sqlj) {
            VariableName variableName;
            if (this.bindInds != null) {
                for (n2 = 0; n2 < this.bindInds.size(); ++n2) {
                    variableName = (VariableName)this.bindInds.elementAt(n2);
                    if (variableName == null) continue;
                    variableName.check();
                    variableName.getVarDecl().setEsqlIndicator();
                }
            }
            if (this.c.getPrepStat() != null || this.c.getPrepHndl() != null || !this.c.isSqljStat) {
                this.isSqljStat = false;
            } else {
                this.iterator = this.c.getIterName();
                String string = "#sql iterator " + this.iterator.substring(1) + "(";
                if (this.bindVars != null) {
                    for (n2 = 0; n2 < this.bindVars.size(); ++n2) {
                        variableName = (VariableName)this.bindVars.elementAt(n2);
                        if (n2 > 0) {
                            string = string + ", ";
                        }
                        string = variableName != null && variableName.isNumeric() ? string + "long" : string + "String";
                    }
                } else {
                    string = string + "String";
                }
                string = string + ");";
                if (!this.iterator.substring(1).equals("qljIter$")) {
                    this.pc.addIterator(string);
                }
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        SqlDeclareCursor sqlDeclareCursor = this.pc.getCursor(this.curName);
        if (this.sqlj && this.isSqljStat && this.descriptorVar == null) {
            if (this.bindVars != null) {
                this.bindSqljVars(stringBuffer, this.bindVars, this.bindInds);
            } else {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("try {" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   setSqljConnection();" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if (" + sqlDeclareCursor.getIterName() + " != null)" + eol);
                stringBuffer.append(this.parent.getIndent());
                if (this.db2Esql) {
                    stringBuffer.append("   rs = (DB2ResultSet)");
                } else {
                    stringBuffer.append("   rs = (ResultSet)");
                }
                stringBuffer.append(sqlDeclareCursor.getIterName());
                stringBuffer.append(".getResultSet();");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if (rs == null || rs.next() == false)");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("catch (SQLException e) {" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
            }
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat: FETCH " + this.curName + " SQLCODE=\" + " + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        } else if (this.descriptorVar == null) {
            if (this.rowset && (this.rowsetStartingHostVar != null || this.rowsetStartingVal != -1)) {
                stringBuffer.append(this.parent.getIndent() + this.getReturnCode() + ".set(Esql.ROWSET_STARTING(new Object[] {" + this.pc.sqlca.SQLCA + ", " + this.cursHndl.getCode());
                stringBuffer.append(", Factory.getNumLiteral( ");
                if (this.rowsetStartingHostVar != null) {
                    stringBuffer.append(this.rowsetStartingHostVar.getCode() + ".toint()");
                } else {
                    stringBuffer.append(this.rowsetStartingVal);
                }
                stringBuffer.append(", 4, 0, false), " + this.rowsetStartingType);
                stringBuffer.append("}));");
                stringBuffer.append(eol);
            }
            this.startForClause(stringBuffer);
            stringBuffer.append(this.parent.getIndent());
            if (!(this.bindVars == null || sqlDeclareCursor != null && (sqlDeclareCursor == null || sqlDeclareCursor.changeBind && sqlDeclareCursor.bindVars != null))) {
                this.bindCols(this.pc, stringBuffer, this.bindVars, this.bindInds);
                stringBuffer.append(this.getReturnCode());
                stringBuffer.append(".set(Esql.FETCH_INTO(");
            } else if (this.db2Esql) {
                stringBuffer.append(this.getReturnCode());
                stringBuffer.append(".set(Esql.FETCH_DB2(");
            } else {
                stringBuffer.append(this.getReturnCode());
                stringBuffer.append(".set(Esql.FETCH(");
            }
            stringBuffer.append("new Object[] {" + this.pc.sqlca.SQLCA + ", ");
            stringBuffer.append(this.cursHndl.getCode());
            stringBuffer.append(",Factory.getNumLiteral(");
            stringBuffer.append(this.fetchType);
            stringBuffer.append(", 4, 0, false)");
            if (this.pc.getOption("-xcsqc") != null) {
                stringBuffer.append(", " + this.getInstanceName());
            }
            stringBuffer.append("}));");
            stringBuffer.append(eol);
            if (this.rowset) {
                this.endForClause(stringBuffer, false);
            } else {
                this.endForClause(stringBuffer, true);
            }
        } else {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.getReturnCode());
            if (this.db2Esql) {
                stringBuffer.append(".set(Esql.FETCH_DESCRIPTOR_DB2(");
            } else {
                stringBuffer.append(".set(Esql.FETCH_DESCRIPTOR(");
            }
            stringBuffer.append("new Object[] {" + this.pc.sqlca.SQLCA + ", ");
            stringBuffer.append(this.cursHndl.getCode());
            stringBuffer.append(", ");
            stringBuffer.append(this.descriptorVar.getCode());
            stringBuffer.append(",Factory.getNumLiteral(");
            stringBuffer.append(this.fetchType);
            stringBuffer.append(", 4, 0, false)");
            if (this.optionCP && this.db2Esql) {
                stringBuffer.append(", ");
                stringBuffer.append("" + this.optionD64);
            }
            stringBuffer.append("}));");
            stringBuffer.append(eol);
        }
        this.addWhenever(stringBuffer);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public Vector getBindVars() {
        return this.bindVars;
    }

    public Vector getBindInds() {
        return this.bindInds;
    }

    public int getFetchType() {
        return this.fetchType;
    }

    public SqlDeclareCursor getCursor() {
        return this.pc.getCursor(this.curName);
    }
}

