/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlOpen
extends SqlStatement {
    private Vector parmVars;
    private Vector parmInds;
    private Vector bindVars;
    private Vector bindInds;
    private SqlDeclareCursor cursor;
    private VariableName descriptorVar = null;

    public SqlOpen(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors);
        Token token2 = this.getSqlToken();
        this.curName = token2.getWord();
        if (token2.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
            this.cursor = new SqlDeclareCursor(this.cursHndl, execSql, token, pcc, tokenManager, errors);
            this.curName = this.cursor.getName();
            this.cursor.cursHndl = this.cursHndl;
        } else {
            this.cursor = this.pc.getCursor(this.curName);
            if (this.cursor == null) {
                throw new GeneralErrorException(93, 4, token2, this.curName, this.error);
            }
            this.cursHndl = this.cursor.cursHndl;
        }
        this.cursor.check();
        this.isSqljStat = this.cursor.isSqljStat;
        this.cursor.pc = this.pc;
        token2 = this.getSqlToken();
        if (token2.getToknum() == 802) {
            token2 = this.getSqlToken();
            if (token2.getWord().equals("DESCRIPTOR")) {
                this.descriptorVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                this.ungetAllSqlToken();
                this.parmVars = new Vector();
                this.parmInds = new Vector();
                this.into(this.parmVars, this.parmInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        token2 = this.getSqlToken();
        if (token2.getToknum() == 542) {
            if (this.descriptorVar != null) {
                throw new GeneralErrorException(11, 4, token2, " DESCRIPTOR ", this.error);
            }
            this.bindVars = new Vector();
            this.bindInds = new Vector();
            this.into(this.bindVars, this.bindInds);
        } else {
            this.ungetAllSqlToken();
        }
        if (this.parmInds != null && this.optionXLVNULL) {
            this.fillParmInds(this.parmInds, this.parmVars);
        }
        if (this.bindVars != null && this.cursor != null && this.cursor.changeBind) {
            if (this.cursor.bindVars == null) {
                for (int i2 = 0; i2 < this.bindVars.size(); ++i2) {
                    Object e2 = this.bindVars.elementAt(i2);
                    if (!(e2 instanceof VariableName) || !((VariableName)e2).hasIndexes() && !((VariableName)e2).hasSubValue()) continue;
                    this.cursor.changeBind = false;
                }
                if (this.cursor.changeBind) {
                    this.cursor.bindVars = this.bindVars;
                    this.cursor.bindInds = this.bindInds;
                }
            } else if (this.cursor.bindVars != null && !this.cursor.bindVars.toString().equals(this.bindVars.toString())) {
                this.cursor.changeBind = false;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int n2;
        if (this.parmVars != null) {
            for (n2 = 0; n2 < this.parmVars.size(); ++n2) {
                Object e2 = this.parmVars.elementAt(n2);
                if (!(e2 instanceof VariableName)) continue;
                ((VariableName)e2).check(this.pc);
            }
        }
        if (this.parmInds != null) {
            for (n2 = 0; n2 < this.parmInds.size(); ++n2) {
                VariableName variableName = (VariableName)this.parmInds.elementAt(n2);
                if (variableName == null) continue;
                variableName.check();
                variableName.getVarDecl().setEsqlIndicator();
            }
        }
        if (this.bindVars != null) {
            this.isSqljStat = false;
            this.cursor.setSqljStatFalse();
        }
    }

    @Override
    public Vector getParmVars() {
        return this.parmVars;
    }

    @Override
    public Vector getParmInds() {
        return this.parmInds;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.descriptorVar == null) {
            stringBuffer.append(this.parent.getIndent());
            this.getCodeDebug(stringBuffer);
            stringBuffer.append(this.cursor.getCode(this.pc, this.parent));
            if (!this.isSqljStat && this.cursor.changeBind && this.bindVars == null && this.cursor.bindVars != null) {
                this.bindVars = this.cursor.bindVars;
                this.bindInds = this.cursor.bindInds;
            }
            if (this.parmVars != null) {
                this.setParams(this.pc, stringBuffer, this.parmVars, this.parmInds);
            }
            if (this.bindVars != null) {
                this.bindCols(this.pc, stringBuffer, this.bindVars, this.bindInds);
            }
            if (this.isSqljStat && this.bindVars == null && this.cursor.isSqljStat && !this.getIterName().equals(this.incompleteIterName)) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("try {" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   if (" + this.getIterName() + " != null)" + eol);
                stringBuffer.append(this.parent.getIndent() + "      ");
                if (this.db2Esql) {
                    stringBuffer.append(this.curName + " = (DB2ResultSet)");
                } else {
                    stringBuffer.append(this.curName + " = (ResultSet)");
                }
                stringBuffer.append(this.getIterName());
                stringBuffer.append(".getResultSet();");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("catch (SQLException e) {" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat: OPEN " + this.curName + " SQLCODE=\" + " + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
            } else {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(this.getReturnCode());
                if (this.cursor.isRowset()) {
                    stringBuffer.append(".set(Esql.OPEN_ROWSET(new Object[] {" + this.pc.sqlca.SQLCA + ", ");
                } else {
                    stringBuffer.append(".set(Esql.OPEN(new Object[] {" + this.pc.sqlca.SQLCA + ", ");
                }
                if (this.cursor.isRowset()) {
                    // empty if block
                }
                stringBuffer.append(this.cursHndl.getCode());
                stringBuffer.append("}));");
                stringBuffer.append(eol);
            }
        } else {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.getReturnCode());
            if (this.db2Esql) {
                stringBuffer.append(".set(Esql.OPEN_DESCRIPTOR_DB2(new Object[] {" + this.pc.sqlca.SQLCA + ", ");
            } else {
                stringBuffer.append(".set(Esql.OPEN_DESCRIPTOR(new Object[] {" + this.pc.sqlca.SQLCA + ", \"" + this.curName + "\", ");
            }
            stringBuffer.append(this.cursHndl.getCode());
            stringBuffer.append(", ");
            stringBuffer.append(this.descriptorVar.getCode());
            if (!this.db2Esql) {
                stringBuffer.append(", " + this.getInstanceName());
            }
            if (this.optionCP && this.db2Esql) {
                stringBuffer.append(", ");
                stringBuffer.append("" + this.optionD64);
            }
            stringBuffer.append("}));");
            stringBuffer.append(eol);
        }
        this.addWhenever(stringBuffer);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public SqlDeclareCursor getCursor() {
        return this.cursor;
    }

    public String getIterName() {
        return this.cursor.getIterName();
    }
}

