/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlPrepare
extends SqlStatement {
    private String name;
    private VariableName selVar;
    private VariableName prepHndl;
    private VariableName intoSqlda;
    private Token selToken;
    private Pcc pc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlPrepare(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors);
        this.isSqljStat = false;
        this.pc = pcc;
        Token token2 = this.getSqlToken();
        if (token2.getToknum() == 58) {
            this.prepHndl = VariableName.get(this.tm, this.error, this.pc);
            if (this.prepHndl.getVarDecl().getHandleType() == 0) {
                throw new GeneralErrorException(11, 4, this.prepHndl.getNameToken(), this.prepHndl.getName(), this.error);
            }
        } else {
            this.name = token2.getWord();
        }
        if (this.db2Esql) {
            token2 = this.getSqlToken();
            if (token2.getToknum() == 542) {
                token2 = this.getSqlToken();
                if (token2.getToknum() != 58) throw new ExpectedFoundException(token2, this.error, "hostVariable");
                this.intoSqlda = VariableName.get(this.tm, this.error, this.pc);
            } else {
                this.ungetAllSqlToken();
            }
        }
        if ((token2 = this.getSqlToken()).getToknum() != 498) {
            throw new ExpectedFoundException(token2, this.error, "'FROM'");
        }
        token2 = this.getSqlToken(true);
        if (token2.getToknum() == 10001) {
            this.selToken = token2;
            return;
        } else {
            if (token2.getToknum() != 58) throw new ExpectedFoundException(token2, this.error, "':'");
            this.selVar = VariableName.get(this.tm, this.error, this.pc);
            if (this.selVar != null) return;
            token2 = this.getSqlToken();
            throw new GeneralErrorException(196, 4, token2, token2.getWord(), this.error);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void check() throws GeneralErrorException {
        SqlDeclareCursor sqlDeclareCursor;
        if (this.name != null && (sqlDeclareCursor = this.pc.getCursor(this.name)) != null) {
            sqlDeclareCursor.isSqljStat = false;
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(this.getReturnCode());
        if (this.intoSqlda != null) {
            stringBuffer.append(".set(Esql.PREPARE_DB2_SQLDA(new Object[] {" + this.pc.sqlca.SQLCA + ",");
        } else {
            stringBuffer.append(".set(Esql.PREPARE(new Object[] {" + this.pc.sqlca.SQLCA + ",");
        }
        if (this.prepHndl != null) {
            stringBuffer.append(this.prepHndl.getCode());
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(this.name);
            stringBuffer.append("\"");
        }
        if (this.selVar != null) {
            stringBuffer.append(",true,");
        } else {
            stringBuffer.append(",false,");
        }
        if (this.selVar != null) {
            if (this.selVar.getVarDecl().isVarying() || this.selVar.getVarDecl().isLob() || this.selVar.getVarDecl().isVarChar()) {
                stringBuffer.append(this.selVar.getVarDecl().getChildren().getLast().getUnivoqueName());
                if (this.selVar.hasIndexes()) {
                    stringBuffer.append(this.selVar.getIndexes().getCode(this.selVar.getVarDecl().isObjectReference(), this.selVar.getVarDecl().getOccurs() > 0, this.selVar.isEdited() && this.selVar.isNumeric()));
                }
            } else {
                stringBuffer.append(this.selVar.getVarDecl().getUnivoqueName());
            }
        } else {
            stringBuffer.append(this.getCodeLiteral(this.selToken));
        }
        if (this.intoSqlda != null) {
            stringBuffer.append(", null, " + this.intoSqlda.getVarDecl().getUnivoqueName());
            if (this.optionCP) {
                stringBuffer.append(", ");
                stringBuffer.append("" + this.optionD64);
            }
            stringBuffer.append("}));");
        } else {
            stringBuffer.append(", null}));");
        }
        stringBuffer.append(eol);
        this.addWhenever(stringBuffer);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public VariableName getPrepHndl() {
        return this.prepHndl;
    }

    public VariableName getSelVar() {
        return this.selVar;
    }

    public Token getSelToken() {
        return this.selToken;
    }
}

