/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;

public class SqlSavepoint
extends SqlStatement {
    private boolean unique = false;
    private boolean retainCursors = false;
    private boolean retainLocks = false;
    private String name = "";
    private Pcc pc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlSavepoint(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors);
        Token token2 = this.getSqlToken();
        this.pc = pcc;
        this.name = token2.getWord();
        token2 = this.getSqlToken();
        if ("UNIQUE".equals(token2.getWord().toUpperCase())) {
            this.unique = true;
            token2 = this.getSqlToken();
        }
        while (token2.getToknum() == 613) {
            token2 = this.getSqlToken();
            if (token2.getToknum() != 701) throw new GeneralErrorException(31, 4, token2, "ROLLBACK/" + token2.getWord(), this.error);
            token2 = this.getSqlToken();
            if (!token2.getWord().toUpperCase().equals("RETAIN")) throw new GeneralErrorException(31, 4, token2, "RETAIN/" + token2.getWord(), this.error);
            token2 = this.getSqlToken();
            if (token2.getWord().toUpperCase().equals("CURSORS")) {
                this.retainCursors = true;
            } else {
                if (!token2.getWord().toUpperCase().equals("LOCKS")) throw new GeneralErrorException(31, 4, token2, "CURSORS or LOCKS/" + token2.getWord(), this.error);
                this.retainLocks = true;
            }
            token2 = this.getSqlToken();
        }
        this.ungetSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(this.getReturnCode());
        stringBuffer.append(".set(Esql.SAVEPOINT(new Object[] {" + this.pc.sqlca.SQLCA + ", \"" + this.name + "\", " + this.unique + ", " + this.retainCursors + ", " + this.retainLocks + "}));");
        stringBuffer.append(eol);
        this.addWhenever(stringBuffer);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

