/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.EsqParser;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.FindAllMethods;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlCall;
import com.iscobol.compiler.SqlDelete;
import com.iscobol.compiler.SqlFetch;
import com.iscobol.compiler.SqlInsert;
import com.iscobol.compiler.SqlOpen;
import com.iscobol.compiler.SqlSelect;
import com.iscobol.compiler.SqlSet;
import com.iscobol.compiler.SqlUpdate;
import com.iscobol.compiler.SqlValue;
import com.iscobol.compiler.SqlWhenever;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.Config;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SqlStatement
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_WITH_HOLD = 1;
    public static final int OP_WITH_NO_HOLD = 2;
    public final int MAX_LINES = Config.a(".compiler.max_hostvars", 700);
    public final boolean db2Esql;
    public final boolean db2Sqljbin;
    public final VariableName sqlca;
    public final VariableName sqlcode;
    public final VariableName sqlerrd;
    public String iterator = "SqljIter$";
    public String incompleteIterName = "SqljIter$";
    public String sqljSetLostWord = "";
    public static final Hashtable sqlTypes = new Hashtable(){
        {
            this.put("ARRAY", 2003);
            this.put("BIGINT", -5);
            this.put("BINARY", -2);
            this.put("BIT", -7);
            this.put("BLOB", 2004);
            this.put("BOOLEAN", 16);
            this.put("CHAR", 1);
            this.put("CLOB", 2005);
            this.put("DATALINK", 70);
            this.put("DATE", 91);
            this.put("DECIMAL", 3);
            this.put("DATE", 91);
            this.put("DISTINCT", 2001);
            this.put("DOUBLE", 8);
            this.put("FLOAT", 6);
            this.put("INTEGER", 4);
            this.put("INT", 4);
            this.put("JAVA_OBJECT", 2000);
            this.put("LONGVARCHAR", -1);
            this.put("LONGVARBINARY", -4);
            this.put("NCHAR", -15);
            this.put("NCLOB", 2011);
            this.put("NULL", 0);
            this.put("NUMERIC", 2);
            this.put("OTHER", 1111);
            this.put("REAL", 7);
            this.put("REF", 2006);
            this.put("ROWID", -8);
            this.put("SMALLINT", 5);
            this.put("SQLXML", 2009);
            this.put("STRUCT", 2002);
            this.put("TIME", 92);
            this.put("TIMESTAMP", 93);
            this.put("TINYINT", -6);
            this.put("VARBINARY", -3);
            this.put("VARCHAR", 12);
        }
    };
    public static final Hashtable sqlTypesCast = new Hashtable(){
        {
            this.put(2003, "ARRAY");
            this.put(-5, "BIGINT");
            this.put(-2, "BINARY");
            this.put(-7, "BIT");
            this.put(2004, "BLOB");
            this.put(16, "BOOLEAN");
            this.put(1, "CHAR");
            this.put(2005, "CLOB");
            this.put(70, "DATALINK");
            this.put(91, "DATE");
            this.put(3, "DECIMAL");
            this.put(2001, "DISTINCT");
            this.put(8, "DOUBLE");
            this.put(6, "FLOAT");
            this.put(4, "INTEGER");
            this.put(2000, "JAVA_OBJECT");
            this.put(-1, "LONGVARCHAR");
            this.put(-4, "LONGVARBINARY");
            this.put(-15, "NCHAR");
            this.put(2011, "NCLOB");
            this.put(0, "NULL");
            this.put(2, "NUMERIC");
            this.put(1111, "OTHER");
            this.put(7, "REAL");
            this.put(2006, "REF");
            this.put(-8, "ROWID");
            this.put(5, "SMALLINT");
            this.put(2009, "SQLXML");
            this.put(2002, "STRUCT");
            this.put(92, "TIME");
            this.put(93, "TIMESTAMP");
            this.put(-6, "TINYINT");
            this.put(-3, "VARBINARY");
            this.put(12, "VARCHAR");
            this.put(2013, "MONTHS");
            this.put(2014, "HOURS");
        }
    };
    public static final Hashtable db2Functions = new Hashtable(){
        {
            this.put("ADD_DAYS", new int[]{91});
            this.put("ADD_HOURS", new int[]{93});
            this.put("ADD_MINUTES", new int[]{93});
            this.put("ADD_MONTHS", new int[]{91});
            this.put("ADD_SECONDS", new int[]{93});
            this.put("ADD_YEARS", new int[]{91});
            this.put("AGE", new int[]{93});
            this.put("DATE_PART", new int[]{91});
            this.put("DATE_TRUNC", new int[]{93});
            this.put("DAYNAME", new int[]{93});
            this.put("DAYOFMONTH", new int[]{91});
            this.put("DAYOFWEEK", new int[]{91});
            this.put("DAYOFWEEK_ISO", new int[]{91});
            this.put("DAYOFYEAR", new int[]{91});
            this.put("DAYS", new int[]{91});
            this.put("DAYS_BETWEEN", new int[]{91});
            this.put("DAYS_TO_END_OF_MONTH", new int[]{91});
            this.put("DATE", new int[]{91});
            this.put("DECIMAL", new int[]{3});
            this.put("EXTRACT", new int[]{91});
            this.put("FIRST_DAY", new int[]{91});
            this.put("FROM_UTC_TIMESTAMP", new int[]{93});
            this.put("HOUR", new int[]{92});
            this.put("HOURS_BETWEEN", new int[]{92});
            this.put("INT", new int[]{4});
            this.put("INTEGER", new int[]{4});
            this.put("JULIAN_DATE", new int[]{91});
            this.put("MICROSECOND", new int[]{92});
            this.put("MIDNIGHT_SECONDS", new int[]{92});
            this.put("MINUTE", new int[]{92});
            this.put("MINUTES_BETWEEN", new int[]{92});
            this.put("MONTH", new int[]{91});
            this.put("MONTHNAME", new int[]{91});
            this.put("MONTHS_BETWEEN", new int[]{91});
            this.put("NEXT_DAY", new int[]{91});
            this.put("NEXT_MONTH", new int[]{91});
            this.put("NEXT_QUARTER", new int[]{91});
            this.put("NEXT_WEEK", new int[]{91});
            this.put("NEXT_YEAR", new int[]{91});
            this.put("QUARTER", new int[]{91});
            this.put("ROUND", new int[]{91});
            this.put("ROUND_TIMESTAMP", new int[]{93});
            this.put("SECOND", new int[]{92});
            this.put("SECONDS_BETWEEN", new int[]{92});
            this.put("THIS_MONTH", new int[]{91});
            this.put("THIS_QUARTER", new int[]{91});
            this.put("THIS_WEEK", new int[]{91});
            this.put("THIS_YEAR", new int[]{91});
            this.put("TIME", new int[]{92});
            this.put("TIMESTAMP", new int[]{93});
            this.put("TIMESTAMP_FORMAT", new int[]{93});
            this.put("TIMESTAMP_ISO", new int[]{93});
            this.put("TIMESTAMPDIFF", new int[]{93});
            this.put("TIMEZONE", new int[]{91});
            this.put("TO_CHAR", new int[]{93});
            this.put("VARCHAR_FORMAT", new int[]{93});
            this.put("WEEK", new int[]{91});
            this.put("WEEK_ISO", new int[]{91});
            this.put("WEEKS_BETWEEN", new int[]{91});
            this.put("YEAR", new int[]{91});
            this.put("YEARS_BETWEEN", new int[]{91});
            this.put("YMD_BETWEEN", new int[]{91});
        }
    };
    public static final Hashtable db2Registers = new Hashtable(){
        {
            this.put("ACCELERATOR", new String[]{"ACCELERATOR"});
            this.put("APPLICATION", new String[]{"APPLICATION", "COMPATIBILITY"});
            this.put("APPLICATION+ENCODING", new String[]{"APPLICATION", "ENCODING", "SCHEME"});
            this.put("CLIENT_ACCTNG", new String[]{"CLIENT_ACCTNG"});
            this.put("CLIENT_APPLNAME", new String[]{"CLIENT_APPLNAME"});
            this.put("CLIENT_CORR_TOKEN", new String[]{"CLIENT_CORR_TOKEN"});
            this.put("CLIENT_USERID", new String[]{"CLIENT_USERID"});
            this.put("CLIENT_WRKSTNAME", new String[]{"CLIENT_WRKSTNAME"});
            this.put("DATE", new String[]{"DATE"});
            this.put("DATE+BETWEEN", new String[]{"DATE", "BETWEEN", "##username", "AND", "##username"});
            this.put("DEBUG", new String[]{"DEBUG", "MODE"});
            this.put("DECFLOAT", new String[]{"DECFLOAT", "ROUNDING", "MODE"});
            this.put("EXPLAIN", new String[]{"EXPLAIN", "MODE"});
            this.put("GET_ACCEL_ARCHIVE", new String[]{"GET_ACCEL_ARCHIVE"});
            this.put("LC_TYPE", new String[]{"LC_TYPE"});
            this.put("LOCALE", new String[]{"LOCALE", "LC_TYPE"});
            this.put("MAINTEINED", new String[]{"MANTEINED", "TABLE", "@TYPES", "@FOR", "@OPTIMIZATION"});
            this.put("MEMBER", new String[]{"MEMBER"});
            this.put("OPTIMIZATION", new String[]{"OPTIMIZATION", "HINT"});
            this.put("PACKAGE", new String[]{"PACKAGE", "PATH"});
            this.put("PACKAGESET", new String[]{"PACKAGESET"});
            this.put("PATH", new String[]{"PATH"});
            this.put("PRECISION", new String[]{"PRECISION"});
            this.put("QUERY", new String[]{"QUERY", "ACCELERATION", "WAITFORDATA"});
            this.put("REFRESH", new String[]{"REFRESH", "AGE"});
            this.put("ROUTINE", new String[]{"ROUTINE", "VERSION"});
            this.put("RULES", new String[]{"RULES"});
            this.put("SCHEMA", new String[]{"SCHEMA"});
            this.put("SERVER", new String[]{"SERVER"});
            this.put("SQLID", new String[]{"SQLID"});
            this.put("TEMPORAL_BUSINESS_TIME", new String[]{"TEMPORAL_BUSINESS_TIME"});
            this.put("TEMPORAL_SYSTEM_TIME", new String[]{"TEMPORAL_SYSTEM_TIME"});
            this.put("TIME", new String[]{"TIME"});
            this.put("TIME+ZONE", new String[]{"TIME", "ZONE"});
            this.put("TIMESTAMP", new String[]{"TIMESTAMP", "@(", "@##num", "@)", "@WITH/WITHOUT", "@TIME", "@ZONE"});
            this.put("ENCRYPTION", new String[]{"ENCRYPTION", "PASSWORD"});
            this.put("SESSION", new String[]{"SESSION", "TIMEZONE"});
            this.put("SESSION_USER", new String[]{"SESSION_USER"});
            this.put("USER", new String[]{"USER"});
        }
    };
    private VariableName firstFuncParDB2;
    protected final ExecSql exec;
    private SqlWhenever whenError;
    private SqlWhenever whenWarn;
    private SqlWhenever whenNotFound;
    private StringBuffer query = new StringBuffer();
    private String lastWord;
    protected VariableName cursHndl;
    private static final Token bindInd = new Token(10002, "0", 0, 0, "");
    protected VariableName bindType;
    protected VariableName forVar;
    protected int forVal = 0;
    protected String curName;
    protected String curFunc = null;
    protected String operFunc = null;
    protected String saveFunc = null;
    protected Token oldFunc = null;
    protected Token parOpen = null;
    protected Token parClose = null;
    protected Token prevTok = null;
    protected Token prevRealTok = null;
    protected int numPar = 0;
    protected final boolean sqlj;
    protected final boolean checkVars;
    protected final boolean optionXNOCGHV;
    protected final boolean optionXLVNULL;
    protected final boolean optionD64;
    protected final boolean optionCP;
    public boolean isSqljStat;
    public static final String SQLJ_HV_PREF = "sqlj$h$";
    public static final String SQLJ_HP_PREF = "sqlj$p$";
    public static Vector sqlDescribeOracle = new Vector();
    public EsqParser sqlExtraInfo;

    public SqlStatement(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(execSql, token, block, pcc, tokenManager, null, 0, errors, true);
    }

    public SqlStatement(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, VariableName variableName, int n2, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(execSql, token, block, pcc, tokenManager, variableName, n2, errors, true);
    }

    public SqlStatement(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, boolean bl) throws GeneralErrorException, EndOfProgramException {
        this(execSql, token, block, pcc, tokenManager, null, 0, errors, bl);
    }

    public SqlStatement(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, VariableName variableName, int n2, Errors errors, boolean bl) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        pcc.setHasExecSql();
        this.db2Esql = tokenManager.getOptionList().getOption("-csdb2") != null || Config.b(".compiler.esql.db2", false);
        this.db2Sqljbin = tokenManager.getOptionList().getOption("-xsqljdb2") != null;
        TokenList tokenList = this.tm.delExtraInfo("SQL");
        if (tokenList != null) {
            this.sqlExtraInfo = new EsqParser(tokenList, this.error);
        }
        this.checkVars = bl;
        this.optionXNOCGHV = this.tm.getOptionList().getOption("-xnocghv") != null || this.tm.getOptionList().getOption("-cghv") == null;
        this.optionCP = this.tm.getOptionList().getOption("-cp") != null || this.tm.getOptionList().getOption("-xms") != null;
        this.optionD64 = this.optionCP && this.tm.getOptionList().getOption("-d64") != null;
        this.forVar = variableName;
        this.forVal = n2;
        this.isSqljStat = this.sqlj = this.pc.getOption("-sqlj") != null;
        this.optionXLVNULL = this.pc.getOption("-xlvnull") != null;
        this.exec = execSql;
        this.whenError = execSql.getWhenError();
        this.whenWarn = execSql.getWhenWarn();
        this.whenNotFound = execSql.getWhenNotFound();
        this.query.append(token.getWord());
        if ((this.pc.warning != null && this.pc.warning.hasGoto() || this.pc.werror != null && this.pc.werror.hasGoto() || this.pc.notFound != null && this.pc.notFound.hasGoto()) && this.parent != null) {
            this.parent.parent.setHasGoto(true);
        }
        if (bl) {
            VariableDeclaration variableDeclaration;
            this.sqlca = new VariableName(new Token(10009, "SQLCA", token.getFLN(), token.getOffset(), token.getFileName()));
            if (this.isSqljStat && (variableDeclaration = this.pc.getAny(this.sqlca, true, true)) != null) {
                variableDeclaration.setUsedAll();
            }
            if (!token.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlca.check(this.pc);
            }
            this.sqlcode = new VariableName(new Token(10009, "SQLCODE", token.getFLN(), token.getOffset(), token.getFileName()));
            if (!token.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlcode.check(this.pc);
            }
            this.sqlerrd = new VariableName(new Token(10009, "SQLERRD", token.getFLN(), token.getOffset(), token.getFileName()));
            if (!token.getWord().equalsIgnoreCase("DECLARE")) {
                this.sqlerrd.check(this.pc, false, true, GetVarOpts.NO_OPTS);
            }
        } else {
            this.sqlca = null;
            this.sqlcode = null;
            this.sqlerrd = null;
        }
    }

    void createCursHndl(Pcc pcc) {
        if (this.cursHndl == null && this.curName != null && !(pcc instanceof FindAllMethods)) {
            try {
                String string = "ESQL-HNDL-" + this.curName;
                Token token = new Token(10009, string, 0, 0, this.tm.getFileName());
                VariableDeclaration variableDeclaration = VariableDeclaration.getHandle(pcc, this.tm, token);
                pcc.fixedVars.addItem(variableDeclaration);
                pcc.loadVariable(variableDeclaration);
                variableDeclaration.setUsed();
                this.cursHndl = new VariableName(new Token(10009, string, this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
                this.cursHndl.check(pcc);
            }
            catch (GeneralErrorException generalErrorException) {
                throw new RuntimeException(generalErrorException.getMessage());
            }
        }
    }

    void createVars(Pcc pcc) {
        try {
            if (this.cursHndl == null && this.curName == null) {
                this.cursHndl = new VariableName(new Token(10009, "ESQL-CURS-HNDL", this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
                this.cursHndl.check(pcc);
            }
            this.bindType = new VariableName(new Token(10009, "ESQL-BIND-TYPE", this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
            this.bindType.check(pcc);
        }
        catch (GeneralErrorException generalErrorException) {
            throw new RuntimeException(generalErrorException.getMessage());
        }
    }

    void addWhenever(StringBuffer stringBuffer) {
        if (this.whenWarn != null) {
            stringBuffer.append(this.whenWarn.getCode());
        }
        if (this.whenNotFound != null) {
            stringBuffer.append(this.whenNotFound.getCode());
        }
        if (this.whenError != null) {
            stringBuffer.append(this.whenError.getCode());
        }
    }

    Token getSqlToken() throws EndOfProgramException, GeneralErrorException {
        return this.getSqlToken(false, '_');
    }

    Token getSqlToken(boolean bl) throws EndOfProgramException, GeneralErrorException {
        return this.getSqlToken(bl, '_');
    }

    Token getSqlToken(boolean bl, char c2) throws EndOfProgramException, GeneralErrorException {
        Token token;
        Token token2 = token = this.tm.getAllToken();
        Token token3 = token;
        try {
            if (this.db2Esql && token2.getToknum() == 40 && this.prevTok != null && (db2Functions.containsKey(this.prevTok.getWord()) || Config.a(".compiler.esql.db2.fun." + this.prevTok.getWord(), null) != null)) {
                this.curFunc = this.prevTok.getWord();
                this.oldFunc = this.prevTok;
                this.operFunc = this.prevTok.getWord();
                this.parOpen = token2;
                this.numPar = 1;
                this.firstFuncParDB2 = null;
            } else if (this.db2Esql && token2.getToknum() == 40 && this.curFunc != null) {
                ++this.numPar;
            } else if (this.db2Esql && token2.getToknum() == 41 && this.curFunc != null) {
                --this.numPar;
                if (this.numPar == 0) {
                    this.curFunc = null;
                    this.parClose = token2;
                }
            }
            if (token.getToknum() == 10009) {
                token3 = this.tm.getAllToken();
                if (token3.getToknum() == 36) {
                    token2 = this.tm.getAllToken();
                    if (token2.getFLN() == token.getFLN() && token3.getOffset() == token.getOffset() + token.getWord().length() && token2.getOffset() == token3.getOffset() + 1) {
                        token2.setWord(token.getWord() + "$" + token2.getWord());
                        token2.setOffset(token.getOffset());
                        this.ungetAllSqlToken();
                        this.prevTok = token;
                        return this.getSqlToken(bl);
                    }
                    this.ungetAllSqlToken();
                    this.ungetAllSqlToken();
                } else {
                    this.ungetAllSqlToken();
                }
                token.setWord(token.getWord().replace('-', c2));
            } else if (token.getToknum() == 10001 && token.getWord().charAt(0) != '\\') {
                char c3 = token.getWord().charAt(0);
                String string = token.getWord().substring(1, token.getWord().length() - 1);
                int n2 = string.indexOf(92, 0);
                while (n2 >= 0) {
                    string = string.substring(0, n2) + '\\' + string.substring(n2, string.length());
                    n2 = string.indexOf(92, n2 + 2);
                }
                n2 = string.indexOf(34, 0);
                while (n2 >= 0) {
                    string = string.substring(0, n2) + '\\' + string.substring(n2, string.length());
                    n2 = string.indexOf(34, n2 + 2);
                }
                if (this.tm.getOptionList().getOption("-csqq") != null) {
                    if (c3 == '\"') {
                        if (!bl) {
                            token.setWord("\\\"" + string + "\\\"");
                        }
                    } else {
                        token.setWord("'" + string + "'");
                    }
                } else if (token != this.prevTok && this.tm.getOptionList().getOption("-csqq2") != null) {
                    if (c3 == '\"') {
                        token.setWord("'" + string + "'");
                    } else {
                        token.setWord("\\\"" + string + "\\\"");
                    }
                } else {
                    if (c3 == '\"') {
                        n2 = string.indexOf(39, 0);
                        while (n2 >= 0) {
                            string = string.substring(0, n2) + '\'' + string.substring(n2, string.length());
                            n2 = string.indexOf(39, n2 + 2);
                        }
                        string = string.replaceAll("\\\\\"\\\\\"", "\\\\\"");
                    }
                    token.setWord("'" + string + "'");
                }
            } else if (token.getToknum() == 58) {
                if (this.tm.getAllToken().getToknum() == 61) {
                    token.setToknum(10128);
                    token.setWord(":=");
                    this.tm.removeLastToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (token.getToknum() == 124) {
                if (this.tm.getAllToken().getToknum() == 124) {
                    token.setToknum(10129);
                    token.setWord("||");
                    this.tm.removeLastToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (token.getToknum() == 47) {
                if (this.tm.getAllToken().getToknum() == 42) {
                    token.setWord("/*");
                    this.tm.removeLastToken();
                    this.addToken(token);
                    while (true) {
                        if ((token = this.tm.getAllToken()).getToknum() == 42) {
                            if (this.tm.getAllToken().getToknum() == 47) {
                                token.setWord("*/");
                                this.tm.removeLastToken();
                                this.addToken(token);
                                this.prevTok = token;
                                return this.getSqlToken(bl);
                            }
                            this.ungetAllSqlToken();
                            this.addToken(token);
                            continue;
                        }
                        if (token.getToknum() == 10021) continue;
                        if (token.getToknum() == 10001 && token.getWord().charAt(0) != '\\') {
                            char c4 = token.getWord().charAt(0);
                            String string = token.getWord().substring(1, token.getWord().length() - 1);
                            int n3 = string.indexOf(92, 0);
                            while (n3 >= 0) {
                                string = string.substring(0, n3) + '\\' + string.substring(n3, string.length());
                                n3 = string.indexOf(92, n3 + 2);
                            }
                            n3 = string.indexOf(34, 0);
                            while (n3 >= 0) {
                                string = string.substring(0, n3) + '\\' + string.substring(n3, string.length());
                                n3 = string.indexOf(34, n3 + 2);
                            }
                            if (this.tm.getOptionList().getOption("-csqq") != null) {
                                if (c4 == '\"') {
                                    if (!bl) {
                                        token.setWord("\\\"" + string + "\\\"");
                                    }
                                } else {
                                    token.setWord("'" + string + "'");
                                }
                            } else if (token != this.prevTok && this.tm.getOptionList().getOption("-csqq2") != null) {
                                if (c4 == '\"') {
                                    token.setWord("'" + string + "'");
                                } else {
                                    token.setWord("\\\"" + string + "\\\"");
                                }
                            } else {
                                if (c4 == '\"') {
                                    n3 = string.indexOf(39, 0);
                                    while (n3 >= 0) {
                                        string = string.substring(0, n3) + '\'' + string.substring(n3, string.length());
                                        n3 = string.indexOf(39, n3 + 2);
                                    }
                                    string = string.replaceAll("\\\\\"\\\\\"", "\\\\\"");
                                }
                                token.setWord("'" + string + "'");
                            }
                        } else {
                            token.setWord(token.getWord().replace('-', c2));
                        }
                        this.addToken(token);
                    }
                }
                this.ungetAllSqlToken();
            } else if (token.getToknum() == 45) {
                if (this.tm.getAllToken().getToknum() == 45) {
                    token.setWord("/*");
                    this.tm.removeLastToken();
                    this.addToken(token);
                    while (true) {
                        if ((token = this.tm.getAllToken()).getToknum() == 10021) {
                            token.setWord("*/");
                            this.tm.removeLastToken();
                            this.addToken(token);
                            this.prevTok = token;
                            return this.getSqlToken(bl);
                        }
                        this.addToken(token);
                    }
                }
                this.ungetAllSqlToken();
            } else if (token.getToknum() == 35) {
                token2 = this.tm.getAllToken();
                if (token2.getFLN() == token.getFLN() && token2.getOffset() == token.getOffset() + 1) {
                    token2.setWord("#" + token2.getWord());
                    this.ungetAllSqlToken();
                    this.prevTok = token;
                    return this.getSqlToken(bl);
                }
                this.ungetAllSqlToken();
            } else if (token.getToknum() == 10021) {
                this.prevTok = token;
                return this.getSqlToken(bl);
            }
            if (this.prevTok != null && this.prevTok.getToknum() == 41 && token2.getToknum() != 45 && token2.getToknum() != 43 && token2.getToknum() != 42 && token2.getToknum() != 47 && this.numPar == 0) {
                this.operFunc = null;
            } else if (token2.getWord().equalsIgnoreCase("AND") || token2.getWord().equalsIgnoreCase("BETWEEN") || token2.getWord().equalsIgnoreCase("OR")) {
                this.saveFunc = this.operFunc;
                this.operFunc = null;
            }
            this.prevTok = token;
            return token;
        }
        catch (EndOfProgramException endOfProgramException) {
            throw new GeneralErrorException(197, 4, token2, token2.getWord(), this.error);
        }
    }

    void ungetAllSqlToken() throws EndOfProgramException {
        if (this.prevTok != null && (this.prevTok.getWord().equalsIgnoreCase("AND") || this.prevTok.getWord().equalsIgnoreCase("BETWEEN") || this.prevTok.getWord().equalsIgnoreCase("OR"))) {
            this.operFunc = this.saveFunc;
        }
        this.tm.ungetAllToken();
    }

    void ungetSqlToken() throws EndOfProgramException {
        if (this.prevTok != null && (this.prevTok.getWord().equalsIgnoreCase("AND") || this.prevTok.getWord().equalsIgnoreCase("BETWEEN") || this.prevTok.getWord().equalsIgnoreCase("OR"))) {
            this.operFunc = this.saveFunc;
        }
        this.tm.ungetToken();
    }

    void toLower() {
        this.query = new StringBuffer(this.query.toString().toLowerCase());
    }

    void resetQuery() {
        this.query = new StringBuffer();
    }

    void setQuery(String string) {
        this.query = new StringBuffer(string);
    }

    void addToken(Token token) {
        this.addToken(token, true);
    }

    void addToken(Token token, boolean bl) {
        switch (token.getToknum()) {
            case 42: 
            case 10001: 
            case 10002: 
            case 10017: {
                this.query.append(" ");
                break;
            }
            default: {
                int n2;
                if (!token.isWord()) break;
                if (bl && (n2 = this.query.length()) > 0) {
                    switch (this.query.charAt(n2 - 1)) {
                        case '(': 
                        case '[': 
                        case '{': {
                            break;
                        }
                        default: {
                            this.query.append(" ");
                        }
                    }
                }
                this.lastWord = token.getWord();
            }
        }
        this.query.append(token.getWord());
    }

    public Token buildSQLJToken(VariableName variableName, boolean bl) {
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        String string = SQLJ_HV_PREF;
        String string2 = variableName.getCode().replace(".at (new int[] {", "$").replace(".num().intValue()", "$").replace(",", "").replace("{", "").replace("}", "").replace(")", "").replace("(", "").replace(" ", "").replace(".", "").replace("]", "").replace("[", "");
        if (bl) {
            string = SQLJ_HP_PREF;
            variableName.setSqljParam(string + string2);
            variableDeclaration.setSqljParam(string + string2);
        } else {
            variableName.setSqlj(string + string2);
            variableDeclaration.setSqlj(string + string2);
        }
        return new Token(58, " :" + string + string2, 0, 0, null);
    }

    public VariableDeclarationList splitChildren(VariableName variableName) {
        VariableDeclarationList variableDeclarationList = variableName.getVarDecl().getChildren();
        if (this.optionXNOCGHV || variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableDeclarationList.getItemNum() < 1 || variableDeclarationList.getFirst().level == 88 || variableDeclarationList.getFirst().level == 78) {
            return null;
        }
        return variableDeclarationList;
    }

    void addSqljHostVar(VariableName variableName, VariableName variableName2, boolean bl, Vector vector, Vector vector2) {
        VariableDeclarationList variableDeclarationList = this.splitChildren(variableName);
        if (variableDeclarationList == null) {
            this.buildSQLJToken(variableName, bl);
            this.addTokenQuestionMark(variableName, bl);
            if (variableName2 != null) {
                this.addToken(this.buildSQLJToken(variableName2, bl));
            }
            vector.add(variableName);
            vector2.add(variableName2);
        } else {
            boolean bl2 = false;
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.redefines == null) {
                    if (bl2) {
                        this.addToken(new Token(44, ",", 0, 0, null));
                    } else {
                        bl2 = true;
                    }
                    VariableName variableName3 = new VariableName(variableDeclaration);
                    this.buildSQLJToken(variableName3, bl);
                    this.addTokenQuestionMark(variableName3, bl);
                    if (variableName2 != null) {
                        this.addToken(this.buildSQLJToken(variableName2, bl));
                    }
                    vector.add(variableName3);
                    vector2.add(variableName2);
                    variableDeclaration.setUsed();
                }
                variableDeclaration = variableDeclarationList.getNext();
            }
        }
    }

    void addToQuery(String string) {
        this.query.append(string);
    }

    void setAsCall() {
        this.query.insert(0, '{');
        this.query.append('}');
    }

    void setAsCall(Vector vector, Vector vector2) {
        vector.insertElementAt(vector.remove(vector.size() - 1), 0);
        vector2.insertElementAt(vector2.remove(vector.size() - 1), 0);
        String string = this.query.toString();
        int n2 = string.lastIndexOf(63);
        if (n2 > 0) {
            this.query = new StringBuffer("?= " + string.substring(0, n2));
        }
        this.setAsCall();
    }

    VariableName getHostVariable() throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(false);
    }

    VariableName getHostVariable(boolean bl) throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(bl, false);
    }

    VariableName getHostVariable(boolean bl, boolean bl2) throws GeneralErrorException, EndOfProgramException {
        return this.getHostVariable(bl, bl2, false);
    }

    VariableName getHostVariable(boolean bl, boolean bl2, boolean bl3) throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        String string;
        VariableName variableName2;
        block31: {
            Token token;
            block30: {
                block29: {
                    variableName2 = null;
                    string = this.operFunc;
                    token = this.getSqlToken(false, Pcc.hyphenRepl);
                    if (token.getToknum() != 10009) break block30;
                    do {
                        token.setWord(token.getWord().replace(Pcc.hyphenRepl, '-'));
                        Token token2 = this.tm.getAllToken();
                        if (token2.getToknum() == 44) {
                            token2.setToknum(0);
                        } else if (token2.getToknum() == 526) {
                            token2.setToknum(10009);
                        }
                        this.ungetAllSqlToken();
                        this.ungetSqlToken();
                        variableName = !bl3 ? VariableName.get(this.tm, this.error, null, this.pc, false, false, false, true) : VariableName.get(this.tm, this.error, null, this.pc, false, false, false, true, GetVarOpts.NO_OPTS, true);
                        if (token2.getToknum() == 0) {
                            token2.setToknum(44);
                        }
                        if (variableName == null) {
                            throw new GeneralErrorException(196, 4, token, token.getWord(), this.error);
                        }
                        if (variableName2 == null) {
                            variableName2 = variableName;
                        } else {
                            variableName.setOf(variableName2);
                            variableName2 = variableName;
                        }
                        token = this.getSqlToken();
                        if (token.getToknum() != 10006) break block29;
                    } while ((token = this.getSqlToken()).getToknum() == 10009);
                    this.ungetSqlToken();
                    this.ungetSqlToken();
                    break block31;
                }
                if (sqlTypesCast.contains(token.getWord().toUpperCase())) {
                    variableName.sqlTypeCast = true;
                    this.ungetSqlToken();
                } else {
                    this.ungetSqlToken();
                }
                break block31;
            }
            throw new GeneralErrorException(196, 4, token, token.getWord(), this.error);
        }
        boolean bl4 = true;
        if (this.forVal != 0 || this.forVar != null || bl2 || this instanceof SqlCall) {
            bl4 = false;
        }
        VariableDeclaration variableDeclaration = null;
        if (!(variableName2 == null || this.pc == null || bl && (variableDeclaration = this.pc.getAny(variableName2, bl4, true)) == null)) {
            variableName2.check(this.pc, bl4, true, GetVarOpts.NO_OPTS);
        } else if (bl && this.pc != null && variableName2 != null) {
            variableDeclaration = VariableDeclaration.getIndicator(this.pc, variableName2, this.tm, this.error);
            this.error.print(265, 2, variableDeclaration.name, variableDeclaration.getName());
            variableName2.setVarDecl(variableDeclaration);
            this.pc.fixedVars.addItem(variableDeclaration);
            this.pc.loadVariable(variableDeclaration);
            variableDeclaration.setUsed();
        }
        if (bl2 && variableDeclaration == null && variableName2 != null) {
            variableDeclaration = this.pc.getAny(variableName2, false, true);
        }
        if (bl2 && variableName2 != null && !variableName2.hasIndexes() && variableDeclaration != null && (this.forVal == 0 || this.forVal > variableDeclaration.getOccursAll()) && this.forVar == null) {
            this.forVal = variableDeclaration.getOccursAll();
        }
        if (this.db2Esql) {
            if (!db2Functions.containsKey(this.getSqlToken().getWord().toUpperCase())) {
                if (this.curFunc != null) {
                    variableName2.sqlTypeFunc = Config.a(".compiler.esql.db2.fun." + this.curFunc, null) != null ? Config.a(".compiler.esql.db2.fun." + this.curFunc, -1) : ((int[])db2Functions.get(this.curFunc))[0];
                } else if (string != null && this.numPar == 0) {
                    variableName2.sqlTypeFunc = Config.a(".compiler.esql.db2.fun." + string, null) != null ? Config.a(".compiler.esql.db2.fun." + string, -1) : ((int[])db2Functions.get(string))[0];
                } else if (this.parOpen != null && this.parClose != null && (variableName.name.getFLN() > this.parOpen.getFLN() || this.parOpen.getFLN() == variableName.name.getFLN() && this.parOpen.getOffset() < variableName.name.getOffset()) && (variableName.name.getFLN() < this.parClose.getFLN() || this.parClose.getFLN() == variableName.name.getFLN() && this.parClose.getOffset() > variableName.name.getOffset())) {
                    variableName2.sqlTypeFunc = Config.a(".compiler.esql.db2.fun." + this.oldFunc, null) != null ? Config.a(".compiler.esql.db2.fun." + this.oldFunc, -1) : ((int[])db2Functions.get(this.oldFunc.getWord()))[0];
                }
            }
            if (variableName2.sqlTypeFunc == 91) {
                if (variableName2.getVarDecl().phisicLen > 10) {
                    variableName2.sqlTypeFunc = 93;
                }
            } else if (variableName2.sqlTypeFunc == 92 && variableName2.getVarDecl().phisicLen > 8) {
                variableName2.sqlTypeFunc = 93;
            }
            if (this.oldFunc != null && this.oldFunc.getWord().equals("TIMESTAMP") && this.firstFuncParDB2 != null && this.prevTok.getWord().equals(")") && this.firstFuncParDB2 != variableName2 && !variableName2.isNumeric()) {
                this.firstFuncParDB2.sqlTypeFunc = 91;
                variableName2.sqlTypeFunc = 92;
            }
            if (this.numPar == 1 && this.curFunc.equals("TIMESTAMP") && this.firstFuncParDB2 == null) {
                this.firstFuncParDB2 = variableName2;
            }
            this.ungetSqlToken();
        }
        this.operFunc = string;
        return variableName2;
    }

    void where(Vector vector, Vector vector2) throws GeneralErrorException, EndOfProgramException {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        this.operFunc = null;
        this.saveFunc = null;
        Token token = this.getSqlToken();
        while (token.getToknum() != 432 && token.getToknum() != 694 && token.getToknum() != 693 && !bl && token.getToknum() != 542) {
            switch (token.getToknum()) {
                case 59: {
                    this.addToken(token);
                    return;
                }
                case 494: {
                    if (this.getSqlToken().getToknum() == 793) {
                        this.ungetAllSqlToken();
                        this.ungetAllSqlToken();
                        return;
                    }
                    this.ungetAllSqlToken();
                    this.addToken(token);
                    break;
                }
                case 526: {
                    this.addToken(token);
                    bl2 = false;
                    break;
                }
                case 40: {
                    this.addToken(token);
                    ++n2;
                    break;
                }
                case 41: {
                    bl2 = true;
                    if (n2 == 0) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    this.addToken(token);
                    --n2;
                    break;
                }
                case 58: {
                    this.value(vector, vector2, false, bl2);
                    break;
                }
                case 10006: {
                    this.addToken(token);
                    this.addToken(this.getSqlToken(), false);
                    break;
                }
                case 10017: {
                    if (this.isSqljStat) {
                        this.query.append(" " + this.getSqlDecimal(token.getWord()));
                        break;
                    }
                    vector.add(token);
                    this.query.append(" ?");
                    vector2.add(null);
                    break;
                }
                default: {
                    if (n2 == 0) {
                        this.saveFunc = null;
                    }
                    this.addToken(token);
                }
            }
            token = this.getSqlToken();
            if (n2 != 0 || !token.getWord().equals("UNION")) continue;
            bl = true;
        }
        this.ungetAllSqlToken();
    }

    void bindCols(Pcc pcc, StringBuffer stringBuffer, Vector vector, Vector vector2) {
        this.createVars(pcc);
        this.bindCols(stringBuffer, vector, vector2, false);
    }

    void bindCols(Pcc pcc, StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl) {
        this.createVars(pcc);
        this.bindCols(stringBuffer, vector, vector2, bl);
    }

    private void bindCols(StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl) {
        if (vector != null) {
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                VariableName variableName = (VariableName)vector.elementAt(n2);
                if (variableName.getVarDecl().isLobLocator()) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("ESQL_BIND_TYPE.set(99999);" + eol);
                }
                stringBuffer.append(this.parent.getIndent());
                if (n3 > 0 && n3 % this.MAX_LINES == 0) {
                    if (n3 > this.MAX_LINES) {
                        stringBuffer.append(" } }; ");
                    }
                    stringBuffer.append(" new Object() { { ");
                }
                stringBuffer.append(this.getReturnCode());
                if (bl) {
                    stringBuffer.append(".set(Esql.GET_OBJECT(new Object[] {");
                } else if (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate) {
                    stringBuffer.append(".set(Esql.BIND_COL_ORA(new Object[] {");
                } else {
                    stringBuffer.append(".set(Esql.BIND_COL(new Object[] {");
                }
                stringBuffer.append(this.cursHndl.getCode());
                stringBuffer.append(", ");
                if ((variableName.getVarDecl().isVarying() || variableName.getVarDecl().isVarChar() || variableName.getVarDecl().isLob()) && !variableName.getVarDecl().isLobLocator()) {
                    stringBuffer.append(variableName.getVarDecl().getChildren().getLast().getUnivoqueName());
                    if (variableName.hasIndexes()) {
                        stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                    }
                } else {
                    stringBuffer.append(variableName.getCode());
                    if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                }
                stringBuffer.append(",");
                stringBuffer.append(this.bindType.getCode());
                stringBuffer.append(",");
                stringBuffer.append("Factory.getNumLiteral(");
                stringBuffer.append(n2 + 1);
                stringBuffer.append(", 4, 0, false),");
                if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isVarChar() || variableName.getVarDecl().isLob()) {
                    stringBuffer.append(variableName.getVarDecl().getChildren().getFirst().getUnivoqueName());
                    if (variableName.hasIndexes()) {
                        stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                    }
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(" , null, ");
                if (vector2.elementAt(n2) == null) {
                    if (this.tm.getOptionList().getOption("-csqn") == null) {
                        stringBuffer.append(this.getBindIndCode());
                    } else {
                        stringBuffer.append("null");
                    }
                } else {
                    VariableName variableName2 = (VariableName)vector2.elementAt(n2);
                    stringBuffer.append(variableName2.getCode());
                    if (!(variableName2.getVarDecl().getOccursAll() == 0 || variableName2.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                }
                if (this.pc.getOption("-xcsqc") != null) {
                    stringBuffer.append(", " + this.getInstanceName());
                }
                stringBuffer.append("}));");
                stringBuffer.append(eol);
                --n2;
                ++n3;
            }
            if (vector.size() > this.MAX_LINES) {
                stringBuffer.append(this.parent.getIndent() + " } };" + eol);
            }
        }
    }

    void setParams(Pcc pcc, StringBuffer stringBuffer, Vector vector, Vector vector2) {
        this.createVars(pcc);
        this.setParams(stringBuffer, vector, vector2, false);
    }

    void setParams(Pcc pcc, StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl) {
        this.createVars(pcc);
        this.setParams(stringBuffer, vector, vector2, bl, null);
    }

    private void setParams(StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl) {
        this.setParams(stringBuffer, vector, vector2, bl, null);
    }

    private void setParams(StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl, Vector vector3) {
        if (vector != null) {
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                VariableName variableName;
                Object e2 = vector.elementAt(n2);
                VariableDeclaration variableDeclaration = null;
                if (vector2.elementAt(n2) != null && e2 instanceof VariableName) {
                    if (e2 instanceof VariableName) {
                        variableDeclaration = ((VariableName)e2).getVarDecl();
                    }
                    if (variableDeclaration == null) {
                        return;
                    }
                    variableName = (VariableName)e2;
                    VariableName variableName2 = (VariableName)vector2.elementAt(n2);
                    if (this.optionXLVNULL && variableDeclaration.isNumeric()) {
                        if (variableName2.getName().startsWith("$$IND$$_")) {
                            stringBuffer.append(this.parent.getIndent());
                            stringBuffer.append(variableName2.getName() + ".setAllZero();" + eol);
                        }
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("if (");
                        if (variableDeclaration.isVarying() || variableDeclaration.isLob() || variableDeclaration.isVarChar()) {
                            stringBuffer.append(variableDeclaration.getChildren().getLast().getUnivoqueName());
                            if (variableName.hasIndexes()) {
                                stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                            }
                        } else {
                            stringBuffer.append(variableName.getCode());
                            if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                stringBuffer.append(".at(j$j$j)");
                            }
                        }
                        stringBuffer.append(".compareTo($lowVal$)==0)" + eol);
                        stringBuffer.append(this.parent.getIndent() + "   ");
                        if (variableName2.getName().startsWith("$$IND$$_")) {
                            stringBuffer.append(variableName2.getName());
                        } else if (variableDeclaration.isVarying() || variableDeclaration.isLob() || variableDeclaration.isVarChar()) {
                            stringBuffer.append(variableDeclaration.getChildren().getLast().getUnivoqueName());
                            if (variableName2.hasIndexes()) {
                                stringBuffer.append(variableName2.getIndexes().getCode(variableDeclaration.isObjectReference(), variableDeclaration.getOccurs() > 0, variableName2.isEdited() && variableName2.isNumeric()));
                            }
                        } else {
                            stringBuffer.append(variableName2.getCode());
                            if (!(variableDeclaration.getOccursAll() == 0 || variableName2.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                stringBuffer.append(".at(j$j$j)");
                            }
                        }
                        stringBuffer.append(".set(-1L);" + eol);
                    }
                }
                stringBuffer.append(this.parent.getIndent());
                if (n3 > 0 && n3 % this.MAX_LINES == 0) {
                    if (n3 > this.MAX_LINES) {
                        stringBuffer.append(" } }; ");
                    }
                    stringBuffer.append(" new Object() { { ");
                }
                stringBuffer.append(this.getReturnCode());
                if (bl) {
                    stringBuffer.append(".set(Esql.SET_PARAMQ(new Object[] {");
                } else if (vector3 != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                    stringBuffer.append(".set(Esql.SET_PARAM_ORA(new Object[] {");
                } else {
                    stringBuffer.append(".set(Esql.SET_PARAM(new Object[] {");
                }
                stringBuffer.append(this.cursHndl.getCode());
                stringBuffer.append(", ");
                variableName = null;
                if (e2 instanceof Token) {
                    stringBuffer.append(this.getCodeLiteral((Token)e2));
                } else {
                    variableName = (VariableName)e2;
                    if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                        stringBuffer.append(variableName.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (variableName.hasIndexes()) {
                            stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                        }
                    } else {
                        stringBuffer.append(variableName.getCode());
                        if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            stringBuffer.append(".at(j$j$j)");
                        }
                    }
                }
                stringBuffer.append(",");
                stringBuffer.append(this.bindType.getCode());
                stringBuffer.append(",");
                stringBuffer.append("Factory.getNumLiteral(");
                stringBuffer.append(n2 + 1);
                stringBuffer.append(", 4, 0, false),");
                if (variableName != null && (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isVarChar() || variableName.getVarDecl().isVarChar() || variableName.getVarDecl().isLob())) {
                    stringBuffer.append(variableName.getVarDecl().getChildren().getFirst().getUnivoqueName());
                    if (variableName.hasIndexes()) {
                        stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                    }
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(", null, ");
                if (vector2.elementAt(n2) == null) {
                    stringBuffer.append(this.getBindIndCode());
                } else {
                    VariableName variableName3 = (VariableName)vector2.elementAt(n2);
                    stringBuffer.append(variableName3.getCode());
                    if (!(variableName3.getVarDecl().getOccursAll() == 0 || variableName3.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                }
                if (variableName != null && variableName.getSqlCallMode() != null) {
                    stringBuffer.append(",\"");
                    stringBuffer.append(variableName.getSqlCallMode());
                    stringBuffer.append("\"");
                } else if (variableName != null && this instanceof SqlCall && variableName.getSqlCallMode() == null) {
                    stringBuffer.append(",\"INOUT\"");
                } else if (this.db2Esql) {
                    stringBuffer.append(",\"INOUT\"");
                } else {
                    stringBuffer.append(",null");
                }
                if (variableName != null && variableName.getVarDecl().isLob()) {
                    if (variableName.getVarDecl().getUsageString() != null && (variableName.getVarDecl().getUsageString().equals("CLOB") || variableName.getVarDecl().getUsageString().equals("DBCLOB"))) {
                        stringBuffer.append(",null,(short)2005");
                    } else if (variableName.getVarDecl().getUsageString() != null && variableName.getVarDecl().getUsageString().equals("BLOB")) {
                        stringBuffer.append(",null,(short)2004");
                    }
                }
                if (variableName != null && variableName.getVarDecl().isLobLocator()) {
                    stringBuffer.append(",null,(short)99999");
                }
                stringBuffer.append("}));");
                stringBuffer.append(eol);
                --n2;
                ++n3;
            }
            if (vector.size() > this.MAX_LINES) {
                stringBuffer.append(this.parent.getIndent() + " } };" + eol);
            }
        }
    }

    private void setSqljParams(StringBuffer stringBuffer, Vector vector, Vector vector2) {
        this.setSqljParams(stringBuffer, vector, vector2, true);
    }

    private void setSqljParams(StringBuffer stringBuffer, Vector vector, Vector vector2, boolean bl) {
        if (vector != null) {
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                VariableName variableName;
                Object e2 = vector.elementAt(n2);
                VariableDeclaration variableDeclaration = null;
                if (vector2.elementAt(n2) != null && e2 instanceof VariableName && (variableDeclaration = ((VariableName)e2).getVarDecl()) != null) {
                    variableName = (VariableName)e2;
                    VariableName variableName2 = (VariableName)vector2.elementAt(n2);
                    stringBuffer.append(this.parent.getIndent());
                    if (bl) {
                        stringBuffer.append(variableName2.getSqljNameParam() + " = ");
                    } else {
                        stringBuffer.append(variableName2.getSqljName() + " = ");
                    }
                    if (variableName2.getVarDecl().isVarying() || variableName2.getVarDecl().isLob() || variableName2.getVarDecl().isVarChar()) {
                        stringBuffer.append(variableName2.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (variableName2.hasIndexes()) {
                            stringBuffer.append(variableName2.getIndexes().getCode(variableName2.getVarDecl().isObjectReference(), variableName2.getVarDecl().getOccurs() > 0, variableName2.isEdited() && variableName.isNumeric()));
                        }
                    } else {
                        stringBuffer.append(variableName2.getCode());
                        if (!(variableName2.getVarDecl().getOccursAll() == 0 || variableName2.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            stringBuffer.append(".at(j$j$j)");
                        }
                    }
                    stringBuffer.append(".toshort();" + eol);
                }
                stringBuffer.append(this.parent.getIndent());
                if (n3 > 0 && n3 % this.MAX_LINES == 0) {
                    if (n3 > this.MAX_LINES) {
                        stringBuffer.append(" } }; ");
                    }
                    stringBuffer.append(" new Object() { { ");
                }
                variableName = null;
                if (!(e2 instanceof Token)) {
                    variableName = (VariableName)e2;
                    if (bl) {
                        stringBuffer.append(variableName.getSqljNameParam() + " = ");
                    } else {
                        stringBuffer.append(variableName.getSqljName() + " = ");
                    }
                    if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                        stringBuffer.append(variableName.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (variableName.hasIndexes()) {
                            stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                        }
                    } else {
                        stringBuffer.append(variableName.getCode());
                        if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            stringBuffer.append(".at(j$j$j)");
                        }
                    }
                }
                if (variableName.isNumeric()) {
                    stringBuffer.append(".todouble();" + eol);
                } else if (this.db2Esql && this.db2Sqljbin && variableName.getVarDecl().phisicLen != 10 && variableName.getVarDecl().phisicLen != 26 && variableName.getVarDecl().phisicLen != 8) {
                    stringBuffer.append(".getMyMemory(");
                    if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                        stringBuffer.append(variableName.getVarDecl().getChildren().getFirst().getUnivoqueName());
                        if (variableName.hasIndexes()) {
                            stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                        }
                        stringBuffer.append(".toint()");
                    } else {
                        stringBuffer.append(variableName.getVarDecl().phisicLen);
                    }
                    stringBuffer.append(");" + eol);
                } else {
                    stringBuffer.append(".toString();" + eol);
                }
                stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat: setParam " + variableName.getVarDecl().getName() + "=\" +  " + variableName.getVarDecl().getName().replace('-', Pcc.hyphenRepl) + ".toString());" + eol);
                --n2;
                ++n3;
            }
        }
    }

    void bindSqljVars(StringBuffer stringBuffer, Vector vector, Vector vector2) {
        if (vector != null) {
            if (this.db2Esql && (this.db2Sqljbin || this instanceof SqlSet || this instanceof SqlFetch)) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("try {" + eol);
            }
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                Object e2 = vector.elementAt(n2);
                VariableDeclaration variableDeclaration = null;
                if (n3 == 0 && this.db2Esql && this instanceof SqlSet) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   setSqljConnection();" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("try {" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (" + ((SqlSet)this).getIterName() + " != null)");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   rs = (DB2ResultSet)");
                    stringBuffer.append(((SqlSet)this).getIterName());
                    stringBuffer.append(".getResultSet();");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (rs == null || rs.next() == false)");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("catch (SQLException e) {" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}" + eol);
                }
                if (n3 == 0 && this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlOpen || this instanceof SqlValue)) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("try {" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    if (this instanceof SqlOpen) {
                        stringBuffer.append(this.curName + " = (DB2ResultSet)");
                    } else {
                        stringBuffer.append("rs = (DB2ResultSet)");
                    }
                    if (this instanceof SqlSelect) {
                        stringBuffer.append(((SqlSelect)this).getIterName());
                    } else if (this instanceof SqlValue) {
                        stringBuffer.append(((SqlValue)this).getIterName());
                    } else {
                        stringBuffer.append(((SqlOpen)this).getIterName());
                    }
                    stringBuffer.append(".getResultSet();");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("catch (SQLException e) {" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}" + eol);
                }
                if (n3 == 0 && this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlFetch || this instanceof SqlValue)) {
                    if (this instanceof SqlFetch) {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   setSqljConnection();" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("if (" + this.curName + " == null || " + this.curName + ".next() == false)");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowData = (byte[])" + this.curName + ".getDBRowDataAsBytes()[0];");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowInfo = (int[])" + this.curName + ".getDBRowDescriptor();");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowOffs = (int[])" + this.curName + ".getDBRowDataAsBytes()[1];");
                        stringBuffer.append(eol);
                    } else {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   setSqljConnection();" + eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("if (rs == null || rs.next() == false)");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   throw new SQLException(\"IsCOBOLNotFound\");");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowData = (byte[])rs.getDBRowDataAsBytes()[0];");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowInfo = (int[])rs.getDBRowDescriptor();");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("rowOffs = (int[])rs.getDBRowDataAsBytes()[1];");
                        stringBuffer.append(eol);
                    }
                }
                VariableName variableName = e2 instanceof VariableName ? (VariableName)e2 : null;
                if (this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlOpen || this instanceof SqlValue || this instanceof SqlFetch) && variableName != null && !variableName.isNumeric()) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("offs = rowOffs[" + n2 + "] + 2;");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("colSqlType = rowInfo != null ? rowInfo[(4*(" + n2 + "))+1] : 0;");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (colSqlType == EsqlRuntime.DB2_VARCHAR ||");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("    colSqlType == (EsqlRuntime.DB2_VARCHAR + 1)) {");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   System.arraycopy(rowData, offs, num, 0, 2);");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   len  = (num[0]<< 8)&0x0000ff00|");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("          (num[1]<< 0)&0x000000ff;");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   offs = offs + 2;");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("else");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   len = rowInfo[(4*(" + n2 + "))+3];");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("bytearr = new byte[len];");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (rowData[rowOffs[(" + n2 + ")]] == 0 &&");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("    rowData[rowOffs[(" + n2 + ")] +1] == 0)");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   System.arraycopy(rowData, offs,");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("                    bytearr, 0, bytearr.length);");
                    stringBuffer.append(eol);
                    if (this instanceof SqlSelect && this.tm.getOptionList().getOption("-csqn") != null) {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("else");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   throw new SQLException(\"IsCOBOLNull\", \"\");");
                        stringBuffer.append(eol);
                    }
                    if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append(variableName.getVarDecl().getChildren().getLast().getUnivoqueName());
                        if (variableName.hasIndexes()) {
                            stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                        }
                    } else {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append(variableName.getCode());
                        if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            stringBuffer.append(".at(j$j$j)");
                        }
                    }
                    stringBuffer.append(".sqlSetBytes(bytearr);");
                    stringBuffer.append(eol);
                    if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append(variableName.getVarDecl().getChildren().getFirst().getUnivoqueName());
                        if (variableName.hasIndexes()) {
                            stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                        }
                        stringBuffer.append(".set(bytearr.length);");
                        stringBuffer.append(eol);
                    }
                } else if (this.db2Esql && this.db2Sqljbin && (this instanceof SqlSelect || this instanceof SqlValue || this instanceof SqlOpen || this instanceof SqlFetch) && variableName != null && variableName.isNumeric()) {
                    stringBuffer.append(this.parent.getIndent());
                    if (this instanceof SqlFetch) {
                        stringBuffer.append("obj = " + this.curName + ".getObject(" + (n2 + 1) + ");");
                    } else {
                        stringBuffer.append("obj = rs.getObject(" + (n2 + 1) + ");");
                    }
                    variableName = (VariableName)e2;
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (obj == null) {");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   " + variableName.getCode());
                    if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                    stringBuffer.append(".set(");
                    if (variableName.isNumeric()) {
                        stringBuffer.append("0);");
                    } else {
                        stringBuffer.append("\" \");");
                    }
                    if (this.tm.getOptionList().getOption("-csqn") == null || this instanceof SqlOpen || this instanceof SqlFetch) {
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   ;");
                    } else {
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("   throw new SQLException(\"IsCOBOLNull\", \"\");");
                    }
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("} else if (obj instanceof BigDecimal)");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent() + "   ");
                    stringBuffer.append(variableName.getCode());
                    if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                    stringBuffer.append(".set((BigDecimal)obj);");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("else");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent() + "   ");
                    stringBuffer.append(variableName.getCode());
                    if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                        stringBuffer.append(".at(j$j$j)");
                    }
                    stringBuffer.append(".set(obj.toString());");
                    stringBuffer.append(eol);
                } else {
                    stringBuffer.append(this.parent.getIndent());
                    if (n3 > 0 && n3 % this.MAX_LINES == 0) {
                        if (n3 > this.MAX_LINES) {
                            stringBuffer.append(" } }; ");
                        }
                        stringBuffer.append(" new Object() { { ");
                    }
                    variableName = null;
                    if (!(e2 instanceof Token)) {
                        variableName = (VariableName)e2;
                        if (variableName.getVarDecl().isVarying() || variableName.getVarDecl().isLob() || variableName.getVarDecl().isVarChar()) {
                            stringBuffer.append(variableName.getVarDecl().getChildren().getLast().getUnivoqueName());
                            if (variableName.hasIndexes()) {
                                stringBuffer.append(variableName.getIndexes().getCode(variableName.getVarDecl().isObjectReference(), variableName.getVarDecl().getOccurs() > 0, variableName.isEdited() && variableName.isNumeric()));
                            }
                        } else {
                            stringBuffer.append(variableName.getCode());
                            if (!(variableName.getVarDecl().getOccursAll() == 0 || variableName.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                stringBuffer.append(".at(j$j$j)");
                            }
                        }
                    }
                    stringBuffer.append(".set(");
                    if (this.db2Esql && (this instanceof SqlFetch || this instanceof SqlSet)) {
                        if (variableName.isNumeric()) {
                            stringBuffer.append("rs.getLong(" + (n3 + 1) + "));" + eol);
                        } else {
                            stringBuffer.append("rs.getString(" + (n3 + 1) + "));" + eol);
                        }
                    } else if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                        stringBuffer.append(variableName.getSqljNameParam() + ");" + eol);
                    } else {
                        stringBuffer.append(variableName.getSqljName() + ");" + eol);
                    }
                }
                if (vector2.elementAt(n2) != null && e2 instanceof VariableName) {
                    if (e2 instanceof VariableName) {
                        variableDeclaration = ((VariableName)e2).getVarDecl();
                    }
                    if (variableDeclaration != null) {
                        stringBuffer.append(this.parent.getIndent());
                        variableName = (VariableName)e2;
                        VariableName variableName2 = (VariableName)vector2.elementAt(n2);
                        if (variableName2.getVarDecl().isVarying() || variableName2.getVarDecl().isLob() || variableName2.getVarDecl().isVarChar()) {
                            stringBuffer.append(variableName2.getVarDecl().getChildren().getLast().getUnivoqueName());
                            if (variableName2.hasIndexes()) {
                                stringBuffer.append(variableName2.getIndexes().getCode(variableName2.getVarDecl().isObjectReference(), variableName2.getVarDecl().getOccurs() > 0, variableName2.isEdited() && variableName.isNumeric()));
                            }
                        } else {
                            stringBuffer.append(variableName2.getCode());
                            if (!(variableName2.getVarDecl().getOccursAll() == 0 || variableName2.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                                stringBuffer.append(".at(j$j$j)");
                            }
                        }
                        stringBuffer.append(".set(");
                        if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                            stringBuffer.append(variableName2.getSqljNameParam());
                        } else {
                            stringBuffer.append(variableName2.getSqljName());
                        }
                        if (!(variableName2.getVarDecl().getOccursAll() == 0 || variableName2.hasIndexes() || this.forVar == null && this.forVal == 0)) {
                            stringBuffer.append(".at(j$j$j)");
                        }
                        stringBuffer.append(");" + eol);
                    }
                }
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat: bind " + variableName.getVarDecl().getName() + "=\" +  " + variableName.getVarDecl().getName().replace('-', Pcc.hyphenRepl) + ".toString());" + eol);
                --n2;
                ++n3;
            }
            if (this instanceof SqlSet || (this instanceof SqlSelect || this instanceof SqlValue) && this.db2Sqljbin && this.db2Esql) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("rs.close();");
                stringBuffer.append(eol);
            }
            if (this.db2Esql && (this.db2Sqljbin || this instanceof SqlSet || this instanceof SqlFetch)) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("catch (SQLException e) {" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}" + eol);
            }
        }
    }

    void into(Vector vector, Vector vector2) throws GeneralErrorException, EndOfProgramException {
        this.into(vector, vector2, false);
    }

    void into(Vector vector, Vector vector2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        Token token;
        this.operFunc = null;
        this.saveFunc = null;
        while ((token = this.getSqlToken()).getToknum() == 58) {
            VariableName variableName;
            VariableName variableName2 = this.getHostVariable(false, true);
            token = this.getSqlToken();
            if (token.getWord().equalsIgnoreCase("INDICATOR")) {
                token = this.getSqlToken();
            }
            if (token.getToknum() == 58) {
                variableName = this.getHostVariable(true, true);
                if (variableName == null) {
                    this.ungetAllSqlToken();
                } else if (!variableName.getVarDecl().isNumeric() || variableName.getVarDecl().isEdited()) {
                    throw new GeneralErrorException(23, 4, variableName.name, variableName.name.getWord(), this.error);
                }
                token = this.getSqlToken();
            } else {
                variableName = null;
            }
            if (this.isSqljStat && this.checkVars && (!this.db2Esql || this.db2Esql && !this.db2Sqljbin)) {
                if (!this.db2Esql && (this instanceof SqlSelect || this instanceof SqlValue)) {
                    this.addSqljHostVar(variableName2, variableName, true, vector, vector2);
                } else {
                    this.addSqljHostVar(variableName2, variableName, false, vector, vector2);
                }
                if (token.getToknum() == 44) {
                    this.addToken(token);
                }
            } else {
                VariableDeclarationList variableDeclarationList = this.splitChildren(variableName2);
                if (variableDeclarationList == null) {
                    vector.add(variableName2);
                    vector2.add(variableName);
                } else {
                    VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
                    while (variableDeclaration != null) {
                        if (variableDeclaration.redefines == null) {
                            vector.add(new VariableName(variableDeclaration));
                            vector2.add(variableName);
                            variableDeclaration.setUsed();
                        }
                        variableDeclaration = variableDeclarationList.getNext();
                    }
                }
            }
            if (variableName != null) {
                variableName.getVarDecl().setEsqlIndicator();
            }
            if (token.getToknum() == 44) continue;
        }
        this.ungetAllSqlToken();
    }

    void attribute(Token token) throws GeneralErrorException, EndOfProgramException {
        this.query.append(" ");
        while (true) {
            this.query.append(token.getWord());
            token = this.getSqlToken();
            if (token.getToknum() != 10006) break;
            this.query.append(".");
            token = this.getSqlToken();
        }
        this.ungetAllSqlToken();
    }

    void value(Token token, Vector vector, Vector vector2) throws GeneralErrorException, EndOfProgramException {
        this.value(token, vector, vector2, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void value(Token token, Vector vector, Vector vector2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        while (true) {
            switch (token.getToknum()) {
                case 58: {
                    this.value(vector, vector2, bl);
                    break;
                }
                case 10017: {
                    if (this.isSqljStat) {
                        this.query.append(" " + this.getSqlDecimal(token.getWord()));
                        break;
                    }
                    vector.add(token);
                    this.query.append(" ?");
                    vector2.add(null);
                    if (!(this instanceof SqlUpdate)) break;
                    SqlUpdate sqlUpdate = (SqlUpdate)this;
                    sqlUpdate.valCols.add(token);
                    sqlUpdate.valInds.add(null);
                    break;
                }
                case 40: {
                    if (this.isSqljStat) {
                        this.sqljSetLostWord = "";
                    }
                    this.addToken(token);
                    token = this.getSqlToken();
                    int n2 = 1;
                    if (token.getWord().equalsIgnoreCase("SELECT")) {
                        do {
                            this.addToken(token);
                            token = this.getSqlToken();
                            if (token.getToknum() == 41) {
                                --n2;
                                continue;
                            }
                            if (token.getToknum() == 40) {
                                ++n2;
                                continue;
                            }
                            if (token.getToknum() != 58) continue;
                            this.value(vector, vector2, bl);
                            token = this.getSqlToken();
                            if (token.getToknum() == 41) {
                                --n2;
                                continue;
                            }
                            if (token.getToknum() != 40) continue;
                            ++n2;
                        } while (n2 != 0 && token.getToknum() != 432);
                    } else {
                        do {
                            this.value(token, vector, vector2, bl);
                            token = this.getSqlToken();
                            if (token.getToknum() != 44) continue;
                            this.addToken(token);
                            token = this.getSqlToken();
                        } while (token.getToknum() != 41 && token.getToknum() != 432 && !token.getWord().equalsIgnoreCase("WHERE"));
                    }
                    if (token.getToknum() != 432) {
                        this.addToken(token);
                        break;
                    }
                    this.ungetAllSqlToken();
                    break;
                }
                case 10006: {
                    this.addToken(token);
                    this.addToken(this.getSqlToken(), false);
                    break;
                }
                case 41: 
                case 44: 
                case 432: {
                    this.ungetAllSqlToken();
                    return;
                }
                default: {
                    SqlUpdate sqlUpdate;
                    if (this instanceof SqlSet && !token.isNull()) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    if ("WHERE".equals(token.getWord())) {
                        this.ungetAllSqlToken();
                        return;
                    }
                    if (this instanceof SqlUpdate && !token.isNull()) {
                        if (this.db2Esql && (token.getWord().equals("CURRENT") || token.getWord().equals("ENCRYPTION") || token.getWord().equals("SESSION") || token.getWord().equals("SESSION_USER") || token.getWord().equals("USER") || token.getWord().equals("CURRENT_DATE") || token.getWord().equals("CURRENT_PATH") || token.getWord().equals("CURRENT_SCHEMA") || token.getWord().equals("CURRENT_TIME") || token.getWord().equals("CURRENT_TIMESTAMP"))) {
                            Object object;
                            if (token.getWord().equals("CURRENT")) {
                                this.addToken(token);
                                token = this.getSqlToken();
                            } else if (token.getWord().startsWith("CURRENT")) {
                                object = token.getWord().replace("-", "_");
                                token = new Token(10001, "CURRENT", 0, 0, null);
                                this.addToken(token);
                                token = new Token(10001, ((String)object).substring(((String)object).lastIndexOf("_") + 1), 0, 0, null);
                            } else {
                                this.addToken(token);
                            }
                            if (db2Registers.containsKey(token.getWord().toUpperCase())) {
                                sqlUpdate = (SqlUpdate)this;
                                object = new Token(10001, "##" + token.getWord() + "##", 0, 0, null);
                                String[] stringArray = (String[])db2Registers.get(token.getWord());
                                String string = ((Token)object).getWord() + "=select current " + token.getWord() + " ";
                                for (int i2 = 1; i2 < stringArray.length && token != null && token.getToknum() != 432 && token.getWord().equalsIgnoreCase("WHERE"); ++i2) {
                                    boolean bl2;
                                    String string2 = stringArray[i2];
                                    if (string2.startsWith("@")) {
                                        bl2 = true;
                                        string2 = string2.substring(1);
                                    } else {
                                        bl2 = false;
                                    }
                                    if (string2.equalsIgnoreCase(token.getWord())) {
                                        this.addToken(token);
                                        string = token.getWord() + " ";
                                        token = this.getSqlToken();
                                        continue;
                                    }
                                    if (bl2) continue;
                                    throw new GeneralErrorException(15, 4, token, " DB2 REGISTER " + stringArray[0], this.error);
                                }
                                string = string + " from sysibm.sysdummy1";
                                object = new Token(10199, string, 0, 0, null);
                                sqlUpdate.valCols.add(object);
                                sqlUpdate.valInds.add(null);
                            } else if (token.getWord().equals("ENCRYPTION") || token.getWord().equals("SESSION") || token.getWord().equals("SESSION_USER") || token.getWord().equals("USER")) {
                                void var8_15;
                                sqlUpdate = (SqlUpdate)this;
                                object = new Token(10001, "##" + token.getWord() + "##", 0, 0, null);
                                String string = ((Token)object).getWord() + "=select " + token.getWord() + " ";
                                if (token.getWord().equals("ENCRYPTION")) {
                                    token = this.getSqlToken();
                                    if (!token.getWord().equals("PASSWORD")) throw new GeneralErrorException(15, 4, token, " DB2 REGISTER ENCRYPTION", this.error);
                                    String string3 = string + " encryption password from sysibm.sysdummy1";
                                } else if (token.getWord().equals("SESSION")) {
                                    token = this.getSqlToken();
                                    if (!token.getWord().equals("TIME")) throw new GeneralErrorException(15, 4, token, " DB2 REGISTER SESSION", this.error);
                                    token = this.getSqlToken();
                                    if (!token.getWord().equals("ZONE")) throw new GeneralErrorException(15, 4, token, " DB2 REGISTER SESSION", this.error);
                                    String string4 = string + " session time zone from sysibm.sysdummy1";
                                } else if (token.getWord().equals("SESSION_USER")) {
                                    String string5 = string + " session_user from sysibm.sysdummy1";
                                } else if (token.getWord().equals("USER")) {
                                    String string6 = string + " user from sysibm.sysdummy1";
                                }
                                object = new Token(10199, (String)var8_15, 0, 0, null);
                                sqlUpdate.valCols.add(object);
                                sqlUpdate.valInds.add(null);
                            } else {
                                sqlUpdate = (SqlUpdate)this;
                                sqlUpdate.valCols.add(token);
                                sqlUpdate.valInds.add(null);
                            }
                        } else {
                            sqlUpdate = (SqlUpdate)this;
                            sqlUpdate.valCols.add(token);
                            sqlUpdate.valInds.add(null);
                        }
                    }
                    if (this.isSqljStat) {
                        this.sqljSetLostWord = " " + token.getWord();
                    }
                    this.addToken(token);
                }
            }
            token = this.getSqlToken();
        }
    }

    void value(Vector vector, Vector vector2) throws GeneralErrorException, EndOfProgramException {
        this.value(vector, vector2, false);
    }

    void value(Vector vector, Vector vector2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        this.value(vector, vector2, false, false);
    }

    void value(Vector vector, Vector vector2, boolean bl, boolean bl2) throws GeneralErrorException, EndOfProgramException {
        String string;
        VariableName variableName;
        VariableName variableName2 = this.getHostVariable(false, bl);
        Token token = this.getSqlToken();
        if (token.getWord().equalsIgnoreCase("INDICATOR")) {
            token = this.getSqlToken();
        }
        if (token.getToknum() == 58) {
            variableName = this.getHostVariable(true, bl);
            if (variableName == null) {
                this.ungetAllSqlToken();
            } else if (!variableName.getVarDecl().isNumeric() || variableName.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, variableName2.name, variableName2.name.getWord(), this.error);
            }
        } else {
            variableName = null;
            this.ungetAllSqlToken();
        }
        if (this instanceof SqlCall) {
            token = this.getSqlToken();
            string = token.getWord();
            if ("IN".equals(string) || "OUT".equals(string) || "INOUT".equals(string)) {
                variableName2.setSqlCallMode(string);
            } else {
                this.ungetAllSqlToken();
            }
        }
        if (this.isSqljStat) {
            this.addSqljHostVar(variableName2, variableName, !bl, vector, vector2);
        } else {
            VariableDeclarationList variableDeclarationList = this.splitChildren(variableName2);
            if (variableDeclarationList == null) {
                vector.add(variableName2);
                if (this.db2Esql) {
                    int n2 = variableName2.getVarDecl().getLogicLen();
                    if (n2 == 0 && variableName2.getVarDecl().value != null) {
                        n2 = variableName2.getVarDecl().value.getWord().length() - 2;
                    }
                    if (variableName2.sqlTypeFunc == -1 || variableName2.sqlTypeCast || this.prevTok == null || this.prevTok.getWord().equalsIgnoreCase("CAST")) {
                        this.query.append(" ?");
                    } else if (variableName2.sqlTypeFunc == 93) {
                        if (n2 > 10) {
                            this.query.append(" CAST(? AS TIMESTAMP)");
                        } else {
                            this.query.append(" CAST(? AS DATE)");
                        }
                    } else if (variableName2.sqlTypeFunc == 3 && !variableName2.isNumeric() && n2 > 4) {
                        this.query.append(" CAST(? AS INT)");
                    } else if (variableName2.sqlTypeFunc == 91 && variableName2.getVarDecl().phisicLen == 7) {
                        this.query.append(" CAST(? AS VARCHAR(7))");
                    } else if (sqlTypesCast.get(variableName2.sqlTypeFunc).equals("VARCHAR")) {
                        this.query.append(" CAST(? AS VARCHAR(" + variableName2.getVarDecl().phisicLen + "))");
                    } else if (sqlTypesCast.get(variableName2.sqlTypeFunc).equals("CHAR")) {
                        this.query.append(" CAST(? AS CHAR(" + variableName2.getVarDecl().phisicLen + "))");
                    } else if (sqlTypesCast.get(variableName2.sqlTypeFunc).equals("DECIMAL")) {
                        this.query.append(" CAST(? AS DECIMAL(" + variableName2.getVarDecl().phisicLen + "," + variableName2.getVarDecl().getDecimals() + "))");
                    } else {
                        this.query.append(" CAST(? AS " + sqlTypesCast.get(variableName2.sqlTypeFunc) + ")");
                    }
                } else if (bl2 && variableName2.getVarDecl().isVarying() && this.pc.getOption("-xsqlrt") != null) {
                    if (this.lastWord != null) {
                        string = this.lastWord + "=";
                        if (this.query.toString().endsWith(string)) {
                            this.query.replace(this.query.length() - string.length(), this.query.length(), "RTRIM(" + this.lastWord + ")=");
                        }
                    }
                    this.query.append(" RTRIM(?)");
                    vector.setElementAt(new VariableName(variableName2.getVarDecl().getChildren().getLast()), vector.size() - 1);
                } else {
                    this.query.append(" ?");
                }
                vector2.add(variableName);
                if (variableName != null) {
                    variableName.getVarDecl().setEsqlIndicator();
                }
                if (this instanceof SqlUpdate) {
                    SqlUpdate sqlUpdate = (SqlUpdate)this;
                    sqlUpdate.valCols.add(variableName2);
                    sqlUpdate.valInds.add(variableName);
                }
            } else {
                if (bl2) {
                    throw new GeneralErrorException(273, 4, variableName2.getNameToken(), variableName2.getName(), this.error);
                }
                int n3 = 0;
                VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
                while (variableDeclaration != null) {
                    if (variableDeclaration.redefines == null) {
                        VariableName variableName3 = new VariableName(variableDeclaration);
                        variableDeclaration.setUsed();
                        variableName3.setSqlCallMode(variableName2.getSqlCallMode());
                        vector.add(variableName3);
                        if (n3 != 0) {
                            this.query.append(",");
                        }
                        this.query.append(" ?");
                        vector2.add(variableName);
                        if (variableName != null) {
                            variableName.getVarDecl().setEsqlIndicator();
                        }
                        if (this instanceof SqlUpdate) {
                            SqlUpdate sqlUpdate = (SqlUpdate)this;
                            sqlUpdate.valCols.add(new VariableName(variableDeclaration));
                            sqlUpdate.valInds.add(variableName);
                        }
                    }
                    variableDeclaration = variableDeclarationList.getNext();
                    ++n3;
                }
            }
        }
    }

    void getCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.getCodeGeneric(pcc, stringBuffer, string, string2, variableName, bl, vector, vector2, vector3, vector4, 0);
    }

    void getCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n2) {
        this.getCodeGeneric(pcc, stringBuffer, string, string2, variableName, bl, vector, vector2, vector3, vector4, n2, false);
    }

    void getCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n2, boolean bl2) {
        this.getCodeGeneric(pcc, stringBuffer, string, string2, variableName, bl, vector, vector2, vector3, vector4, n2, false, 0);
    }

    void getCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n2, boolean bl2, int n3) {
        this.getCodeGeneric(pcc, stringBuffer, string, string2, variableName, bl, vector, vector2, vector3, vector4, n2, bl2, n3, 0, null);
    }

    void getCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n2, boolean bl2, int n3, int n4, VariableName variableName2) {
        if (this.isSqljStat) {
            this.getSqljCodeGeneric(pcc, stringBuffer, string, string2, variableName, bl, vector, vector2, vector3, vector4, n2, bl2, n3, variableName2);
            return;
        }
        this.createVars(pcc);
        this.createVars(pcc);
        if (string2 == null && variableName == null) {
            stringBuffer.append(this.cursHndl.getCode());
            if (bl2) {
                stringBuffer.append(".set(Esql.DECLARE_UPDT(new Object[] {" + this.pc.sqlca.SQLCA + ",");
            } else if (vector != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                stringBuffer.append(".set(Esql.DECLARE_STMT_ORA(new Object[] {" + this.pc.sqlca.SQLCA + ",");
            } else {
                stringBuffer.append(".set(Esql.DECLARE_STMT(new Object[] {" + this.pc.sqlca.SQLCA + ",");
            }
            if (string != null) {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(", null, \"");
            if (variableName2 != null) {
                stringBuffer.append(this.query + "\".replace(\"call?\", \"call \" + " + variableName2.getCode() + ".toString().trim())");
            } else {
                stringBuffer.append(this.query + "\"");
            }
            stringBuffer.append(", null, \"");
            stringBuffer.append(n2);
            if (string != null) {
                stringBuffer.append("\", " + this.getInstanceName(pcc));
                if (bl2) {
                    stringBuffer.append("}));");
                } else {
                    stringBuffer.append(", \"" + n3 + "\"");
                    if (n4 > 0) {
                        stringBuffer.append(", Integer.valueOf(" + n4 + ")");
                    }
                    stringBuffer.append("}));");
                }
            } else if (bl2) {
                stringBuffer.append("\", null}));");
            } else {
                stringBuffer.append("\", null, \"" + n3 + "\"");
                if (n4 > 0) {
                    stringBuffer.append(", Integer.valueOf(" + n4 + ")");
                }
                stringBuffer.append("}));");
            }
            stringBuffer.append(eol);
        } else {
            stringBuffer.append(this.cursHndl.getCode());
            stringBuffer.append(".set(Esql.DECLARE(new Object[] {" + this.pc.sqlca.SQLCA + ",");
            if (string != null) {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(", null, ");
            if (variableName == null) {
                stringBuffer.append("\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(variableName.getCode());
            }
            stringBuffer.append(", null, \"");
            stringBuffer.append(n2);
            stringBuffer.append("\", ");
            if (string != null) {
                stringBuffer.append(this.getInstanceName(pcc));
            } else {
                stringBuffer.append("null");
            }
            if (n4 > 0) {
                stringBuffer.append(", Integer.valueOf(" + n4 + ")");
            }
            stringBuffer.append(" }));");
            stringBuffer.append(eol);
        }
        if (bl || vector != null || vector3 != null) {
            if (vector3 != null) {
                this.setParams(stringBuffer, vector3, vector4, false, vector);
            }
            if (vector != null) {
                this.bindCols(stringBuffer, vector, vector2, false);
            }
        }
        if (bl) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.getReturnCode());
            if (vector != null && (this instanceof SqlInsert || this instanceof SqlDelete || this instanceof SqlUpdate)) {
                stringBuffer.append(".set(Esql.EXECUTE_ORA(new Object[] {" + this.pc.sqlca.SQLCA + ", ");
            } else {
                stringBuffer.append(".set(Esql.EXECUTE(new Object[] {" + this.pc.sqlca.SQLCA + ", ");
            }
            stringBuffer.append(this.cursHndl.getCode());
            stringBuffer.append("}));");
            stringBuffer.append(eol);
        }
        this.addWhenever(stringBuffer);
    }

    void getSqljCodeGeneric(Pcc pcc, StringBuffer stringBuffer, String string, String string2, VariableName variableName, boolean bl, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n2, boolean bl2, int n3, VariableName variableName2) {
        this.setSqljParams(stringBuffer, vector3, vector4);
        stringBuffer.append(this.parent.getIndent());
        if ((this instanceof SqlSelect || this instanceof SqlValue || this instanceof SqlSet && this.db2Esql) && (vector == null || vector != null && vector.size() == 0)) {
            if (this instanceof SqlSelect) {
                if (this.pc.addIterDeclaration(((SqlSelect)this).getIterDecl())) {
                    this.pc.addResultSet(((SqlSelect)this).getIterDecl());
                }
            } else if (this instanceof SqlValue) {
                if (this.pc.addIterDeclaration(((SqlValue)this).getIterDecl())) {
                    this.pc.addResultSet(((SqlValue)this).getIterDecl());
                }
            } else if (this.pc.addIterDeclaration(((SqlSet)this).getIterDecl())) {
                this.pc.addResultSet(((SqlSet)this).getIterDecl());
            }
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("try {" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("if (automaticConnection && ctx" + this.pc.getClassName() + " == null)" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("   setSqljConnection();" + eol);
        stringBuffer.append(this.parent.getIndent());
        if (this instanceof SqlSelect && (this.db2Sqljbin || vector == null || vector != null && vector.size() == 0)) {
            if (this.pc.iterDeclContains(((SqlSelect)this).getIterName().substring(1))) {
                stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlSelect)this).getIterName() + " = {" + this.query + "};" + eol);
            } else {
                stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
            }
        } else if (this instanceof SqlValue && (this.db2Sqljbin || vector == null || vector != null && vector.size() == 0)) {
            if (this.pc.iterDeclContains(((SqlValue)this).getIterName().substring(1))) {
                stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlValue)this).getIterName() + " = {" + this.query + "};" + eol);
            } else {
                stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
            }
        } else if (this instanceof SqlSet) {
            stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] " + ((SqlSet)this).getIterName() + " = {" + this.query + "};" + eol);
        } else {
            stringBuffer.append("#sql [ctx" + this.pc.getClassName() + "] {" + this.query + "};" + eol);
        }
        this.bindSqljVars(stringBuffer, vector, vector2);
        if (this instanceof SqlUpdate || this instanceof SqlDelete) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.pc.sqlca.SQLERRD + ".at(3).set(ctx" + this.pc.getClassName() + ".getExecutionContext().getUpdateCount());");
            stringBuffer.append(eol);
        }
        if (this instanceof SqlUpdate || this instanceof SqlInsert || this instanceof SqlDelete) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if (EsqlRuntime.noData != 0 && ctx" + this.pc.getClassName() + ".getExecutionContext().getUpdateCount() == 0)");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("   throw new SQLException(\"IsCOBOLNoData\");");
            stringBuffer.append(eol);
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("}" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("catch (SQLException e) {" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("}" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("Esql.LOG_SQLJ(\"SQLJStat:" + this.query + " SQLCODE=\" + " + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        this.addWhenever(stringBuffer);
    }

    public String getQuery() {
        return this.query.toString();
    }

    public Vector getParmVars() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Vector getParmInds() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public VariableName getCursorHandle() {
        return this.cursHndl;
    }

    protected String getBindIndCode() {
        return this.getCodeLiteral(bindInd);
    }

    public SqlWhenever getWhenError() {
        return this.whenError;
    }

    public SqlWhenever getWhenWarn() {
        return this.whenWarn;
    }

    public SqlWhenever getWhenNotFound() {
        return this.whenNotFound;
    }

    public String getSqlDecimal(String string) {
        int n2;
        if (this.tm.getDecimalPoint() == ',' && (n2 = string.indexOf(44)) >= 0) {
            return string.substring(0, n2) + "." + string.substring(n2 + 1);
        }
        return string;
    }

    void startForClause(StringBuffer stringBuffer) {
        if (this.forVal != 0) {
            stringBuffer.append(this.parent.getIndent() + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(0);" + eol);
            stringBuffer.append(this.parent.getIndent() + "for (int j$j$j = 1; j$j$j <= " + this.forVal + "; j$j$j++) {" + eol);
            ++this.parent.nesting;
        } else if (this.forVar != null) {
            stringBuffer.append(this.parent.getIndent() + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(0);" + eol);
            stringBuffer.append(this.parent.getIndent() + "for (int j$j$j = 1; j$j$j <= " + this.forVar.getVarDecl().getUnivoqueName() + ".toint(); j$j$j++) {" + eol);
            ++this.parent.nesting;
        }
    }

    void endForClause(StringBuffer stringBuffer) {
        this.endForClause(stringBuffer, false);
    }

    void endForClause(StringBuffer stringBuffer, boolean bl) {
        Object var3_3 = null;
        if (this.forVar != null || this.forVal != 0) {
            if (bl) {
                stringBuffer.append(this.parent.getIndent() + "if (" + this.pc.sqlca.SQLCODE + ".toint() != 0)" + eol);
                stringBuffer.append(this.parent.getIndent() + "   break;" + eol);
            } else {
                stringBuffer.append(this.parent.getIndent() + "if (" + this.pc.sqlca.SQLCODE + ".toint() == 0)" + eol);
                stringBuffer.append(this.parent.getIndent() + "   " + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(j$j$j);" + eol);
                stringBuffer.append(this.parent.getIndent() + "else {" + eol);
                stringBuffer.append(this.parent.getIndent() + "   " + this.pc.sqlca.SQLERRD + ".atNC (3 ).set(j$j$j - 1);" + eol);
                stringBuffer.append(this.parent.getIndent() + "   break;" + eol);
                stringBuffer.append(this.parent.getIndent() + "}" + eol);
            }
            --this.parent.nesting;
            stringBuffer.append(this.parent.getIndent() + "}" + eol);
        }
    }

    void returningClause(Vector vector, Vector vector2, Vector vector3, Vector vector4) throws GeneralErrorException, EndOfProgramException {
        Token token;
        this.addToQuery(" RETURNING");
        while ((token = this.getSqlToken()).getToknum() != 432 && token.getToknum() != 542) {
            if (token.getToknum() == 58) {
                VariableName variableName = this.getHostVariable();
                if (vector == null) {
                    vector = new Vector<VariableName>();
                    vector2 = new Vector<Object>();
                }
                vector.add(variableName);
                vector2.add(null);
                this.addToken(new Token(63, " ?", 0, 0, null));
                continue;
            }
            this.addToken(token);
        }
        if (token.getToknum() == 542) {
            this.addToken(token);
            this.into(vector3, vector4);
            for (int i2 = 0; i2 < vector3.size(); ++i2) {
                if (i2 > 0) {
                    this.addToQuery(",");
                }
                this.addToQuery(" ?");
            }
        } else {
            throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
        }
    }

    public void fillParmInds(Vector vector, Vector vector2) throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (vector.elementAt(i2) != null) continue;
            VariableDeclaration variableDeclaration = null;
            Object e2 = vector2.elementAt(i2);
            if (e2 instanceof VariableName) {
                variableDeclaration = ((VariableName)e2).getVarDecl();
            } else if (((Token)e2).getToknum() == 10009) {
                variableDeclaration = this.pc.getAllVariables().get(((Token)e2).getWord()).getFirst();
            }
            if (variableDeclaration == null || !variableDeclaration.isNumeric()) continue;
            VariableName variableName = new VariableName(new Token(10009, "$$IND$$_" + n2++, token.getFLN(), token.getOffset(), token.getFileName()));
            if (n2 > this.pc.indCount) {
                variableDeclaration = VariableDeclaration.getIndicator(this.pc, variableName, this.tm, this.error);
                this.pc.fixedVars.addItem(variableDeclaration);
                this.pc.loadVariable(variableDeclaration);
                variableDeclaration.setUsed();
                ++this.pc.indCount;
            }
            variableName.setVarDecl(variableDeclaration);
            vector.setElementAt(variableName, i2);
            variableName.check(this.pc);
        }
        this.ungetSqlToken();
    }

    protected String getInstanceName() {
        return this.getInstanceName(this.pc);
    }

    protected String getInstanceName(Pcc pcc) {
        if (pcc.isFactory()) {
            return pcc.getClassName() + ".class";
        }
        if (pcc.isDefault()) {
            return "$This$";
        }
        return pcc.getClassName() + ".this";
    }

    public void addTokenQuestionMark(VariableName variableName) {
        this.addTokenQuestionMark(variableName, false);
    }

    public void addTokenQuestionMark(VariableName variableName, boolean bl) {
        if (this.db2Esql) {
            int n2 = variableName.getVarDecl().getLogicLen();
            if (n2 == 0 && variableName.getVarDecl().value != null) {
                n2 = variableName.getVarDecl().value.getWord().length() - 2;
            }
            if (variableName.sqlTypeFunc == -1 || variableName.sqlTypeCast || this.prevRealTok == null || this.prevRealTok.getWord().equalsIgnoreCase("CAST")) {
                if (this instanceof SqlSelect && ((SqlSelect)this).isBeforeFromInto() && !((SqlSelect)this).isNextTokFun() && (this.prevRealTok == null || !this.prevRealTok.getWord().equalsIgnoreCase("CAST"))) {
                    if (this.isSqljStat) {
                        if (bl) {
                            this.addToken(new Token(10009, " CAST( :" + variableName.getSqljNameParam() + " AS VARCHAR(" + variableName.getVarDecl().phisicLen + "))", 0, 0, null));
                        } else {
                            this.addToken(new Token(10009, " CAST( :" + variableName.getSqljName() + " AS VARCHAR(" + variableName.getVarDecl().phisicLen + "))", 0, 0, null));
                        }
                    } else {
                        this.addToken(new Token(10009, " CAST(? AS VARCHAR(" + variableName.getVarDecl().phisicLen + "))", 0, 0, null));
                    }
                } else if (this.isSqljStat) {
                    if (bl) {
                        this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
            } else if (variableName.sqlTypeFunc == 93) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (bl) {
                        this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                if (n2 > 10) {
                    this.addToken(new Token(10009, " AS TIMESTAMP)", 0, 0, null));
                } else {
                    this.addToken(new Token(10009, " AS DATE)", 0, 0, null));
                }
            } else if (variableName.sqlTypeFunc == 3 && !variableName.isNumeric() && n2 > 4) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (bl) {
                        this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                this.addToken(new Token(10009, " AS INT)", 0, 0, null));
            } else if (variableName.sqlTypeFunc != -1) {
                this.addToken(new Token(10009, " CAST(", 0, 0, null));
                if (this.isSqljStat) {
                    if (bl) {
                        this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
                if (variableName.sqlTypeFunc == 91 && variableName.getVarDecl().phisicLen == 7) {
                    this.addToken(new Token(10009, " AS VARCHAR(7))", 0, 0, null));
                } else if (sqlTypesCast.get(variableName.sqlTypeFunc).equals("VARCHAR") || sqlTypesCast.get(variableName.sqlTypeFunc).equals("CHAR")) {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(variableName.sqlTypeFunc) + "(" + variableName.getVarDecl().phisicLen + "))", 0, 0, null));
                } else if (sqlTypesCast.get(variableName.sqlTypeFunc).equals("DECIMAL")) {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(variableName.sqlTypeFunc) + "(" + variableName.getVarDecl().phisicLen + "," + variableName.getVarDecl().getDecimals() + "))", 0, 0, null));
                } else {
                    this.addToken(new Token(10009, " AS " + sqlTypesCast.get(variableName.sqlTypeFunc) + ")", 0, 0, null));
                }
            } else if (this instanceof SqlSelect && ((SqlSelect)this).isBeforeFromInto() && !((SqlSelect)this).isNextTokFun()) {
                if (this.isSqljStat) {
                    this.addToken(new Token(10009, " CAST(? AS VARCHAR" + variableName.getVarDecl().phisicLen + "))", 0, 0, null));
                } else if (this.isSqljStat) {
                    if (bl) {
                        this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
                    } else {
                        this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
                    }
                } else {
                    this.addToken(new Token(63, " ?", 0, 0, null));
                }
            }
        } else if (this.isSqljStat) {
            if (bl) {
                this.addToken(new Token(10009, " :" + variableName.getSqljNameParam(), 0, 0, null));
            } else {
                this.addToken(new Token(10009, " :" + variableName.getSqljName(), 0, 0, null));
            }
        } else {
            this.addToken(new Token(63, " ?", 0, 0, null));
        }
    }

    public boolean isTypeCast(Token token) {
        return sqlTypesCast.contains(token.getWord().toUpperCase()) || token.getWord().toUpperCase().equals("DAYS") || token.getWord().toUpperCase().equals("DAY") || token.getWord().toUpperCase().equals("MINUTE") || token.getWord().toUpperCase().equals("MINUTES") || token.getWord().toUpperCase().equals("SECOND") || token.getWord().toUpperCase().equals("SECONDS") || token.getWord().toUpperCase().equals("HOUR") || token.getWord().toUpperCase().equals("YEARS") || token.getWord().toUpperCase().equals("YEAR") || token.getWord().toUpperCase().equals("MONTH");
    }

    public void setIteratotName(Token token) {
        String string = token.getFileName().replace("\\", "/").replace(":", "");
        if (string.contains("/")) {
            string = string.substring(string.lastIndexOf("/") + 1);
        }
        this.iterator = this.iterator + string.replace(".", "_").replace("/", "_").replace("/", "_").replace("-", "_") + token.getFLN();
    }
}

