/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlVar
extends SqlStatement {
    static final int SQL_TYPE_NOBIN = 0;
    static final int SQL_TYPE_BINARY = 1;
    VariableName var;
    int sqlType = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlVar(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors, false);
        Token token2 = this.tm.getToken();
        if (token2 == null || token2.getToknum() != 10009) throw new GeneralErrorException(15, 4, token2, token2.getWord(), this.error);
        this.ungetSqlToken();
        this.var = VariableName.get(this.tm, this.error, this.pc);
        token2 = this.getSqlToken();
        if (token2 == null || !token2.getWord().equalsIgnoreCase("IS")) throw new GeneralErrorException(15, 4, token2, token2.getWord(), this.error);
        token2 = this.getSqlToken();
        if (token2 == null) throw new GeneralErrorException(12, 4, null, "", this.error);
        if (token2.getWord().equalsIgnoreCase("LONG")) {
            token2 = this.tm.getToken();
        }
        this.sqlType = token2 != null && token2.getWord().equalsIgnoreCase("RAW") || token2.getWord().equalsIgnoreCase("BINARY") ? 1 : 0;
        while ((token2 = this.getSqlToken()) != null && token2.getToknum() != 432) {
        }
        this.ungetAllSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sqlType == 1) {
            stringBuffer.append(this.var.getName().replace('-', Pcc.hyphenRepl) + ".setSqlBinary();" + eol);
        }
        return stringBuffer.toString();
    }
}

