/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class SqlWhenever
extends SqlStatement {
    private boolean notFound;
    public final VariableName sqlwarn0;
    private Verb imperative;
    private boolean hasGoto = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlWhenever(ExecSql execSql, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(execSql, token, block, pcc, tokenManager, errors);
        Token token2 = this.getSqlToken();
        String string = token2.getWord().toUpperCase();
        if (token2.getToknum() == 598) {
            this.sqlwarn0 = null;
            token2 = this.getSqlToken();
            if (!"FOUND".equals(token2.getWord().toUpperCase())) throw new ExpectedFoundException(token2, this.error, "FOUND");
            this.notFound = true;
        } else if ("SQLWARNING".equals(string)) {
            this.sqlwarn0 = new VariableName(new Token(10009, "SQLWARN0", token.getFLN(), token.getOffset(), token.getFileName()));
            this.sqlwarn0.check(this.pc);
        } else {
            if (!"SQLERROR".equals(string)) {
                this.sqlwarn0 = null;
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.sqlwarn0 = null;
        }
        token2 = this.getSqlToken();
        if ("DO".equals(token2.getWord().toUpperCase())) {
            token2 = this.getSqlToken();
        }
        if ("GOTO".equals(token2.getWord().toUpperCase())) {
            token2.setToknum(503);
        }
        if (token2.getToknum() == 503) {
            this.hasGoto = true;
            this.imperative = new Goto(token2, this.parent, this.pc, this.tm, this.error);
            return;
        } else if (token2.getToknum() == 632) {
            this.imperative = new Perform(token2, this.parent, this.pc, this.tm, this.error);
            return;
        } else if (token2.getToknum() == 313) {
            this.imperative = new Call(token2, this.parent, this.pc, this.tm, this.error);
            return;
        } else {
            if (token2.getToknum() == 372) return;
            throw new UnexpectedTokenException(token2, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.imperative != null) {
            this.imperative.check();
        }
    }

    public boolean isWarning() {
        return this.sqlwarn0 != null;
    }

    public boolean isNotFound() {
        return this.notFound;
    }

    public boolean hasGoto() {
        return this.hasGoto;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.imperative != null) {
            if (this.notFound) {
                stringBuffer.append("{ final int $sqlCode = " + this.pc.sqlca.SQLCODE + ".toint();");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if ($sqlCode == Esql.getSqlcode100()) {");
            } else if (this.isWarning()) {
                stringBuffer.append("{ if (" + this.pc.sqlca.SQLWARN0 + ".compareTo(Factory.getStrLiteral(\"W\")");
                Alphabet alphabet = null;
                if (this.pc != null) {
                    alphabet = this.pc.getProgramCollatingSeq();
                }
                if (alphabet != null) {
                    stringBuffer.append("," + alphabet.getDeclUnivoqueName());
                }
                stringBuffer.append(")==0) {");
            } else {
                stringBuffer.append("{ final int $sqlCode = " + this.pc.sqlca.SQLCODE + ".toint();");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("if ($sqlCode != 0 && $sqlCode != Esql.getSqlcode100()) {");
            }
            stringBuffer.append(eol);
            stringBuffer.append(this.imperative.getCode());
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} }");
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public Verb getImperative() {
        return this.imperative;
    }
}

