/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.LikeFlags;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Start
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_EQ = 1;
    public static final int OP_GE = 3;
    public static final int OP_LE = 4;
    public static final int OP_GT = 5;
    public static final int OP_LT = 6;
    public static final int OP_FIRST = 7;
    public static final int OP_LAST = 8;
    private Select sel;
    private InvalidKey invKey;
    private VariableName keyName;
    private Token keyIndexTk;
    private VariableName keyIndexVn;
    private VariableDeclaration[] key;
    private int type = 0;
    private int op = 0;
    private Expression withLength;
    private int varKeySize;
    private LikeFlags whileLike;
    private VariableName whileRegexVar;
    private Token whileRegexTok;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Start(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Object object;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 777) {
            this.type = 777;
            return;
        }
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(token2.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, token2.getWord(), this.error);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 489 || token2.getToknum() == 554 || token2.getToknum() == 551) {
            this.type = token2.getToknum();
            if (this.type == 551) {
                if (this.sel.isXml()) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 545) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                    this.tm.ungetToken();
                    this.keyName = VariableName.get(this.tm, this.error, this.pc);
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 528) {
                        token2 = this.tm.getToken();
                        if (token2.getToknum() == 545) {
                            token2 = this.tm.getToken();
                        }
                        if (token2.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.keyIndexVn = VariableName.get(this.tm, this.error, this.pc);
                            return;
                        } else {
                            if (!Token.isIntLit(token2)) throw new GeneralErrorException(22, 4, this.keyWord, token2.getWord(), this.error);
                            this.keyIndexTk = token2;
                        }
                        return;
                    } else {
                        this.tm.ungetToken();
                    }
                    return;
                }
                this.relationalOperator();
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error);
                if (this.sel.organization == 677) {
                    this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                } else {
                    this.key = this.sel.getKeyByName(this.keyName.getName());
                    if (this.key == null) {
                        this.keyName.check(this.pc);
                        this.varKeySize = this.keyName.getVarDecl().getPhisicLen();
                        object = this.pc.getFdByRecord(this.keyName.getVarDecl().getGrandPa());
                        if (object != null) {
                            if (((FileDescriptor)object).sel != this.sel || !((FileDescriptor)object).getVirtualParent().isChild(this.keyName.getName())) {
                                throw new GeneralErrorException(56, 4, this.keyWord, token2.getWord(), this.error);
                            }
                            this.key = this.sel.getKeyByOffset(this.keyName.getVarDecl().getOffset());
                        }
                        if (this.key == null) {
                            throw new GeneralErrorException(56, 4, this.keyWord, token2.getWord(), this.error);
                        }
                    }
                }
            }
        } else {
            this.tm.ungetToken();
        }
        if ((token2 = this.tm.getToken()).getToknum() == 813 || token2.isLength() || token2.getToknum() == 728) {
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (!token2.isLength() && token2.getToknum() != 728) {
                throw new ExpectedFoundException(token2, this.error, "LENGTH");
            }
            object = new int[]{0};
            this.withLength = new Expression((int[])object, token, block, pcc, tokenManager, errors);
            if (!this.withLength.isNumeric()) {
                throw new GeneralErrorException(49, 4, token, token.getWord(), this.error);
            }
            if (object[0] != 0) {
                throw new GeneralErrorException(44, 4, token, token.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if ("WHILE".equals(token2.getWord())) {
            if (this.sel.organization != 529) {
                throw new ClauseClashException(token2, this.error, "WHILE");
            }
            token2.setToknum(10025);
            token2 = this.tm.getToken();
            if (token2.getToknum() == 551) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 545) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 598) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 561) {
                throw new ExpectedFoundException(token2, this.error, "LIKE");
            }
            this.whileLike = new LikeFlags(this.tm, this.error, this.pc);
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.whileRegexVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (token2.getToknum() != 10001) throw new UnexpectedTokenException(token2, this.error);
                this.whileRegexTok = token2;
            }
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        token2 = this.tm.getToken();
        if (token2.getToknum() != 447) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    void relationalOperator() throws GeneralErrorException, EndOfProgramException {
        boolean bl = false;
        Token token = this.tm.getToken();
        if (token.getToknum() == 545) {
            token = this.tm.getToken();
        }
        if (token.getToknum() == 489) {
            this.op = 7;
            return;
        }
        if (token.getToknum() == 554) {
            this.op = 8;
            return;
        }
        if (token.getToknum() == 598) {
            bl = true;
            token = this.tm.getToken();
        }
        switch (token.getToknum()) {
            case 61: 
            case 462: 
            case 463: {
                if (bl) {
                    throw new ClauseClashException(token, this.error, "NOT");
                }
                this.op = 1;
                token = this.tm.getToken();
                if (token.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 60: 
            case 62: 
            case 471: 
            case 507: 
            case 560: {
                this.op = token.getToknum() == 560 || token.getToknum() == 60 ? (bl ? 3 : 6) : (bl ? 4 : 5);
                token = this.tm.getToken();
                if (token.getToknum() == 761) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 617) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 462 || token.getToknum() == 61 || token.getToknum() == 463) {
                    switch (this.op) {
                        case 3: {
                            this.op = 5;
                            break;
                        }
                        case 6: {
                            this.op = 4;
                            break;
                        }
                        case 4: {
                            this.op = 6;
                            break;
                        }
                        case 5: {
                            this.op = 3;
                        }
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 773) break;
                    this.tm.ungetToken();
                    break;
                }
                if (token.getToknum() == 761) break;
                this.tm.ungetToken();
                break;
            }
            default: {
                throw new UnexpectedTokenException(token, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.whileLike != null && this.whileRegexTok != null) {
            this.whileLike.check(this.whileRegexTok);
        }
    }

    @Override
    public String getCode() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (this.sel != null && this.sel.isXml()) {
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".startXml(");
            if (this.keyName != null) {
                stringBuffer.append(this.keyName.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(",");
            if (this.keyIndexTk != null) {
                stringBuffer.append(this.tm.getCodeLiteral(this.keyIndexTk)).append(".toint()");
            } else if (this.keyIndexVn != null) {
                stringBuffer.append(this.keyIndexVn.getCode()).append(".toint()");
            } else {
                stringBuffer.append("1");
            }
            stringBuffer.append(");");
        } else {
            if (this.type == 777) {
                stringBuffer.append("Factory.beginTrans();");
                stringBuffer.append(eol);
                Use.putDeclTransaction(stringBuffer, this.pc, this.parent.getIndent());
                this.getCodeDebugEnd(stringBuffer);
                return stringBuffer.toString();
            }
            if (this.invKey != null) {
                stringBuffer.append(this.invKey.getCodeBefore());
            }
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".start(");
            if (this.type == 551) {
                if (this.op == 0) {
                    this.op = 1;
                }
                if (this.key == null) {
                    if (this.sel.organization == 529) {
                        this.key = this.sel.getPrimaryKey();
                    } else if (this.sel.organization == 677) {
                        this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                    }
                }
                if (this.key != null) {
                    stringBuffer.append("new CobolVar[] {");
                    n2 = 0;
                    while (true) {
                        stringBuffer.append(this.key[n2].getQualUnivoqueName());
                        if (++n2 >= this.key.length) break;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append("null");
                }
            } else {
                if (this.sel.organization == 529) {
                    this.key = this.sel.getPrimaryKey();
                } else if (this.sel.organization == 677) {
                    this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                }
                if (this.key != null) {
                    stringBuffer.append("new CobolVar[] {");
                    n2 = 0;
                    while (true) {
                        stringBuffer.append(this.key[n2].getQualUnivoqueName());
                        if (++n2 >= this.key.length) break;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append("null");
                }
            }
            stringBuffer.append(",");
            if (this.type == 489) {
                stringBuffer.append("CobolFile.START_FIRST");
            } else if (this.type == 554) {
                stringBuffer.append("CobolFile.START_LAST");
            } else {
                switch (this.op) {
                    case 1: {
                        stringBuffer.append("CobolFile.START_EQUAL");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("CobolFile.START_LTEQ");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("CobolFile.START_GREAT");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("CobolFile.START_LESS");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("CobolFile.START_FIRST");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("CobolFile.START_LAST");
                        break;
                    }
                    default: {
                        stringBuffer.append("CobolFile.START_GTEQ");
                    }
                }
            }
            stringBuffer.append(",");
            if (this.withLength != null) {
                stringBuffer.append(this.withLength.getCode());
                stringBuffer.append(".intValue())");
            } else {
                stringBuffer.append(this.varKeySize);
                stringBuffer.append(")");
            }
            stringBuffer.append(";");
            if (this.whileLike != null && this.key != null) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(this.sel.getName());
                stringBuffer.append(".like(new CobolVar[] {");
                n2 = 0;
                while (true) {
                    stringBuffer.append(this.key[n2].getQualUnivoqueName());
                    if (++n2 >= this.key.length) break;
                    stringBuffer.append(",");
                }
                stringBuffer.append("},");
                if (this.whileRegexVar != null) {
                    stringBuffer.append(this.whileRegexVar.getCode());
                } else {
                    stringBuffer.append(this.getCodeLiteral(this.whileRegexTok));
                }
                stringBuffer.append(",");
                stringBuffer.append(this.whileLike.getCode());
                stringBuffer.append(");");
            }
        }
        Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
        if (this.invKey != null) {
            stringBuffer.append(this.invKey.getCode());
        }
        n2 = this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null ? 1 : 0;
        Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), n2 != 0);
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public int getType() {
        return this.type;
    }

    public int getOp() {
        return this.op;
    }

    public Expression getWithLength() {
        return this.withLength;
    }

    public VariableDeclaration[] getKey() {
        return this.key;
    }

    public InvalidKey getInvalidKey() {
        return this.invKey;
    }

    public Select getSelect() {
        return this.sel;
    }

    public int getVarKeySize() {
        return this.varKeySize;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

