/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Stop
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token label;
    private Token rCode;
    private VariableName retCode;
    private VariableNameList threadHandles;
    boolean guiWd2UnsupportedLog;

    public Stop(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 703) {
            if (this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, token, token.getWord().toUpperCase() + " " + token2.getWord());
            }
            if ((token2 = this.tm.getToken()).getToknum() == 505 || token2.getToknum() == 694) {
                token2 = this.tm.getToken();
            }
            if (Token.isIntLit(token2)) {
                this.rCode = token2;
            } else if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.retCode = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            } else {
                this.tm.ungetToken();
            }
        } else if (token2.getToknum() == 10001 || token2.getToknum() == 10002 || token2.getToknum() == 10017) {
            this.label = token2;
        } else if (token2.getToknum() == 10009) {
            this.label = token2;
            this.tm.ungetToken();
            this.retCode = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
        } else if (token2.getToknum() == 763) {
            this.threadHandles = new VariableNameList();
            while ((token2 = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                VariableName variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName == null) {
                    token2 = this.tm.getToken();
                    throw new UnexpectedTokenException(token2, this.error);
                }
                if (!variableName.getVarDecl().isValidThreadHandle()) {
                    throw new ClauseClashException(token2, this.error, variableName.getName());
                }
                this.threadHandles.addItem(variableName);
            }
            this.tm.ungetToken();
            if (this.pc.getOption("-ca") != null) {
                this.error.print(148, 2, this.keyWord, "STOP THREAD");
            }
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        boolean bl = this.pc.getOption("-d") != null;
        String[] stringArray = this.pc.getOutddProperty();
        if (this.label != null && bl) {
            object = this.label.getToknum() != 10009 ? "\"" + this.label.getCode() + "\"" : this.retCode.getCode() + ".toString()";
            stringBuffer.append("Debugger.stop(");
            stringBuffer.append(Pcc.getInddProperty());
            stringBuffer.append(',');
            stringBuffer.append(stringArray[0]);
            stringBuffer.append(',');
            stringBuffer.append(stringArray[1]);
            stringBuffer.append(',');
            stringBuffer.append(stringArray[2]);
            stringBuffer.append(',');
            stringBuffer.append((String)object);
            stringBuffer.append(");");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        this.getCodeDebug(stringBuffer);
        if (this.threadHandles != null) {
            int n2 = this.threadHandles.getItemNum();
            if (n2 > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("Factory.stopThread (");
                    stringBuffer.append(this.threadHandles.getAt(i2).getCode());
                    stringBuffer.append(");");
                }
            } else {
                stringBuffer.append("Factory.stopThread (null);");
            }
            stringBuffer.append(eol);
        } else if (this.label == null) {
            if (!this.pc.isFactory()) {
                if (this.pc.getSplitFlag()) {
                    stringBuffer.append(this.pc.getClassName() + ".this.");
                } else {
                    object = this.pc.getRoot();
                    if (object != this.pc) {
                        if (this.pc.isDefault()) {
                            stringBuffer.append("$This$.");
                        } else {
                            stringBuffer.append(((Pcc)object).getFullClassName() + ".this.");
                        }
                    }
                }
                stringBuffer.append("finalize();" + eol);
            }
            stringBuffer.append(this.parent.getIndent());
            Stop.getStopRunCode(stringBuffer, this.pc.capitalizeNames, this.retCode, this.rCode);
            stringBuffer.append(eol);
        } else if (!bl) {
            object = this.label.getToknum() != 10009 ? "\"" + this.label.getCode() + "\"" : this.retCode.getCode() + ".toString()";
            stringBuffer.append("Factory.displayUponSysOut(");
            stringBuffer.append(stringArray[0]);
            stringBuffer.append(',');
            stringBuffer.append(stringArray[1]);
            stringBuffer.append(',');
            stringBuffer.append(stringArray[2]);
            stringBuffer.append(",false,");
            stringBuffer.append((String)object);
            stringBuffer.append(");");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("Factory.acceptFromConsole(");
            stringBuffer.append(Pcc.getInddProperty());
            stringBuffer.append(");");
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public static void getStopRunCode(StringBuffer stringBuffer, boolean bl, VariableName variableName, Token token) {
        stringBuffer.append("if(true) throw new StopRunException(");
        if (variableName == null) {
            if (token == null) {
                stringBuffer.append(Stop.getReturnCode(bl) + ".toint()");
            } else {
                stringBuffer.append(token.getAsInt());
            }
        } else {
            stringBuffer.append(variableName.getCode() + ".num().intValue()");
        }
        stringBuffer.append(");" + eol);
    }

    public boolean isStopRun() {
        if (this.threadHandles != null) {
            return false;
        }
        return this.label == null;
    }

    public boolean isStopThread() {
        if (this.threadHandles != null) {
            return true;
        }
        if (this.label == null) {
            return false;
        }
        return false;
    }

    public Token getLabel() {
        return this.label;
    }

    public VariableName getRetCode() {
        return this.retCode;
    }

    public Token getRCode() {
        return this.rCode;
    }
}

