/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Exec;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VerbList;
import com.iscobol.interfaces.compiler.IDataSection;

public abstract class StorageSection
implements CobolToken,
ErrorsNumbers,
IDataSection {
    TokenManager tm;
    Errors error;
    Pcc pc;
    VariableDeclarationList vars = new VariableDeclarationList();
    int memoryOffset = 0;
    final boolean memIn1block;
    final boolean optionXMS;
    final boolean optionXMSN;
    final byte defaultByte;
    final int align;
    Token firstToken;
    Token lastToken;
    private VerbList execList = new VerbList();

    public StorageSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        int n2;
        this.firstToken = token;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        this.memIn1block = this.pc.getOption("-m1") != null && pcc.getRoot() instanceof CobolProgram;
        this.optionXMS = this.pc.getOption("-xms") != null;
        this.optionXMSN = this.pc.getOption("-xmsn") != null;
        try {
            n2 = Integer.parseInt(this.pc.getOption("-align="));
            if (n2 < 1) {
                n2 = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 1;
        }
        this.align = n2;
        this.defaultByte = VariableDeclaration.getDefaultByte(this.pc.getOptions(), false, true);
    }

    void getCodeHeader(StringBuffer stringBuffer) {
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.getCodeHeader(stringBuffer2);
        if (this.memIn1block) {
            if (this.optionXMS) {
                if (this.optionXMSN) {
                    stringBuffer2.append("   public Memory wsMem=Factory.getNotOptmzdMem(");
                } else {
                    stringBuffer2.append("   public Memory wsMem = Factory.getMem (");
                }
            } else {
                stringBuffer2.append("   public byte wsMem[] = Factory.getMem (");
            }
            stringBuffer2.append(this.memoryOffset);
            if (this.defaultByte != 32) {
                stringBuffer2.append(", (byte)");
                stringBuffer2.append(this.defaultByte);
            }
            stringBuffer2.append(");" + eol);
            stringBuffer2.append(eol);
        }
        CobolToken cobolToken = this.vars.getFirst();
        while (cobolToken != null) {
            stringBuffer2.append(((VariableDeclaration)cobolToken).getCode(stringBuffer));
            cobolToken = this.vars.getNext();
        }
        cobolToken = (Exec)this.execList.getFirst();
        while (cobolToken != null) {
            ((Exec)cobolToken).getCode(stringBuffer);
            cobolToken = (Exec)this.execList.getNext();
        }
        return stringBuffer2.toString();
    }

    @Override
    public final VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public final Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public final Token getLastToken() {
        return this.lastToken;
    }

    protected void exec(Token token) throws GeneralErrorException, EndOfProgramException {
        try {
            this.execList.addItem(new Exec(token, null, this.pc, this.tm, this.error));
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        token = this.tm.getToken();
        if (token.getToknum() != 10006) {
            this.tm.ungetToken();
        }
    }

    public VerbList getExecList() {
        return this.execList;
    }

    static int calcAlign(int n2, int n3) {
        return n3 - n2 % n3 & n3 - 1;
    }
}

