/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Enumeration;
import java.util.Vector;

public class Strings
extends Verb
implements CobolToken,
ErrorsNumbers {
    Vector itemList = new Vector();
    VariableName destination = null;
    VariableName pointer = null;
    Vector src = new Vector();
    Vector delimiters = new Vector();
    Block overflowBlock;
    Block notOverflowBlock;
    boolean destNational;
    private boolean hasNational;

    public Strings(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.allowAllLitGen = false;
        Token token2 = this.tm.getToken();
        boolean bl = false;
        do {
            VariableName variableName;
            int n2 = 0;
            while (true) {
                if (token2.getToknum() == 10001) {
                    this.itemList.addElement(token2);
                } else if (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    variableName = VariableName.get(this.tm, this.error, this.pc);
                    if (!variableName.isUsageDisplay()) {
                        this.error.print(288, 3, token2, token2.getWord());
                    }
                    this.setHasNational(variableName);
                    this.itemList.addElement(variableName);
                } else if (token2.isFigurativeZero()) {
                    token2 = Strings.cloneToken(token2, 10001, "'0'");
                    this.itemList.addElement(token2);
                } else {
                    if (n2 != 0) break;
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
                ++n2;
            }
            Delim delim = new Delim();
            if (token2.getToknum() != 398) {
                this.src.addElement(this.itemList);
                delim.delimSize = true;
                this.delimiters.addElement(delim);
            } else {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 312) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 776) {
                    delim.isTrailing = true;
                    token2 = this.tm.getToken();
                }
                switch (token2.getToknum()) {
                    case 10002: {
                        if (token2.isFigurativeZero()) {
                            token2 = Strings.cloneToken(token2, 10001, "'0'");
                        }
                    }
                    case 10001: {
                        this.src.addElement(this.itemList);
                        if (delim.isTrailing && token2.getWord().length() > 3) {
                            throw new GeneralErrorException(69, 4, token2, token2.getWord(), this.error);
                        }
                        delim.delimTk = token2;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        variableName = VariableName.get(this.tm, this.error, this.pc);
                        if (!variableName.isUsageDisplay()) {
                            throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                        }
                        if (delim.isTrailing && variableName.getVariableLength() > 1) {
                            throw new GeneralErrorException(69, 4, variableName.getNameToken(), variableName.getName(), this.error);
                        }
                        this.setHasNational(variableName);
                        this.src.addElement(this.itemList);
                        delim.delimVn = variableName;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    case 728: {
                        if (delim.isTrailing) {
                            throw new UnexpectedTokenException(token2, this.error);
                        }
                        this.src.addElement(this.itemList);
                        delim.delimSize = true;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    default: {
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                }
                token2 = this.tm.getToken();
            }
            this.itemList = new Vector();
        } while (token2.getToknum() != 542);
        token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.destination = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
        if (!this.destination.isUsageDisplay() || this.destination.getVarDecl().isEdited() || this.destination.getVarDecl().isJustified() && this.pc.getOption("-ca") == null && this.pc.getOption("-cm") == null) {
            throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
        }
        this.setHasNational(this.destination);
        this.destNational = this.destination.getVarDecl().isNational;
        token2 = this.tm.getToken();
        if (token2.getToknum() == 813 && (token2 = this.tm.getToken()).getToknum() != 638) {
            throw new ExpectedFoundException(token2, this.error, "'POINTER'");
        }
        if (token2.getToknum() == 638) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.pointer = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.pointer.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 598 || token2.getToknum() == 613 || token2.getToknum() == 624) {
            boolean bl2 = false;
            if (token2.getToknum() == 598) {
                bl = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 613) {
                bl2 = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 624) {
                if (bl) {
                    this.notOverflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 10);
                } else {
                    this.overflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 9);
                }
                token2 = this.tm.getToken();
                if (!bl && token2.getToknum() == 598) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 613) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() == 624) {
                        this.notOverflowBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (bl) {
                    this.tm.ungetToken();
                }
                if (bl2) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 448) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token token, int n2, String string) {
        Token token2 = new Token(token);
        token2.setToknum(n2);
        token2.setWord(string);
        token2.setAll(token.isAll());
        return token2;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.overflowBlock != null) {
            stringBuffer.append("if(");
        } else if (this.notOverflowBlock != null) {
            stringBuffer.append("if(!");
        }
        stringBuffer.append(this.destination.getCode());
        stringBuffer.append(".string");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        stringBuffer.append("(");
        stringBuffer.append(this.getSourceCode());
        if (this.pointer != null) {
            stringBuffer.append("," + this.pointer.getCode());
        } else {
            stringBuffer.append(",null");
        }
        stringBuffer.append(",");
        stringBuffer.append(this.pc.getOption("-cudc") != null);
        stringBuffer.append(")");
        if (this.overflowBlock != null || this.notOverflowBlock != null) {
            stringBuffer.append(")");
            if (this.overflowBlock != null) {
                stringBuffer.append(this.overflowBlock.getCode());
                if (this.notOverflowBlock != null) {
                    stringBuffer.append(" else ");
                    stringBuffer.append(this.notOverflowBlock.getCode());
                }
            } else if (this.notOverflowBlock != null) {
                stringBuffer.append(this.notOverflowBlock.getCode());
            }
        } else {
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private String getSourceCode() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer.append("new CobolVar[] {");
        stringBuffer2.append("new CobolVar[] {");
        stringBuffer3.append("new boolean[] {");
        Enumeration enumeration = this.src.elements();
        Enumeration enumeration2 = this.delimiters.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration3 = ((Vector)enumeration.nextElement()).elements();
            Delim delim = (Delim)enumeration2.nextElement();
            while (enumeration3.hasMoreElements()) {
                CobolToken cobolToken;
                Object e2 = enumeration3.nextElement();
                if (e2 instanceof Token) {
                    cobolToken = (Token)e2;
                    if (this.destNational && ((Token)cobolToken).isFigurativeHighValue()) {
                        ((Token)cobolToken).setAll(false);
                        ((Token)cobolToken).setNational(true);
                    }
                    stringBuffer.append(this.getCodeLiteral((Token)e2));
                } else {
                    cobolToken = (VariableName)e2;
                    stringBuffer.append(((VariableName)cobolToken).getCode());
                    if (!this.hasNational && ((VariableName)cobolToken).getVarDecl() == this.destination.getVarDecl() && !((VariableName)cobolToken).getVarDecl().isAnyLength() && this.pc.getOption("-b") != null) {
                        stringBuffer.append(".copy()");
                    }
                }
                if (delim.delimSize) {
                    stringBuffer2.append("null");
                } else if (delim.delimTk != null) {
                    if (this.destNational && delim.delimTk.isFigurativeHighValue()) {
                        delim.delimTk.setAll(false);
                        delim.delimTk.setNational(true);
                    }
                    stringBuffer2.append(this.getCodeLiteral(delim.delimTk));
                } else {
                    stringBuffer2.append(delim.delimVn.getCode());
                }
                stringBuffer3.append(delim.isTrailing);
                if (!enumeration3.hasMoreElements() && !enumeration.hasMoreElements()) continue;
                stringBuffer.append(",");
                stringBuffer2.append(",");
                stringBuffer3.append(",");
            }
        }
        stringBuffer.append(" }");
        stringBuffer2.append(" }");
        stringBuffer3.append(" }");
        return stringBuffer.append(",").append(stringBuffer2).append(",").append(stringBuffer3).toString();
    }

    public Vector getSources() {
        return this.src;
    }

    public Vector getDelimiters() {
        return this.delimiters;
    }

    public Block getOverflowBlock() {
        return this.overflowBlock;
    }

    public Block getNotOverflowBlock() {
        return this.notOverflowBlock;
    }

    public VariableName getDestination() {
        return this.destination;
    }

    public VariableName getPointer() {
        return this.pointer;
    }

    private void setHasNational(VariableName variableName) {
        if (!this.hasNational) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            this.hasNational = variableDeclaration != null && (variableDeclaration.isNational() || variableDeclaration.isPicG());
        }
    }

    public static class Delim {
        public Token delimTk;
        public VariableName delimVn;
        public boolean isTrailing;
        public boolean delimSize;
    }
}

