/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.ISubscript;

public class Subscript
implements CobolToken,
ErrorsNumbers,
ISubscript {
    private Expression expIdx;
    private boolean all;
    char operator;
    private String index;

    public static Subscript get(TokenManager tokenManager, Errors errors, Pcc pcc, Token token) throws EndOfProgramException, GeneralErrorException {
        Subscript subscript = Subscript.get(tokenManager, errors, pcc);
        return subscript;
    }

    public static Subscript get(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        Subscript subscript = new Subscript();
        subscript.expIdx = new Expression(new int[]{0}, null, null, pcc, tokenManager, errors);
        if (subscript.expIdx.isVoid()) {
            subscript = null;
        }
        return subscript;
    }

    public static Subscript getWithAll(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        Subscript subscript;
        if (tokenManager.getToken(false).getToknum() == 262) {
            subscript = new Subscript();
            subscript.all = true;
        } else {
            tokenManager.ungetToken();
            subscript = Subscript.get(tokenManager, errors, pcc);
        }
        return subscript;
    }

    static Subscript get(String string) {
        Subscript subscript = new Subscript();
        subscript.index = string;
        return subscript;
    }

    void check(Token token, Errors errors, Pcc pcc) throws GeneralErrorException {
        if (!this.all && this.index == null) {
            if (!this.expIdx.isNumeric() && !this.expIdx.isPrimitiveInteger()) {
                throw new GeneralErrorException(49, 4, token, this.expIdx.toString(), errors);
            }
            token = this.expIdx.getAsToken();
            if (token != null && token.getToknum() != 10002) {
                throw new GeneralErrorException(22, 4, token, token.getWord(), errors);
            }
        }
    }

    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.all) {
            stringBuffer.append('0');
        } else {
            if (this.index != null) {
                return this.index;
            }
            Token token = this.expIdx.getAsToken();
            if (token != null && token.getToknum() == 10002) {
                stringBuffer.append(token.getAsInt());
            } else {
                boolean bl = this.expIdx.couldBeNativeInt();
                if (bl) {
                    stringBuffer.append("(int) ");
                    stringBuffer.append(this.expIdx.getCode(true));
                } else {
                    stringBuffer.append(this.expIdx.getCode(false));
                    stringBuffer.append(".intValue()");
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public Expression getExpression() {
        return this.expIdx;
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    public boolean isLiteral() {
        if (this.all) {
            return false;
        }
        return this.index != null || this.expIdx.getAsToken() != null;
    }

    @Override
    public boolean isAll() {
        return this.all;
    }
}

