/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Subtract
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private TokenList numList = new TokenList();
    private VariableNameList varList = new VariableNameList();
    private VariableNameList varFromList = new VariableNameList();
    private VariableNameList varGiving = new VariableNameList();
    private Token tokenFrom;
    private boolean giving;
    private boolean corresponding;
    private boolean corrRounded;
    private OnSizeError ose;

    public Subtract(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 381 || token2.getToknum() == 380) {
            this.subCorr(token2, token, block, pcc, tokenManager, errors);
        } else {
            this.subFrom(token2, token, block, pcc, tokenManager, errors);
        }
    }

    private void subFrom(Token token, Token token2, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        block34: {
            variableName = null;
            block11: while (true) {
                switch (token.getToknum()) {
                    case 10001: {
                        if (!token.isNull()) break block11;
                        token.setZero();
                    }
                    case 10002: 
                    case 10017: {
                        this.numList.addItem(token);
                        variableName = null;
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        variableName = VariableName.getAny(this.tm, this.error, this.pc);
                        if (variableName != null && variableName.isNumeric() && !variableName.isEdited()) {
                            this.varList.addItem(variableName);
                            break;
                        }
                        throw new GeneralErrorException(109, 4, variableName.getNameToken(), variableName.getName(), this.error);
                    }
                    default: {
                        break block11;
                    }
                }
                token = this.tm.getToken();
            }
            if (token.getToknum() == 498) {
                block12: while (true) {
                    token = this.tm.getToken();
                    switch (token.getToknum()) {
                        case 702: {
                            if (variableName != null) {
                                variableName.rounded = true;
                                continue block12;
                            }
                            throw new UnexpectedTokenException(token, this.error);
                        }
                        case 10001: {
                            if (!token.isNull()) break block34;
                            token.setZero();
                        }
                        case 10002: 
                        case 10017: {
                            if (this.tokenFrom != null) {
                                throw new UnexpectedTokenException(token, this.error);
                            }
                            this.tokenFrom = token;
                            variableName = null;
                            continue block12;
                        }
                        case 10009: {
                            this.tm.ungetToken();
                            variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                            if (variableName != null && variableName.isNumeric() && !variableName.isEdited()) {
                                this.varFromList.addItem(variableName);
                                continue block12;
                            }
                            throw new GeneralErrorException(109, 4, variableName.getNameToken(), variableName.getName(), this.error);
                        }
                    }
                    break;
                }
            } else {
                throw new ExpectedFoundException(token, this.error, "FROM");
            }
        }
        if (token.getToknum() == 505) {
            this.giving = true;
            token = this.tm.getToken();
            if (token.getToknum() == 10009) {
                while (token.getToknum() == 10009) {
                    this.tm.ungetToken();
                    variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (variableName == null || !variableName.isNumeric()) {
                        throw new GeneralErrorException(109, 4, variableName.getNameToken(), variableName.getName(), this.error);
                    }
                    this.varGiving.addItem(variableName);
                    token = this.tm.getToken();
                    if (token.getToknum() != 702) continue;
                    variableName.rounded = true;
                    token = this.tm.getToken();
                }
                if (this.varFromList.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            if (this.varFromList.getItemNum() > 0) {
                this.varFromList.getFirst().setPropTypeGet();
            }
        } else {
            if (this.tokenFrom != null) {
                throw new GeneralErrorException(17, 4, this.tokenFrom, this.tokenFrom.getWord(), this.error);
            }
            VariableName variableName2 = this.varFromList.getFirst();
            while (variableName2 != null) {
                variableName2.checkPropTypeSetGet();
                variableName2 = this.varFromList.getNext();
            }
        }
        if (!this.giving && variableName == null || this.varList.getItemNum() + this.numList.getItemNum() < 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(token2, block, this, pcc, tokenManager, errors);
        token = this.tm.getToken();
        if (token.getToknum() != 449) {
            this.tm.ungetToken();
        }
    }

    private void subCorr(Token token, Token token2, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        this.corresponding = true;
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName != null) {
                    if (variableName.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
                    }
                    this.varList.addItem(variableName);
                    variableName.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
        }
        token = this.tm.getToken();
        if (token.getToknum() != 498) {
            throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName != null) {
                    this.varFromList.addItem(variableName);
                    variableName.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
            }
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 702: {
                variableName.rounded = true;
                this.corrRounded = true;
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
        this.ose = new OnSizeError(token2, block, this, pcc, tokenManager, errors);
        token = this.tm.getToken();
        if (token.getToknum() != 449) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (this.giving) {
                if (this.varFromList.getItemNum() > 0) {
                    stringBuffer.append(this.varFromList.getFirst().getCode());
                } else {
                    stringBuffer.append(Expression.toNum(this.tokenFrom));
                }
                stringBuffer.append(" - (");
            }
            if (this.varList.getItemNum() > 0) {
                stringBuffer.append(this.varList.getFirst().getCode());
                VariableName variableName = this.varList.getNext();
                while (variableName != null) {
                    stringBuffer.append(" + ");
                    stringBuffer.append(variableName.getCode());
                    variableName = this.varList.getNext();
                }
                Token token = this.numList.getFirst();
                while (token != null) {
                    stringBuffer.append(" + ");
                    stringBuffer.append(Expression.toNum(token));
                    token = this.numList.getNext();
                }
            } else {
                stringBuffer.append(Expression.toNum(this.numList.getFirst()));
                Token token = this.numList.getNext();
                while (token != null) {
                    stringBuffer.append(" + ");
                    stringBuffer.append(Expression.toNum(token));
                    token = this.numList.getNext();
                }
            }
        } else {
            if (this.giving) {
                if (this.varFromList.getItemNum() > 0) {
                    stringBuffer.append(Compute.getCobolNumCode(this.varFromList.getFirst()));
                } else {
                    stringBuffer.append(this.getCodeLiteral(this.tokenFrom));
                    stringBuffer.append(".num()");
                }
                stringBuffer.append(".subtract(");
            }
            if (this.varList.getItemNum() > 0) {
                stringBuffer.append(Compute.getCobolNumCode(this.varList.getFirst()));
                VariableName variableName = this.varList.getNext();
                while (variableName != null) {
                    stringBuffer.append(".add(");
                    stringBuffer.append(Compute.getCobolNumCode(variableName));
                    stringBuffer.append(")");
                    variableName = this.varList.getNext();
                }
                Token token = this.numList.getFirst();
                while (token != null) {
                    stringBuffer.append(".add(");
                    stringBuffer.append(this.getCodeLiteral(token));
                    stringBuffer.append(".num())");
                    token = this.numList.getNext();
                }
            } else {
                stringBuffer.append(this.getCodeLiteral(this.numList.getFirst()));
                stringBuffer.append(".num()");
                Token token = this.numList.getNext();
                while (token != null) {
                    stringBuffer.append(".add(");
                    stringBuffer.append(this.getCodeLiteral(token));
                    stringBuffer.append(".num())");
                    token = this.numList.getNext();
                }
            }
        }
        if (this.giving) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration variableDeclaration;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.varList.getItemNum() == 0 && this.numList.getItemNum() == 1 && this.numList.getFirst().getToknum() == 10002 || this.varList.getItemNum() == 1 && this.numList.getItemNum() == 0 && (variableDeclaration = this.varList.getFirst().getVarDecl()).isInteger() && variableDeclaration.getLogicLen() <= 18)) {
            VariableName variableName = this.varFromList.getFirst();
            while (variableName != null) {
                variableDeclaration = variableName.getVarDecl();
                if (variableName.rounded && variableDeclaration.getPNumber() != 0 || !variableDeclaration.isInteger() || variableDeclaration.getLogicLen() > 18) {
                    return false;
                }
                variableName = this.varFromList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer stringBuffer, String string, VariableDeclaration variableDeclaration, String string2, VariableDeclaration variableDeclaration2) {
        stringBuffer.append(string2);
        stringBuffer.append(".set(");
        stringBuffer.append(string2);
        stringBuffer.append(".num().subtract(");
        stringBuffer.append(string);
        stringBuffer.append(".num()),");
        stringBuffer.append(this.corrRounded);
        if (this.ose.hasBlocks()) {
            stringBuffer.append(",true)|");
        } else {
            stringBuffer.append(",false);");
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.corresponding) {
            this.getCodeDebug(stringBuffer);
            stringBuffer.append(this.ose.getCodeBefore());
            this.getCodeCorresponding(stringBuffer, this.varList.getFirst(), this.varFromList.getFirst(), true);
            if (this.ose.hasBlocks()) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(eol);
            }
            stringBuffer.append(this.ose.getCode());
        } else if (this.isOptimizable()) {
            VariableName variableName = this.varList.getFirst();
            Token token = this.numList.getFirst();
            this.getCodeDebug(stringBuffer);
            VariableName variableName2 = this.varFromList.getFirst();
            while (variableName2 != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(variableName2.getCode());
                stringBuffer.append(".subFromMe(");
                if (token != null) {
                    stringBuffer.append(token.getAsLong());
                } else {
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".tolong()");
                }
                stringBuffer.append(");");
                stringBuffer.append(eol);
                variableName2 = this.varFromList.getNext();
            }
        } else {
            VariableName variableName;
            String string;
            int n2;
            VariableNameList variableNameList = this.varGiving.getItemNum() > 0 ? this.varGiving : this.varFromList;
            boolean bl = true;
            int n3 = this.varList.getItemNum();
            for (n2 = 0; n2 < n3 && bl; bl &= Expression.couldBeNativeInt(this.varList.getAt(n2).getVarDecl()), ++n2) {
            }
            if (bl) {
                if (this.giving) {
                    bl = this.varFromList.getItemNum() > 0 ? (bl &= Expression.couldBeNativeInt(this.varFromList.getFirst().getVarDecl())) : (bl &= Expression.couldBeNativeInt(this.tokenFrom));
                }
                if (bl) {
                    Token token;
                    n3 = this.numList.getItemNum();
                    for (n2 = 0; n2 < n3 && bl; bl &= Expression.couldBeNativeInt(token), ++n2) {
                        token = this.numList.getAt(n2);
                    }
                }
            }
            if (variableNameList.getItemNum() > 1) {
                string = "sub$" + Subtract.getUniqueId();
                stringBuffer.append(this.parent.getIndent());
                if (bl) {
                    stringBuffer.append("long ");
                } else {
                    stringBuffer.append("CobolNum ");
                }
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.getInitialEvaluation(bl));
                stringBuffer.append(";");
                stringBuffer.append(eol);
            } else {
                string = this.getInitialEvaluation(bl);
            }
            stringBuffer.append(this.parent.getIndent());
            this.getCodeDebug(stringBuffer);
            VariableNameList variableNameList2 = new VariableNameList();
            int n4 = 0;
            while (n4 < variableNameList.getItemNum()) {
                variableName = variableNameList.getAt(n4);
                if (variableName.isPrimitive()) {
                    variableNameList2.addItem(variableName);
                    variableNameList.deleteCurrent();
                    continue;
                }
                ++n4;
            }
            n3 = variableNameList2.getItemNum();
            for (n4 = 0; n4 < n3; ++n4) {
                String string2;
                variableName = variableNameList2.getAt(n4);
                stringBuffer.append(variableName.getCode());
                String string3 = variableName.getType().getName(true);
                stringBuffer.append(" = ");
                if (this.giving) {
                    if (bl) {
                        stringBuffer.append(Compute.addCast(string3, string));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, string));
                    }
                } else if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                    if (bl) {
                        string2 = variableName.getCode() + " - (" + string + ")";
                        stringBuffer.append(Compute.addCast(string3, string2));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, "CobolNum.noo((long) " + variableName.getCode() + ", 0).subtract(" + string + ")"));
                    }
                } else if (bl) {
                    string2 = variableName.isNumericVar() ? variableName.getCode() + ".tolong()" : variableName.getCode();
                    string2 = string2 + " - " + string;
                    stringBuffer.append(Compute.addCast(string3, string2));
                } else {
                    string2 = variableName.isNumericVar() ? variableName.getCode() + ".num()" : "CobolNum.noo((double) " + variableName.getCode() + ")";
                    string2 = string2 + ".subtract(" + string + ")";
                    stringBuffer.append(Compute.getConversionMethod(string3, string2));
                }
                stringBuffer.append(";");
                if (n4 >= n3 - 1) continue;
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            n3 = variableNameList.getItemNum();
            if (n3 > 0) {
                if (variableNameList2.getItemNum() > 0) {
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                }
                stringBuffer.append(this.ose.getCodeBefore());
                for (n4 = 0; n4 < n3; ++n4) {
                    variableName = variableNameList.getAt(n4);
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".set(");
                    if (this.giving) {
                        stringBuffer.append(string);
                        if (bl) {
                            stringBuffer.append(",0");
                        }
                    } else {
                        stringBuffer.append(variableName.getCode());
                        stringBuffer.append(".num().subtract(");
                        if (bl) {
                            stringBuffer.append("CobolNum.noo(");
                            stringBuffer.append(string);
                            stringBuffer.append(",0)");
                        } else {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(")");
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(variableName.rounded);
                    stringBuffer.append(",");
                    stringBuffer.append(this.ose.hasBlocks());
                    stringBuffer.append(")");
                    if (n4 >= n3 - 1) break;
                    stringBuffer.append(this.ose.hasBlocks() ? "|" : ";");
                }
                stringBuffer.append(this.ose.getCode());
            }
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    public TokenList getNumList() {
        return this.numList;
    }

    public VariableNameList getVarList() {
        return this.varList;
    }

    public VariableNameList getVarFromList() {
        return this.varFromList;
    }

    public Token getTokenFrom() {
        return this.tokenFrom;
    }
}

