/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Synchronized
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Block syncBlock;
    private VariableName syncVar;

    public Synchronized(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 613) {
            this.syncVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (this.syncVar == null) {
                token2 = this.tm.getToken();
                throw new UnexpectedTokenException(token2, this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.syncBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        token2 = this.tm.getToken();
        if (token2.getToknum() != 450) {
            throw new ExpectedFoundException(token2, this.error, "'END-SYNCHRONIZED'");
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("synchronized (");
        if (this.syncVar != null) {
            stringBuffer.append(this.syncVar.getCode());
        } else {
            Pcc pcc = this.pc.getRoot();
            if (pcc != this.pc) {
                stringBuffer.append(pcc.getFullClassName() + ".");
            }
            stringBuffer.append("this");
        }
        stringBuffer.append(")");
        stringBuffer.append(this.syncBlock.getCode());
        return stringBuffer.toString();
    }
}

