/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.IToken;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class Token
implements CobolToken,
IToken {
    static final int CPP_ADDED = -100000000;
    private static final String encoding = System.getProperty("file.encoding");
    static Hashtable reservedWords = new Hashtable();
    static Hashtable reservedWordsOrig;
    private String _word;
    private boolean upperCase;
    private boolean isAll;
    private boolean national;
    private boolean resource;
    private boolean figurative;
    private boolean hexdecimal;
    private boolean isDouble;
    private boolean isNull;
    private boolean lineRepl;
    private int token;
    private String fileName;
    private int fileLineNumber;
    private int fileIndex;
    private int offset;
    private int nativeSize;
    private int decimals;
    private int bitLen;
    private String constName;
    String doc;

    public static String version() {
        return "$Id: Token.java 38658 2024-09-12 15:13:57Z gianni_578 $";
    }

    public Token assign(Token token) {
        this._word = token._word;
        this.upperCase = token.upperCase;
        this.token = token.token;
        this.setFLN(token.fileLineNumber);
        this.offset = token.offset;
        this.fileName = token.fileName;
        this.fileIndex = token.fileIndex;
        this.hexdecimal = token.hexdecimal;
        this.isAll = token.isAll;
        this.national = token.national;
        this.bitLen = token.bitLen;
        return this;
    }

    public Token(int n2, char[] cArray, int n3, int n4, int n5, int n6, String string) {
        StringBuffer stringBuffer = new StringBuffer(n4);
        n4 += n3;
        for (int i2 = n3; i2 < n4 && i2 < cArray.length; ++i2) {
            stringBuffer.append(cArray[i2]);
        }
        this.token = n2;
        this._word = stringBuffer.toString();
        this.setFLN(n5);
        this.offset = n6;
        this.fileName = string;
    }

    public Token(char c2, int n2, int n3, String string) {
        this.token = c2;
        this._word = new StringBuffer().append(c2).toString();
        this.setFLN(n2);
        this.offset = n3;
        this.fileName = string;
    }

    public Token(int n2, String string, int n3, int n4, String string2) {
        this.token = n2;
        this._word = string;
        this.setFLN(n3);
        this.offset = n4;
        this.fileName = string2;
    }

    public Token(Token token) {
        this.assign(token);
    }

    public Token combine(char c2, Token token) {
        int n2 = 0;
        String string = this.getWord();
        String string2 = token.getWord();
        n2 = string.indexOf(44);
        BigDecimal bigDecimal = n2 > 0 ? new BigDecimal(string.substring(0, n2) + "." + string.substring(n2 + 1)) : new BigDecimal(string);
        n2 = 0;
        n2 = string2.indexOf(44);
        BigDecimal bigDecimal2 = n2 > 0 ? new BigDecimal(string2.substring(0, n2) + "." + string2.substring(n2 + 1)) : new BigDecimal(string2);
        switch (c2) {
            case '+': {
                bigDecimal = bigDecimal.add(bigDecimal2);
                break;
            }
            case '-': {
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                break;
            }
            case '*': {
                bigDecimal = bigDecimal.multiply(bigDecimal2);
                break;
            }
            case '/': {
                bigDecimal = bigDecimal.divide(bigDecimal2, 4);
                break;
            }
            case '^': {
                boolean bl;
                int n3;
                if (bigDecimal2.scale() != 0) {
                    n3 = bigDecimal.scale();
                    bigDecimal = new BigDecimal(Math.pow(bigDecimal.doubleValue(), bigDecimal2.doubleValue()));
                    bigDecimal = bigDecimal.setScale(n3, 4);
                    break;
                }
                n3 = bigDecimal2.intValue();
                if (n3 == 0) {
                    bigDecimal = new BigDecimal(1);
                    break;
                }
                if (n3 < 0) {
                    bl = true;
                    n3 = -n3;
                } else {
                    bl = false;
                }
                BigDecimal bigDecimal3 = bigDecimal;
                for (int i2 = 1; i2 < n3; ++i2) {
                    bigDecimal3 = bigDecimal3.multiply(bigDecimal);
                }
                if (bl) {
                    bigDecimal = new BigDecimal(1).divide(bigDecimal3, bigDecimal.scale(), 4);
                    break;
                }
                bigDecimal = bigDecimal3.setScale(bigDecimal.scale(), 4);
                break;
            }
            default: {
                throw new IllegalArgumentException("OP=" + c2);
            }
        }
        Token token2 = new Token(this);
        token2.setWord(bigDecimal.toString());
        return token2;
    }

    @Override
    public int getToknum() {
        return this.token;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    int getLength() {
        return this._word.length();
    }

    @Override
    public int getFLN() {
        return this.fileLineNumber;
    }

    @Override
    public void setFLN(int n2) {
        if (n2 >= 0) {
            this.fileLineNumber = n2;
            this.lineRepl = false;
        } else if (n2 > -100000000) {
            this.fileLineNumber = -n2;
            this.lineRepl = true;
        } else {
            this.fileLineNumber = n2 - -100000000;
        }
    }

    public boolean isLineRepl() {
        return this.lineRepl;
    }

    static final String getUpperCaseWord(String string) {
        return string.replace(Pcc.hyphenRepl, '-').toUpperCase(Locale.US);
    }

    private final String getUpperCaseWord() {
        return Token.getUpperCaseWord(this._word);
    }

    @Override
    public final String getOriginalWord() {
        return this._word;
    }

    @Override
    public final String getWord() {
        return this.upperCase ? Token.getUpperCaseWord(this._word) : this._word;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setWord(String string) {
        this.upperCase = false;
        this._word = string;
    }

    void setToknum(int n2) {
        this.token = n2;
    }

    void setOffset(int n2) {
        this.offset = n2;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public void setFileIndex(int n2) {
        this.fileIndex = n2;
    }

    public void setAll(boolean bl) {
        this.isAll = bl;
    }

    void setNational(boolean bl) {
        this.national = bl;
    }

    void setResource(boolean bl) {
        this.resource = bl;
    }

    @Override
    public boolean isAll() {
        return this.isAll;
    }

    @Override
    public boolean isNational() {
        return this.national;
    }

    @Override
    public boolean isResource() {
        return this.resource;
    }

    void setFigurative(boolean bl) {
        this.figurative = bl;
    }

    @Override
    public boolean isFigurative() {
        return this.figurative;
    }

    void setHexdecimal(boolean bl) {
        this.hexdecimal = bl;
    }

    @Override
    public boolean isHexdecimal() {
        return this.hexdecimal;
    }

    public boolean isFigurativeZero() {
        return this.getFigurativeChar() == 48;
    }

    public boolean isFigurativeSpace() {
        return this.getFigurativeChar() == 32;
    }

    public boolean isFigurativeQuote() {
        return this.getFigurativeChar() == 34;
    }

    public boolean isFigurativeHighValue() {
        return this.getFigurativeChar() == 255;
    }

    void setDouble(boolean bl) {
        this.isDouble = bl;
    }

    boolean isDouble() {
        return this.isDouble;
    }

    void setNativeSize(int n2) {
        this.nativeSize = n2;
    }

    int getNativeSize() {
        return this.nativeSize;
    }

    public int getFigurativeChar() {
        if (this.figurative) {
            String string = this.getWord();
            if (this.token == 10001) {
                return string.charAt(1);
            }
            return string.charAt(0);
        }
        return -1;
    }

    @Override
    public void putKeyword(Hashtable hashtable) {
        this.token = this.findResKey(hashtable);
    }

    private int findResKey(Hashtable hashtable) {
        String string = this.getUpperCaseWord();
        if (hashtable != null && hashtable.get(string) != null) {
            this.upperCase = true;
            return 10009;
        }
        Integer n2 = (Integer)reservedWords.get(string);
        if (n2 != null) {
            this.upperCase = true;
            return n2;
        }
        int n3 = string.length();
        char[] cArray = new char[n3];
        int n4 = 0;
        string.getChars(0, n3, cArray, 0);
        char c2 = cArray[0];
        if (c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '+') {
            for (n4 = 1; n4 < n3 && (c2 = cArray[n4]) >= '0' && c2 <= '9'; ++n4) {
            }
        }
        if (n4 == n3) {
            return 10002;
        }
        this.upperCase = true;
        return 10009;
    }

    public static boolean changeKeyword(String string, String string2) {
        string = string.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        string2 = string2.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        Integer n2 = (Integer)reservedWords.get(string);
        if (n2 != null && reservedWords.get(string2) == null) {
            reservedWords.remove(string);
            reservedWords.put(string2, n2);
            return true;
        }
        return false;
    }

    public static boolean replaceMeaning(String string, String string2) {
        Integer n2;
        string = string.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        string2 = string2.toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-');
        Integer n3 = (Integer)reservedWords.get(string);
        if (n3 != null && (n2 = (Integer)reservedWords.get(string2)) != null) {
            reservedWords.put(string2, n3);
            return true;
        }
        return false;
    }

    public static void restoreKeywords() {
        reservedWords.clear();
        reservedWords.putAll(reservedWordsOrig);
    }

    @Override
    public boolean isZero() {
        int n2;
        String string = this.getWord();
        if (this.token == 10002 && (n2 = string.length()) > 0) {
            --n2;
            while (n2 >= 0) {
                if (string.charAt(n2) != '0') {
                    return false;
                }
                --n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getWord();
        return "[" + string + "]";
    }

    @Override
    public int getRealLength() {
        int n2 = 0;
        String string = this.getWord();
        if (this.token == 10001) {
            char[] cArray = string.toCharArray();
            char c2 = cArray[0];
            int n3 = cArray.length - 1;
            block3: for (int i2 = 1; i2 < n3; ++i2) {
                char c3 = cArray[i2];
                switch (c3) {
                    case '\"': 
                    case '\'': {
                        if (c2 == c3 && !this.hexdecimal) {
                            ++i2;
                        }
                        ++n2;
                        continue block3;
                    }
                    default: {
                        ++n2;
                    }
                }
            }
        } else {
            n2 = string.length();
        }
        return n2;
    }

    public String getCode() {
        String string;
        String string2 = this.getWord();
        if (this.token == 10001) {
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            char c2 = cArray[0];
            int n2 = cArray.length - 1;
            block7: for (int i2 = 1; i2 < n2; ++i2) {
                char c3 = cArray[i2];
                switch (c3) {
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block7;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        if (c2 != c3) continue block7;
                        ++i2;
                        continue block7;
                    }
                    case '\'': {
                        stringBuffer.append("'");
                        if (c2 != c3) continue block7;
                        ++i2;
                        continue block7;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block7;
                    }
                    default: {
                        stringBuffer.append(c3);
                    }
                }
            }
            string = stringBuffer.toString();
        } else if (this.token == 10009) {
            string = string2.replace('-', Pcc.hyphenRepl);
            if (Character.isDigit(string.charAt(0))) {
                string = '_' + string;
            }
        } else {
            string = string2;
        }
        return string;
    }

    public String getPlain() {
        String string;
        String string2 = this.getWord();
        if (this.token == 10001) {
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            char c2 = cArray[0];
            int n2 = cArray.length - 1;
            block4: for (int i2 = 1; i2 < n2; ++i2) {
                char c3 = cArray[i2];
                switch (c3) {
                    case '\"': {
                        stringBuffer.append("\"");
                        if (c2 != c3) continue block4;
                        ++i2;
                        continue block4;
                    }
                    case '\'': {
                        stringBuffer.append("'");
                        if (c2 != c3) continue block4;
                        ++i2;
                        continue block4;
                    }
                    default: {
                        stringBuffer.append(c3);
                    }
                }
            }
            string = stringBuffer.toString();
        } else {
            string = string2;
        }
        return string;
    }

    public String getLitArg() {
        return this.getLitArg(false);
    }

    public String getLitArg(boolean bl) {
        String string;
        String string2 = this.getWord();
        if (string2.length() == 0) {
            string = "";
        } else if (this.token == 10001) {
            if (this.hexdecimal) {
                if (bl) {
                    string = this.national && this.isFigurativeHighValue() ? "\"FFFF\"" : "\"" + TokenManager.stringToHex(string2.substring(1, string2.length() - 1), this.national, false) + "\"";
                } else {
                    char[] cArray = string2.substring(1, string2.length() - 1).toCharArray();
                    string = "new byte[] {";
                    if (this.national && this.isFigurativeHighValue()) {
                        string = string + "-1,-1";
                    } else {
                        int n2 = 0;
                        while (true) {
                            if (this.national) {
                                string = string + (byte)(cArray[n2] >>> 8);
                                string = string + ',';
                                string = string + (byte)(cArray[n2] & 0xFF);
                            } else {
                                string = string + (byte)(cArray[n2] & 0xFF);
                            }
                            if (++n2 >= cArray.length) break;
                            string = string + ',';
                        }
                    }
                    string = string + "}";
                }
            } else {
                string = "\"" + this.getCode() + "\"";
            }
        } else if (this.isDouble) {
            string = string2;
        } else {
            char c2 = string2.charAt(0);
            int n3 = c2 == '-' || c2 == '+' ? 1 : 0;
            if (Token.countDigit(string2) > 18) {
                return "\"" + string2 + "\"";
            }
            int n4 = string2.indexOf(46);
            if (n4 >= 0 || (n4 = string2.indexOf(44)) >= 0) {
                string = string2.substring(0, n4) + string2.substring(n4 + 1) + "L,";
                string = string + (n4 - n3) + "," + (string2.length() - n4 - 1);
            } else {
                string = string2 + "L," + (string2.length() - n3) + "," + 0;
            }
            int n5 = string.length();
            for (n4 = n3; n4 < n5 && string.charAt(n4) == '0'; ++n4) {
            }
            if (n4 > n3) {
                string = string.charAt(n4) == 'L' ? string.substring(n4 - 1, string.length()) : string.substring(n4, string.length());
                if (n3 > 0) {
                    string = c2 + string;
                }
            }
        }
        return string;
    }

    @Override
    public String getAsLong() {
        String string;
        switch (this.getToknum()) {
            case 10002: {
                string = this.getLitArg();
                int n2 = string.indexOf(44);
                if (n2 < 0) break;
                string = string.substring(0, n2);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Override
    public String getAsInt() {
        String string;
        switch (this.getToknum()) {
            case 10002: {
                string = this.getAsLong();
                int n2 = string.indexOf(76);
                if (n2 < 0) break;
                string = string.substring(0, n2);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public int longValue() {
        try {
            return Integer.parseInt(this.getAsInt());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public String getLiteralFactory(String string, boolean bl, boolean bl2) {
        if (bl2) {
            if (this.isFigurative() && !this.hexdecimal && !this.national) {
                switch (this.getFigurativeChar()) {
                    case 34: {
                        return "Str.QUOTES()";
                    }
                    case 32: {
                        if (this.isAll) {
                            return "Str.SPACES()";
                        }
                        return "Str.SPACE()";
                    }
                    case 255: {
                        return "Str.HIGH_VALUES()";
                    }
                    case 0: {
                        return "Str.LOW_VALUES()";
                    }
                    case 48: {
                        return "Num.ZERO()";
                    }
                }
                return "Str.get(\"" + this.getCode() + "\")";
            }
            String string2 = "";
            switch (this.getToknum()) {
                case 10001: {
                    if (this.resource) {
                        if (this.national) {
                            return "Str.getResNat(\"" + this.getCode() + "\")";
                        }
                        return "Str.getRes(\"" + this.getCode() + "\")";
                    }
                    if (this.national) {
                        if (this.hexdecimal) {
                            if (this.isAll) {
                                return "Str.getAllNatHex(" + this.getLitArg(true) + ")";
                            }
                            return "Str.getNatHex(" + this.getLitArg(true) + ")";
                        }
                        if (this.isAll) {
                            return "Str.getAllNat(\"" + this.getCode() + "\")";
                        }
                        return "Str.getNat(\"" + this.getCode() + "\")";
                    }
                    if (this.hexdecimal) {
                        if (this.isAll) {
                            return "Str.getAllHex(" + this.getLitArg(true) + ")";
                        }
                        return "Str.getHex(" + this.getLitArg(true) + ")";
                    }
                    if (this.isAll) {
                        return "Str.getAll(\"" + this.getCode() + "\")";
                    }
                    return "Str.get(\"" + this.getCode() + "\")";
                }
                case 10002: {
                    if (this._word.startsWith("0") && this._word.length() > 1) {
                        string2 = ", " + this._word.length();
                    }
                    if (this.isAll) {
                        return "Num.getAll(" + this.getAsLong() + string2 + ")";
                    }
                    if (this.bitLen > 0) {
                        return "Factory.getBooleanLiteral(\"" + this.getWord().substring(2, this.getWord().length() - 1) + "\")";
                    }
                    return "Num.get(" + this.getAsLong() + string2 + ")";
                }
                case 10017: {
                    if (this.isAll) {
                        return "Num.getAll(\"" + this.getCode() + "\")";
                    }
                    return "Num.get(\"" + this.getCode() + "\")";
                }
            }
            return "Str.get(\"" + this.getCode() + "\")";
        }
        switch (this.getToknum()) {
            case 10001: {
                if (this.resource) {
                    if (this.national) {
                        return "Factory.getResource(" + this.getLitArg() + ")";
                    }
                    return "Factory.getResourceX(" + this.getLitArg() + ")";
                }
                if (this.national) {
                    if (this.hexdecimal && bl) {
                        if (this.isAll) {
                            return "Factory.getAllLiteralNH(" + this.getLitArg(true) + ")";
                        }
                        return "Factory.getStrLiteralNH(" + this.getLitArg(true) + ")";
                    }
                    if (this.isAll) {
                        return "Factory.getAllLiteralN(" + this.getLitArg() + ")";
                    }
                    return "Factory.getStrLiteralN(" + this.getLitArg() + ")";
                }
                if (this.isAll) {
                    if (this.isFigurativeSpace()) {
                        return "Factory.getFigurativeAllSpace()";
                    }
                    if (this.isFigurativeQuote()) {
                        return "Factory.getFigurativeQuote()";
                    }
                    if (this.hexdecimal && bl) {
                        return "Factory.getAllLiteralH(" + this.getLitArg(true) + ")";
                    }
                    return "Factory.getAllLiteral(" + this.getLitArg() + ")";
                }
                if (this.isFigurativeSpace()) {
                    return "Factory.getFigurativeSpace()";
                }
                if (this.isFigurativeQuote()) {
                    return "Factory.getFigurativeQuote()";
                }
                if (this.hexdecimal && bl) {
                    return "Factory.getStrLiteralH(" + this.getLitArg(true) + ")";
                }
                return "Factory.getStrLiteral(" + this.getLitArg() + ")";
            }
            case 10002: 
            case 10017: {
                if (this.getWord().length() == 0) {
                    return "null";
                }
                if (this.isAll) {
                    if (this.isFigurativeZero()) {
                        return "Factory.getFigurativeZero(" + string + ")";
                    }
                    return "Factory.getAllNumLiteral(" + this.getLitArg() + "," + string + ")";
                }
                if (this.nativeSize > 0) {
                    return "Factory.getNativeInt(" + this.getLitArg() + "," + this.nativeSize + "," + string + ")";
                }
                if (this.bitLen > 0) {
                    return "Factory.getBooleanLiteral(\"" + this.getWord().substring(2, this.getWord().length() - 1) + "\")";
                }
                return "Factory.getNumLiteral(" + this.getLitArg() + "," + string + ")";
            }
            case 612: {
                return "null";
            }
        }
        return "??getLiteralFactory??";
    }

    String getLiteralDeclaration(String string, String string2, boolean bl, boolean bl2) {
        switch (this.getToknum()) {
            case 10001: {
                if (this.national) {
                    if (this.isAll) {
                        return "   LiteralAllN " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
                    }
                    return "   PicN " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
                }
                if (this.isAll) {
                    return "   LiteralAll " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
                }
                return "   PicX " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
            }
            case 10002: 
            case 10017: {
                if (this.isAll) {
                    return "   NumericLiteralAll " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
                }
                if (this.bitLen > 0) {
                    return "   Pic1 " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
                }
                return "   NumericVar " + string + "=" + this.getLiteralFactory(string2, bl2, bl) + ";";
            }
        }
        return "??getLiteralDeclaration??";
    }

    String getCodeFltLiteral(String string) {
        String string2 = this.getWord();
        switch (this.getToknum()) {
            case 10002: 
            case 10017: {
                if (this.isDouble) {
                    return string2;
                }
                int n2 = string2.indexOf(46);
                if (n2 >= 0 || (n2 = string2.indexOf(44)) >= 0) {
                    return string2.substring(0, n2) + "." + string2.substring(n2 + 1) + "F";
                }
                return "" + this.getWord() + ".0F";
            }
        }
        return "????";
    }

    @Override
    public boolean isWord() {
        return this.token == 10009 || this.token > 255 && this.token < 10000;
    }

    boolean isSeparator() {
        return this.token == 44 || this.token == 59;
    }

    boolean isLength() {
        return this.token == 558;
    }

    private static int countDigit(String string) {
        int n2 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (!Character.isDigit(string.charAt(i2))) continue;
            ++n2;
        }
        return n2;
    }

    int length() {
        int n2;
        if (this.token == 10001) {
            if (this.hexdecimal && this.national) {
                return (this._word.length() - 2) / 2;
            }
            return this._word.length() - 2;
        }
        if (this.token == 10002 || this.token == 10017) {
            for (n2 = 0; n2 < this._word.length() - 1 && this._word.charAt(n2) == '0'; ++n2) {
            }
        }
        return this._word.length() - n2;
    }

    void makeConst(Token token) {
        String string;
        this.constName = string = this.getWord();
        this.setToknum(token.getToknum());
        this.setWord(token.getWord());
        this.setAll(this.isAll() || token.isAll());
        this.setNational(token.isNational());
        this.setHexdecimal(token.isHexdecimal());
        this.setBitLen(token.getBitLen());
    }

    @Override
    public boolean isConst() {
        return this.constName != null;
    }

    String getConstName() {
        return this.constName;
    }

    void setDecimals(int n2) {
        this.decimals = n2;
    }

    int getDecimals() {
        return this.decimals;
    }

    void setHexAll(char c2) {
        this.setToknum(10001);
        this.setWord("'" + c2 + "'");
        this.isAll = true;
        this.setFigurative(true);
        this.setHexdecimal(true);
    }

    void setNullFlag() {
        this.isNull = true;
    }

    void setNull(char c2) {
        this.isNull = true;
        this.setHexAll(c2);
    }

    void setZero() {
        this.setToknum(10002);
        this.setWord("0");
        this.isAll = true;
        this.setFigurative(true);
        this.setHexdecimal(false);
    }

    void setNumZero() {
        this.setToknum(10002);
        this.setWord("0");
        this.isAll = false;
        this.isNull = false;
        this.setFigurative(false);
        this.setHexdecimal(false);
    }

    boolean isNull() {
        return this.isNull;
    }

    public static byte getEncByte(char c2) {
        try {
            return String.valueOf(c2).getBytes(encoding)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (byte)c2;
        }
    }

    static boolean isZero(Token token) {
        if (token.isZero()) {
            return true;
        }
        if (token.isNull()) {
            token.setZero();
            return true;
        }
        return false;
    }

    static boolean isNumLit(Token token) {
        if (token.getToknum() == 10002 || token.getToknum() == 10017) {
            return true;
        }
        if (token.isNull()) {
            token.setZero();
            return true;
        }
        return false;
    }

    static boolean isIntLit(Token token) {
        if (token.getToknum() == 10002) {
            return true;
        }
        if (token.isNull()) {
            token.setZero();
            return true;
        }
        return false;
    }

    public int getBitLen() {
        return this.bitLen;
    }

    public void setBitLen(int n2) {
        this.bitLen = n2;
    }

    static {
        for (int i2 = 0; i2 < tokDesc.length; ++i2) {
            reservedWords.put(tokDesc[i2], tokNum[i2]);
        }
        reservedWordsOrig = new Hashtable(reservedWords);
    }
}

